/* Isidora Milivojevic
*  2020/0214
*  ETF Beograd
*/

// Uvoz biblioteka
#include "mbed.h"

// Definisanje makroa
#define WAIT                                                                0.1
#define ACTIVE                                                                0 
#define NOT_ACTIVE                                                            1   

//Globalne promenljive
AnalogIn pot1(PA_0);
AnalogIn pot2(PA_1);
InterruptIn sw1(PC_9);
PwmOut buzz(PA_11);
DigitalOut select1(PC_7);
DigitalOut select2(PB_6);
BusOut display(PA_10, PA_9, PA_8, PB_10, PB_5, PB_4, PB_3);
int j = 0;
int d = 0;
int digits[11] = { 0b1000000, //0
                       0b1111001, //1
                       0b0100100, //2
                       0b0110000, //3
                       0b0011001, //4
                       0b0010010, //5
                       0b0000010, //6
                       0b1111000, //7
                       0b0000000, //8
                       0b0010000, //9
                  };

//Prototipi funkcija
void ISR_sw1(void);

 //Glavna funkcija
int main() {
    sw1.fall(&ISR_sw1);
    select1.write(NOT_ACTIVE);
    select2.write(NOT_ACTIVE);
    while (true){
        buzz.period_us(pot2.read()*2000+100); //Menjanje frekvenicje zujalice pomocu pot2
        buzz.write(pot1.read()); //Menjanje jacine zujalice pomocu pot1
        j = (int(pot1.read()*100))%10; //Jedinice jacine zvuka
        d = (int(pot1.read()*100))/10; //Desetice jacine zvuka
    }
}

//Prekidna rutina za pritisak tastera
void ISR_sw1(){
    while(true){
        if(!d) {
            display.write(digits[j]);
            select1.write(ACTIVE);
            select2.write(NOT_ACTIVE);
        } else {
            display.write(digits[d]); 
            select1.write(NOT_ACTIVE);
            select2.write(ACTIVE);
            wait_ms(10);
            display.write(digits[j]);                  
            select1.write(ACTIVE);
            select2.write(NOT_ACTIVE);
            wait_ms(10);    
        }      
    }
}