#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
#include "QEI.h"
#include "Rtc_Ds1307.h"
#include "string.h"
#include <Pulse1.h>

PulseInOut irda(PTB0);// en este puerto se pone el sensor infrarrojo
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
Rtc_Ds1307 rtc(PTE0, PTE1);
QEI wheel (PTA16, PTA17, NC, 48);
DebouncedIn button_enco(PTC5);
DigitalOut myled(LED3);

int numN[35];//cadena para almacenar todos los tiempos que conforman los bits de datos
int numP[35];//cadena para almacenar todos los tiempos que conforman los bits de datos
int numbin[35];
int bin[35];//cadena para almacenar todos los tiempos que conforman los bits de datos
int dato; // tiempo de cada dato que se lee
int pul_low;
int i1,j1,k1,header,proL,proH; 
char r;
char cadena[33];
char uno[33]="11100000111000000010000011011111";
char dos[33]="11100000111000001010000001011111";
char tres[33]="11100000111000000110000010011111";
char cuatro[33]="11100000111000000001000011101111";
char cinco[33]="11100000111000001001000001101111";
char seis[33]="11100000111000000101000010101111";
char siete[33]="11100000111000000011000011001111";
char set[33]="10001010111100010011010100101000";
int mode=0;
int code;
int numb=32;
int s=0;
//
int C1=0x0C;
int m;
int Conf=0;  // 0: Alarma y 1:Reloj
int Lugar=0; // Definen el punto en el cual va el programa
int i=0;
int j=1;
int IRDA=1;
int irda_en=0;
int visual=0;
int alarma=0;
int main()
{
    myled=1;
    j=1;
    Rtc_Ds1307::Time_rtc tm2 = {};
    Rtc_Ds1307::Time_rtc tm = {};
    Rtc_Ds1307::Time_rtc Alarm[8] = {};
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    lcd.locate(0,0);
    lcd.printf("--ALARMA  --HORA"); 
    rtc.getTime(tm); //lee el tiempo del DS1307

    while(1)
    {
        
        switch (Lugar)
        {
            case 0:
                m=wheel.getPulses();  // m son los datos del encoder
                if(m!=0 && Conf==0){
                    Conf=1;
                    wheel.reset();  
                    m=0;              
                }
                
                if(m!=0 && Conf==1){
                    Conf=0;
                    wheel.reset();  
                    m=0;              
                }
                
                if(Conf==0){
                    
                    lcd.locate(11,0);
                    lcd.printf("-");                    
                    lcd.locate(1,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                    
                }
                
                 if(Conf==1){
                    
                    lcd.locate(1,0);
                    lcd.printf("-");                    
                    lcd.locate(11,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                }
                
                if (button_enco.falling()){  //si se pulsa boton encoder
                    Lugar++;
                    m=0;       
                }
            
            break;
            
            case 1:
                switch(i)
                {
                    case 0:                     
                        if(Conf==0) // ALARMA
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("CONFIG. ALARMA ");
                            wait(1);
                            lcd.cls();
                            i++;
                            lcd.locate(0,0);
                            lcd.printf("DIA: ");
                            m=0;                             
                        }
                
                        if(Conf==1) //RELOJ
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("CONFIG. HORA   ");
                            wait(1);
                            i++;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("DIA: ");
                            m=0;
                            
                        }    

                    break;
                    
                    case 1: //DAY OF WEEK
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.wday=tm.wday+m;
                            if(tm.wday>7)
                            {
                                tm.wday=1;
                            }
                            if(tm.wday<1)
                            {
                                tm.wday=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        
                        switch(tm.wday){
                            case (1):
                                lcd.locate(5,0);
                                lcd.printf("DOMINGO    ");
                            break;    
                            case (2):
                                lcd.locate(5,0);
                                lcd.printf("LUNES    ");
                            break;     
                            case (3):
                                lcd.locate(5,0);
                                lcd.printf("MARTES   ");
                            break;     
                            case (4):
                                lcd.locate(5,0);
                                lcd.printf("MIERCOLES");
                            break;                                        
                            case (5):
                                lcd.locate(5,0);
                                lcd.printf("JUEVES     ");
                            break;     
                            case (6):
                                lcd.locate(5,0);
                                lcd.printf("VIERNES   ");
                            break;     
                            case (7):
                                lcd.locate(5,0);
                                lcd.printf("SABADO ");
                            break;                                    
                            }  
                        
                        
                        if (button_enco.falling())
                        {
                            switch(Conf)
                            {
                                case 0:
                                    i=5;
                                    m=0;
                                    lcd.cls();
                                    lcd.locate(0,0);
                                    lcd.printf("HORA: ");
                                    m=0;
                                break;    
                                case 1:
                                    i=2;
                                    m=0;
                                    lcd.cls();
                                    lcd.locate(0,0);
                                    lcd.printf("DIA: ");
                                break;
                            }           
                        }
                    
                    break;
                    case 2: // DAY OF DATE
                        m=0;
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.date=tm.date+m;
                            if(tm.date>31)
                            {
                                tm.date=1;
                            }
                            if(tm.date<1)
                            {
                                tm.date=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(5,0);
                        lcd.printf("%02d   ",tm.date);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("MES: ");
                            
                        }
                    break;
                    case 3: // MONTH
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.mon=tm.mon+m;
                            if(tm.mon>12)
                            {
                                tm.mon=1;
                            }
                            if(tm.mon<1)
                            {
                                tm.mon=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(7,0);
                        lcd.printf("%02d",tm.mon);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("ANO: ");
                            
                        }
                    
                    break;
                    
                    case 4: //YEAR
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.year=tm.year+m;
                            if(tm.year>2022)
                            {
                                tm.year=2018;
                            }
                            if(tm.year<2018)
                            {
                                tm.year=2018;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%02d",tm.year);
                        
                        if (button_enco.falling())
                        {
                            i=5;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("HORA: ");
                            
                            
                        }
                    
                    break;
                    
                    case 5: //HOUR
                        m=0;
                        m=wheel.getPulses();       
                        if (m!=0) 
                        {
                            tm.hour+= m;
                            if(tm.hour>23)
                            {
                                tm.hour=0;
                            }
                            if(tm.hour<0)
                            {
                                tm.hour=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%02d",tm.hour);
                        
                        if (button_enco.falling())
                        {
                            i=6;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("MINUTO: ");
                            //tm.min=0;
                        }
                    
                    break;
                    
                    case 6: //MINUTE
                        m=0;
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.min=tm.min+m;
                            if(tm.min>59)
                            {
                                tm.min=0;
                            }
                            if(tm.min<0)
                            {
                                tm.min=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%02d",tm.min);
                        
                        if (button_enco.falling())
                        {
                            i=7;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("SEGUNDO: ");
                            //tm.sec=0;
                        }
                    
                    break;
                    
                    
                    case 7: //SECOND
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.sec=tm.sec+m;
                            if(tm.sec>59)
                            {
                                tm.sec=0;
                            }
                            if(tm.sec<0)
                            {
                                tm.sec=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%02d",tm.sec);
                        
                        if (button_enco.falling())
                        {
                            ///////////////////
                            if(Conf==0)
                            {
                                Alarm[j]=tm;
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("CONFIG. %d ALARMA",j);
                                wait(1);
                                i=0;
                                m=0;
                                if(j>=7)
                                {
                                Lugar++;
                                }
                                j++;
                                lcd.cls();
                                                          
                            }
                
                            if(Conf==1)
                            {   
                                rtc.setTime(tm, true, false);
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("CONFIG. HORA ");
                                wait(1);
                                i=0;
                                m=0;
                                Lugar=0;
                                lcd.locate(0,0);
                                lcd.printf("--ALARMA  --HORA");                                
                            } 
                           
                           ///////////////////
                        }
                    
                    break;
                   
                }            
            break;
            
            case 2: // SHOW THE TIME AND ALARM AND COMPROBATE THE ALARM STATE
                rtc.getTime(tm2); //READING THE RTC
                
                           
                if(visual==0)
                {    
                    lcd.locate(0,0);                        
                    lcd.printf("HORA:   ");
                    lcd.locate(8,0);    
                    lcd.printf("%02d:",tm2.hour);
                    lcd.printf("%02d:",tm2.min);
                    lcd.printf("%02d",tm2.sec); 
                    lcd.locate(0,1);
                    switch(tm2.wday){
                            case (1):
                                lcd.locate(0,1);
                                lcd.printf("DOM   ");
                            break;    
                            case (2):
                                lcd.locate(0,1);
                                lcd.printf("LUN   ");
                            break;     
                            case (3):
                                lcd.locate(0,1);
                                lcd.printf("MAR   ");
                            break;     
                            case (4):
                                lcd.locate(0,1);
                                lcd.printf("MIE   ");
                            break;                                        
                            case (5):
                                lcd.locate(0,1);
                                lcd.printf("JUE   ");
                            break;     
                            case (6):
                                lcd.locate(0,1);
                                lcd.printf("VIE   ");
                            break;     
                            case (7):
                                lcd.locate(0,1);
                                lcd.printf("SAB   ");
                            break;                                    
                    }
                    lcd.locate(6,1);          
                    lcd.printf("%02d/",tm2.date);
                    lcd.printf("%02d/",tm2.mon);
                    lcd.printf("%02d",tm2.year);
                    wait(0.1);
                    //////////
                    m=wheel.getPulses();
                    if(m!=0)
                    {
                        visual=1;
                        wheel.reset();  
                        m=0;
                    }
                }
                
                if(visual==1)
                {
                    lcd.locate(0,1);    
                    lcd.printf("     ");
                    lcd.locate(8,0);    
                    lcd.printf("%02d:",Alarm[IRDA].hour);
                    lcd.printf("%02d:",Alarm[IRDA].min);
                    lcd.printf("%02d",Alarm[IRDA].sec);
                    
                    switch(Alarm[IRDA].wday){
                            case (1):
                                lcd.locate(0,0);
                                lcd.printf(" DOM   ");
                            break;    
                            case (2):
                                lcd.locate(0,0);
                                lcd.printf(" LUN   ");
                            break;     
                            case (3):
                                lcd.locate(0,0);
                                lcd.printf(" MAR   ");
                            break;     
                            case (4):
                                lcd.locate(0,0);
                                lcd.printf(" MIE   ");
                            break;                                        
                            case (5):
                                lcd.locate(0,0);
                                lcd.printf(" JUE   ");
                            break;     
                            case (6):
                                lcd.locate(0,0);
                                lcd.printf(" VIE   ");
                            break;     
                            case (7):
                                lcd.locate(0,0);
                                lcd.printf(" SAB   ");
                            break;                                    
                    }
                    lcd.locate(5,1);
                    lcd.printf("SET %d ALARMA",IRDA);    
                    wait(0.1);
                    ////
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        visual=0;
                        wheel.reset();  
                        m=0;                                       
                    }
                }
/////////////////////////////////// ALARM COMPROBATION /////////////////////////////////////////////////////////////////////////////                
                if( (tm2.wday==Alarm[IRDA].wday)&&((tm2.hour)==Alarm[IRDA].hour)&&(tm2.min==Alarm[IRDA].min)&&(tm2.sec==Alarm[IRDA].sec) )
                {
                    Lugar++;
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("ALARMA ACTIVA!!");
                    wait(1);
                    lcd.locate(0,0);
                    lcd.printf("->APAGAR       ");                       
                    lcd.locate(0,1);                        
                    lcd.printf("--POSPONER     ");
                    m=0;
                }
////////////////// IRDA WAITING ///////////////////////////////////////////////////////////////////////////////////////////////////                
                if (button_enco.falling())
                        {
                            irda_en=1;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf(" ESPERANDO SENAL ");
                            
                        }
                 
            break;
            
            case 3: //TURN OFF OR POSTPONE THE ALARM
                
                if(alarma==0) //CHOICE OF POSTPONE
                {
                    myled=1;
                    wait(0.5);
                    myled=0;
                    wait(0.5);
                                        
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        alarma=1;
                        m=0;
                        wheel.reset();
                        
                        lcd.locate(1,0);
                        lcd.printf("-");                    
                        lcd.locate(1,1);
                        lcd.printf(">");                                          
                    }
                }
                          
                ///////////////////
                
                if(alarma==1) //CHOICE OF TURN OFF
                {
                    myled=1;
                    wait(0.5);
                    myled=0;
                    wait(0.5);
                                        
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        alarma=0;
                        m=0;
                        wheel.reset();
                        
                        lcd.locate(1,0);
                        lcd.printf(">");                    
                        lcd.locate(1,1);
                        lcd.printf("-");                                          
                    }
                }
                
                if (button_enco.falling())
                {
                    if(alarma==0)
                    {
                        Lugar=2; //RETURN TO SHOW THE TIME
                        wheel.reset();
                        m=0;
                        myled=1;
                        lcd.cls();                          
                    }
                    if(alarma==1)
                    {
                        Lugar=2;  //RETURN TO SHOW THE TIME WITH CURRENT ALARM UPDATED
                        rtc.getTime(tm2);
                        if(tm.min!=58)
                        {
                            Alarm[IRDA].min=tm2.min+1;
                        }
                        if(tm.min==59)
                        {
                            Alarm[IRDA].min=0;
                            Alarm[IRDA].hour=tm2.hour+1;
                        }
                        Alarm[IRDA].sec=tm2.sec;
                        lcd.cls();
                        alarma=0;
                        myled=1;   
                    }                    
                }
            break;
        }
///////////////////////////////// IRDA READING //////////////////////////////////////////////////////////////////////////////////                     
        while (irda_en)
        {
        fflush( stdin );     
        lop2:  if(!mode){
               header = irda.read_high_us(); 
               if(header>3500) goto seguir2;
               goto lop2;
               }
                  
        seguir2:
              for(i1=0;i1<numb;++i1){  
              numP[i1] = irda.read_high_us();    //funcion para leer un pulso alto
              if (numP[i1]<1000){
                s=0;
                r='0';
              }else{
                s=1;
                r='1';
              }
              numbin[i1]=s;
              cadena[i1]=r;                                    
              }
              if (!strcmp(cadena,uno)){
              IRDA=1;    
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;
              }else if (!strcmp(cadena,dos)){
              IRDA=2;
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;
              }else if (!strcmp(cadena,tres)){
              IRDA=3;
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;
              }else if (!strcmp(cadena,cuatro)){
              IRDA=4;
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;
              }else if (!strcmp(cadena,cinco)){
              IRDA=5;
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;
              }else if (!strcmp(cadena,seis)){
              IRDA=6;
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;
              }else if (!strcmp(cadena,siete)){
              IRDA=7;
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;   
              }else if(!strcmp(cadena,set)){
              goto lop3;   
              }    
        lop3: Lugar=2;
              irda_en=0;
              lcd.cls();
              break;  
        }
    }          
}