/* 
Project Stepper
Written by Tony Cacace & Brandon Ring
Date: 08-19-11
Rev: AD

This program will use the mbed micro-controller to step a stepper motor forward and reverse
based on the users input request.  It also uses Limit switches to define range of travel for
the stage and the Home marker.

Revesions....
AB: Added menu function and forward and reverse loops.
AD: Added homing using limit switches.
*/

#include "mbed.h"
#include "TextLCD.h"

#define DELAYSEQ 3.0    // A wait used between the main while loop

TextLCD lcd(p24, p26, p27, p28, p29, p30);
DigitalOut enable1(p21);
DigitalOut enable2(p22);
DigitalOut STP1(p11);
DigitalOut STP2(p12);
DigitalOut STP3(p13);
DigitalOut STP4(p14);
DigitalIn  LLT(p21);
DigitalIn  ULT(p22);
DigitalIn  HLT(p23);
Serial pc(USBTX, USBRX); // tx, rx

int Yes = 0;      //Yes means false, for homing loop
int No = 1;       //No means true, for homing loop
void moveSteps (int);       // Fuction prototype: used to define how many steps to take
volatile int count = 1;     //keeps track of counted steps 1-4 
float delayStep = 0.005;    //Speed of motor.....0.005
int Exit = No;           //Defines the variable exit for the HOME loop.
int stepcount = 0;              // keeps track of how many steps were taken


int main() {
    enable1 = 1;    //Turn on driver
    enable2 = 1;    //Turn on driver
//    int inputdir;   //Variable used to define step direction.
    int inputsteps; //Variable used to define step amount.

do {    //Print menu on PC to request what to do from the user.
    pc.printf("Menu\n\n");
    pc.printf("1. Home Stage.\n");
    pc.printf("2. Move Stage Forward.\n");
    pc.printf("3. Move Stage Backwards.\n");
    pc.printf("4. Exit Program.\n\n");
    pc.scanf("%d",&count);
  
 switch (count) {   //Switch function to move to loop requested by user.
 
     case 1: // (HOME) Call function here to do the required operation
     pc.printf("Homing Stage...\n\n",count);
     
        Exit = No;
        while ( (HLT < 1) && (Exit) && (ULT < 1) ) { //Moves stage forward until we hit the Home limit or Upper Limit
            
            int stepcount = 0;              // keeps track of how many steps were taken
            inputsteps = 10;             // Sets limit in case limits never trip. (ie Home or EOT limit tripped)
            while ( (stepcount<inputsteps) && (HLT < 1) && (ULT < 1) && (Exit) ) { // compares how many steps taken to the desired steps passed in 
                count++;
                
                    if (count == 5)     // if the motor went around oncce..
                        count=1;        // ...reset the counter
                
                    switch (count) {
                
                    case 1:     // if count equals 1 do this
                        STP1 = 1;
                        STP2 = 0;
                        STP3 = 0;
                        STP4 = 0;
                    break;      // this skips the code below until stepcount++ 
        
                    case 2:
                        STP1 = 0;
                        STP2 = 0;
                        STP3 = 1;
                        STP4 = 0;
                    break;

                    case 3:
                        STP1 = 0;
                        STP2 = 1;
                        STP3 = 0;
                        STP4 = 0;
                    break;
    
                    case 4:
                        STP1 = 0;
                        STP2 = 0;
                        STP3 = 0;
                        STP4 = 1;
                    break;
                    }
                    stepcount++;                //Iterate loop to keep track of steps.
                    lcd.cls();                  //Clear mbed LCD screen.
                    lcd.printf("%i", stepcount);//Print loop count on LCD.
                    wait(delayStep);            //Defines how fast to step the motor.
                    
                    if (HLT == 1) {     //If we are at the home limit sensor stop moving stage.
                        Exit = Yes;     //If loop is true, stop moving stage.
                        pc.printf("Stage is Homed!\n\n");
                        }
                        
                    if (stepcount==inputsteps) { //If loop reaches max count, throw error
                                Exit = Yes;
                                pc.printf("Error Homing Stage, please check connections.\n");
                                pc.printf("Stage failed to move within giving limits.\n");
                                pc.printf("Possible error, Upper limit switch wasn't tripped.\n\n");
                                }
                        
                    if (ULT == 1) {  //If EOT limit is reached, begin stepping stage backwards.
                    
                        int stepcount = 0;       // keeps track of how many steps were taken
                        inputsteps = -10;        // Sets limit in case limits never trip. (ie Home or EOT limit tripped)
                        while ( (stepcount>inputsteps) && (HLT < 1) && (Exit) ) { 
                            //Keep moving stage backwards until Home limit is hit.

                            count--;
      
                            if (count == 0) // if the motor went around oncce..
                                count=4;    // ...reset the counter
                    
                            switch (count) {
      
                            case 1:     // if count equals 1 do this
                                STP1 = 1;
                                STP2 = 0;
                                STP3 = 0;
                                STP4 = 0;
                            break;

                            case 2:     // this skips the code below until stepcount--
                                STP1 = 0;
                                STP2 = 0;
                                STP3 = 1;
                                STP4 = 0;
                            break;

                            case 3:
                                STP1 = 0;
                                STP2 = 1;
                                STP3 = 0;
                                STP4 = 0;
                            break;

                            case 4:
                                STP1 = 0;
                                STP2 = 0;
                                STP3 = 0;
                                STP4 = 1;
                            break;
                            }
                            stepcount--;            //Iterate loop to keep track of steps.
                            lcd.cls();              //Clear mbed LCD screen.
                            lcd.printf("%i", stepcount);//Print loop count on LCD.
                            wait(delayStep);
                            
                            if (LLT == 1) { //Lower limit sensor is tripped, Exit loop and throw fault.
                                Exit = Yes;
                                pc.printf("Error Homing Stage, please check connections.\n");
                                pc.printf("Lower limit sensor was tripped.\n\n");
                                }
                                
                            if (HLT == 1) {  //If we are at the home limit sensor stop moving stage.
                                Exit = Yes;     //If loop is true, stop moving stage.
                                pc.printf("Stage is Homed!\n\n");
                                }
                                
                            if (stepcount==inputsteps) { //If loop reaches max count, throw error
                                Exit = Yes;
                                pc.printf("Error Homing Stage, please check connections.\n");
                                pc.printf("Stage failed to move within giving limits.\n");
                                pc.printf("Possible error, Lower limit switch wasn't tripped.\n\n");
                                }
                            }
                        }    
                    }
                Exit = Yes;    
                }
            break;
            
     case 2: // (Move Forward) Call function here to do the required operation
     pc.printf("Move Stage Forward.\n\n",count);
     
            inputsteps=1;   //makes sure whiile loop is true once.
     while ( (inputsteps > 0) && (inputsteps < 101) ){          //Experimented to determine this range.
            pc.printf("How many steps do you want to move?\n"); //Next two lines print to PC for user input.
            pc.printf("     Enter a number between 1 and 100.\n\n");
            pc.scanf("%i", &inputsteps);    //Reads PC terminal to take in user input.
            lcd.cls();                      //Clears LCD screen.
            lcd.printf("%i", inputsteps);   //Print User command to mbed LCD.
            
            int stepcount = 0;                 // keeps track of how many steps were taken
            pc.printf("Move started....\n\n"); //Prints so user knows command was received.
            
                while (stepcount<inputsteps) { // compares how many steps taken to the desired steps passed in 
                    count++;
                
                    if (count == 5)     // if the motor went around oncce..
                        count=1;        // ...reset the counter
                
                    switch (count) {
                
                    case 1:     // if count equals 1 do this
                        STP1 = 1;
                        STP2 = 0;
                        STP3 = 0;
                        STP4 = 0;
                    break;      // this skips the code below until stepcount++ 
        
                    case 2:
                        STP1 = 0;
                        STP2 = 0;
                        STP3 = 1;
                        STP4 = 0;
                    break;

                    case 3:
                        STP1 = 0;
                        STP2 = 1;
                        STP3 = 0;
                        STP4 = 0;
                    break;
    
                    case 4:
                        STP1 = 0;
                        STP2 = 0;
                        STP3 = 0;
                        STP4 = 1;
                    break;
                    }
                    stepcount++;                //Iterate loop to keep track of steps.
                    lcd.cls();                  //Clear mbed LCD screen.
                    lcd.printf("%i", stepcount);//Print loop count on LCD.
                    wait(delayStep);            //Defines how fast to step the motor.
                    }
                inputsteps=0;   //Reset inputsteps so that while loop becomes false.
                pc.printf("%i steps completed.\n\n", stepcount); //Prints number of steps performed.
                }
            break;
            
     case 3: // (Move Backward) Call function here to do the required operation
     pc.printf("Move Stage Backwards.\n\n",count);
     
            inputsteps=1;   //makes sure while loop is true once.
     while ( (inputsteps > 0) && (inputsteps < 101) ){          //Experimented to determine this range.
            pc.printf("How many steps do you want to move?\n"); //Next two lines print to PC for user input.
            pc.printf("     Enter a number between 1 and 100.\n\n");
            pc.scanf("%i", &inputsteps);    //Reads PC terminal to take in user input.
            lcd.cls();                      //Clears LCD screen.
            lcd.printf("%i", inputsteps);   //Print User command to mbed LCD.
            
            int stepcount = 0;              // keeps track of how many steps were taken
            inputsteps=-1*inputsteps;       // reverses sign so that motor steps backwards.
            pc.printf("Move started....\n\n"); //Prints so user knows command was received.
                while (stepcount>inputsteps) { 

                    count--;
      
                    if (count == 0) // if the motor went around oncce..
                        count=4;    // ...reset the counter
                    
                    switch (count) {
      
                    case 1:     // if count equals 1 do this
                        STP1 = 1;
                        STP2 = 0;
                        STP3 = 0;
                        STP4 = 0;
                    break;

                    case 2:     // this skips the code below until stepcount--
                        STP1 = 0;
                        STP2 = 0;
                        STP3 = 1;
                        STP4 = 0;
                    break;

                    case 3:
                        STP1 = 0;
                        STP2 = 1;
                        STP3 = 0;
                        STP4 = 0;
                    break;

                    case 4:
                        STP1 = 0;
                        STP2 = 0;
                        STP3 = 0;
                        STP4 = 1;
                    break;
                    }
                    stepcount--;                //Iterate loop to keep track of steps.
                    lcd.cls();                  //Clear mbed LCD screen.
                    lcd.printf("%i", stepcount);//Print loop count on LCD.
                    wait(delayStep);
                    }
                inputsteps=0;   //Reset inputsteps so that while loop becomes false.
                pc.printf("%i steps completed.\n\n", stepcount); //Prints number of steps performed.    
                }
            break;
            
     case 4: // (End Program) Call function here to do the required operation
            pc.printf("Goodbye\n\n");
            wait(100000); //Wait forever!
            break;
            
     default: // (Invaild Input)
            pc.printf("Invaild Choice. Try again...\n\n");
            wait(1);
            break;
        }
    } 

while (1); //Program won't run without this while loop!

}


