/******************************************************
 * This header program declares all the functions and
 * variables used by RGB LED component.
 ******************************************************/


// Class to control an RGB LED using three PWM pins
class RGBLED {
    public:
        // RGBLED constructor
        RGBLED(PinName redPin, PinName greenPin, PinName bluePin) : red(redPin), green(greenPin), blue(bluePin) {
            red.period(0.0005);
            green.period(0.0005);
            blue.period(0.0005);
            red = 0.0;
            green = 0.0;
            blue = 0.0;
        }

        RGBLED operator=(int color) {
            write(color);
            return *this;
        }


    private:
        PwmOut red;
        PwmOut green;
        PwmOut blue;

        void write(int color) {
            red = (color >> 16) / 255.0 / 16.0;
            green = ((color >> 8) & 0xFF) / 255.0 / 16.0;
            blue = (color & 0xFF) / 255.0 / 16.0;
        }
};