/******************************************************
 * This header file declares all the functions and
 * variables used by the virtual stage in Pac-Man.
 ******************************************************/


#define FACERIGHT   0
#define FACEDOWN    1
#define FACELEFT    2
#define FACEUP      3


// Stage class
class Stage {
    public:
        // Stage constructor
        Stage(uLCD_4DGL& uLCD) : uLCD(uLCD) {
        }
    
        // Set up the stage
        void initialize() {
            printCounters();
            drawStage();
            setPositions();
        }

        // Check if the position is valid
        bool checkValid(int xCoordinate, int yCoordinate) {
            return (positions[xCoordinate][yCoordinate] != 0);
        }

        // Get the valid positions of the players
        char* getPositions() {
            return *positions;
        }

        // Get the number of pac dots
        int getPacDots() {
            return pacDots;
        }
    
        // Get the number of big pac dots
        int getBigPacDots() {
            return bigPacDots;
        }


    private:
        // Total number of pac dots
        int pacDots;
        // Total number of big pac dots
        int bigPacDots;
        // Invalid = 0, valid = 1, pac dot = 2, big pac dot = 3
        char positions[128][128];
        // uLCD display
        uLCD_4DGL& uLCD;
        // Set Pacman as a friend class
        friend class Pacman;
        // Set Ghost as a friend class
        friend class Ghost;

        // Print score and power-up counters
        void printCounters() {
            uLCD.printf("Score     Power-Up                 %%");
        }

        // Draw the bounds of the maze
        void drawStage() {
            uLCD.pixel(108, 64, BLUE);
            uLCD.pixel(20, 64, BLUE);
            uLCD.pixel(68, 24, BLUE);
            uLCD.pixel(60, 120, BLUE);
            uLCD.line(4, 16, 60, 16, BLUE);
            uLCD.line(68, 16, 124, 16, BLUE);
            uLCD.line(60, 16, 60, 24, BLUE);
            uLCD.line(68, 16, 68, 24, BLUE);
            uLCD.line(60, 24, 68, 24, BLUE);
            uLCD.line(4, 16, 4, 40, BLUE);
            uLCD.line(4, 40, 20, 40, BLUE);
            uLCD.line(20, 40, 20, 64, BLUE);
            uLCD.line(4, 64, 20, 64, BLUE);
            uLCD.line(4, 72, 20, 72, BLUE);
            uLCD.line(20, 72, 20, 96, BLUE);
            uLCD.line(20, 96, 4, 96, BLUE);
            uLCD.line(4, 96, 4, 120, BLUE);
            uLCD.line(4, 120, 60, 120, BLUE);
            uLCD.line(124, 16, 124, 40, BLUE);
            uLCD.line(124, 40, 108, 40, BLUE);
            uLCD.line(108, 40, 108, 64, BLUE);
            uLCD.line(124, 64, 108, 64, BLUE);
            uLCD.line(124, 72, 108, 72, BLUE);
            uLCD.line(108, 72, 108, 96, BLUE);
            uLCD.line(108, 96, 124, 96, BLUE);
            uLCD.line(124, 96, 124, 120, BLUE);
            uLCD.line(124, 120, 68, 120, BLUE);
            uLCD.line(68, 120, 68, 112, BLUE);
            uLCD.line(68, 112, 60, 112, BLUE);
            uLCD.line(60, 112, 60, 120, BLUE);
            uLCD.rectangle(12, 24, 20, 32, BLUE);
            uLCD.rectangle(28, 24, 52, 40, BLUE);
            uLCD.rectangle(76, 24, 100, 40, BLUE);
            uLCD.rectangle(108, 24, 116, 32, BLUE);
            uLCD.rectangle(28, 48, 44, 64, BLUE);
            uLCD.rectangle(84, 48, 100, 64, BLUE);
            uLCD.rectangle(28, 72, 44, 88, BLUE);
            uLCD.rectangle(84, 72, 100, 88, BLUE);
            uLCD.rectangle(52, 64, 76, 72, BLUE);
            uLCD.line(61, 64, 68, 64, PINK);
            uLCD.pixel(61, 64, PINK);
            uLCD.pixel(68, 64, PINK);
            uLCD.rectangle(12, 104, 20, 112, BLUE);
            uLCD.rectangle(28, 96, 52, 112, BLUE);
            uLCD.rectangle(76, 96, 100, 112, BLUE);
            uLCD.rectangle(108, 104, 116, 112, BLUE);
            uLCD.rectangle(60, 32, 68, 56, BLUE);
            uLCD.rectangle(52, 48, 76, 56, BLUE);
            uLCD.rectangle(60, 80, 68, 104, BLUE);
            uLCD.rectangle(52, 80, 76, 88, BLUE);
            uLCD.rectangle(60, 81, 68, 88, BLACK);
            uLCD.rectangle(60, 48, 68, 55, BLACK);
            uLCD.pixel(60, 48, BLUE);
            uLCD.pixel(68, 48, BLUE);
            uLCD.pixel(60, 88, BLUE);
            uLCD.pixel(68, 88, BLUE);
        }

        // Set the positions of the players and pac dots
        void setPositions() {
            // Set the valid positions of the players
            for (int i = 0; i < 128; i++) {
                for (int j = 0; j < 128; j++) {
                    positions[i][j] = 0;
                }
            }
    
            for (int i = 8; i <= 56; i++) {
                positions[i][20] = 1;
                positions[i][116] = 1;
            }
        
            for (int j = 20; j <= 36; j++) {
                positions[8][j] = 1;
                positions[120][j] = 1;
            }
        
            for (int i = 8; i <= 24; i++) {
                positions[i][36] = 1;
                positions[i][100] = 1;
            }
        
            for (int j = 20; j <= 116; j++) {
                positions[24][j] = 1;
                positions[104][j] = 1;
            }
        
            for (int j = 20; j <= 44; j++) {
                positions[56][j] = 1;
                positions[72][j] = 1;
            }
        
            for (int i = 24; i <= 56; i++) {
                positions[i][44] = 1;
                positions[i][92] = 1;
            }
        
            for (int j = 44; j <= 92; j++) {
                positions[48][j] = 1;
                positions[80][j] = 1;
            }
        
            for (int i = 4; i <= 48; i++) {
                positions[i][68] = 1;
            }
        
            for (int i = 56; i <= 72; i++) {
                positions[i][28] = 1;
                positions[i][108] = 1;
            }
        
            for (int i = 72; i <= 120; i++) {
                positions[i][20] = 1;
                positions[i][116] = 1;
            }
        
            for (int i = 72; i <= 104; i++) {
                positions[i][44] = 1;
                positions[i][92] = 1;
            }
        
            for (int i = 104; i <= 120; i++) {
                positions[i][36] = 1;
                positions[i][100] = 1;
            }
        
            for (int i = 48; i <= 80; i++) {
                positions[i][60] = 1;
                positions[i][76] = 1;
            }
        
            for (int i = 80; i <= 124; i++) {
                positions[i][68] = 1;
            }
        
            for (int j = 100; j <= 116; j++) {
                positions[8][j] = 1;
                positions[120][j] = 1;
            }
        
            for (int j = 92; j <= 116; j++) {
                positions[56][j] = 1;
                positions[72][j] = 1;
            }

            // Set valid positions of the pac dots
            pacDots = -40;
            bigPacDots = 4;
        
            for (int i = 0; i < 128; i++) {
                for (int j = 0; j < 128; j++) {
                    if (positions[i][j] == 1) {
                        if ((i % 4 == 0) && (j % 4 == 0)) {
                            uLCD.pixel(i, j, YELLOW);
                            pacDots++;
                            positions[i][j] = 2;
                        }
                    }
                }
            }

            uLCD.rectangle(48, 60, 80, 76, BLACK);
            uLCD.line(48, 46, 48, 91, BLACK);
            uLCD.line(80, 46, 80, 91, BLACK);
            uLCD.line(58, 108, 70, 108, BLACK);
            
            for (int i = 48; i <= 80; i++) {
                for (int j = 45; j < 91; j++) {
                    if (positions[i][j] == 2) {
                        positions[i][j] = 1;
                    }
                }
            }

            uLCD.filled_circle(8, 100, 1, YELLOW);
            positions[8][100] = 3;
            uLCD.filled_circle(120, 100, 1, YELLOW);
            positions[120][100] = 3;
            uLCD.filled_circle(8, 36, 1, YELLOW);
            positions[8][36] = 3;
            uLCD.filled_circle(120, 36, 1, YELLOW);
            positions[120][36] = 3;
        }

        // Redraw the current pac dot locations
        void redrawPacDots() {
            for (int i = 4; i <= 124; i++) {
                for (int j = 20; j <= 116; j++) {
                    if (positions[i][j] == 2) {
                        uLCD.pixel(i, j, YELLOW);
                    } else if (positions[i][j] == 3) {
                        uLCD.filled_circle(i, j, 1, YELLOW);
                    }
                }
            }

            uLCD.pixel(64, 108, BLACK);
        }            
};