/******************************************************
 * This header program declares all the functions and
 * variables used by one of the players in Rock, Paper,
 * Scissors, Lizard, Spock.
 ******************************************************/


#define ROCK            0
#define PAPER           1
#define SCISSORS        2
#define LIZARD          3
#define SPOCK           4
#define SWITCHUP        0
#define SWITCHCLICK     1
#define SWITCHLEFT      2
#define SWITCHDOWN      3
#define SWITCHRIGHT     4
#define MEH             "/sd/Meh.wav"


// Rock, Paper, Scissors, Lizard, Spock player one class
class RPSLK {
    public:
        // Rock, Paper, Scissors, Lizard, Spock constructor
        RPSLK(DigitalOut &reset, PinDetect &rock, PinDetect &paper, PinDetect &scissors, PinDetect &lizard, PinDetect &spock, SDFileSystem &sd, Serial &XBee, uLCD_4DGL &uLCD,
            wave_player &waver) : reset(reset), rock(rock), paper(paper), scissors(scissors), lizard(lizard), spock(spock), sd(sd), XBee(XBee), uLCD(uLCD), waver(waver) {
            // Maximize the uLCD baud rate
            uLCD.baudrate(MAXBAUDRATE);

            // Set up interrupts
            rock.mode(PullUp);
            paper.mode(PullUp);
            scissors.mode(PullUp);
            lizard.mode(PullUp);
            spock.mode(PullUp);
            wait(0.1);
            rock.attach_deasserted(this, &RPSLK::upTrigger);
            paper.attach_deasserted(this, &RPSLK::clickTrigger);
            scissors.attach_deasserted(this, &RPSLK::leftTrigger);
            lizard.attach_deasserted(this, &RPSLK::downTrigger);
            spock.attach_deasserted(this, &RPSLK::rightTrigger);
            wait(0.1);        
            rock.setSampleFrequency();
            paper.setSampleFrequency();
            scissors.setSampleFrequency();
            lizard.setSampleFrequency();
            spock.setSampleFrequency();
            wait(0.1);

            // Set up XBee
            reset = 0;
            wait(0.001);
            reset = 1;
            wait(0.001);

            choice = -1;
            otherChoice = -1;
            hand = -1;
            otherHand = -1;
            score = 0;
            otherScore = 0;
        }

        // Play the game
        void playRPSLK() {
            displayInstructions();

            restart:
            resetChoices();
            selectHand();
            compareHands();
            compareScores();
            bool playAgain = replay();

            if (playAgain == true) {
                goto restart;
            } else {
                displayFinalScores();
            }
        }


    private:
        DigitalOut &reset;
        PinDetect &rock;
        PinDetect &paper;
        PinDetect &scissors;
        PinDetect &lizard;
        PinDetect &spock;
        SDFileSystem &sd;
        Serial &XBee;
        uLCD_4DGL &uLCD;
        wave_player &waver;
        volatile int choice;
        int otherChoice;
        int hand;
        int otherHand;
        int score;
        int otherScore;

        // Tactile switch interrupt routines
        void upTrigger() {
            choice = SWITCHUP;
        }

        void clickTrigger() {
            choice = SWITCHCLICK;
        }

        void leftTrigger() {
            choice = SWITCHLEFT;
        }

        void downTrigger() {
            choice = SWITCHDOWN;
        }

        void rightTrigger() {
            choice = SWITCHRIGHT;
        }

        // Play a sound file
        void playSound(char *wav) {
            // Open sound file
            FILE *wave_file;
            wave_file = fopen(wav, "r");

            // Play wav file
            waver.play(wave_file);

            // Close wav file
            fclose(wave_file);
        }

        // Reset choices and hands
        void resetChoices() {
            choice = -1;
            otherChoice = -1;
            hand = -1;
            otherHand = -1;
        }

        // Display instructions
        void displayInstructions() {
            uLCD.cls();
            uLCD.printf("Hello, and welcometo a game of Rock,Paper, Scissors,\nLizard, Spock.\n\n");
            uLCD.printf("Click the tactile ");
            uLCD.printf("switch to         ");
            uLCD.printf("continue.");

            while (choice != SWITCHCLICK) {
                wait(0.01);
            }

            choice = -1;
            uLCD.cls();

            uLCD.printf("Scissors > Paper\n");
            uLCD.printf("Paper > Rock\n");
            uLCD.printf("Rock > Lizard\n");
            uLCD.printf("Lizard > Spock\n");
            uLCD.printf("Spock > Scissors\n");
            uLCD.printf("Scissors > Lizard\n");
            uLCD.printf("Lizard > Paper\n");
            uLCD.printf("Paper > Spock\n");
            uLCD.printf("Spock > Rock\n");
            uLCD.printf("Rock > Scissors\n\n");
            uLCD.printf("Click to continue.");

            while (choice != SWITCHCLICK) {
                wait(0.01);
            }

            choice = -1;
            uLCD.cls();
        }

        // Select hand
        void selectHand() {
            uLCD.printf("Up: Rock\n");
            uLCD.printf("Click: Paper\n");
            uLCD.printf("Left: Scissors\n");
            uLCD.printf("Down: Lizard\n");
            uLCD.printf("Right: Spock\n\n");
            uLCD.printf("Choose your hand.");

            choice = -1;

            while (choice == -1) {
                wait(0.01);
            }

            hand = choice;
            XBee.putc(hand);
            uLCD.cls();
        }

        // Display hand
        void displayHand() {
            uLCD.printf("You chose ");

            switch (hand) {
                case ROCK:
                    uLCD.printf("Rock\n\n");
                    break;
                case PAPER:
                    uLCD.printf("Paper\n\n");
                    break;
                case SCISSORS:
                    uLCD.printf("Scissors\n");
                    break;
                case LIZARD:
                    uLCD.printf("Lizard\n\n");
                    break;
                case SPOCK:
                    uLCD.printf("Spock\n\n");
                    break;
                default:
                    break;
            }
        }

        // Compare hands
        void compareHands() {
            uLCD.printf("You chose ");

            switch (hand) {
                case ROCK:
                    uLCD.printf("Rock\n\n");
                    break;
                case PAPER:
                    uLCD.printf("Paper\n\n");
                    break;
                case SCISSORS:
                    uLCD.printf("Scissors\n");
                    break;
                case LIZARD:
                    uLCD.printf("Lizard\n\n");
                    break;
                case SPOCK:
                    uLCD.printf("Spock\n\n");
                    break;
                default:
                    break;
            }

            bool print = true;

            while (otherHand == -1) {
                if (XBee.readable() == true) {
                    otherHand = XBee.getc();
                    print = false;
                }

                if (print == true) {
                    uLCD.printf("Waiting for other player...");
                    print = false;
                }
            }

            wait(1);
            uLCD.cls();

            switch (hand) {
                case ROCK:
                    uLCD.printf("Rock ");
                    drawLeftRock();
                    break;
                case PAPER:
                    uLCD.printf("Paper ");
                    drawLeftPaper();
                    break;
                case SCISSORS:
                    uLCD.printf("Scissors ");
                    drawLeftScissors();
                    break;
                case LIZARD:
                    uLCD.printf("Lizard ");
                    drawLeftLizard();
                    break;
                case SPOCK:
                    uLCD.printf("Spock ");
                    drawLeftSpock();
                    break;
                default:
                    break;
            }

            switch (otherHand) {
                case ROCK:
                    uLCD.locate(14, 0);
                    uLCD.printf("Rock\n");
                    drawRightRock();
                    break;
                case PAPER:
                    uLCD.locate(13, 0);
                    uLCD.printf("Paper\n");
                    drawRightPaper();
                    break;
                case SCISSORS:
                    uLCD.locate(10, 0);
                    uLCD.printf("Scissors\n");
                    drawRightScissors();
                    break;
                case LIZARD:
                    uLCD.locate(12, 0);
                    uLCD.printf("Lizard\n");
                    drawRightLizard();
                    break;
                case SPOCK:
                    uLCD.locate(13, 0);
                    uLCD.printf("Spock\n");
                    drawRightSpock();
                    break;
                default:
                    break;
            }

            uLCD.printf("You chose...\n");

            wait(2);

            if (hand == otherHand) {
                uLCD.printf("mediocrely.");
                playSound(MEH);
            } else if ((hand == SCISSORS) && ((otherHand == PAPER) || (otherHand == LIZARD))) {
                uLCD.printf("wisely.");
                playSound(WIN);
                score++;
            } else if ((hand == PAPER) && ((otherHand == ROCK) || (otherHand == SPOCK))) {
                uLCD.printf("wisely.");
                playSound(WIN);
                score++;
            } else if ((hand == ROCK) && ((otherHand == LIZARD) || (otherHand == SCISSORS))) {
                uLCD.printf("wisely.");
                playSound(WIN);
                score++;
            } else if ((hand == LIZARD) && ((otherHand == SPOCK) || (otherHand == PAPER))) {
                uLCD.printf("wisely.");
                playSound(WIN);
                score++;
            } else if ((hand == SPOCK) && ((otherHand == SCISSORS) || (otherHand == ROCK))) {
                uLCD.printf("wisely.");
                playSound(WIN);
                score++;
            } else {
                uLCD.printf("poorly.");
                playSound(BOMB);
            }

            XBee.putc(true);
            bool done = false;

            while (done == false) {
                if (XBee.readable() == true) {
                    done = XBee.getc();
                }
            }
        }

        // Compare scores
        void compareScores() {
            XBee.putc(score);
            wait(1);

            if (XBee.readable() == true) {
                otherScore = XBee.getc();
            }

            wait(1);
            uLCD.cls();

            uLCD.printf("Your score: %d\n\n", score);
            uLCD.printf("Their score: %d\n\n", otherScore);

            if (score == otherScore) {
                uLCD.printf("It is tied!\n\n");
            } else if (score > otherScore) {
                uLCD.printf("You are winning!\n\n");
            } else {
                uLCD.printf("The other player\nis winning.\n\n");
            }

            uLCD.printf("Click to continue.");
            resetChoices();

            while (choice != SWITCHCLICK) {
                wait(0.01);
            }

            uLCD.cls();
        }

        // Ask if the player wants to replay
        bool replay() {
            bool playAgain = true;
            uLCD.printf("Play again?\n\n");
            uLCD.printf("Click to play\nagain or tilt to\nquit.");

            resetChoices();

            while (choice == -1) {
                if (XBee.readable() == true) {
                    otherChoice = XBee.getc();
                }
            }

            XBee.putc(choice);
            uLCD.cls();

            if (choice != SWITCHCLICK) {
                uLCD.printf("Exiting...");
                playAgain = false;
            } else {
                bool print = true;

                while (otherChoice == -1) {
                    if (XBee.readable() == true) {
                        otherChoice = XBee.getc();
                        print = false;
                    }

                    if (print == true) {
                        uLCD.printf("Waiting for other player...");
                        print = false;
                    }
                }

                uLCD.cls();

                if ((otherChoice == SWITCHUP) || (otherChoice == SWITCHLEFT) || (otherChoice == SWITCHDOWN) || (otherChoice == SWITCHRIGHT)) {
                    uLCD.printf("Sorry, but the\nother player quit.\n\nExiting...");
                    playAgain = false;
                } else if (otherChoice == SWITCHCLICK) {
                    uLCD.printf("Get ready for\nanother round!");
                    playAgain = true;
                }
            }

            wait(2);
            uLCD.cls();
            return playAgain;
        }

        // Display the final scores
        void displayFinalScores() {
            uLCD.printf("Final scores:\n\n");
            uLCD.printf("Your score: %d\n\n", score);
            uLCD.printf("Their score: %d\n\n\n", otherScore);

            wait(3);

            if (score > otherScore) {
                uLCD.printf("You win!");
                playSound(WIN);
            } else if (score == otherScore) {
                uLCD.printf("It's a draw!");
                playSound(MEH);
            } else {
                uLCD.printf("You lose.");
                playSound(BOMB);
            }
        }

        // Draw left Lizard
        void drawLeftLizard() {
            uLCD.pixel(25, 80, 2427648);
            uLCD.pixel(26, 80, 2623744);
            uLCD.pixel(24, 81, 8546383);
            uLCD.pixel(25, 81, 13215366);
            uLCD.pixel(26, 81, 14727316);
            uLCD.pixel(27, 81, 11569252);
            uLCD.pixel(28, 81, 7030565);
            uLCD.pixel(29, 81, 2755328);
            uLCD.pixel(23, 82, 5192732);
            uLCD.pixel(24, 82, 15519137);
            uLCD.pixel(25, 82, 15648143);
            uLCD.pixel(26, 82, 15844231);
            uLCD.pixel(27, 82, 16435850);
            uLCD.pixel(28, 82, 16502672);
            uLCD.pixel(29, 82, 15385221);
            uLCD.pixel(30, 82, 12755561);
            uLCD.pixel(31, 82, 10388563);
            uLCD.pixel(32, 82, 8218948);
            uLCD.pixel(33, 82, 5062177);
            uLCD.pixel(34, 82, 2035968);
            uLCD.pixel(23, 83, 10389593);
            uLCD.pixel(24, 83, 16176025);
            uLCD.pixel(25, 83, 14463341);
            uLCD.pixel(26, 83, 14527332);
            uLCD.pixel(27, 83, 15250024);
            uLCD.pixel(28, 83, 14723680);
            uLCD.pixel(29, 83, 15251307);
            uLCD.pixel(30, 83, 16436099);
            uLCD.pixel(31, 83, 15780232);
            uLCD.pixel(32, 83, 15650459);
            uLCD.pixel(33, 83, 14862236);
            uLCD.pixel(34, 83, 13941651);
            uLCD.pixel(35, 83, 11771256);
            uLCD.pixel(36, 83, 7627073);
            uLCD.pixel(37, 83, 3022854);
            uLCD.pixel(22, 84, 2692608);
            uLCD.pixel(23, 84, 14927752);
            uLCD.pixel(24, 84, 13872743);
            uLCD.pixel(25, 84, 14002528);
            uLCD.pixel(26, 84, 14855531);
            uLCD.pixel(27, 84, 15709557);
            uLCD.pixel(28, 84, 14129751);
            uLCD.pixel(29, 84, 13339717);
            uLCD.pixel(30, 84, 14458451);
            uLCD.pixel(31, 84, 13735758);
            uLCD.pixel(32, 84, 12946768);
            uLCD.pixel(33, 84, 13079386);
            uLCD.pixel(34, 84, 12882777);
            uLCD.pixel(35, 84, 13081701);
            uLCD.pixel(36, 84, 14399106);
            uLCD.pixel(37, 84, 13742726);
            uLCD.pixel(38, 84, 7823422);
            uLCD.pixel(22, 85, 8414771);
            uLCD.pixel(23, 85, 15255679);
            uLCD.pixel(24, 85, 13213777);
            uLCD.pixel(25, 85, 15514736);
            uLCD.pixel(26, 85, 16434050);
            uLCD.pixel(27, 85, 16761475);
            uLCD.pixel(28, 85, 16760958);
            uLCD.pixel(29, 85, 16761468);
            uLCD.pixel(30, 85, 16761977);
            uLCD.pixel(31, 85, 15970148);
            uLCD.pixel(32, 85, 16759674);
            uLCD.pixel(33, 85, 15905137);
            uLCD.pixel(34, 85, 16432506);
            uLCD.pixel(35, 85, 15512946);
            uLCD.pixel(36, 85, 12751182);
            uLCD.pixel(37, 85, 12752473);
            uLCD.pixel(38, 85, 13741176);
            uLCD.pixel(39, 85, 12493177);
            uLCD.pixel(40, 85, 5783590);
            uLCD.pixel(21, 86, 2230016);
            uLCD.pixel(22, 86, 13742203);
            uLCD.pixel(23, 86, 14662000);
            uLCD.pixel(24, 86, 14133338);
            uLCD.pixel(25, 86, 16368760);
            uLCD.pixel(26, 86, 16433017);
            uLCD.pixel(27, 86, 16300406);
            uLCD.pixel(28, 86, 16760696);
            uLCD.pixel(29, 86, 16563316);
            uLCD.pixel(30, 86, 16629109);
            uLCD.pixel(31, 86, 16761210);
            uLCD.pixel(32, 86, 16761474);
            uLCD.pixel(33, 86, 16760960);
            uLCD.pixel(34, 86, 16234611);
            uLCD.pixel(35, 86, 16564343);
            uLCD.pixel(36, 86, 16765316);
            uLCD.pixel(37, 86, 15908207);
            uLCD.pixel(38, 86, 13540437);
            uLCD.pixel(39, 86, 12751958);
            uLCD.pixel(40, 86, 15648403);
            uLCD.pixel(41, 86, 12754554);
            uLCD.pixel(42, 86, 7164219);
            uLCD.pixel(21, 87, 7163441);
            uLCD.pixel(22, 87, 15846033);
            uLCD.pixel(23, 87, 14594149);
            uLCD.pixel(24, 87, 16039023);
            uLCD.pixel(25, 87, 16696181);
            uLCD.pixel(26, 87, 16432243);
            uLCD.pixel(27, 87, 16431730);
            uLCD.pixel(28, 87, 16695415);
            uLCD.pixel(29, 87, 16300657);
            uLCD.pixel(30, 87, 16037748);
            uLCD.pixel(31, 87, 16696193);
            uLCD.pixel(32, 87, 16037750);
            uLCD.pixel(33, 87, 15971955);
            uLCD.pixel(34, 87, 16432760);
            uLCD.pixel(35, 87, 16498804);
            uLCD.pixel(36, 87, 16169321);
            uLCD.pixel(37, 87, 16498286);
            uLCD.pixel(38, 87, 16761974);
            uLCD.pixel(39, 87, 16039026);
            uLCD.pixel(40, 87, 12421707);
            uLCD.pixel(41, 87, 14133364);
            uLCD.pixel(42, 87, 16305832);
            uLCD.pixel(43, 87, 12754564);
            uLCD.pixel(44, 87, 5453098);
            uLCD.pixel(20, 88, 2164224);
            uLCD.pixel(21, 88, 13346174);
            uLCD.pixel(22, 88, 16041608);
            uLCD.pixel(23, 88, 15973233);
            uLCD.pixel(24, 88, 16563825);
            uLCD.pixel(25, 88, 16760175);
            uLCD.pixel(26, 88, 16760946);
            uLCD.pixel(27, 88, 16760945);
            uLCD.pixel(28, 88, 16761461);
            uLCD.pixel(29, 88, 16630650);
            uLCD.pixel(30, 88, 15249777);
            uLCD.pixel(31, 88, 13934176);
            uLCD.pixel(32, 88, 14460512);
            uLCD.pixel(33, 88, 14657887);
            uLCD.pixel(34, 88, 15183463);
            uLCD.pixel(35, 88, 15446376);
            uLCD.pixel(36, 88, 15709035);
            uLCD.pixel(37, 88, 16629367);
            uLCD.pixel(38, 88, 16760953);
            uLCD.pixel(39, 88, 15905648);
            uLCD.pixel(40, 88, 16762760);
            uLCD.pixel(41, 88, 13933924);
            uLCD.pixel(42, 88, 12553049);
            uLCD.pixel(43, 88, 14002303);
            uLCD.pixel(44, 88, 14398100);
            uLCD.pixel(45, 88, 9135953);
            uLCD.pixel(46, 88, 3083776);
            uLCD.pixel(20, 89, 5782301);
            uLCD.pixel(21, 89, 16305822);
            uLCD.pixel(22, 89, 15710585);
            uLCD.pixel(23, 89, 16761465);
            uLCD.pixel(24, 89, 16760178);
            uLCD.pixel(25, 89, 16430440);
            uLCD.pixel(26, 89, 16760429);
            uLCD.pixel(27, 89, 16695405);
            uLCD.pixel(28, 89, 16038504);
            uLCD.pixel(29, 89, 15250024);
            uLCD.pixel(30, 89, 14132331);
            uLCD.pixel(31, 89, 13869674);
            uLCD.pixel(32, 89, 13739358);
            uLCD.pixel(33, 89, 14594149);
            uLCD.pixel(34, 89, 13409364);
            uLCD.pixel(35, 89, 13079120);
            uLCD.pixel(36, 89, 14591847);
            uLCD.pixel(37, 89, 15051115);
            uLCD.pixel(38, 89, 15248236);
            uLCD.pixel(39, 89, 16762501);
            uLCD.pixel(40, 89, 15972470);
            uLCD.pixel(41, 89, 16763013);
            uLCD.pixel(42, 89, 16500871);
            uLCD.pixel(43, 89, 13475167);
            uLCD.pixel(44, 89, 12291417);
            uLCD.pixel(45, 89, 13937533);
            uLCD.pixel(46, 89, 13214331);
            uLCD.pixel(47, 89, 9927777);
            uLCD.pixel(48, 89, 2234640);
            uLCD.pixel(20, 90, 10847323);
            uLCD.pixel(21, 90, 16041870);
            uLCD.pixel(22, 90, 15907188);
            uLCD.pixel(23, 90, 16760179);
            uLCD.pixel(24, 90, 16760695);
            uLCD.pixel(25, 90, 16759151);
            uLCD.pixel(26, 90, 16760684);
            uLCD.pixel(27, 90, 16761710);
            uLCD.pixel(28, 90, 16631411);
            uLCD.pixel(29, 90, 14922603);
            uLCD.pixel(30, 90, 12949349);
            uLCD.pixel(31, 90, 13542514);
            uLCD.pixel(32, 90, 11438919);
            uLCD.pixel(33, 90, 10452275);
            uLCD.pixel(34, 90, 10714682);
            uLCD.pixel(35, 90, 11437128);
            uLCD.pixel(36, 90, 11764812);
            uLCD.pixel(37, 90, 12948572);
            uLCD.pixel(38, 90, 14526831);
            uLCD.pixel(39, 90, 14921839);
            uLCD.pixel(40, 90, 15447918);
            uLCD.pixel(41, 90, 15843443);
            uLCD.pixel(42, 90, 15976051);
            uLCD.pixel(43, 90, 15318891);
            uLCD.pixel(44, 90, 14463844);
            uLCD.pixel(45, 90, 12622415);
            uLCD.pixel(46, 90, 12820056);
            uLCD.pixel(47, 90, 15652001);
            uLCD.pixel(48, 90, 3221527);
            uLCD.pixel(19, 91, 2034176);
            uLCD.pixel(20, 91, 14728330);
            uLCD.pixel(21, 91, 15448955);
            uLCD.pixel(22, 91, 16761725);
            uLCD.pixel(23, 91, 16759666);
            uLCD.pixel(24, 91, 16692080);
            uLCD.pixel(25, 91, 16761210);
            uLCD.pixel(26, 91, 16760686);
            uLCD.pixel(27, 91, 15906400);
            uLCD.pixel(28, 91, 16763767);
            uLCD.pixel(29, 91, 14528874);
            uLCD.pixel(30, 91, 8871213);
            uLCD.pixel(31, 91, 6307093);
            uLCD.pixel(32, 91, 9993290);
            uLCD.pixel(33, 91, 12362605);
            uLCD.pixel(34, 91, 13347965);
            uLCD.pixel(35, 91, 13149047);
            uLCD.pixel(36, 91, 12950128);
            uLCD.pixel(37, 91, 11633238);
            uLCD.pixel(38, 91, 10842942);
            uLCD.pixel(39, 91, 11632450);
            uLCD.pixel(40, 91, 12553542);
            uLCD.pixel(41, 91, 13080648);
            uLCD.pixel(42, 91, 14331224);
            uLCD.pixel(43, 91, 14990439);
            uLCD.pixel(44, 91, 15451768);
            uLCD.pixel(45, 91, 14399857);
            uLCD.pixel(46, 91, 12031317);
            uLCD.pixel(47, 91, 10586459);
            uLCD.pixel(19, 92, 6309409);
            uLCD.pixel(20, 92, 15912596);
            uLCD.pixel(21, 92, 15119728);
            uLCD.pixel(22, 92, 16761210);
            uLCD.pixel(23, 92, 16759412);
            uLCD.pixel(24, 92, 16758903);
            uLCD.pixel(25, 92, 16760185);
            uLCD.pixel(26, 92, 16759917);
            uLCD.pixel(27, 92, 15972709);
            uLCD.pixel(28, 92, 16172658);
            uLCD.pixel(29, 92, 12358218);
            uLCD.pixel(30, 92, 8608302);
            uLCD.pixel(31, 92, 2031616);
            uLCD.pixel(32, 92, 2361856);
            uLCD.pixel(33, 92, 3678741);
            uLCD.pixel(34, 92, 3479821);
            uLCD.pixel(35, 92, 5319967);
            uLCD.pixel(36, 92, 10581087);
            uLCD.pixel(37, 92, 12948083);
            uLCD.pixel(38, 92, 12355162);
            uLCD.pixel(39, 92, 12749138);
            uLCD.pixel(40, 92, 14064732);
            uLCD.pixel(41, 92, 12881737);
            uLCD.pixel(42, 92, 11830078);
            uLCD.pixel(43, 92, 12028748);
            uLCD.pixel(44, 92, 10451272);
            uLCD.pixel(45, 92, 9268551);
            uLCD.pixel(46, 92, 3348225);
            uLCD.pixel(19, 93, 10453076);
            uLCD.pixel(20, 93, 16635028);
            uLCD.pixel(21, 93, 15711090);
            uLCD.pixel(22, 93, 16761465);
            uLCD.pixel(23, 93, 16364910);
            uLCD.pixel(24, 93, 16759419);
            uLCD.pixel(25, 93, 16561525);
            uLCD.pixel(26, 93, 16762233);
            uLCD.pixel(27, 93, 16302189);
            uLCD.pixel(28, 93, 15646316);
            uLCD.pixel(29, 93, 14792559);
            uLCD.pixel(30, 93, 11832157);
            uLCD.pixel(35, 93, 3740676);
            uLCD.pixel(36, 93, 9396294);
            uLCD.pixel(37, 93, 14394238);
            uLCD.pixel(38, 93, 16498060);
            uLCD.pixel(39, 93, 16760707);
            uLCD.pixel(40, 93, 16760442);
            uLCD.pixel(41, 93, 16761471);
            uLCD.pixel(42, 93, 16236931);
            uLCD.pixel(43, 93, 15449483);
            uLCD.pixel(44, 93, 9201734);
            uLCD.pixel(18, 94, 3545088);
            uLCD.pixel(19, 94, 14004348);
            uLCD.pixel(20, 94, 16041859);
            uLCD.pixel(21, 94, 15645037);
            uLCD.pixel(22, 94, 16761204);
            uLCD.pixel(23, 94, 16761467);
            uLCD.pixel(24, 94, 16760962);
            uLCD.pixel(25, 94, 16035440);
            uLCD.pixel(26, 94, 16761980);
            uLCD.pixel(27, 94, 16762487);
            uLCD.pixel(28, 94, 15514730);
            uLCD.pixel(29, 94, 15449976);
            uLCD.pixel(30, 94, 15055753);
            uLCD.pixel(31, 94, 7557420);
            uLCD.pixel(32, 94, 2626560);
            uLCD.pixel(33, 94, 2429440);
            uLCD.pixel(34, 94, 6835239);
            uLCD.pixel(35, 94, 13082996);
            uLCD.pixel(36, 94, 16368782);
            uLCD.pixel(37, 94, 16761474);
            uLCD.pixel(38, 94, 16760436);
            uLCD.pixel(39, 94, 16759661);
            uLCD.pixel(40, 94, 16760686);
            uLCD.pixel(41, 94, 16628332);
            uLCD.pixel(42, 94, 16104315);
            uLCD.pixel(43, 94, 15581069);
            uLCD.pixel(44, 94, 15189671);
            uLCD.pixel(45, 94, 4929577);
            uLCD.pixel(15, 95, 2430465);
            uLCD.pixel(16, 95, 4005635);
            uLCD.pixel(17, 95, 5122566);
            uLCD.pixel(18, 95, 10845264);
            uLCD.pixel(19, 95, 16173456);
            uLCD.pixel(20, 95, 16303741);
            uLCD.pixel(21, 95, 16367727);
            uLCD.pixel(22, 95, 16300393);
            uLCD.pixel(23, 95, 16759666);
            uLCD.pixel(24, 95, 16760191);
            uLCD.pixel(25, 95, 16627579);
            uLCD.pixel(26, 95, 16563317);
            uLCD.pixel(27, 95, 16433011);
            uLCD.pixel(28, 95, 16302963);
            uLCD.pixel(29, 95, 15317359);
            uLCD.pixel(30, 95, 16238222);
            uLCD.pixel(31, 95, 14990475);
            uLCD.pixel(32, 95, 14072710);
            uLCD.pixel(33, 95, 13546877);
            uLCD.pixel(34, 95, 15123591);
            uLCD.pixel(35, 95, 16437131);
            uLCD.pixel(36, 95, 16236405);
            uLCD.pixel(37, 95, 16496746);
            uLCD.pixel(38, 95, 16760428);
            uLCD.pixel(39, 95, 16758630);
            uLCD.pixel(40, 95, 16758891);
            uLCD.pixel(41, 95, 15509859);
            uLCD.pixel(42, 95, 14920820);
            uLCD.pixel(43, 95, 13345143);
            uLCD.pixel(44, 95, 13546138);
            uLCD.pixel(45, 95, 4601901);
            uLCD.pixel(13, 96, 4205074);
            uLCD.pixel(14, 96, 9928549);
            uLCD.pixel(15, 96, 14927526);
            uLCD.pixel(16, 96, 16305571);
            uLCD.pixel(17, 96, 15514249);
            uLCD.pixel(18, 96, 16764567);
            uLCD.pixel(19, 96, 16039550);
            uLCD.pixel(20, 96, 15775594);
            uLCD.pixel(21, 96, 16498283);
            uLCD.pixel(22, 96, 16760683);
            uLCD.pixel(23, 96, 16760946);
            uLCD.pixel(24, 96, 16430452);
            uLCD.pixel(25, 96, 16761221);
            uLCD.pixel(26, 96, 16694135);
            uLCD.pixel(27, 96, 15971690);
            uLCD.pixel(28, 96, 16762998);
            uLCD.pixel(29, 96, 16302449);
            uLCD.pixel(30, 96, 16170878);
            uLCD.pixel(31, 96, 16369544);
            uLCD.pixel(32, 96, 15648384);
            uLCD.pixel(33, 96, 15911808);
            uLCD.pixel(34, 96, 16173179);
            uLCD.pixel(35, 96, 15908720);
            uLCD.pixel(36, 96, 16038764);
            uLCD.pixel(37, 96, 16761204);
            uLCD.pixel(38, 96, 16760693);
            uLCD.pixel(39, 96, 15905135);
            uLCD.pixel(40, 96, 14392676);
            uLCD.pixel(41, 96, 15315075);
            uLCD.pixel(42, 96, 11568225);
            uLCD.pixel(43, 96, 10715494);
            uLCD.pixel(44, 96, 10719359);
            uLCD.pixel(45, 96, 2037516);
            uLCD.pixel(7, 97, 2296576);
            uLCD.pixel(8, 97, 3480064);
            uLCD.pixel(9, 97, 4334855);
            uLCD.pixel(10, 97, 6044442);
            uLCD.pixel(11, 97, 8741694);
            uLCD.pixel(12, 97, 12228463);
            uLCD.pixel(13, 97, 14991251);
            uLCD.pixel(14, 97, 15648923);
            uLCD.pixel(15, 97, 15252619);
            uLCD.pixel(16, 97, 15907715);
            uLCD.pixel(17, 97, 16564356);
            uLCD.pixel(18, 97, 15905911);
            uLCD.pixel(19, 97, 16301174);
            uLCD.pixel(20, 97, 16760944);
            uLCD.pixel(21, 97, 16761451);
            uLCD.pixel(22, 97, 16761708);
            uLCD.pixel(23, 97, 16628331);
            uLCD.pixel(24, 97, 16627829);
            uLCD.pixel(25, 97, 16759420);
            uLCD.pixel(26, 97, 16760186);
            uLCD.pixel(27, 97, 16760179);
            uLCD.pixel(28, 97, 16761455);
            uLCD.pixel(29, 97, 16498283);
            uLCD.pixel(30, 97, 16366450);
            uLCD.pixel(31, 97, 16169586);
            uLCD.pixel(32, 97, 16038766);
            uLCD.pixel(33, 97, 16302449);
            uLCD.pixel(34, 97, 16236141);
            uLCD.pixel(35, 97, 16236141);
            uLCD.pixel(36, 97, 16499828);
            uLCD.pixel(37, 97, 16105333);
            uLCD.pixel(38, 97, 15053425);
            uLCD.pixel(39, 97, 14395764);
            uLCD.pixel(40, 97, 12752495);
            uLCD.pixel(41, 97, 6503969);
            uLCD.pixel(42, 97, 2163712);
            uLCD.pixel(43, 97, 2033920);
            uLCD.pixel(0, 98, 3020800);
            uLCD.pixel(1, 98, 3415552);
            uLCD.pixel(2, 98, 5125648);
            uLCD.pixel(3, 98, 7362351);
            uLCD.pixel(4, 98, 9203784);
            uLCD.pixel(5, 98, 11176799);
            uLCD.pixel(6, 98, 13018230);
            uLCD.pixel(7, 98, 14069887);
            uLCD.pixel(8, 98, 14661250);
            uLCD.pixel(9, 98, 15778700);
            uLCD.pixel(10, 98, 16567184);
            uLCD.pixel(11, 98, 16501130);
            uLCD.pixel(12, 98, 16237952);
            uLCD.pixel(13, 98, 16368766);
            uLCD.pixel(14, 98, 16368507);
            uLCD.pixel(15, 98, 16301685);
            uLCD.pixel(16, 98, 16496754);
            uLCD.pixel(17, 98, 16761212);
            uLCD.pixel(18, 98, 16496241);
            uLCD.pixel(19, 98, 16761208);
            uLCD.pixel(20, 98, 16761197);
            uLCD.pixel(21, 98, 16563041);
            uLCD.pixel(22, 98, 16761192);
            uLCD.pixel(23, 98, 16759913);
            uLCD.pixel(24, 98, 16760184);
            uLCD.pixel(25, 98, 16561527);
            uLCD.pixel(26, 98, 16759673);
            uLCD.pixel(27, 98, 16761465);
            uLCD.pixel(28, 98, 16759656);
            uLCD.pixel(29, 98, 16496482);
            uLCD.pixel(30, 98, 16693611);
            uLCD.pixel(31, 98, 16760950);
            uLCD.pixel(32, 98, 16759411);
            uLCD.pixel(33, 98, 16761213);
            uLCD.pixel(34, 98, 16760182);
            uLCD.pixel(35, 98, 15314277);
            uLCD.pixel(36, 98, 14724711);
            uLCD.pixel(37, 98, 14727544);
            uLCD.pixel(38, 98, 12953199);
            uLCD.pixel(39, 98, 10060376);
            uLCD.pixel(40, 98, 2824704);
            uLCD.pixel(0, 99, 14793093);
            uLCD.pixel(1, 99, 14858886);
            uLCD.pixel(2, 99, 15648656);
            uLCD.pixel(3, 99, 16306584);
            uLCD.pixel(4, 99, 16174226);
            uLCD.pixel(5, 99, 15910537);
            uLCD.pixel(6, 99, 15910276);
            uLCD.pixel(7, 99, 15975039);
            uLCD.pixel(8, 99, 16434559);
            uLCD.pixel(9, 99, 16105333);
            uLCD.pixel(10, 99, 16104818);
            uLCD.pixel(11, 99, 16433009);
            uLCD.pixel(12, 99, 16564079);
            uLCD.pixel(13, 99, 16366186);
            uLCD.pixel(14, 99, 16628844);
            uLCD.pixel(15, 99, 16761200);
            uLCD.pixel(16, 99, 16761200);
            uLCD.pixel(17, 99, 16561511);
            uLCD.pixel(18, 99, 16761464);
            uLCD.pixel(19, 99, 16561256);
            uLCD.pixel(20, 99, 16759657);
            uLCD.pixel(21, 99, 16760425);
            uLCD.pixel(22, 99, 16760425);
            uLCD.pixel(23, 99, 16759661);
            uLCD.pixel(24, 99, 16693363);
            uLCD.pixel(25, 99, 16760446);
            uLCD.pixel(26, 99, 16759159);
            uLCD.pixel(27, 99, 16430703);
            uLCD.pixel(28, 99, 16760431);
            uLCD.pixel(29, 99, 16761711);
            uLCD.pixel(30, 99, 16430952);
            uLCD.pixel(31, 99, 16759921);
            uLCD.pixel(32, 99, 16430191);
            uLCD.pixel(33, 99, 14522714);
            uLCD.pixel(34, 99, 14129500);
            uLCD.pixel(35, 99, 14593137);
            uLCD.pixel(36, 99, 13345647);
            uLCD.pixel(37, 99, 10059343);
            uLCD.pixel(38, 99, 5127706);
            uLCD.pixel(0, 100, 16498561);
            uLCD.pixel(1, 100, 16301695);
            uLCD.pixel(2, 100, 16235901);
            uLCD.pixel(3, 100, 16236153);
            uLCD.pixel(4, 100, 16301944);
            uLCD.pixel(5, 100, 16302197);
            uLCD.pixel(6, 100, 16302195);
            uLCD.pixel(7, 100, 16301936);
            uLCD.pixel(8, 100, 16367727);
            uLCD.pixel(9, 100, 16433007);
            uLCD.pixel(10, 100, 16563825);
            uLCD.pixel(11, 100, 16629361);
            uLCD.pixel(12, 100, 16760179);
            uLCD.pixel(13, 100, 16759923);
            uLCD.pixel(14, 100, 16759925);
            uLCD.pixel(15, 100, 16759921);
            uLCD.pixel(16, 100, 16760169);
            uLCD.pixel(17, 100, 16760167);
            uLCD.pixel(18, 100, 16759915);
            uLCD.pixel(19, 100, 16759663);
            uLCD.pixel(20, 100, 16759665);
            uLCD.pixel(21, 100, 16759411);
            uLCD.pixel(22, 100, 16759157);
            uLCD.pixel(23, 100, 16759158);
            uLCD.pixel(24, 100, 16758648);
            uLCD.pixel(25, 100, 16759932);
            uLCD.pixel(26, 100, 16760186);
            uLCD.pixel(27, 100, 16497524);
            uLCD.pixel(28, 100, 16432757);
            uLCD.pixel(29, 100, 16630649);
            uLCD.pixel(30, 100, 16236404);
            uLCD.pixel(31, 100, 15250539);
            uLCD.pixel(32, 100, 13739104);
            uLCD.pixel(33, 100, 13214051);
            uLCD.pixel(34, 100, 13807226);
            uLCD.pixel(35, 100, 10519387);
            uLCD.pixel(36, 100, 3612421);
            uLCD.pixel(0, 101, 16760440);
            uLCD.pixel(1, 101, 16759925);
            uLCD.pixel(2, 101, 16694132);
            uLCD.pixel(3, 101, 16563314);
            uLCD.pixel(4, 101, 16629361);
            uLCD.pixel(5, 101, 16629359);
            uLCD.pixel(6, 101, 16564078);
            uLCD.pixel(7, 101, 16498283);
            uLCD.pixel(8, 101, 16564076);
            uLCD.pixel(9, 101, 16629358);
            uLCD.pixel(10, 101, 16629359);
            uLCD.pixel(11, 101, 16760177);
            uLCD.pixel(12, 101, 16760179);
            uLCD.pixel(13, 101, 16759925);
            uLCD.pixel(14, 101, 16759925);
            uLCD.pixel(15, 101, 16759923);
            uLCD.pixel(16, 101, 16761198);
            uLCD.pixel(17, 101, 16761196);
            uLCD.pixel(18, 101, 16760687);
            uLCD.pixel(19, 101, 16760178);
            uLCD.pixel(20, 101, 16759926);
            uLCD.pixel(21, 101, 16759414);
            uLCD.pixel(22, 101, 16759160);
            uLCD.pixel(23, 101, 16759158);
            uLCD.pixel(24, 101, 16759671);
            uLCD.pixel(25, 101, 16760183);
            uLCD.pixel(26, 101, 16628339);
            uLCD.pixel(27, 101, 16629622);
            uLCD.pixel(28, 101, 16762750);
            uLCD.pixel(29, 101, 15973749);
            uLCD.pixel(30, 101, 14592355);
            uLCD.pixel(31, 101, 13673312);
            uLCD.pixel(32, 101, 13479534);
            uLCD.pixel(33, 101, 13415807);
            uLCD.pixel(34, 101, 7363121);
            uLCD.pixel(0, 102, 16760947);
            uLCD.pixel(1, 102, 16629361);
            uLCD.pixel(2, 102, 16563568);
            uLCD.pixel(3, 102, 16563568);
            uLCD.pixel(4, 102, 16629107);
            uLCD.pixel(5, 102, 16629361);
            uLCD.pixel(6, 102, 16629361);
            uLCD.pixel(7, 102, 16563568);
            uLCD.pixel(8, 102, 16629361);
            uLCD.pixel(9, 102, 16760177);
            uLCD.pixel(10, 102, 16760177);
            uLCD.pixel(11, 102, 16760177);
            uLCD.pixel(12, 102, 16760177);
            uLCD.pixel(13, 102, 16760177);
            uLCD.pixel(14, 102, 16760177);
            uLCD.pixel(15, 102, 16629361);
            uLCD.pixel(16, 102, 16235632);
            uLCD.pixel(17, 102, 16235632);
            uLCD.pixel(18, 102, 16366448);
            uLCD.pixel(19, 102, 16497523);
            uLCD.pixel(20, 102, 16628339);
            uLCD.pixel(21, 102, 16759153);
            uLCD.pixel(22, 102, 16759408);
            uLCD.pixel(23, 102, 16759406);
            uLCD.pixel(24, 102, 16760687);
            uLCD.pixel(25, 102, 16759915);
            uLCD.pixel(26, 102, 16761202);
            uLCD.pixel(27, 102, 16761203);
            uLCD.pixel(28, 102, 16103276);
            uLCD.pixel(29, 102, 15511915);
            uLCD.pixel(30, 102, 15051881);
            uLCD.pixel(31, 102, 13803878);
            uLCD.pixel(32, 102, 12821873);
            uLCD.pixel(33, 102, 6179617);
            uLCD.pixel(0, 103, 16695664);
            uLCD.pixel(1, 103, 16564078);
            uLCD.pixel(2, 103, 16498286);
            uLCD.pixel(3, 103, 16498032);
            uLCD.pixel(4, 103, 16629107);
            uLCD.pixel(5, 103, 16629107);
            uLCD.pixel(6, 103, 16760179);
            uLCD.pixel(7, 103, 16694386);
            uLCD.pixel(8, 103, 16759925);
            uLCD.pixel(9, 103, 16760179);
            uLCD.pixel(10, 103, 16760179);
            uLCD.pixel(11, 103, 16760177);
            uLCD.pixel(12, 103, 16760175);
            uLCD.pixel(13, 103, 16760430);
            uLCD.pixel(14, 103, 16760428);
            uLCD.pixel(15, 103, 16629359);
            uLCD.pixel(16, 103, 16498550);
            uLCD.pixel(17, 103, 16433017);
            uLCD.pixel(18, 103, 16498551);
            uLCD.pixel(19, 103, 16629622);
            uLCD.pixel(20, 103, 16694900);
            uLCD.pixel(21, 103, 16760432);
            uLCD.pixel(22, 103, 16760429);
            uLCD.pixel(23, 103, 16760425);
            uLCD.pixel(24, 103, 16761451);
            uLCD.pixel(25, 103, 16233822);
            uLCD.pixel(26, 103, 16760940);
            uLCD.pixel(27, 103, 16761972);
            uLCD.pixel(28, 103, 14985825);
            uLCD.pixel(29, 103, 14327904);
            uLCD.pixel(30, 103, 14460011);
            uLCD.pixel(31, 103, 13146729);
            uLCD.pixel(32, 103, 5454613);
            uLCD.pixel(0, 104, 16565100);
            uLCD.pixel(1, 104, 16433514);
            uLCD.pixel(2, 104, 16367467);
            uLCD.pixel(3, 104, 16498286);
            uLCD.pixel(4, 104, 16629361);
            uLCD.pixel(5, 104, 16760179);
            uLCD.pixel(6, 104, 16759925);
            uLCD.pixel(7, 104, 16759668);
            uLCD.pixel(8, 104, 16759670);
            uLCD.pixel(9, 104, 16759925);
            uLCD.pixel(10, 104, 16759923);
            uLCD.pixel(11, 104, 16760177);
            uLCD.pixel(12, 104, 16760430);
            uLCD.pixel(13, 104, 16629612);
            uLCD.pixel(14, 104, 16629610);
            uLCD.pixel(15, 104, 16564076);
            uLCD.pixel(16, 104, 16629622);
            uLCD.pixel(17, 104, 16629369);
            uLCD.pixel(18, 104, 16629367);
            uLCD.pixel(19, 104, 16629107);
            uLCD.pixel(20, 104, 16694382);
            uLCD.pixel(21, 104, 16694633);
            uLCD.pixel(22, 104, 16694373);
            uLCD.pixel(23, 104, 16629345);
            uLCD.pixel(24, 104, 16366687);
            uLCD.pixel(25, 104, 16696169);
            uLCD.pixel(26, 104, 16302189);
            uLCD.pixel(27, 104, 14131543);
            uLCD.pixel(28, 104, 13474395);
            uLCD.pixel(29, 104, 15316868);
            uLCD.pixel(30, 104, 12290657);
            uLCD.pixel(31, 104, 4529664);
            uLCD.pixel(0, 105, 16499564);
            uLCD.pixel(1, 105, 16367978);
            uLCD.pixel(2, 105, 16367467);
            uLCD.pixel(3, 105, 16498285);
            uLCD.pixel(4, 105, 16760175);
            uLCD.pixel(5, 105, 16759921);
            uLCD.pixel(6, 105, 16759667);
            uLCD.pixel(7, 105, 16759412);
            uLCD.pixel(8, 105, 16759413);
            uLCD.pixel(9, 105, 16759669);
            uLCD.pixel(10, 105, 16759923);
            uLCD.pixel(11, 105, 16760177);
            uLCD.pixel(12, 105, 16629359);
            uLCD.pixel(13, 105, 16564076);
            uLCD.pixel(14, 105, 16564330);
            uLCD.pixel(15, 105, 16564078);
            uLCD.pixel(16, 105, 16431730);
            uLCD.pixel(17, 105, 16562547);
            uLCD.pixel(18, 105, 16628339);
            uLCD.pixel(19, 105, 16694384);
            uLCD.pixel(20, 105, 16760430);
            uLCD.pixel(21, 105, 16695403);
            uLCD.pixel(22, 105, 16761449);
            uLCD.pixel(23, 105, 16630890);
            uLCD.pixel(24, 105, 16236903);
            uLCD.pixel(25, 105, 15317348);
            uLCD.pixel(26, 105, 13738840);
            uLCD.pixel(27, 105, 14003308);
            uLCD.pixel(28, 105, 13938301);
            uLCD.pixel(29, 105, 8609595);
            uLCD.pixel(30, 105, 2819840);
            uLCD.pixel(0, 106, 16499566);
            uLCD.pixel(1, 106, 16367980);
            uLCD.pixel(2, 106, 16367467);
            uLCD.pixel(3, 106, 16563819);
            uLCD.pixel(4, 106, 16760174);
            uLCD.pixel(5, 106, 16759918);
            uLCD.pixel(6, 106, 16759663);
            uLCD.pixel(7, 106, 16759406);
            uLCD.pixel(8, 106, 16759409);
            uLCD.pixel(9, 106, 16759665);
            uLCD.pixel(10, 106, 16759921);
            uLCD.pixel(11, 106, 16760177);
            uLCD.pixel(12, 106, 16629361);
            uLCD.pixel(13, 106, 16564079);
            uLCD.pixel(14, 106, 16367727);
            uLCD.pixel(15, 106, 16563825);
            uLCD.pixel(16, 106, 16760435);
            uLCD.pixel(17, 106, 16760179);
            uLCD.pixel(18, 106, 16760435);
            uLCD.pixel(19, 106, 16760432);
            uLCD.pixel(20, 106, 16760432);
            uLCD.pixel(21, 106, 16629871);
            uLCD.pixel(22, 106, 16367982);
            uLCD.pixel(23, 106, 16106097);
            uLCD.pixel(24, 106, 14792295);
            uLCD.pixel(25, 106, 12359504);
            uLCD.pixel(26, 106, 13611381);
            uLCD.pixel(27, 106, 12362100);
            uLCD.pixel(28, 106, 4863254);
            uLCD.pixel(0, 107, 16564593);
            uLCD.pixel(1, 107, 16433262);
            uLCD.pixel(2, 107, 16498285);
            uLCD.pixel(3, 107, 16563819);
            uLCD.pixel(4, 107, 16760172);
            uLCD.pixel(5, 107, 16760172);
            uLCD.pixel(6, 107, 16759916);
            uLCD.pixel(7, 107, 16759659);
            uLCD.pixel(8, 107, 16759918);
            uLCD.pixel(9, 107, 16759919);
            uLCD.pixel(10, 107, 16759921);
            uLCD.pixel(11, 107, 16629107);
            uLCD.pixel(12, 107, 16432757);
            uLCD.pixel(13, 107, 16367478);
            uLCD.pixel(14, 107, 16171128);
            uLCD.pixel(15, 107, 16367224);
            uLCD.pixel(16, 107, 16760182);
            uLCD.pixel(17, 107, 16759153);
            uLCD.pixel(18, 107, 16364910);
            uLCD.pixel(19, 107, 15773801);
            uLCD.pixel(20, 107, 15182693);
            uLCD.pixel(21, 107, 14526305);
            uLCD.pixel(22, 107, 14000736);
            uLCD.pixel(23, 107, 13541985);
            uLCD.pixel(24, 107, 13149801);
            uLCD.pixel(25, 107, 14204296);
            uLCD.pixel(26, 107, 9469267);
            uLCD.pixel(27, 107, 2364928);
            uLCD.pixel(0, 108, 16761979);
            uLCD.pixel(1, 108, 16300655);
            uLCD.pixel(2, 108, 16300396);
            uLCD.pixel(3, 108, 16760430);
            uLCD.pixel(4, 108, 16759915);
            uLCD.pixel(5, 108, 16760169);
            uLCD.pixel(6, 108, 16760939);
            uLCD.pixel(7, 108, 16761198);
            uLCD.pixel(8, 108, 16760943);
            uLCD.pixel(9, 108, 16760175);
            uLCD.pixel(10, 108, 16300655);
            uLCD.pixel(11, 108, 15775087);
            uLCD.pixel(12, 108, 15052397);
            uLCD.pixel(13, 108, 14592106);
            uLCD.pixel(14, 108, 14329452);
            uLCD.pixel(15, 108, 14592108);
            uLCD.pixel(16, 108, 14525283);
            uLCD.pixel(17, 108, 14459231);
            uLCD.pixel(18, 108, 14262112);
            uLCD.pixel(19, 108, 14196837);
            uLCD.pixel(20, 108, 14198126);
            uLCD.pixel(21, 108, 14265209);
            uLCD.pixel(22, 108, 14200192);
            uLCD.pixel(23, 108, 13873286);
            uLCD.pixel(24, 108, 12230779);
            uLCD.pixel(25, 108, 6574385);
            uLCD.pixel(0, 109, 16300404);
            uLCD.pixel(1, 109, 16694903);
            uLCD.pixel(2, 109, 16762237);
            uLCD.pixel(3, 109, 16761462);
            uLCD.pixel(4, 109, 16563051);
            uLCD.pixel(5, 109, 16498026);
            uLCD.pixel(6, 109, 16563819);
            uLCD.pixel(7, 109, 15971939);
            uLCD.pixel(8, 109, 15643491);
            uLCD.pixel(9, 109, 14854492);
            uLCD.pixel(10, 109, 14065754);
            uLCD.pixel(11, 109, 13803360);
            uLCD.pixel(12, 109, 13935467);
            uLCD.pixel(13, 109, 14067317);
            uLCD.pixel(14, 109, 14199165);
            uLCD.pixel(15, 109, 14199933);
            uLCD.pixel(16, 109, 14067828);
            uLCD.pixel(17, 109, 14594940);
            uLCD.pixel(18, 109, 14594689);
            uLCD.pixel(19, 109, 13082226);
            uLCD.pixel(20, 109, 11109214);
            uLCD.pixel(21, 109, 9399374);
            uLCD.pixel(22, 109, 8018497);
            uLCD.pixel(23, 109, 6967098);
            uLCD.pixel(24, 109, 2495234);
            uLCD.pixel(0, 110, 16761731);
            uLCD.pixel(1, 110, 16431479);
            uLCD.pixel(2, 110, 16299891);
            uLCD.pixel(3, 110, 16431988);
            uLCD.pixel(4, 110, 16234862);
            uLCD.pixel(5, 110, 15775594);
            uLCD.pixel(6, 110, 15183714);
            uLCD.pixel(7, 110, 14263641);
            uLCD.pixel(8, 110, 13672021);
            uLCD.pixel(9, 110, 13935969);
            uLCD.pixel(10, 110, 14331505);
            uLCD.pixel(11, 110, 14398078);
            uLCD.pixel(12, 110, 13608315);
            uLCD.pixel(13, 110, 11635558);
            uLCD.pixel(14, 110, 9596494);
            uLCD.pixel(15, 110, 8281406);
            uLCD.pixel(16, 110, 8151867);
            uLCD.pixel(17, 110, 7889467);
            uLCD.pixel(18, 110, 6244392);
            uLCD.pixel(19, 110, 3283972);
            uLCD.pixel(0, 111, 16628606);
            uLCD.pixel(1, 111, 16629119);
            uLCD.pixel(2, 111, 16564094);
            uLCD.pixel(3, 111, 15709298);
            uLCD.pixel(4, 111, 14262879);
            uLCD.pixel(5, 111, 13606232);
            uLCD.pixel(6, 111, 13738335);
            uLCD.pixel(7, 111, 13411171);
            uLCD.pixel(8, 111, 14398585);
            uLCD.pixel(9, 111, 13675895);
            uLCD.pixel(10, 111, 11768676);
            uLCD.pixel(11, 111, 8414011);
            uLCD.pixel(12, 111, 4598027);
            uLCD.pixel(0, 112, 16629117);
            uLCD.pixel(1, 112, 15116650);
            uLCD.pixel(2, 112, 14196319);
            uLCD.pixel(3, 112, 14131557);
            uLCD.pixel(4, 112, 13803879);
            uLCD.pixel(5, 112, 13476461);
            uLCD.pixel(6, 112, 13478263);
            uLCD.pixel(7, 112, 13413759);
            uLCD.pixel(8, 112, 10388828);
            uLCD.pixel(9, 112, 6902320);
            uLCD.pixel(10, 112, 2758400);
            uLCD.pixel(0, 113, 14721888);
            uLCD.pixel(1, 113, 14854248);
            uLCD.pixel(2, 113, 14131555);
            uLCD.pixel(3, 113, 13211744);
            uLCD.pixel(4, 113, 13739895);
            uLCD.pixel(5, 113, 14333837);
            uLCD.pixel(6, 113, 11111530);
            uLCD.pixel(7, 113, 5981739);
            uLCD.pixel(0, 114, 14722399);
            uLCD.pixel(1, 114, 13670742);
            uLCD.pixel(2, 114, 14264170);
            uLCD.pixel(3, 114, 14857346);
            uLCD.pixel(4, 114, 11832935);
            uLCD.pixel(5, 114, 6374438);
            uLCD.pixel(6, 114, 2231552);
            uLCD.pixel(0, 115, 13937010);
            uLCD.pixel(1, 115, 14266749);
            uLCD.pixel(2, 115, 12425323);
            uLCD.pixel(3, 115, 7492140);
            uLCD.pixel(4, 115, 2690816);
            uLCD.pixel(0, 116, 11509901);
            uLCD.pixel(1, 116, 6773319);
            uLCD.pixel(2, 116, 2102276);
            uLCD.pixel(0, 117, 2105374);
        }

        // Draw right Lizard
        void drawRightLizard() {
            uLCD.pixel(99, 80, 2100227);
            uLCD.pixel(101, 80, 3085056);
            uLCD.pixel(102, 80, 2427904);
            uLCD.pixel(98, 81, 3348224);
            uLCD.pixel(99, 81, 5716508);
            uLCD.pixel(100, 81, 11110501);
            uLCD.pixel(101, 81, 14202772);
            uLCD.pixel(102, 81, 12295808);
            uLCD.pixel(103, 81, 9006934);
            uLCD.pixel(93, 82, 2692096);
            uLCD.pixel(94, 82, 5717276);
            uLCD.pixel(95, 82, 8742976);
            uLCD.pixel(96, 82, 10847831);
            uLCD.pixel(97, 82, 12689515);
            uLCD.pixel(98, 82, 14860167);
            uLCD.pixel(99, 82, 16570783);
            uLCD.pixel(100, 82, 15714965);
            uLCD.pixel(101, 82, 15517848);
            uLCD.pixel(102, 82, 15387038);
            uLCD.pixel(103, 82, 15782833);
            uLCD.pixel(104, 82, 5323555);
            uLCD.pixel(90, 83, 3877137);
            uLCD.pixel(91, 83, 7362620);
            uLCD.pixel(92, 83, 11836025);
            uLCD.pixel(93, 83, 14005647);
            uLCD.pixel(94, 83, 15452572);
            uLCD.pixel(95, 83, 15583380);
            uLCD.pixel(96, 83, 15779979);
            uLCD.pixel(97, 83, 16043143);
            uLCD.pixel(98, 83, 15384181);
            uLCD.pixel(99, 83, 13871455);
            uLCD.pixel(100, 83, 14858615);
            uLCD.pixel(101, 83, 13411944);
            uLCD.pixel(102, 83, 14004345);
            uLCD.pixel(103, 83, 16177318);
            uLCD.pixel(104, 83, 10059610);
            uLCD.pixel(89, 84, 7692080);
            uLCD.pixel(90, 84, 13742723);
            uLCD.pixel(91, 84, 14596746);
            uLCD.pixel(92, 84, 12358503);
            uLCD.pixel(93, 84, 12818028);
            uLCD.pixel(94, 84, 12751206);
            uLCD.pixel(95, 84, 12355673);
            uLCD.pixel(96, 84, 13539937);
            uLCD.pixel(97, 84, 13934429);
            uLCD.pixel(98, 84, 13012547);
            uLCD.pixel(99, 84, 14066003);
            uLCD.pixel(100, 84, 15185775);
            uLCD.pixel(101, 84, 14726766);
            uLCD.pixel(102, 84, 14003557);
            uLCD.pixel(103, 84, 13347431);
            uLCD.pixel(104, 84, 14993040);
            uLCD.pixel(105, 84, 3086592);
            uLCD.pixel(87, 85, 5389849);
            uLCD.pixel(88, 85, 12098666);
            uLCD.pixel(89, 85, 13676145);
            uLCD.pixel(90, 85, 13213792);
            uLCD.pixel(91, 85, 11830856);
            uLCD.pixel(92, 85, 16303755);
            uLCD.pixel(93, 85, 15842438);
            uLCD.pixel(94, 85, 15381119);
            uLCD.pixel(95, 85, 16367753);
            uLCD.pixel(96, 85, 15182703);
            uLCD.pixel(97, 85, 16764298);
            uLCD.pixel(98, 85, 16432241);
            uLCD.pixel(99, 85, 16235630);
            uLCD.pixel(100, 85, 16236919);
            uLCD.pixel(101, 85, 15712115);
            uLCD.pixel(102, 85, 14989674);
            uLCD.pixel(103, 85, 13543517);
            uLCD.pixel(104, 85, 15189382);
            uLCD.pixel(105, 85, 8217143);
            uLCD.pixel(85, 86, 6965821);
            uLCD.pixel(86, 86, 13083529);
            uLCD.pixel(87, 86, 16175016);
            uLCD.pixel(88, 86, 12817761);
            uLCD.pixel(89, 86, 13408859);
            uLCD.pixel(90, 86, 15974262);
            uLCD.pixel(91, 86, 16765060);
            uLCD.pixel(92, 86, 15513196);
            uLCD.pixel(93, 86, 15841647);
            uLCD.pixel(94, 86, 16236151);
            uLCD.pixel(95, 86, 16696189);
            uLCD.pixel(96, 86, 16762496);
            uLCD.pixel(97, 86, 16498551);
            uLCD.pixel(98, 86, 15971692);
            uLCD.pixel(99, 86, 16762750);
            uLCD.pixel(100, 86, 16433017);
            uLCD.pixel(101, 86, 16368507);
            uLCD.pixel(102, 86, 16040822);
            uLCD.pixel(103, 86, 13936733);
            uLCD.pixel(104, 86, 14858876);
            uLCD.pixel(105, 86, 13676418);
            uLCD.pixel(106, 86, 2427904);
            uLCD.pixel(83, 87, 5519394);
            uLCD.pixel(84, 87, 13608592);
            uLCD.pixel(85, 87, 15909801);
            uLCD.pixel(86, 87, 13935233);
            uLCD.pixel(87, 87, 11763282);
            uLCD.pixel(88, 87, 16301960);
            uLCD.pixel(89, 87, 16630659);
            uLCD.pixel(90, 87, 16170099);
            uLCD.pixel(91, 87, 16038764);
            uLCD.pixel(92, 87, 16696692);
            uLCD.pixel(93, 87, 16630899);
            uLCD.pixel(94, 87, 16236141);
            uLCD.pixel(95, 87, 15380834);
            uLCD.pixel(96, 87, 16763260);
            uLCD.pixel(97, 87, 16169585);
            uLCD.pixel(98, 87, 15971437);
            uLCD.pixel(99, 87, 16563063);
            uLCD.pixel(100, 87, 16168820);
            uLCD.pixel(101, 87, 16564346);
            uLCD.pixel(102, 87, 16696955);
            uLCD.pixel(103, 87, 14987881);
            uLCD.pixel(104, 87, 14725748);
            uLCD.pixel(105, 87, 15978399);
            uLCD.pixel(106, 87, 6703150);
            uLCD.pixel(81, 88, 2954496);
            uLCD.pixel(82, 88, 8348996);
            uLCD.pixel(83, 88, 14004876);
            uLCD.pixel(84, 88, 13869947);
            uLCD.pixel(85, 88, 13539182);
            uLCD.pixel(86, 88, 13735530);
            uLCD.pixel(87, 88, 16695952);
            uLCD.pixel(88, 88, 15906174);
            uLCD.pixel(89, 88, 16761220);
            uLCD.pixel(90, 88, 16564092);
            uLCD.pixel(91, 88, 15709547);
            uLCD.pixel(92, 88, 15051869);
            uLCD.pixel(93, 88, 15183966);
            uLCD.pixel(94, 88, 14855001);
            uLCD.pixel(95, 88, 14657624);
            uLCD.pixel(96, 88, 13341253);
            uLCD.pixel(97, 88, 15709035);
            uLCD.pixel(98, 88, 16762497);
            uLCD.pixel(99, 88, 16760444);
            uLCD.pixel(100, 88, 16562295);
            uLCD.pixel(101, 88, 16760185);
            uLCD.pixel(102, 88, 16695415);
            uLCD.pixel(103, 88, 16302198);
            uLCD.pixel(104, 88, 15382390);
            uLCD.pixel(105, 88, 15911317);
            uLCD.pixel(106, 88, 12491643);
            uLCD.pixel(107, 88, 2756608);
            uLCD.pixel(79, 89, 2694407);
            uLCD.pixel(80, 89, 9206107);
            uLCD.pixel(81, 89, 12625539);
            uLCD.pixel(82, 89, 13939851);
            uLCD.pixel(83, 89, 11635032);
            uLCD.pixel(84, 89, 13211744);
            uLCD.pixel(85, 89, 16697484);
            uLCD.pixel(86, 89, 16762766);
            uLCD.pixel(87, 89, 15511929);
            uLCD.pixel(88, 89, 16764567);
            uLCD.pixel(89, 89, 14985585);
            uLCD.pixel(90, 89, 14064479);
            uLCD.pixel(91, 89, 15052398);
            uLCD.pixel(92, 89, 13539671);
            uLCD.pixel(93, 89, 13540439);
            uLCD.pixel(94, 89, 14198367);
            uLCD.pixel(95, 89, 14789734);
            uLCD.pixel(96, 89, 14328926);
            uLCD.pixel(97, 89, 14196570);
            uLCD.pixel(98, 89, 15708785);
            uLCD.pixel(99, 89, 16168309);
            uLCD.pixel(100, 89, 16760702);
            uLCD.pixel(101, 89, 16759413);
            uLCD.pixel(102, 89, 16299374);
            uLCD.pixel(103, 89, 16761208);
            uLCD.pixel(104, 89, 16170876);
            uLCD.pixel(105, 89, 15449220);
            uLCD.pixel(106, 89, 15912101);
            uLCD.pixel(107, 89, 5519392);
            uLCD.pixel(79, 90, 4076060);
            uLCD.pixel(80, 90, 14732206);
            uLCD.pixel(81, 90, 12625023);
            uLCD.pixel(82, 90, 11570531);
            uLCD.pixel(83, 90, 15056519);
            uLCD.pixel(84, 90, 15121270);
            uLCD.pixel(85, 90, 16305281);
            uLCD.pixel(86, 90, 15975550);
            uLCD.pixel(87, 90, 15514748);
            uLCD.pixel(88, 90, 14066538);
            uLCD.pixel(89, 90, 14790011);
            uLCD.pixel(90, 90, 13803376);
            uLCD.pixel(91, 90, 11172174);
            uLCD.pixel(92, 90, 11370066);
            uLCD.pixel(93, 90, 10777929);
            uLCD.pixel(94, 90, 11172939);
            uLCD.pixel(95, 90, 11501644);
            uLCD.pixel(96, 90, 14329710);
            uLCD.pixel(97, 90, 12947797);
            uLCD.pixel(98, 90, 15315570);
            uLCD.pixel(99, 90, 16761473);
            uLCD.pixel(100, 90, 16760186);
            uLCD.pixel(101, 90, 16758899);
            uLCD.pixel(102, 90, 16495981);
            uLCD.pixel(103, 90, 16497521);
            uLCD.pixel(104, 90, 16433017);
            uLCD.pixel(105, 90, 15777409);
            uLCD.pixel(106, 90, 15911577);
            uLCD.pixel(107, 90, 10321757);
            uLCD.pixel(80, 91, 10192237);
            uLCD.pixel(81, 91, 11769462);
            uLCD.pixel(82, 91, 14399632);
            uLCD.pixel(83, 91, 14924679);
            uLCD.pixel(84, 91, 14727534);
            uLCD.pixel(85, 91, 14200669);
            uLCD.pixel(86, 91, 12555847);
            uLCD.pixel(87, 91, 12028740);
            uLCD.pixel(88, 91, 11896651);
            uLCD.pixel(89, 91, 10317627);
            uLCD.pixel(90, 91, 11107410);
            uLCD.pixel(91, 91, 13081464);
            uLCD.pixel(92, 91, 13279619);
            uLCD.pixel(93, 91, 13674379);
            uLCD.pixel(94, 91, 12819066);
            uLCD.pixel(95, 91, 10252876);
            uLCD.pixel(96, 91, 7225875);
            uLCD.pixel(97, 91, 9001508);
            uLCD.pixel(98, 91, 14658928);
            uLCD.pixel(99, 91, 16764041);
            uLCD.pixel(100, 91, 16365168);
            uLCD.pixel(101, 91, 16759410);
            uLCD.pixel(102, 91, 16761206);
            uLCD.pixel(103, 91, 16365421);
            uLCD.pixel(104, 91, 16366964);
            uLCD.pixel(105, 91, 16435077);
            uLCD.pixel(106, 91, 14660733);
            uLCD.pixel(107, 91, 14729108);
            uLCD.pixel(81, 92, 3348736);
            uLCD.pixel(82, 92, 8807750);
            uLCD.pixel(83, 92, 10846034);
            uLCD.pixel(84, 92, 12227149);
            uLCD.pixel(85, 92, 10713129);
            uLCD.pixel(86, 92, 12686920);
            uLCD.pixel(87, 92, 13805147);
            uLCD.pixel(88, 92, 12094279);
            uLCD.pixel(89, 92, 11831116);
            uLCD.pixel(90, 92, 12621414);
            uLCD.pixel(91, 92, 10648150);
            uLCD.pixel(92, 92, 5451284);
            uLCD.pixel(93, 92, 3938052);
            uLCD.pixel(94, 92, 4267017);
            uLCD.pixel(95, 92, 2951168);
            uLCD.pixel(96, 92, 2031616);
            uLCD.pixel(97, 92, 8871724);
            uLCD.pixel(98, 92, 12621914);
            uLCD.pixel(99, 92, 16106623);
            uLCD.pixel(100, 92, 15840106);
            uLCD.pixel(101, 92, 16761977);
            uLCD.pixel(102, 92, 16365160);
            uLCD.pixel(103, 92, 16760434);
            uLCD.pixel(104, 92, 16038253);
            uLCD.pixel(105, 92, 16302973);
            uLCD.pixel(106, 92, 15055226);
            uLCD.pixel(107, 92, 15912604);
            uLCD.pixel(108, 92, 6309411);
            uLCD.pixel(82, 93, 2229760);
            uLCD.pixel(83, 93, 8872253);
            uLCD.pixel(84, 93, 15778185);
            uLCD.pixel(85, 93, 16303745);
            uLCD.pixel(86, 93, 16237434);
            uLCD.pixel(87, 93, 16040823);
            uLCD.pixel(88, 93, 15514225);
            uLCD.pixel(89, 93, 16765582);
            uLCD.pixel(90, 93, 14068080);
            uLCD.pixel(91, 93, 9134133);
            uLCD.pixel(92, 93, 3740160);
            uLCD.pixel(93, 93, 2228224);
            uLCD.pixel(94, 93, 2293760);
            uLCD.pixel(95, 93, 2097152);
            uLCD.pixel(96, 93, 3609856);
            uLCD.pixel(97, 93, 11176276);
            uLCD.pixel(98, 93, 13873264);
            uLCD.pixel(99, 93, 15582073);
            uLCD.pixel(100, 93, 16236145);
            uLCD.pixel(101, 93, 16762231);
            uLCD.pixel(102, 93, 16168038);
            uLCD.pixel(103, 93, 16760947);
            uLCD.pixel(104, 93, 16300653);
            uLCD.pixel(105, 93, 16302712);
            uLCD.pixel(106, 93, 15317622);
            uLCD.pixel(107, 93, 16438168);
            uLCD.pixel(108, 93, 10979420);
            uLCD.pixel(82, 94, 5125929);
            uLCD.pixel(83, 94, 15452079);
            uLCD.pixel(84, 94, 15973525);
            uLCD.pixel(85, 94, 15510904);
            uLCD.pixel(86, 94, 16761220);
            uLCD.pixel(87, 94, 16630137);
            uLCD.pixel(88, 94, 16761974);
            uLCD.pixel(89, 94, 15775851);
            uLCD.pixel(90, 94, 16763778);
            uLCD.pixel(91, 94, 16172680);
            uLCD.pixel(92, 94, 12949866);
            uLCD.pixel(93, 94, 7819305);
            uLCD.pixel(94, 94, 3411968);
            uLCD.pixel(95, 94, 2951936);
            uLCD.pixel(96, 94, 6899994);
            uLCD.pixel(97, 94, 14334593);
            uLCD.pixel(98, 94, 15124356);
            uLCD.pixel(99, 94, 15056499);
            uLCD.pixel(100, 94, 16302965);
            uLCD.pixel(101, 94, 16761972);
            uLCD.pixel(102, 94, 15971429);
            uLCD.pixel(103, 94, 16761461);
            uLCD.pixel(104, 94, 16563825);
            uLCD.pixel(105, 94, 16433524);
            uLCD.pixel(106, 94, 15382639);
            uLCD.pixel(107, 94, 16568463);
            uLCD.pixel(108, 94, 13478261);
            uLCD.pixel(109, 94, 3939840);
            uLCD.pixel(82, 95, 4929585);
            uLCD.pixel(83, 95, 13808291);
            uLCD.pixel(84, 95, 13671040);
            uLCD.pixel(85, 95, 16037008);
            uLCD.pixel(86, 95, 14852976);
            uLCD.pixel(87, 95, 15708787);
            uLCD.pixel(88, 95, 16498036);
            uLCD.pixel(89, 95, 16761972);
            uLCD.pixel(90, 95, 14986589);
            uLCD.pixel(91, 95, 16500606);
            uLCD.pixel(92, 95, 16567184);
            uLCD.pixel(93, 95, 15187079);
            uLCD.pixel(94, 95, 14464131);
            uLCD.pixel(95, 95, 14596231);
            uLCD.pixel(96, 95, 14859654);
            uLCD.pixel(97, 95, 15912592);
            uLCD.pixel(98, 95, 14794615);
            uLCD.pixel(99, 95, 15648634);
            uLCD.pixel(100, 95, 16039791);
            uLCD.pixel(101, 95, 16498800);
            uLCD.pixel(102, 95, 16103276);
            uLCD.pixel(103, 95, 16761464);
            uLCD.pixel(104, 95, 16760693);
            uLCD.pixel(105, 95, 16564595);
            uLCD.pixel(106, 95, 15710058);
            uLCD.pixel(107, 95, 16106364);
            uLCD.pixel(108, 95, 16239247);
            uLCD.pixel(109, 95, 11175256);
            uLCD.pixel(110, 95, 4465929);
            uLCD.pixel(111, 95, 3940624);
            uLCD.pixel(112, 95, 3283470);
            uLCD.pixel(82, 96, 2167822);
            uLCD.pixel(83, 96, 10783874);
            uLCD.pixel(84, 96, 11042157);
            uLCD.pixel(85, 96, 11829352);
            uLCD.pixel(86, 96, 14460544);
            uLCD.pixel(87, 96, 14723191);
            uLCD.pixel(88, 96, 15578742);
            uLCD.pixel(89, 96, 15710061);
            uLCD.pixel(90, 96, 16764033);
            uLCD.pixel(91, 96, 15842161);
            uLCD.pixel(92, 96, 16237952);
            uLCD.pixel(93, 96, 15975040);
            uLCD.pixel(94, 96, 15515264);
            uLCD.pixel(95, 96, 16173194);
            uLCD.pixel(96, 96, 16173446);
            uLCD.pixel(97, 96, 15844734);
            uLCD.pixel(98, 96, 15187054);
            uLCD.pixel(99, 96, 16304505);
            uLCD.pixel(100, 96, 15842414);
            uLCD.pixel(101, 96, 16433524);
            uLCD.pixel(102, 96, 16366195);
            uLCD.pixel(103, 96, 16629110);
            uLCD.pixel(104, 96, 16694132);
            uLCD.pixel(105, 96, 16761204);
            uLCD.pixel(106, 96, 16300907);
            uLCD.pixel(107, 96, 16038766);
            uLCD.pixel(108, 96, 15974780);
            uLCD.pixel(109, 96, 16765853);
            uLCD.pixel(110, 96, 14858386);
            uLCD.pixel(111, 96, 15978161);
            uLCD.pixel(112, 96, 14399389);
            uLCD.pixel(113, 96, 10058333);
            uLCD.pixel(114, 96, 5190154);
            uLCD.pixel(84, 97, 2230016);
            uLCD.pixel(85, 97, 2162688);
            uLCD.pixel(86, 97, 6503971);
            uLCD.pixel(87, 97, 12753780);
            uLCD.pixel(88, 97, 13344107);
            uLCD.pixel(89, 97, 15448446);
            uLCD.pixel(90, 97, 16303492);
            uLCD.pixel(91, 97, 15776631);
            uLCD.pixel(92, 97, 15381871);
            uLCD.pixel(93, 97, 16237180);
            uLCD.pixel(94, 97, 16040055);
            uLCD.pixel(95, 97, 16040055);
            uLCD.pixel(96, 97, 15842416);
            uLCD.pixel(97, 97, 15645035);
            uLCD.pixel(98, 97, 16302447);
            uLCD.pixel(99, 97, 16762998);
            uLCD.pixel(100, 97, 16170609);
            uLCD.pixel(101, 97, 16499064);
            uLCD.pixel(102, 97, 16497785);
            uLCD.pixel(103, 97, 16430709);
            uLCD.pixel(104, 97, 16430703);
            uLCD.pixel(105, 97, 16760435);
            uLCD.pixel(106, 97, 16760686);
            uLCD.pixel(107, 97, 16498026);
            uLCD.pixel(108, 97, 16104305);
            uLCD.pixel(109, 97, 15118448);
            uLCD.pixel(110, 97, 16237717);
            uLCD.pixel(111, 97, 15646358);
            uLCD.pixel(112, 97, 15581594);
            uLCD.pixel(113, 97, 15713944);
            uLCD.pixel(114, 97, 14793345);
            uLCD.pixel(115, 97, 12491619);
            uLCD.pixel(116, 97, 8215603);
            uLCD.pixel(117, 97, 6505509);
            uLCD.pixel(118, 97, 4466186);
            uLCD.pixel(119, 97, 2888192);
            uLCD.pixel(120, 97, 2362368);
            uLCD.pixel(121, 97, 2034176);
            uLCD.pixel(87, 98, 2955520);
            uLCD.pixel(88, 98, 10255964);
            uLCD.pixel(89, 98, 13543553);
            uLCD.pixel(90, 98, 14265726);
            uLCD.pixel(91, 98, 14988155);
            uLCD.pixel(92, 98, 15250806);
            uLCD.pixel(93, 98, 16105337);
            uLCD.pixel(94, 98, 16104818);
            uLCD.pixel(95, 98, 16761974);
            uLCD.pixel(96, 98, 16761458);
            uLCD.pixel(97, 98, 16431204);
            uLCD.pixel(98, 98, 16759911);
            uLCD.pixel(99, 98, 16101985);
            uLCD.pixel(100, 98, 16498550);
            uLCD.pixel(101, 98, 16301433);
            uLCD.pixel(102, 98, 16563067);
            uLCD.pixel(103, 98, 16627577);
            uLCD.pixel(104, 98, 16561777);
            uLCD.pixel(105, 98, 16759151);
            uLCD.pixel(106, 98, 16760939);
            uLCD.pixel(107, 98, 16760425);
            uLCD.pixel(108, 98, 16763257);
            uLCD.pixel(109, 98, 15577449);
            uLCD.pixel(110, 98, 16763023);
            uLCD.pixel(111, 98, 15447682);
            uLCD.pixel(112, 98, 15579781);
            uLCD.pixel(113, 98, 16172426);
            uLCD.pixel(114, 98, 16436353);
            uLCD.pixel(115, 98, 15647351);
            uLCD.pixel(116, 98, 16370827);
            uLCD.pixel(117, 98, 15976075);
            uLCD.pixel(118, 98, 15384456);
            uLCD.pixel(119, 98, 14924679);
            uLCD.pixel(120, 98, 14201473);
            uLCD.pixel(121, 98, 12689523);
            uLCD.pixel(122, 98, 10782557);
            uLCD.pixel(123, 98, 9270348);
            uLCD.pixel(124, 98, 6967341);
            uLCD.pixel(125, 98, 5388824);
            uLCD.pixel(126, 98, 3678465);
            uLCD.pixel(127, 98, 2888960);
            uLCD.pixel(89, 99, 5257248);
            uLCD.pixel(90, 99, 10386528);
            uLCD.pixel(91, 99, 12885623);
            uLCD.pixel(92, 99, 13870966);
            uLCD.pixel(93, 99, 13869672);
            uLCD.pixel(94, 99, 13802841);
            uLCD.pixel(95, 99, 15774827);
            uLCD.pixel(96, 99, 16760430);
            uLCD.pixel(97, 99, 16233310);
            uLCD.pixel(98, 99, 16761453);
            uLCD.pixel(99, 99, 16760171);
            uLCD.pixel(100, 99, 16694386);
            uLCD.pixel(101, 99, 16168307);
            uLCD.pixel(102, 99, 16693883);
            uLCD.pixel(103, 99, 16759932);
            uLCD.pixel(104, 99, 16759160);
            uLCD.pixel(105, 99, 16692846);
            uLCD.pixel(106, 99, 16759916);
            uLCD.pixel(107, 99, 16760170);
            uLCD.pixel(108, 99, 16299879);
            uLCD.pixel(109, 99, 16695413);
            uLCD.pixel(110, 99, 16104056);
            uLCD.pixel(111, 99, 16499074);
            uLCD.pixel(112, 99, 16564867);
            uLCD.pixel(113, 99, 15776372);
            uLCD.pixel(114, 99, 15711080);
            uLCD.pixel(115, 99, 16369009);
            uLCD.pixel(116, 99, 16039793);
            uLCD.pixel(117, 99, 16171126);
            uLCD.pixel(118, 99, 16171641);
            uLCD.pixel(119, 99, 16040573);
            uLCD.pixel(120, 99, 15975040);
            uLCD.pixel(121, 99, 15910022);
            uLCD.pixel(122, 99, 15911052);
            uLCD.pixel(123, 99, 16042899);
            uLCD.pixel(124, 99, 16569758);
            uLCD.pixel(125, 99, 15451794);
            uLCD.pixel(126, 99, 14727817);
            uLCD.pixel(127, 99, 14793610);
            uLCD.pixel(91, 100, 2889476);
            uLCD.pixel(92, 100, 10388326);
            uLCD.pixel(93, 100, 13413250);
            uLCD.pixel(94, 100, 14003065);
            uLCD.pixel(95, 100, 13606240);
            uLCD.pixel(96, 100, 14985571);
            uLCD.pixel(97, 100, 16761203);
            uLCD.pixel(98, 100, 16760425);
            uLCD.pixel(99, 100, 16759655);
            uLCD.pixel(100, 100, 16759922);
            uLCD.pixel(101, 100, 16758385);
            uLCD.pixel(102, 100, 16759414);
            uLCD.pixel(103, 100, 16760185);
            uLCD.pixel(104, 100, 16758902);
            uLCD.pixel(105, 100, 16627827);
            uLCD.pixel(106, 100, 16759925);
            uLCD.pixel(107, 100, 16629109);
            uLCD.pixel(108, 100, 16629622);
            uLCD.pixel(109, 100, 16498551);
            uLCD.pixel(110, 100, 16432760);
            uLCD.pixel(111, 100, 16366967);
            uLCD.pixel(112, 100, 16366965);
            uLCD.pixel(113, 100, 16367218);
            uLCD.pixel(114, 100, 16433007);
            uLCD.pixel(115, 100, 16433262);
            uLCD.pixel(116, 100, 16498802);
            uLCD.pixel(117, 100, 16498802);
            uLCD.pixel(118, 100, 16367731);
            uLCD.pixel(119, 100, 16367731);
            uLCD.pixel(120, 100, 16367478);
            uLCD.pixel(121, 100, 16302198);
            uLCD.pixel(122, 100, 16236923);
            uLCD.pixel(123, 100, 16236923);
            uLCD.pixel(124, 100, 16105083);
            uLCD.pixel(125, 100, 16170878);
            uLCD.pixel(126, 100, 16170879);
            uLCD.pixel(127, 100, 16236418);
            uLCD.pixel(93, 101, 7230521);
            uLCD.pixel(94, 101, 13544325);
            uLCD.pixel(95, 101, 14463103);
            uLCD.pixel(96, 101, 14197864);
            uLCD.pixel(97, 101, 14525020);
            uLCD.pixel(98, 101, 16760432);
            uLCD.pixel(99, 101, 16762485);
            uLCD.pixel(100, 101, 16759150);
            uLCD.pixel(101, 101, 16759666);
            uLCD.pixel(102, 101, 16759925);
            uLCD.pixel(103, 101, 16759153);
            uLCD.pixel(104, 101, 16693362);
            uLCD.pixel(105, 101, 16760697);
            uLCD.pixel(106, 101, 16761467);
            uLCD.pixel(107, 101, 16497524);
            uLCD.pixel(108, 101, 16497781);
            uLCD.pixel(109, 101, 16498036);
            uLCD.pixel(110, 101, 16498034);
            uLCD.pixel(111, 101, 16563827);
            uLCD.pixel(112, 101, 16629361);
            uLCD.pixel(113, 101, 16629359);
            uLCD.pixel(114, 101, 16563565);
            uLCD.pixel(115, 101, 16563565);
            uLCD.pixel(116, 101, 16695152);
            uLCD.pixel(117, 101, 16629618);
            uLCD.pixel(118, 101, 16563825);
            uLCD.pixel(119, 101, 16563825);
            uLCD.pixel(120, 101, 16563825);
            uLCD.pixel(121, 101, 16563825);
            uLCD.pixel(122, 101, 16629620);
            uLCD.pixel(123, 101, 16629620);
            uLCD.pixel(124, 101, 16498036);
            uLCD.pixel(125, 101, 16563829);
            uLCD.pixel(126, 101, 16563574);
            uLCD.pixel(127, 101, 16629367);
            uLCD.pixel(93, 102, 2231296);
            uLCD.pixel(94, 102, 6373925);
            uLCD.pixel(95, 102, 12687985);
            uLCD.pixel(96, 102, 14001778);
            uLCD.pixel(97, 102, 14855794);
            uLCD.pixel(98, 102, 15314540);
            uLCD.pixel(99, 102, 16432243);
            uLCD.pixel(100, 102, 16760178);
            uLCD.pixel(101, 102, 16759919);
            uLCD.pixel(102, 102, 16760690);
            uLCD.pixel(103, 102, 16760947);
            uLCD.pixel(104, 102, 16760175);
            uLCD.pixel(105, 102, 16496492);
            uLCD.pixel(106, 102, 16497005);
            uLCD.pixel(107, 102, 16760177);
            uLCD.pixel(108, 102, 16562798);
            uLCD.pixel(109, 102, 16628589);
            uLCD.pixel(110, 102, 16694382);
            uLCD.pixel(111, 102, 16760175);
            uLCD.pixel(112, 102, 16760175);
            uLCD.pixel(113, 102, 16760430);
            uLCD.pixel(114, 102, 16694637);
            uLCD.pixel(115, 102, 16694382);
            uLCD.pixel(116, 102, 16695154);
            uLCD.pixel(117, 102, 16629107);
            uLCD.pixel(118, 102, 16629107);
            uLCD.pixel(119, 102, 16629107);
            uLCD.pixel(120, 102, 16563827);
            uLCD.pixel(121, 102, 16563827);
            uLCD.pixel(122, 102, 16433011);
            uLCD.pixel(123, 102, 16498804);
            uLCD.pixel(124, 102, 16367218);
            uLCD.pixel(125, 102, 16433011);
            uLCD.pixel(126, 102, 16432757);
            uLCD.pixel(127, 102, 16498550);
            uLCD.pixel(94, 103, 2164224);
            uLCD.pixel(95, 103, 6044444);
            uLCD.pixel(96, 103, 12885364);
            uLCD.pixel(97, 103, 13541487);
            uLCD.pixel(98, 103, 13672041);
            uLCD.pixel(99, 103, 14855276);
            uLCD.pixel(100, 103, 16762493);
            uLCD.pixel(101, 103, 16761202);
            uLCD.pixel(102, 103, 16234600);
            uLCD.pixel(103, 103, 16168807);
            uLCD.pixel(104, 103, 16760430);
            uLCD.pixel(105, 103, 16761201);
            uLCD.pixel(106, 103, 16760686);
            uLCD.pixel(107, 103, 16760943);
            uLCD.pixel(108, 103, 16759915);
            uLCD.pixel(109, 103, 16760172);
            uLCD.pixel(110, 103, 16760172);
            uLCD.pixel(111, 103, 16760174);
            uLCD.pixel(112, 103, 16759918);
            uLCD.pixel(113, 103, 16760174);
            uLCD.pixel(114, 103, 16760174);
            uLCD.pixel(115, 103, 16760175);
            uLCD.pixel(116, 103, 16760179);
            uLCD.pixel(117, 103, 16629109);
            uLCD.pixel(118, 103, 16629109);
            uLCD.pixel(119, 103, 16629109);
            uLCD.pixel(120, 103, 16629107);
            uLCD.pixel(121, 103, 16563827);
            uLCD.pixel(122, 103, 16563827);
            uLCD.pixel(123, 103, 16433009);
            uLCD.pixel(124, 103, 16367216);
            uLCD.pixel(125, 103, 16433009);
            uLCD.pixel(126, 103, 16433009);
            uLCD.pixel(127, 103, 16498802);
            uLCD.pixel(95, 104, 2296320);
            uLCD.pixel(96, 104, 3544832);
            uLCD.pixel(97, 104, 12096626);
            uLCD.pixel(98, 104, 15517086);
            uLCD.pixel(99, 104, 12621154);
            uLCD.pixel(100, 104, 13737818);
            uLCD.pixel(101, 104, 15841898);
            uLCD.pixel(102, 104, 16631412);
            uLCD.pixel(103, 104, 16236396);
            uLCD.pixel(104, 104, 16432492);
            uLCD.pixel(105, 104, 16695405);
            uLCD.pixel(106, 104, 16563047);
            uLCD.pixel(107, 104, 16496997);
            uLCD.pixel(108, 104, 16760684);
            uLCD.pixel(109, 104, 16760427);
            uLCD.pixel(110, 104, 16759914);
            uLCD.pixel(111, 104, 16759915);
            uLCD.pixel(112, 104, 16759661);
            uLCD.pixel(113, 104, 16759661);
            uLCD.pixel(114, 104, 16759919);
            uLCD.pixel(115, 104, 16760178);
            uLCD.pixel(116, 104, 16759925);
            uLCD.pixel(117, 104, 16759926);
            uLCD.pixel(118, 104, 16759925);
            uLCD.pixel(119, 104, 16563316);
            uLCD.pixel(120, 104, 16563314);
            uLCD.pixel(121, 104, 16563825);
            uLCD.pixel(122, 104, 16563825);
            uLCD.pixel(123, 104, 16564079);
            uLCD.pixel(124, 104, 16367214);
            uLCD.pixel(125, 104, 16433007);
            uLCD.pixel(126, 104, 16367727);
            uLCD.pixel(127, 104, 16433520);
            uLCD.pixel(96, 105, 2099456);
            uLCD.pixel(97, 105, 2295808);
            uLCD.pixel(98, 105, 7821631);
            uLCD.pixel(99, 105, 13807754);
            uLCD.pixel(100, 105, 13608809);
            uLCD.pixel(101, 105, 14660458);
            uLCD.pixel(102, 105, 15251564);
            uLCD.pixel(103, 105, 15909236);
            uLCD.pixel(104, 105, 16763517);
            uLCD.pixel(105, 105, 16564593);
            uLCD.pixel(106, 105, 16168807);
            uLCD.pixel(107, 105, 16760685);
            uLCD.pixel(108, 105, 16760429);
            uLCD.pixel(109, 105, 16760429);
            uLCD.pixel(110, 105, 16760172);
            uLCD.pixel(111, 105, 16759661);
            uLCD.pixel(112, 105, 16759662);
            uLCD.pixel(113, 105, 16759664);
            uLCD.pixel(114, 105, 16759921);
            uLCD.pixel(115, 105, 16760179);
            uLCD.pixel(116, 105, 16759925);
            uLCD.pixel(117, 105, 16759925);
            uLCD.pixel(118, 105, 16694132);
            uLCD.pixel(119, 105, 16694386);
            uLCD.pixel(120, 105, 16563568);
            uLCD.pixel(121, 105, 16563566);
            uLCD.pixel(122, 105, 16629359);
            uLCD.pixel(123, 105, 16564078);
            uLCD.pixel(124, 105, 16498285);
            uLCD.pixel(125, 105, 16433262);
            uLCD.pixel(126, 105, 16433262);
            uLCD.pixel(127, 105, 16433775);
            uLCD.pixel(99, 106, 4994072);
            uLCD.pixel(100, 106, 12953207);
            uLCD.pixel(101, 106, 13084008);
            uLCD.pixel(102, 106, 12754013);
            uLCD.pixel(103, 106, 13740134);
            uLCD.pixel(104, 106, 15975552);
            uLCD.pixel(105, 106, 16566145);
            uLCD.pixel(106, 106, 16301684);
            uLCD.pixel(107, 106, 16762234);
            uLCD.pixel(108, 106, 16366189);
            uLCD.pixel(109, 106, 16562798);
            uLCD.pixel(110, 106, 16628591);
            uLCD.pixel(111, 106, 16760177);
            uLCD.pixel(112, 106, 16629107);
            uLCD.pixel(113, 106, 16629109);
            uLCD.pixel(114, 106, 16497781);
            uLCD.pixel(115, 106, 16497781);
            uLCD.pixel(116, 106, 16629109);
            uLCD.pixel(117, 106, 16694386);
            uLCD.pixel(118, 106, 16694384);
            uLCD.pixel(119, 106, 16694382);
            uLCD.pixel(120, 106, 16694382);
            uLCD.pixel(121, 106, 16694637);
            uLCD.pixel(122, 106, 16694635);
            uLCD.pixel(123, 106, 16629612);
            uLCD.pixel(124, 106, 16498283);
            uLCD.pixel(125, 106, 16433260);
            uLCD.pixel(126, 106, 16433260);
            uLCD.pixel(127, 106, 16499053);
            uLCD.pixel(100, 107, 2758144);
            uLCD.pixel(101, 107, 9731152);
            uLCD.pixel(102, 107, 14006666);
            uLCD.pixel(103, 107, 13544826);
            uLCD.pixel(104, 107, 12951143);
            uLCD.pixel(105, 107, 13475941);
            uLCD.pixel(106, 107, 14198118);
            uLCD.pixel(107, 107, 14920811);
            uLCD.pixel(108, 107, 15644016);
            uLCD.pixel(109, 107, 15906675);
            uLCD.pixel(110, 107, 16169845);
            uLCD.pixel(111, 107, 16367226);
            uLCD.pixel(112, 107, 16498814);
            uLCD.pixel(113, 107, 16367741);
            uLCD.pixel(114, 107, 16105085);
            uLCD.pixel(115, 107, 16104569);
            uLCD.pixel(116, 107, 16563574);
            uLCD.pixel(117, 107, 16563314);
            uLCD.pixel(118, 107, 16563568);
            uLCD.pixel(119, 107, 16563566);
            uLCD.pixel(120, 107, 16563565);
            uLCD.pixel(121, 107, 16694637);
            uLCD.pixel(122, 107, 16694635);
            uLCD.pixel(123, 107, 16629610);
            uLCD.pixel(124, 107, 16563817);
            uLCD.pixel(125, 107, 16564076);
            uLCD.pixel(126, 107, 16564076);
            uLCD.pixel(127, 107, 16499053);
            uLCD.pixel(101, 108, 2232832);
            uLCD.pixel(102, 108, 6310961);
            uLCD.pixel(103, 108, 11573112);
            uLCD.pixel(104, 108, 14335128);
            uLCD.pixel(105, 108, 14004872);
            uLCD.pixel(106, 108, 13542516);
            uLCD.pixel(107, 108, 13936242);
            uLCD.pixel(108, 108, 14067053);
            uLCD.pixel(109, 108, 14198124);
            uLCD.pixel(110, 108, 14001000);
            uLCD.pixel(111, 108, 14067050);
            uLCD.pixel(112, 108, 14461809);
            uLCD.pixel(113, 108, 14199407);
            uLCD.pixel(114, 108, 14133360);
            uLCD.pixel(115, 108, 14724721);
            uLCD.pixel(116, 108, 15907188);
            uLCD.pixel(117, 108, 16235632);
            uLCD.pixel(118, 108, 16563825);
            uLCD.pixel(119, 108, 16629872);
            uLCD.pixel(120, 108, 16695664);
            uLCD.pixel(121, 108, 16760944);
            uLCD.pixel(122, 108, 16695405);
            uLCD.pixel(123, 108, 16563819);
            uLCD.pixel(124, 108, 16432233);
            uLCD.pixel(125, 108, 16234600);
            uLCD.pixel(126, 108, 16366186);
            uLCD.pixel(127, 108, 16761714);
            uLCD.pixel(103, 109, 3614230);
            uLCD.pixel(104, 109, 5981488);
            uLCD.pixel(105, 109, 7756608);
            uLCD.pixel(106, 109, 9663057);
            uLCD.pixel(107, 109, 11241570);
            uLCD.pixel(108, 109, 12622192);
            uLCD.pixel(109, 109, 14003328);
            uLCD.pixel(110, 109, 14463877);
            uLCD.pixel(111, 109, 14003326);
            uLCD.pixel(112, 109, 13740924);
            uLCD.pixel(113, 109, 13806717);
            uLCD.pixel(114, 109, 13609851);
            uLCD.pixel(115, 109, 13674612);
            uLCD.pixel(116, 109, 13211480);
            uLCD.pixel(117, 109, 13737046);
            uLCD.pixel(118, 109, 14526303);
            uLCD.pixel(119, 109, 15512681);
            uLCD.pixel(120, 109, 15907180);
            uLCD.pixel(121, 109, 15972971);
            uLCD.pixel(122, 109, 16104042);
            uLCD.pixel(123, 109, 16498286);
            uLCD.pixel(124, 109, 16763772);
            uLCD.pixel(125, 109, 16761975);
            uLCD.pixel(126, 109, 16431982);
            uLCD.pixel(127, 109, 16300396);
            uLCD.pixel(108, 110, 3809028);
            uLCD.pixel(109, 110, 6571817);
            uLCD.pixel(110, 110, 8414019);
            uLCD.pixel(111, 110, 8348224);
            uLCD.pixel(112, 110, 8085052);
            uLCD.pixel(113, 110, 9006408);
            uLCD.pixel(114, 110, 10914919);
            uLCD.pixel(115, 110, 13085312);
            uLCD.pixel(116, 110, 14727554);
            uLCD.pixel(117, 110, 14397298);
            uLCD.pixel(118, 110, 13673060);
            uLCD.pixel(119, 110, 13540956);
            uLCD.pixel(120, 110, 14264421);
            uLCD.pixel(121, 110, 15381871);
            uLCD.pixel(122, 110, 15710577);
            uLCD.pixel(123, 110, 15709548);
            uLCD.pixel(124, 110, 15577449);
            uLCD.pixel(125, 110, 16366195);
            uLCD.pixel(126, 110, 16761724);
            uLCD.pixel(127, 110, 16761981);
            uLCD.pixel(114, 111, 2298112);
            uLCD.pixel(115, 111, 3942152);
            uLCD.pixel(116, 111, 8019510);
            uLCD.pixel(117, 111, 11505504);
            uLCD.pixel(118, 111, 14201986);
            uLCD.pixel(119, 111, 14135933);
            uLCD.pixel(120, 111, 13213800);
            uLCD.pixel(121, 111, 13278562);
            uLCD.pixel(122, 111, 13869412);
            uLCD.pixel(123, 111, 14065760);
            uLCD.pixel(124, 111, 16367487);
            uLCD.pixel(125, 111, 16235642);
            uLCD.pixel(126, 111, 16169336);
            uLCD.pixel(127, 111, 16235127);
            uLCD.pixel(117, 112, 3021056);
            uLCD.pixel(118, 112, 6704430);
            uLCD.pixel(119, 112, 10979944);
            uLCD.pixel(120, 112, 13216128);
            uLCD.pixel(121, 112, 13280632);
            uLCD.pixel(122, 112, 13279342);
            uLCD.pixel(123, 112, 14001776);
            uLCD.pixel(124, 112, 13671780);
            uLCD.pixel(125, 112, 14131557);
            uLCD.pixel(126, 112, 14986351);
            uLCD.pixel(127, 112, 16038523);
            uLCD.pixel(119, 113, 2034944);
            uLCD.pixel(120, 113, 6178348);
            uLCD.pixel(121, 113, 11506290);
            uLCD.pixel(122, 113, 14004876);
            uLCD.pixel(123, 113, 13740156);
            uLCD.pixel(124, 113, 13278314);
            uLCD.pixel(125, 113, 13803368);
            uLCD.pixel(126, 113, 14263659);
            uLCD.pixel(127, 113, 14657901);
            uLCD.pixel(122, 114, 6506024);
            uLCD.pixel(123, 114, 11702121);
            uLCD.pixel(124, 114, 14266500);
            uLCD.pixel(125, 114, 14331002);
            uLCD.pixel(126, 114, 14000747);
            uLCD.pixel(127, 114, 13671523);
            uLCD.pixel(123, 115, 2428160);
            uLCD.pixel(124, 115, 7623990);
            uLCD.pixel(125, 115, 11373414);
            uLCD.pixel(126, 115, 14333069);
            uLCD.pixel(127, 115, 14201222);
            uLCD.pixel(125, 116, 2168071);
            uLCD.pixel(126, 116, 6641736);
            uLCD.pixel(127, 116, 10984073);
            uLCD.pixel(127, 117, 2368287);
        }

        // Draw left paper
        void drawLeftPaper() {
            uLCD.pixel(35, 77, 4208685);
            uLCD.pixel(34, 78, 8548440);
            uLCD.pixel(35, 78, 15654607);
            uLCD.pixel(36, 78, 4668724);
            uLCD.pixel(33, 79, 10058834);
            uLCD.pixel(34, 79, 14665383);
            uLCD.pixel(35, 79, 14732214);
            uLCD.pixel(36, 79, 6377542);
            uLCD.pixel(30, 80, 2561024);
            uLCD.pixel(31, 80, 8480832);
            uLCD.pixel(32, 80, 14136191);
            uLCD.pixel(33, 80, 15780759);
            uLCD.pixel(34, 80, 15189407);
            uLCD.pixel(35, 80, 14796459);
            uLCD.pixel(36, 80, 3811097);
            uLCD.pixel(29, 81, 6242840);
            uLCD.pixel(30, 81, 12624242);
            uLCD.pixel(31, 81, 16176029);
            uLCD.pixel(32, 81, 15713156);
            uLCD.pixel(33, 81, 15449474);
            uLCD.pixel(34, 81, 14924428);
            uLCD.pixel(35, 81, 11044712);
            uLCD.pixel(25, 82, 2232064);
            uLCD.pixel(26, 82, 4006664);
            uLCD.pixel(27, 82, 7163691);
            uLCD.pixel(28, 82, 12031335);
            uLCD.pixel(29, 82, 15385484);
            uLCD.pixel(30, 82, 15713928);
            uLCD.pixel(31, 82, 15252344);
            uLCD.pixel(32, 82, 15710836);
            uLCD.pixel(33, 82, 15974012);
            uLCD.pixel(34, 82, 14725760);
            uLCD.pixel(35, 82, 6109461);
            uLCD.pixel(23, 83, 5914673);
            uLCD.pixel(24, 83, 11900545);
            uLCD.pixel(25, 83, 13018502);
            uLCD.pixel(26, 83, 14727827);
            uLCD.pixel(27, 83, 15845784);
            uLCD.pixel(28, 83, 16042640);
            uLCD.pixel(29, 83, 15647361);
            uLCD.pixel(30, 83, 14660973);
            uLCD.pixel(31, 83, 13673565);
            uLCD.pixel(32, 83, 15449725);
            uLCD.pixel(33, 83, 14397815);
            uLCD.pixel(34, 83, 9464638);
            uLCD.pixel(21, 84, 2885888);
            uLCD.pixel(22, 84, 11830892);
            uLCD.pixel(23, 84, 16369056);
            uLCD.pixel(24, 84, 16236947);
            uLCD.pixel(25, 84, 16499854);
            uLCD.pixel(26, 84, 16500105);
            uLCD.pixel(27, 84, 15843454);
            uLCD.pixel(28, 84, 14857839);
            uLCD.pixel(29, 84, 15517050);
            uLCD.pixel(30, 84, 15452027);
            uLCD.pixel(31, 84, 12164186);
            uLCD.pixel(32, 84, 13284485);
            uLCD.pixel(33, 84, 8877910);
            uLCD.pixel(43, 84, 2297856);
            uLCD.pixel(44, 84, 5126161);
            uLCD.pixel(45, 84, 8349497);
            uLCD.pixel(46, 84, 11967595);
            uLCD.pixel(47, 84, 13612935);
            uLCD.pixel(48, 84, 14535076);
            uLCD.pixel(49, 84, 6048818);
            uLCD.pixel(20, 85, 2755072);
            uLCD.pixel(21, 85, 12686702);
            uLCD.pixel(22, 85, 16763800);
            uLCD.pixel(23, 85, 15971704);
            uLCD.pixel(24, 85, 16761213);
            uLCD.pixel(25, 85, 16299374);
            uLCD.pixel(26, 85, 15971437);
            uLCD.pixel(27, 85, 16762752);
            uLCD.pixel(28, 85, 16632969);
            uLCD.pixel(29, 85, 15713924);
            uLCD.pixel(30, 85, 13741936);
            uLCD.pixel(31, 85, 10322768);
            uLCD.pixel(32, 85, 3943953);
            uLCD.pixel(39, 85, 2298368);
            uLCD.pixel(40, 85, 5717799);
            uLCD.pixel(41, 85, 9400916);
            uLCD.pixel(42, 85, 12425844);
            uLCD.pixel(43, 85, 14135684);
            uLCD.pixel(44, 85, 15187592);
            uLCD.pixel(45, 85, 16108431);
            uLCD.pixel(46, 85, 16569235);
            uLCD.pixel(47, 85, 15451527);
            uLCD.pixel(48, 85, 14729870);
            uLCD.pixel(49, 85, 12560257);
            uLCD.pixel(20, 86, 11965542);
            uLCD.pixel(21, 86, 16107914);
            uLCD.pixel(22, 86, 16302967);
            uLCD.pixel(23, 86, 16432744);
            uLCD.pixel(24, 86, 16760679);
            uLCD.pixel(25, 86, 16761708);
            uLCD.pixel(26, 86, 16432239);
            uLCD.pixel(27, 86, 16236155);
            uLCD.pixel(28, 86, 15185023);
            uLCD.pixel(29, 86, 12290915);
            uLCD.pixel(30, 86, 7357733);
            uLCD.pixel(37, 86, 4927515);
            uLCD.pixel(38, 86, 9136461);
            uLCD.pixel(39, 86, 13937284);
            uLCD.pixel(40, 86, 16106901);
            uLCD.pixel(41, 86, 16764054);
            uLCD.pixel(42, 86, 16630149);
            uLCD.pixel(43, 86, 16169338);
            uLCD.pixel(44, 86, 15906166);
            uLCD.pixel(45, 86, 15905911);
            uLCD.pixel(46, 86, 15840633);
            uLCD.pixel(47, 86, 14461039);
            uLCD.pixel(48, 86, 15386000);
            uLCD.pixel(49, 86, 11506793);
            uLCD.pixel(18, 87, 2165760);
            uLCD.pixel(19, 87, 12164208);
            uLCD.pixel(20, 87, 15714699);
            uLCD.pixel(21, 87, 15515249);
            uLCD.pixel(22, 87, 15973733);
            uLCD.pixel(23, 87, 16696165);
            uLCD.pixel(24, 87, 16366173);
            uLCD.pixel(25, 87, 16761450);
            uLCD.pixel(26, 87, 16432239);
            uLCD.pixel(27, 87, 14853736);
            uLCD.pixel(28, 87, 9789233);
            uLCD.pixel(29, 87, 3539712);
            uLCD.pixel(30, 87, 2359296);
            uLCD.pixel(31, 87, 2359296);
            uLCD.pixel(32, 87, 3019264);
            uLCD.pixel(33, 87, 4796697);
            uLCD.pixel(34, 87, 5783077);
            uLCD.pixel(35, 87, 9598042);
            uLCD.pixel(36, 87, 13412747);
            uLCD.pixel(37, 87, 15253660);
            uLCD.pixel(38, 87, 16699297);
            uLCD.pixel(39, 87, 15513727);
            uLCD.pixel(40, 87, 14920041);
            uLCD.pixel(41, 87, 16366965);
            uLCD.pixel(42, 87, 16760952);
            uLCD.pixel(43, 87, 16234609);
            uLCD.pixel(44, 87, 14985064);
            uLCD.pixel(45, 87, 14393448);
            uLCD.pixel(46, 87, 14986365);
            uLCD.pixel(47, 87, 14791304);
            uLCD.pixel(48, 87, 10715737);
            uLCD.pixel(49, 87, 4467722);
            uLCD.pixel(17, 88, 4270336);
            uLCD.pixel(18, 88, 13018741);
            uLCD.pixel(19, 88, 15846801);
            uLCD.pixel(20, 88, 15844993);
            uLCD.pixel(21, 88, 16040820);
            uLCD.pixel(22, 88, 16499566);
            uLCD.pixel(23, 88, 16564328);
            uLCD.pixel(24, 88, 16761197);
            uLCD.pixel(25, 88, 16628844);
            uLCD.pixel(26, 88, 14458198);
            uLCD.pixel(27, 88, 13603671);
            uLCD.pixel(28, 88, 13867371);
            uLCD.pixel(29, 88, 13276272);
            uLCD.pixel(30, 88, 12816501);
            uLCD.pixel(31, 88, 12750704);
            uLCD.pixel(32, 88, 14592892);
            uLCD.pixel(33, 88, 16304015);
            uLCD.pixel(34, 88, 15974796);
            uLCD.pixel(35, 88, 16369554);
            uLCD.pixel(36, 88, 15975050);
            uLCD.pixel(37, 88, 15448957);
            uLCD.pixel(38, 88, 16303491);
            uLCD.pixel(39, 88, 14856295);
            uLCD.pixel(40, 88, 14066516);
            uLCD.pixel(41, 88, 15317097);
            uLCD.pixel(42, 88, 15317870);
            uLCD.pixel(43, 88, 14661490);
            uLCD.pixel(44, 88, 13806968);
            uLCD.pixel(45, 88, 11702889);
            uLCD.pixel(46, 88, 8019778);
            uLCD.pixel(47, 88, 3810319);
            uLCD.pixel(16, 89, 4861440);
            uLCD.pixel(17, 89, 14398839);
            uLCD.pixel(18, 89, 15779719);
            uLCD.pixel(19, 89, 15186550);
            uLCD.pixel(20, 89, 16172157);
            uLCD.pixel(21, 89, 15841646);
            uLCD.pixel(22, 89, 16762233);
            uLCD.pixel(23, 89, 16300396);
            uLCD.pixel(24, 89, 16761207);
            uLCD.pixel(25, 89, 15115870);
            uLCD.pixel(26, 89, 13537100);
            uLCD.pixel(27, 89, 15379569);
            uLCD.pixel(28, 89, 16763540);
            uLCD.pixel(29, 89, 16170637);
            uLCD.pixel(30, 89, 15644812);
            uLCD.pixel(31, 89, 16367503);
            uLCD.pixel(32, 89, 16760706);
            uLCD.pixel(33, 89, 16298862);
            uLCD.pixel(34, 89, 16431731);
            uLCD.pixel(35, 89, 16366965);
            uLCD.pixel(36, 89, 16171126);
            uLCD.pixel(37, 89, 16238202);
            uLCD.pixel(38, 89, 15383663);
            uLCD.pixel(39, 89, 14660969);
            uLCD.pixel(40, 89, 13740385);
            uLCD.pixel(41, 89, 13807467);
            uLCD.pixel(42, 89, 12032349);
            uLCD.pixel(43, 89, 8743738);
            uLCD.pixel(44, 89, 4402954);
            uLCD.pixel(0, 90, 9336664);
            uLCD.pixel(1, 90, 7889218);
            uLCD.pixel(2, 90, 5915174);
            uLCD.pixel(3, 90, 4204558);
            uLCD.pixel(4, 90, 2625536);
            uLCD.pixel(15, 90, 2625536);
            uLCD.pixel(16, 90, 13740395);
            uLCD.pixel(17, 90, 16766088);
            uLCD.pixel(18, 90, 16040055);
            uLCD.pixel(19, 90, 16039544);
            uLCD.pixel(20, 90, 16235640);
            uLCD.pixel(21, 90, 16300922);
            uLCD.pixel(22, 90, 16760962);
            uLCD.pixel(23, 90, 16562813);
            uLCD.pixel(24, 90, 16628606);
            uLCD.pixel(25, 90, 16760963);
            uLCD.pixel(26, 90, 16234359);
            uLCD.pixel(27, 90, 16169336);
            uLCD.pixel(28, 90, 16433019);
            uLCD.pixel(29, 90, 16301944);
            uLCD.pixel(30, 90, 16368505);
            uLCD.pixel(31, 90, 16695160);
            uLCD.pixel(32, 90, 16760444);
            uLCD.pixel(33, 90, 16757360);
            uLCD.pixel(34, 90, 16760693);
            uLCD.pixel(35, 90, 16695152);
            uLCD.pixel(36, 90, 15513447);
            uLCD.pixel(37, 90, 14989674);
            uLCD.pixel(38, 90, 14005099);
            uLCD.pixel(39, 90, 13414259);
            uLCD.pixel(40, 90, 10718045);
            uLCD.pixel(41, 90, 6507564);
            uLCD.pixel(0, 91, 16175263);
            uLCD.pixel(1, 91, 15715225);
            uLCD.pixel(2, 91, 15517848);
            uLCD.pixel(3, 91, 15320469);
            uLCD.pixel(4, 91, 14596492);
            uLCD.pixel(5, 91, 13215609);
            uLCD.pixel(6, 91, 12360301);
            uLCD.pixel(7, 91, 12097386);
            uLCD.pixel(8, 91, 10978907);
            uLCD.pixel(9, 91, 11242592);
            uLCD.pixel(10, 91, 9860685);
            uLCD.pixel(11, 91, 9071939);
            uLCD.pixel(12, 91, 10256213);
            uLCD.pixel(13, 91, 10190933);
            uLCD.pixel(14, 91, 10453851);
            uLCD.pixel(15, 91, 13083505);
            uLCD.pixel(16, 91, 16765067);
            uLCD.pixel(17, 91, 15183455);
            uLCD.pixel(18, 91, 16301171);
            uLCD.pixel(19, 91, 16760953);
            uLCD.pixel(20, 91, 16497785);
            uLCD.pixel(21, 91, 16628860);
            uLCD.pixel(22, 91, 16497021);
            uLCD.pixel(23, 91, 16760193);
            uLCD.pixel(24, 91, 16562814);
            uLCD.pixel(25, 91, 16694653);
            uLCD.pixel(26, 91, 16366199);
            uLCD.pixel(27, 91, 16761210);
            uLCD.pixel(28, 91, 16498804);
            uLCD.pixel(29, 91, 15775590);
            uLCD.pixel(30, 91, 16104808);
            uLCD.pixel(31, 91, 16629612);
            uLCD.pixel(32, 91, 16691561);
            uLCD.pixel(33, 91, 16760441);
            uLCD.pixel(34, 91, 16628080);
            uLCD.pixel(35, 91, 16235892);
            uLCD.pixel(36, 91, 13869661);
            uLCD.pixel(37, 91, 10582585);
            uLCD.pixel(38, 91, 7887136);
            uLCD.pixel(39, 91, 3545856);
            uLCD.pixel(42, 91, 3020549);
            uLCD.pixel(43, 91, 4665889);
            uLCD.pixel(44, 91, 4929829);
            uLCD.pixel(45, 91, 4469789);
            uLCD.pixel(46, 91, 5654573);
            uLCD.pixel(47, 91, 6838588);
            uLCD.pixel(48, 91, 8613459);
            uLCD.pixel(49, 91, 10060903);
            uLCD.pixel(50, 91, 10523247);
            uLCD.pixel(51, 91, 9603950);
            uLCD.pixel(0, 92, 15842676);
            uLCD.pixel(1, 92, 15777397);
            uLCD.pixel(2, 92, 15843190);
            uLCD.pixel(3, 92, 15909496);
            uLCD.pixel(4, 92, 15975291);
            uLCD.pixel(5, 92, 16041341);
            uLCD.pixel(6, 92, 16107136);
            uLCD.pixel(7, 92, 16042113);
            uLCD.pixel(8, 92, 16239238);
            uLCD.pixel(9, 92, 16108165);
            uLCD.pixel(10, 92, 16108166);
            uLCD.pixel(11, 92, 16239752);
            uLCD.pixel(12, 92, 16173705);
            uLCD.pixel(13, 92, 15911303);
            uLCD.pixel(14, 92, 16240268);
            uLCD.pixel(15, 92, 15975297);
            uLCD.pixel(16, 92, 16169334);
            uLCD.pixel(17, 92, 16628340);
            uLCD.pixel(18, 92, 16759926);
            uLCD.pixel(19, 92, 16694133);
            uLCD.pixel(20, 92, 16562547);
            uLCD.pixel(21, 92, 16431731);
            uLCD.pixel(22, 92, 16629110);
            uLCD.pixel(23, 92, 16761209);
            uLCD.pixel(24, 92, 16103278);
            uLCD.pixel(25, 92, 16498034);
            uLCD.pixel(26, 92, 16563825);
            uLCD.pixel(27, 92, 16366446);
            uLCD.pixel(28, 92, 16761972);
            uLCD.pixel(29, 92, 14656851);
            uLCD.pixel(30, 92, 16499055);
            uLCD.pixel(31, 92, 16433260);
            uLCD.pixel(32, 92, 16565100);
            uLCD.pixel(33, 92, 16301934);
            uLCD.pixel(34, 92, 16302977);
            uLCD.pixel(35, 92, 9462059);
            uLCD.pixel(36, 92, 2359296);
            uLCD.pixel(37, 92, 2031616);
            uLCD.pixel(38, 92, 2754304);
            uLCD.pixel(39, 92, 5188872);
            uLCD.pixel(40, 92, 10518097);
            uLCD.pixel(41, 92, 13938555);
            uLCD.pixel(42, 92, 15582348);
            uLCD.pixel(43, 92, 16305040);
            uLCD.pixel(44, 92, 15448706);
            uLCD.pixel(45, 92, 16303250);
            uLCD.pixel(46, 92, 16369046);
            uLCD.pixel(47, 92, 15843214);
            uLCD.pixel(48, 92, 16371858);
            uLCD.pixel(49, 92, 15452805);
            uLCD.pixel(50, 92, 14862212);
            uLCD.pixel(51, 92, 15982760);
            uLCD.pixel(52, 92, 7759690);
            uLCD.pixel(0, 93, 16563819);
            uLCD.pixel(1, 93, 16563819);
            uLCD.pixel(2, 93, 16498283);
            uLCD.pixel(3, 93, 16498283);
            uLCD.pixel(4, 93, 16498285);
            uLCD.pixel(5, 93, 16367469);
            uLCD.pixel(6, 93, 16367214);
            uLCD.pixel(7, 93, 16367727);
            uLCD.pixel(8, 93, 16170348);
            uLCD.pixel(9, 93, 16105070);
            uLCD.pixel(10, 93, 16105070);
            uLCD.pixel(11, 93, 16236402);
            uLCD.pixel(12, 93, 16236402);
            uLCD.pixel(13, 93, 16105588);
            uLCD.pixel(14, 93, 16302967);
            uLCD.pixel(15, 93, 16170098);
            uLCD.pixel(16, 93, 16760442);
            uLCD.pixel(17, 93, 16759673);
            uLCD.pixel(18, 93, 16760184);
            uLCD.pixel(19, 93, 16760953);
            uLCD.pixel(20, 93, 16761208);
            uLCD.pixel(21, 93, 16760948);
            uLCD.pixel(22, 93, 16563566);
            uLCD.pixel(23, 93, 16235114);
            uLCD.pixel(24, 93, 16763000);
            uLCD.pixel(25, 93, 16763000);
            uLCD.pixel(26, 93, 16761972);
            uLCD.pixel(27, 93, 16169321);
            uLCD.pixel(28, 93, 14788184);
            uLCD.pixel(29, 93, 13998668);
            uLCD.pixel(30, 93, 16564597);
            uLCD.pixel(31, 93, 16236143);
            uLCD.pixel(32, 93, 15777381);
            uLCD.pixel(33, 93, 16173171);
            uLCD.pixel(34, 93, 15120757);
            uLCD.pixel(35, 93, 9792053);
            uLCD.pixel(36, 93, 8015914);
            uLCD.pixel(37, 93, 11634792);
            uLCD.pixel(38, 93, 14134926);
            uLCD.pixel(39, 93, 15844766);
            uLCD.pixel(40, 93, 15712653);
            uLCD.pixel(41, 93, 16106372);
            uLCD.pixel(42, 93, 14592096);
            uLCD.pixel(43, 93, 16301938);
            uLCD.pixel(44, 93, 16761722);
            uLCD.pixel(45, 93, 16760956);
            uLCD.pixel(46, 93, 16562813);
            uLCD.pixel(47, 93, 14919271);
            uLCD.pixel(48, 93, 15777650);
            uLCD.pixel(49, 93, 15122543);
            uLCD.pixel(50, 93, 14466161);
            uLCD.pixel(51, 93, 14928272);
            uLCD.pixel(52, 93, 8481869);
            uLCD.pixel(0, 94, 16760175);
            uLCD.pixel(1, 94, 16760175);
            uLCD.pixel(2, 94, 16759918);
            uLCD.pixel(3, 94, 16759918);
            uLCD.pixel(4, 94, 16759661);
            uLCD.pixel(5, 94, 16759404);
            uLCD.pixel(6, 94, 16759404);
            uLCD.pixel(7, 94, 16694124);
            uLCD.pixel(8, 94, 16694124);
            uLCD.pixel(9, 94, 16628589);
            uLCD.pixel(10, 94, 16562796);
            uLCD.pixel(11, 94, 16694384);
            uLCD.pixel(12, 94, 16694386);
            uLCD.pixel(13, 94, 16694900);
            uLCD.pixel(14, 94, 16563316);
            uLCD.pixel(15, 94, 16628339);
            uLCD.pixel(16, 94, 16760183);
            uLCD.pixel(17, 94, 16758899);
            uLCD.pixel(18, 94, 16495981);
            uLCD.pixel(19, 94, 16430699);
            uLCD.pixel(20, 94, 16628331);
            uLCD.pixel(21, 94, 16760942);
            uLCD.pixel(22, 94, 16761969);
            uLCD.pixel(23, 94, 16762483);
            uLCD.pixel(24, 94, 15840353);
            uLCD.pixel(25, 94, 15972711);
            uLCD.pixel(26, 94, 16498802);
            uLCD.pixel(27, 94, 15182690);
            uLCD.pixel(28, 94, 14130005);
            uLCD.pixel(29, 94, 13603407);
            uLCD.pixel(30, 94, 16629889);
            uLCD.pixel(31, 94, 16169847);
            uLCD.pixel(32, 94, 16171892);
            uLCD.pixel(33, 94, 16107124);
            uLCD.pixel(34, 94, 16238971);
            uLCD.pixel(35, 94, 15976318);
            uLCD.pixel(36, 94, 16765585);
            uLCD.pixel(37, 94, 16765590);
            uLCD.pixel(38, 94, 15711876);
            uLCD.pixel(39, 94, 16040071);
            uLCD.pixel(40, 94, 16236422);
            uLCD.pixel(41, 94, 16235391);
            uLCD.pixel(42, 94, 13866583);
            uLCD.pixel(43, 94, 15182439);
            uLCD.pixel(44, 94, 14919778);
            uLCD.pixel(45, 94, 13867857);
            uLCD.pixel(46, 94, 14592349);
            uLCD.pixel(47, 94, 13606228);
            uLCD.pixel(48, 94, 14397034);
            uLCD.pixel(49, 94, 14727290);
            uLCD.pixel(50, 94, 13873788);
            uLCD.pixel(51, 94, 11835505);
            uLCD.pixel(52, 94, 6508093);
            uLCD.pixel(0, 95, 16759411);
            uLCD.pixel(1, 95, 16759409);
            uLCD.pixel(2, 95, 16759409);
            uLCD.pixel(3, 95, 16759409);
            uLCD.pixel(4, 95, 16759666);
            uLCD.pixel(5, 95, 16759666);
            uLCD.pixel(6, 95, 16759666);
            uLCD.pixel(7, 95, 16759922);
            uLCD.pixel(8, 95, 16760693);
            uLCD.pixel(9, 95, 16760949);
            uLCD.pixel(10, 95, 16759924);
            uLCD.pixel(11, 95, 16760438);
            uLCD.pixel(12, 95, 16759926);
            uLCD.pixel(13, 95, 16760698);
            uLCD.pixel(14, 95, 16495984);
            uLCD.pixel(15, 95, 16759412);
            uLCD.pixel(16, 95, 16759407);
            uLCD.pixel(17, 95, 16760176);
            uLCD.pixel(18, 95, 16760946);
            uLCD.pixel(19, 95, 16760688);
            uLCD.pixel(20, 95, 16628844);
            uLCD.pixel(21, 95, 16300647);
            uLCD.pixel(22, 95, 16300904);
            uLCD.pixel(23, 95, 16301676);
            uLCD.pixel(24, 95, 16564593);
            uLCD.pixel(25, 95, 16762488);
            uLCD.pixel(26, 95, 15248484);
            uLCD.pixel(27, 95, 12550973);
            uLCD.pixel(28, 95, 15050855);
            uLCD.pixel(29, 95, 13998427);
            uLCD.pixel(30, 95, 15840122);
            uLCD.pixel(31, 95, 16761990);
            uLCD.pixel(32, 95, 16104819);
            uLCD.pixel(33, 95, 16237170);
            uLCD.pixel(34, 95, 16106099);
            uLCD.pixel(35, 95, 15777134);
            uLCD.pixel(36, 95, 15448686);
            uLCD.pixel(37, 95, 15185262);
            uLCD.pixel(38, 95, 15381875);
            uLCD.pixel(39, 95, 15907968);
            uLCD.pixel(40, 95, 15051893);
            uLCD.pixel(41, 95, 14591090);
            uLCD.pixel(42, 95, 12880987);
            uLCD.pixel(43, 95, 13934702);
            uLCD.pixel(44, 95, 14528633);
            uLCD.pixel(45, 95, 14003568);
            uLCD.pixel(46, 95, 13478764);
            uLCD.pixel(47, 95, 11637078);
            uLCD.pixel(48, 95, 9201720);
            uLCD.pixel(49, 95, 7820592);
            uLCD.pixel(50, 95, 5518874);
            uLCD.pixel(51, 95, 2362624);
            uLCD.pixel(0, 96, 16758907);
            uLCD.pixel(1, 96, 16758905);
            uLCD.pixel(2, 96, 16759162);
            uLCD.pixel(3, 96, 16759162);
            uLCD.pixel(4, 96, 16759417);
            uLCD.pixel(5, 96, 16759417);
            uLCD.pixel(6, 96, 16759928);
            uLCD.pixel(7, 96, 16760184);
            uLCD.pixel(8, 96, 16759927);
            uLCD.pixel(9, 96, 16759927);
            uLCD.pixel(10, 96, 16758902);
            uLCD.pixel(11, 96, 16759931);
            uLCD.pixel(12, 96, 16627831);
            uLCD.pixel(13, 96, 16759934);
            uLCD.pixel(14, 96, 15706475);
            uLCD.pixel(15, 96, 16496243);
            uLCD.pixel(16, 96, 16760944);
            uLCD.pixel(17, 96, 16760940);
            uLCD.pixel(18, 96, 16695405);
            uLCD.pixel(19, 96, 16695151);
            uLCD.pixel(20, 96, 16629359);
            uLCD.pixel(21, 96, 16563825);
            uLCD.pixel(22, 96, 16629622);
            uLCD.pixel(23, 96, 16498551);
            uLCD.pixel(24, 96, 16564346);
            uLCD.pixel(25, 96, 13669713);
            uLCD.pixel(26, 96, 13932887);
            uLCD.pixel(27, 96, 14261598);
            uLCD.pixel(28, 96, 13932633);
            uLCD.pixel(29, 96, 14788456);
            uLCD.pixel(30, 96, 16762249);
            uLCD.pixel(31, 96, 14919271);
            uLCD.pixel(32, 96, 16761468);
            uLCD.pixel(33, 96, 16430701);
            uLCD.pixel(34, 96, 16629109);
            uLCD.pixel(35, 96, 16564344);
            uLCD.pixel(36, 96, 15644016);
            uLCD.pixel(37, 96, 15250034);
            uLCD.pixel(38, 96, 14724468);
            uLCD.pixel(39, 96, 13540459);
            uLCD.pixel(40, 96, 14528132);
            uLCD.pixel(41, 96, 13607808);
            uLCD.pixel(42, 96, 12885376);
            uLCD.pixel(43, 96, 11308147);
            uLCD.pixel(44, 96, 9402205);
            uLCD.pixel(45, 96, 6311990);
            uLCD.pixel(46, 96, 2892297);
            uLCD.pixel(0, 97, 16759676);
            uLCD.pixel(1, 97, 16759674);
            uLCD.pixel(2, 97, 16693881);
            uLCD.pixel(3, 97, 16694135);
            uLCD.pixel(4, 97, 16694135);
            uLCD.pixel(5, 97, 16694133);
            uLCD.pixel(6, 97, 16694133);
            uLCD.pixel(7, 97, 16694132);
            uLCD.pixel(8, 97, 16628340);
            uLCD.pixel(9, 97, 16694133);
            uLCD.pixel(10, 97, 16562547);
            uLCD.pixel(11, 97, 16760185);
            uLCD.pixel(12, 97, 16562549);
            uLCD.pixel(13, 97, 16760702);
            uLCD.pixel(14, 97, 15180642);
            uLCD.pixel(15, 97, 16234352);
            uLCD.pixel(16, 97, 16761458);
            uLCD.pixel(17, 97, 16432490);
            uLCD.pixel(18, 97, 16104042);
            uLCD.pixel(19, 97, 16301423);
            uLCD.pixel(20, 97, 16630136);
            uLCD.pixel(21, 97, 16630137);
            uLCD.pixel(22, 97, 16169334);
            uLCD.pixel(23, 97, 15642992);
            uLCD.pixel(24, 97, 12814406);
            uLCD.pixel(25, 97, 14195805);
            uLCD.pixel(26, 97, 14261598);
            uLCD.pixel(27, 97, 15643764);
            uLCD.pixel(28, 97, 14788455);
            uLCD.pixel(29, 97, 15314799);
            uLCD.pixel(30, 97, 14525283);
            uLCD.pixel(31, 97, 15708785);
            uLCD.pixel(32, 97, 16761983);
            uLCD.pixel(33, 97, 16561776);
            uLCD.pixel(34, 97, 16760956);
            uLCD.pixel(35, 97, 15379820);
            uLCD.pixel(36, 97, 12881488);
            uLCD.pixel(37, 97, 12816986);
            uLCD.pixel(38, 97, 12818533);
            uLCD.pixel(39, 97, 12226917);
            uLCD.pixel(40, 97, 8280113);
            uLCD.pixel(41, 97, 4662789);
            uLCD.pixel(42, 97, 2755584);
            uLCD.pixel(0, 98, 16367731);
            uLCD.pixel(1, 98, 16367731);
            uLCD.pixel(2, 98, 16433011);
            uLCD.pixel(3, 98, 16367216);
            uLCD.pixel(4, 98, 16367214);
            uLCD.pixel(5, 98, 16367469);
            uLCD.pixel(6, 98, 16301676);
            uLCD.pixel(7, 98, 16301674);
            uLCD.pixel(8, 98, 16367469);
            uLCD.pixel(9, 98, 16564848);
            uLCD.pixel(10, 98, 16367469);
            uLCD.pixel(11, 98, 16696434);
            uLCD.pixel(12, 98, 16367214);
            uLCD.pixel(13, 98, 16762231);
            uLCD.pixel(14, 98, 14590805);
            uLCD.pixel(15, 98, 15972460);
            uLCD.pixel(16, 98, 16367477);
            uLCD.pixel(17, 98, 16433271);
            uLCD.pixel(18, 98, 16564857);
            uLCD.pixel(19, 98, 16630396);
            uLCD.pixel(20, 98, 16301433);
            uLCD.pixel(21, 98, 15511917);
            uLCD.pixel(22, 98, 14393438);
            uLCD.pixel(23, 98, 13603922);
            uLCD.pixel(24, 98, 14985575);
            uLCD.pixel(25, 98, 16367228);
            uLCD.pixel(26, 98, 16301948);
            uLCD.pixel(27, 98, 15841397);
            uLCD.pixel(28, 98, 13999193);
            uLCD.pixel(29, 98, 14460258);
            uLCD.pixel(30, 98, 14986856);
            uLCD.pixel(31, 98, 16762495);
            uLCD.pixel(32, 98, 15642215);
            uLCD.pixel(33, 98, 16762755);
            uLCD.pixel(34, 98, 16762245);
            uLCD.pixel(35, 98, 9198111);
            uLCD.pixel(36, 98, 3147008);
            uLCD.pixel(37, 98, 3346176);
            uLCD.pixel(38, 98, 3808256);
            uLCD.pixel(39, 98, 3940864);
            uLCD.pixel(40, 98, 4401152);
            uLCD.pixel(41, 98, 3744000);
            uLCD.pixel(42, 98, 3809792);
            uLCD.pixel(43, 98, 2427904);
            uLCD.pixel(44, 98, 2493440);
            uLCD.pixel(45, 98, 2756352);
            uLCD.pixel(46, 98, 3940360);
            uLCD.pixel(47, 98, 4796697);
            uLCD.pixel(48, 98, 4600343);
            uLCD.pixel(49, 98, 3154186);
            uLCD.pixel(0, 99, 16171379);
            uLCD.pixel(1, 99, 16171379);
            uLCD.pixel(2, 99, 16302195);
            uLCD.pixel(3, 99, 16302449);
            uLCD.pixel(4, 99, 16368242);
            uLCD.pixel(5, 99, 16237424);
            uLCD.pixel(6, 99, 16237424);
            uLCD.pixel(7, 99, 16237424);
            uLCD.pixel(8, 99, 16236654);
            uLCD.pixel(9, 99, 16368240);
            uLCD.pixel(10, 99, 16170861);
            uLCD.pixel(11, 99, 16499826);
            uLCD.pixel(12, 99, 16039275);
            uLCD.pixel(13, 99, 16499828);
            uLCD.pixel(14, 99, 13933388);
            uLCD.pixel(15, 99, 15381095);
            uLCD.pixel(16, 99, 16565116);
            uLCD.pixel(17, 99, 16171130);
            uLCD.pixel(18, 99, 15512946);
            uLCD.pixel(19, 99, 14722914);
            uLCD.pixel(20, 99, 13999191);
            uLCD.pixel(21, 99, 14261850);
            uLCD.pixel(22, 99, 15248745);
            uLCD.pixel(23, 99, 16235640);
            uLCD.pixel(24, 99, 16761984);
            uLCD.pixel(25, 99, 15972468);
            uLCD.pixel(26, 99, 16433019);
            uLCD.pixel(27, 99, 14327643);
            uLCD.pixel(28, 99, 14328156);
            uLCD.pixel(29, 99, 14854498);
            uLCD.pixel(30, 99, 16434298);
            uLCD.pixel(31, 99, 16038513);
            uLCD.pixel(32, 99, 16563574);
            uLCD.pixel(33, 99, 16760955);
            uLCD.pixel(34, 99, 16170879);
            uLCD.pixel(35, 99, 12027210);
            uLCD.pixel(36, 99, 10713666);
            uLCD.pixel(37, 99, 12754793);
            uLCD.pixel(38, 99, 13018993);
            uLCD.pixel(39, 99, 14729868);
            uLCD.pixel(40, 99, 14729610);
            uLCD.pixel(41, 99, 15584660);
            uLCD.pixel(42, 99, 15254925);
            uLCD.pixel(43, 99, 13806452);
            uLCD.pixel(44, 99, 14200444);
            uLCD.pixel(45, 99, 14726279);
            uLCD.pixel(46, 99, 16107681);
            uLCD.pixel(47, 99, 14859413);
            uLCD.pixel(48, 99, 14994852);
            uLCD.pixel(49, 99, 12365709);
            uLCD.pixel(50, 99, 4339493);
            uLCD.pixel(0, 100, 14789477);
            uLCD.pixel(1, 100, 14723684);
            uLCD.pixel(2, 100, 14592098);
            uLCD.pixel(3, 100, 14591844);
            uLCD.pixel(4, 100, 14657637);
            uLCD.pixel(5, 100, 14592357);
            uLCD.pixel(6, 100, 14460771);
            uLCD.pixel(7, 100, 14394978);
            uLCD.pixel(8, 100, 14723943);
            uLCD.pixel(9, 100, 14394978);
            uLCD.pixel(10, 100, 15183981);
            uLCD.pixel(11, 100, 15250028);
            uLCD.pixel(12, 100, 15315821);
            uLCD.pixel(13, 100, 14789477);
            uLCD.pixel(14, 100, 13604433);
            uLCD.pixel(15, 100, 13999961);
            uLCD.pixel(16, 100, 15842424);
            uLCD.pixel(17, 100, 16302975);
            uLCD.pixel(18, 100, 16237180);
            uLCD.pixel(19, 100, 15644784);
            uLCD.pixel(20, 100, 15841647);
            uLCD.pixel(21, 100, 16630649);
            uLCD.pixel(22, 100, 16762492);
            uLCD.pixel(23, 100, 16432758);
            uLCD.pixel(24, 100, 16432758);
            uLCD.pixel(25, 100, 16498553);
            uLCD.pixel(26, 100, 15445865);
            uLCD.pixel(27, 100, 15116900);
            uLCD.pixel(28, 100, 16366967);
            uLCD.pixel(29, 100, 14722140);
            uLCD.pixel(30, 100, 16762236);
            uLCD.pixel(31, 100, 16498034);
            uLCD.pixel(32, 100, 16694386);
            uLCD.pixel(33, 100, 16760696);
            uLCD.pixel(34, 100, 16037748);
            uLCD.pixel(35, 100, 16499073);
            uLCD.pixel(36, 100, 16698252);
            uLCD.pixel(37, 100, 16172167);
            uLCD.pixel(38, 100, 15909508);
            uLCD.pixel(39, 100, 15645821);
            uLCD.pixel(40, 100, 14066530);
            uLCD.pixel(41, 100, 15973499);
            uLCD.pixel(42, 100, 16565120);
            uLCD.pixel(43, 100, 16630400);
            uLCD.pixel(44, 100, 15906166);
            uLCD.pixel(45, 100, 15444846);
            uLCD.pixel(46, 100, 16431489);
            uLCD.pixel(47, 100, 15711367);
            uLCD.pixel(48, 100, 14138513);
            uLCD.pixel(49, 100, 14997429);
            uLCD.pixel(50, 100, 6116154);
            uLCD.pixel(0, 101, 13999707);
            uLCD.pixel(1, 101, 14065500);
            uLCD.pixel(2, 101, 14131293);
            uLCD.pixel(3, 101, 14131295);
            uLCD.pixel(4, 101, 14066015);
            uLCD.pixel(5, 101, 14131553);
            uLCD.pixel(6, 101, 14066530);
            uLCD.pixel(7, 101, 14132323);
            uLCD.pixel(8, 101, 14132323);
            uLCD.pixel(9, 101, 13671772);
            uLCD.pixel(10, 101, 13999967);
            uLCD.pixel(11, 101, 13868636);
            uLCD.pixel(12, 101, 14197088);
            uLCD.pixel(13, 101, 14131293);
            uLCD.pixel(14, 101, 13210191);
            uLCD.pixel(15, 101, 13736789);
            uLCD.pixel(16, 101, 15513200);
            uLCD.pixel(17, 101, 15644784);
            uLCD.pixel(18, 101, 16039026);
            uLCD.pixel(19, 101, 16367477);
            uLCD.pixel(20, 101, 16499315);
            uLCD.pixel(21, 101, 16433009);
            uLCD.pixel(22, 101, 16300653);
            uLCD.pixel(23, 101, 16169069);
            uLCD.pixel(24, 101, 16169071);
            uLCD.pixel(25, 101, 16761724);
            uLCD.pixel(26, 101, 16497783);
            uLCD.pixel(27, 101, 16497783);
            uLCD.pixel(28, 101, 15906416);
            uLCD.pixel(29, 101, 15380070);
            uLCD.pixel(30, 101, 16498550);
            uLCD.pixel(31, 101, 16235632);
            uLCD.pixel(32, 101, 16168556);
            uLCD.pixel(33, 101, 16761466);
            uLCD.pixel(34, 101, 16366965);
            uLCD.pixel(35, 101, 16038261);
            uLCD.pixel(36, 101, 15907704);
            uLCD.pixel(37, 101, 15842426);
            uLCD.pixel(38, 101, 16171391);
            uLCD.pixel(39, 101, 15841911);
            uLCD.pixel(40, 101, 14196572);
            uLCD.pixel(41, 101, 15315053);
            uLCD.pixel(42, 101, 15446126);
            uLCD.pixel(43, 101, 15446385);
            uLCD.pixel(44, 101, 15117167);
            uLCD.pixel(45, 101, 14723181);
            uLCD.pixel(46, 101, 15183992);
            uLCD.pixel(47, 101, 14199931);
            uLCD.pixel(48, 101, 13810324);
            uLCD.pixel(49, 101, 11246976);
            uLCD.pixel(50, 101, 3484434);
            uLCD.pixel(0, 102, 14328408);
            uLCD.pixel(1, 102, 14459994);
            uLCD.pixel(2, 102, 14460508);
            uLCD.pixel(3, 102, 14394717);
            uLCD.pixel(4, 102, 14197851);
            uLCD.pixel(5, 102, 14131804);
            uLCD.pixel(6, 102, 14132574);
            uLCD.pixel(7, 102, 14264160);
            uLCD.pixel(8, 102, 14132574);
            uLCD.pixel(9, 102, 14264160);
            uLCD.pixel(10, 102, 14592355);
            uLCD.pixel(11, 102, 14132058);
            uLCD.pixel(12, 102, 14197338);
            uLCD.pixel(13, 102, 14131543);
            uLCD.pixel(14, 102, 13802064);
            uLCD.pixel(15, 102, 14459480);
            uLCD.pixel(16, 102, 15116383);
            uLCD.pixel(17, 102, 16234349);
            uLCD.pixel(18, 102, 16761719);
            uLCD.pixel(19, 102, 16761201);
            uLCD.pixel(20, 102, 16563051);
            uLCD.pixel(21, 102, 16628844);
            uLCD.pixel(22, 102, 16761458);
            uLCD.pixel(23, 102, 16761719);
            uLCD.pixel(24, 102, 16497521);
            uLCD.pixel(25, 102, 16761981);
            uLCD.pixel(26, 102, 16431992);
            uLCD.pixel(27, 102, 16169334);
            uLCD.pixel(28, 102, 14393436);
            uLCD.pixel(29, 102, 15907188);
            uLCD.pixel(30, 102, 16367737);
            uLCD.pixel(31, 102, 16433784);
            uLCD.pixel(32, 102, 16696442);
            uLCD.pixel(33, 102, 16367477);
            uLCD.pixel(34, 102, 15315817);
            uLCD.pixel(35, 102, 15316078);
            uLCD.pixel(36, 102, 15053935);
            uLCD.pixel(37, 102, 14528106);
            uLCD.pixel(38, 102, 14594414);
            uLCD.pixel(39, 102, 14462830);
            uLCD.pixel(40, 102, 14134126);
            uLCD.pixel(41, 102, 14068850);
            uLCD.pixel(42, 102, 12885864);
            uLCD.pixel(43, 102, 11965540);
            uLCD.pixel(44, 102, 10914143);
            uLCD.pixel(45, 102, 9665365);
            uLCD.pixel(46, 102, 8745296);
            uLCD.pixel(47, 102, 7364932);
            uLCD.pixel(48, 102, 5391401);
            uLCD.pixel(49, 102, 3089676);
            uLCD.pixel(0, 103, 13935197);
            uLCD.pixel(1, 103, 13935197);
            uLCD.pixel(2, 103, 13869663);
            uLCD.pixel(3, 103, 13869663);
            uLCD.pixel(4, 103, 13672542);
            uLCD.pixel(5, 103, 13672542);
            uLCD.pixel(6, 103, 13541726);
            uLCD.pixel(7, 103, 13541726);
            uLCD.pixel(8, 103, 13607521);
            uLCD.pixel(9, 103, 13804898);
            uLCD.pixel(10, 103, 13804128);
            uLCD.pixel(11, 103, 13540956);
            uLCD.pixel(12, 103, 13935457);
            uLCD.pixel(13, 103, 14132835);
            uLCD.pixel(14, 103, 13934943);
            uLCD.pixel(15, 103, 14263133);
            uLCD.pixel(16, 103, 14195026);
            uLCD.pixel(17, 103, 14983768);
            uLCD.pixel(18, 103, 15773282);
            uLCD.pixel(19, 103, 16431210);
            uLCD.pixel(20, 103, 16760687);
            uLCD.pixel(21, 103, 16760687);
            uLCD.pixel(22, 103, 16497003);
            uLCD.pixel(23, 103, 16102247);
            uLCD.pixel(24, 103, 16234351);
            uLCD.pixel(25, 103, 15905387);
            uLCD.pixel(26, 103, 15379304);
            uLCD.pixel(27, 103, 14656097);
            uLCD.pixel(28, 103, 13209164);
            uLCD.pixel(29, 103, 16104567);
            uLCD.pixel(30, 103, 16302716);
            uLCD.pixel(31, 103, 16039801);
            uLCD.pixel(32, 103, 15843194);
            uLCD.pixel(33, 103, 14988402);
            uLCD.pixel(34, 103, 12489299);
            uLCD.pixel(35, 103, 10253367);
            uLCD.pixel(36, 103, 8873004);
            uLCD.pixel(37, 103, 9202999);
            uLCD.pixel(38, 103, 10321739);
            uLCD.pixel(39, 103, 9993292);
            uLCD.pixel(40, 103, 8809278);
            uLCD.pixel(41, 103, 7231278);
            uLCD.pixel(42, 103, 4535055);
            uLCD.pixel(43, 103, 2298880);
            uLCD.pixel(0, 104, 14397823);
            uLCD.pixel(1, 104, 14200444);
            uLCD.pixel(2, 104, 13937787);
            uLCD.pixel(3, 104, 13937787);
            uLCD.pixel(4, 104, 13872510);
            uLCD.pixel(5, 104, 13872510);
            uLCD.pixel(6, 104, 13675131);
            uLCD.pixel(7, 104, 13477752);
            uLCD.pixel(8, 104, 12885617);
            uLCD.pixel(9, 104, 12951408);
            uLCD.pixel(10, 104, 12622443);
            uLCD.pixel(11, 104, 13017199);
            uLCD.pixel(12, 104, 14135166);
            uLCD.pixel(13, 104, 14398336);
            uLCD.pixel(14, 104, 13871479);
            uLCD.pixel(15, 104, 13475432);
            uLCD.pixel(16, 104, 14460007);
            uLCD.pixel(17, 104, 14195546);
            uLCD.pixel(18, 104, 14261591);
            uLCD.pixel(19, 104, 14984797);
            uLCD.pixel(20, 104, 15050588);
            uLCD.pixel(21, 104, 14655317);
            uLCD.pixel(22, 104, 14786903);
            uLCD.pixel(23, 104, 15379042);
            uLCD.pixel(24, 104, 14918492);
            uLCD.pixel(25, 104, 14391894);
            uLCD.pixel(26, 104, 14918753);
            uLCD.pixel(27, 104, 13669200);
            uLCD.pixel(28, 104, 13208649);
            uLCD.pixel(29, 104, 15775087);
            uLCD.pixel(30, 104, 16367478);
            uLCD.pixel(31, 104, 15776633);
            uLCD.pixel(32, 104, 15845522);
            uLCD.pixel(33, 104, 8741943);
            uLCD.pixel(34, 104, 2229760);
            uLCD.pixel(0, 105, 7821882);
            uLCD.pixel(1, 105, 7163952);
            uLCD.pixel(2, 105, 6374438);
            uLCD.pixel(3, 105, 5519643);
            uLCD.pixel(4, 105, 4861714);
            uLCD.pixel(5, 105, 4072711);
            uLCD.pixel(6, 105, 3217152);
            uLCD.pixel(7, 105, 2625024);
            uLCD.pixel(8, 105, 2559232);
            uLCD.pixel(9, 105, 2756608);
            uLCD.pixel(10, 105, 2296064);
            uLCD.pixel(11, 105, 3151104);
            uLCD.pixel(12, 105, 5190679);
            uLCD.pixel(13, 105, 7887677);
            uLCD.pixel(14, 105, 11111534);
            uLCD.pixel(15, 105, 13412997);
            uLCD.pixel(16, 105, 13870970);
            uLCD.pixel(17, 105, 14461557);
            uLCD.pixel(18, 105, 14263917);
            uLCD.pixel(19, 105, 13737313);
            uLCD.pixel(20, 105, 13999967);
            uLCD.pixel(21, 105, 14657639);
            uLCD.pixel(22, 105, 14525537);
            uLCD.pixel(23, 105, 13735508);
            uLCD.pixel(24, 105, 14458718);
            uLCD.pixel(25, 105, 14129753);
            uLCD.pixel(26, 105, 15050855);
            uLCD.pixel(27, 105, 13603407);
            uLCD.pixel(28, 105, 13734477);
            uLCD.pixel(29, 105, 15181921);
            uLCD.pixel(30, 105, 16498036);
            uLCD.pixel(31, 105, 16630913);
            uLCD.pixel(32, 105, 15449222);
            uLCD.pixel(33, 105, 8871989);
            uLCD.pixel(34, 105, 3544576);
            uLCD.pixel(35, 105, 2625280);
            uLCD.pixel(15, 106, 2890507);
            uLCD.pixel(16, 106, 5059354);
            uLCD.pixel(17, 106, 9532241);
            uLCD.pixel(18, 106, 13281923);
            uLCD.pixel(19, 106, 13807747);
            uLCD.pixel(20, 106, 12951408);
            uLCD.pixel(21, 106, 13082218);
            uLCD.pixel(22, 106, 13804910);
            uLCD.pixel(23, 106, 14132844);
            uLCD.pixel(24, 106, 14460268);
            uLCD.pixel(25, 106, 14328423);
            uLCD.pixel(26, 106, 14853738);
            uLCD.pixel(27, 106, 13932376);
            uLCD.pixel(28, 106, 14195028);
            uLCD.pixel(29, 106, 14721112);
            uLCD.pixel(30, 106, 15904870);
            uLCD.pixel(31, 106, 16694386);
            uLCD.pixel(32, 106, 16760188);
            uLCD.pixel(33, 106, 16762248);
            uLCD.pixel(34, 106, 16630925);
            uLCD.pixel(35, 106, 15317385);
            uLCD.pixel(36, 106, 13345917);
            uLCD.pixel(37, 106, 11571056);
            uLCD.pixel(38, 106, 8217418);
            uLCD.pixel(39, 106, 3152646);
            uLCD.pixel(18, 107, 3416588);
            uLCD.pixel(19, 107, 8613970);
            uLCD.pixel(20, 107, 12757897);
            uLCD.pixel(21, 107, 13743502);
            uLCD.pixel(22, 107, 13413248);
            uLCD.pixel(23, 107, 13346166);
            uLCD.pixel(24, 107, 13410417);
            uLCD.pixel(25, 107, 13672559);
            uLCD.pixel(26, 107, 13802857);
            uLCD.pixel(27, 107, 14131304);
            uLCD.pixel(28, 107, 14590823);
            uLCD.pixel(29, 107, 14327645);
            uLCD.pixel(30, 107, 14195798);
            uLCD.pixel(31, 107, 14523991);
            uLCD.pixel(32, 107, 15246689);
            uLCD.pixel(33, 107, 15641193);
            uLCD.pixel(34, 107, 15906166);
            uLCD.pixel(35, 107, 16038271);
            uLCD.pixel(36, 107, 14921851);
            uLCD.pixel(37, 107, 15317385);
            uLCD.pixel(38, 107, 16239777);
            uLCD.pixel(39, 107, 15188119);
            uLCD.pixel(40, 107, 12359282);
            uLCD.pixel(41, 107, 9530960);
            uLCD.pixel(42, 107, 6505773);
            uLCD.pixel(43, 107, 3151106);
            uLCD.pixel(20, 108, 3221008);
            uLCD.pixel(21, 108, 6575162);
            uLCD.pixel(22, 108, 9929315);
            uLCD.pixel(23, 108, 12099197);
            uLCD.pixel(24, 108, 13215877);
            uLCD.pixel(25, 108, 13741704);
            uLCD.pixel(26, 108, 14200454);
            uLCD.pixel(27, 108, 14068608);
            uLCD.pixel(28, 108, 14331003);
            uLCD.pixel(29, 108, 14659708);
            uLCD.pixel(30, 108, 14724983);
            uLCD.pixel(31, 108, 14396016);
            uLCD.pixel(32, 108, 14659957);
            uLCD.pixel(33, 108, 13936234);
            uLCD.pixel(34, 108, 14922613);
            uLCD.pixel(35, 108, 14856305);
            uLCD.pixel(36, 108, 13144658);
            uLCD.pixel(37, 108, 13539158);
            uLCD.pixel(38, 108, 15249260);
            uLCD.pixel(39, 108, 15051881);
            uLCD.pixel(40, 108, 14723433);
            uLCD.pixel(41, 108, 16765593);
            uLCD.pixel(42, 108, 16042137);
            uLCD.pixel(43, 108, 14531220);
            uLCD.pixel(44, 108, 6178348);
            uLCD.pixel(24, 109, 3416072);
            uLCD.pixel(25, 109, 4994074);
            uLCD.pixel(26, 109, 6769713);
            uLCD.pixel(27, 109, 8282435);
            uLCD.pixel(28, 109, 9466448);
            uLCD.pixel(29, 109, 10255446);
            uLCD.pixel(30, 109, 10189652);
            uLCD.pixel(31, 109, 9532490);
            uLCD.pixel(32, 109, 7757622);
            uLCD.pixel(33, 109, 7100204);
            uLCD.pixel(34, 109, 8677692);
            uLCD.pixel(35, 109, 10781777);
            uLCD.pixel(36, 109, 12227418);
            uLCD.pixel(37, 109, 14002540);
            uLCD.pixel(38, 109, 15119217);
            uLCD.pixel(39, 109, 14394465);
            uLCD.pixel(40, 109, 14131293);
            uLCD.pixel(41, 109, 14790001);
            uLCD.pixel(42, 109, 14594944);
            uLCD.pixel(43, 109, 15123868);
            uLCD.pixel(44, 109, 13087381);
            uLCD.pixel(36, 110, 2629893);
            uLCD.pixel(37, 110, 5785638);
            uLCD.pixel(38, 110, 8481345);
            uLCD.pixel(39, 110, 9729353);
            uLCD.pixel(40, 110, 11110234);
            uLCD.pixel(41, 110, 12163181);
            uLCD.pixel(42, 110, 13217160);
            uLCD.pixel(43, 110, 13745311);
            uLCD.pixel(44, 110, 9668724);
            uLCD.pixel(41, 111, 2824451);
            uLCD.pixel(42, 111, 3812118);
            uLCD.pixel(43, 111, 4076066);
        }

        // Draw right paper
        void drawRightPaper() {
            uLCD.pixel(92, 77, 4404532);
            uLCD.pixel(91, 78, 4339766);
            uLCD.pixel(92, 78, 15917017);
            uLCD.pixel(93, 78, 8876136);
            uLCD.pixel(91, 79, 6115402);
            uLCD.pixel(92, 79, 14403000);
            uLCD.pixel(93, 79, 14533297);
            uLCD.pixel(94, 79, 9860965);
            uLCD.pixel(95, 79, 2426368);
            uLCD.pixel(96, 79, 2492928);
            uLCD.pixel(97, 79, 2428163);
            uLCD.pixel(91, 80, 3483418);
            uLCD.pixel(92, 80, 14928053);
            uLCD.pixel(93, 80, 15518383);
            uLCD.pixel(94, 80, 15386278);
            uLCD.pixel(95, 80, 14267797);
            uLCD.pixel(96, 80, 8676164);
            uLCD.pixel(98, 80, 2099200);
            uLCD.pixel(92, 81, 10980463);
            uLCD.pixel(93, 81, 13807242);
            uLCD.pixel(94, 81, 15121554);
            uLCD.pixel(95, 81, 15253393);
            uLCD.pixel(96, 81, 16504489);
            uLCD.pixel(97, 81, 13281662);
            uLCD.pixel(98, 81, 6506271);
            uLCD.pixel(99, 81, 2033664);
            uLCD.pixel(92, 82, 5716245);
            uLCD.pixel(93, 82, 14201477);
            uLCD.pixel(94, 82, 16042388);
            uLCD.pixel(95, 82, 15252352);
            uLCD.pixel(96, 82, 14727293);
            uLCD.pixel(97, 82, 15123337);
            uLCD.pixel(98, 82, 14730123);
            uLCD.pixel(99, 82, 11112803);
            uLCD.pixel(100, 82, 6639669);
            uLCD.pixel(101, 82, 3876887);
            uLCD.pixel(93, 83, 9400134);
            uLCD.pixel(94, 83, 14004094);
            uLCD.pixel(95, 83, 15188103);
            uLCD.pixel(96, 83, 13280358);
            uLCD.pixel(97, 83, 13939055);
            uLCD.pixel(98, 83, 15650186);
            uLCD.pixel(99, 83, 15519378);
            uLCD.pixel(100, 83, 15321506);
            uLCD.pixel(101, 83, 14138012);
            uLCD.pixel(102, 83, 13085839);
            uLCD.pixel(103, 83, 10718065);
            uLCD.pixel(104, 83, 5982515);
            uLCD.pixel(78, 84, 5720117);
            uLCD.pixel(79, 84, 14864051);
            uLCD.pixel(80, 84, 13415827);
            uLCD.pixel(81, 84, 11836275);
            uLCD.pixel(82, 84, 8874558);
            uLCD.pixel(83, 84, 4993549);
            uLCD.pixel(84, 84, 2298624);
            uLCD.pixel(94, 84, 9205592);
            uLCD.pixel(95, 84, 13348743);
            uLCD.pixel(96, 84, 12689515);
            uLCD.pixel(97, 84, 15319940);
            uLCD.pixel(98, 84, 14990452);
            uLCD.pixel(99, 84, 15186804);
            uLCD.pixel(100, 84, 15843202);
            uLCD.pixel(101, 84, 16632467);
            uLCD.pixel(102, 84, 16107665);
            uLCD.pixel(103, 84, 15911062);
            uLCD.pixel(104, 84, 15714974);
            uLCD.pixel(105, 84, 10979685);
            uLCD.pixel(106, 84, 2493952);
            uLCD.pixel(78, 85, 12823439);
            uLCD.pixel(79, 85, 14071954);
            uLCD.pixel(80, 85, 15255192);
            uLCD.pixel(81, 85, 16503711);
            uLCD.pixel(82, 85, 15647882);
            uLCD.pixel(83, 85, 15582352);
            uLCD.pixel(84, 85, 13938828);
            uLCD.pixel(85, 85, 11901050);
            uLCD.pixel(86, 85, 9401944);
            uLCD.pixel(87, 85, 5587492);
            uLCD.pixel(88, 85, 2233856);
            uLCD.pixel(94, 85, 2364420);
            uLCD.pixel(95, 85, 4599316);
            uLCD.pixel(96, 85, 10058066);
            uLCD.pixel(97, 85, 13872762);
            uLCD.pixel(98, 85, 16634260);
            uLCD.pixel(99, 85, 16303745);
            uLCD.pixel(100, 85, 16696191);
            uLCD.pixel(101, 85, 15642476);
            uLCD.pixel(102, 85, 15907190);
            uLCD.pixel(103, 85, 15513976);
            uLCD.pixel(104, 85, 15975818);
            uLCD.pixel(105, 85, 16768426);
            uLCD.pixel(106, 85, 12097136);
            uLCD.pixel(107, 85, 2427392);
            uLCD.pixel(78, 86, 11769462);
            uLCD.pixel(79, 86, 14925974);
            uLCD.pixel(80, 86, 14397823);
            uLCD.pixel(81, 86, 15317636);
            uLCD.pixel(82, 86, 15974277);
            uLCD.pixel(83, 86, 15710078);
            uLCD.pixel(84, 86, 16498060);
            uLCD.pixel(85, 86, 16169356);
            uLCD.pixel(86, 86, 16434328);
            uLCD.pixel(87, 86, 15909530);
            uLCD.pixel(88, 86, 13544072);
            uLCD.pixel(89, 86, 9203284);
            uLCD.pixel(90, 86, 4139543);
            uLCD.pixel(91, 86, 2035204);
            uLCD.pixel(96, 86, 2294272);
            uLCD.pixel(97, 86, 6964520);
            uLCD.pixel(98, 86, 12226666);
            uLCD.pixel(99, 86, 15382663);
            uLCD.pixel(100, 86, 16695429);
            uLCD.pixel(101, 86, 16168307);
            uLCD.pixel(102, 86, 16763013);
            uLCD.pixel(103, 86, 16630913);
            uLCD.pixel(104, 86, 15250804);
            uLCD.pixel(105, 86, 14989435);
            uLCD.pixel(106, 86, 15846298);
            uLCD.pixel(107, 86, 12229235);
            uLCD.pixel(108, 86, 2559232);
            uLCD.pixel(78, 87, 4270090);
            uLCD.pixel(79, 87, 11176548);
            uLCD.pixel(80, 87, 13741186);
            uLCD.pixel(81, 87, 14594950);
            uLCD.pixel(82, 87, 13804659);
            uLCD.pixel(83, 87, 14197615);
            uLCD.pixel(84, 87, 15905147);
            uLCD.pixel(85, 87, 16761740);
            uLCD.pixel(86, 87, 16563591);
            uLCD.pixel(87, 87, 14459758);
            uLCD.pixel(88, 87, 15382408);
            uLCD.pixel(89, 87, 16767150);
            uLCD.pixel(90, 87, 15319713);
            uLCD.pixel(91, 87, 12820872);
            uLCD.pixel(92, 87, 9268315);
            uLCD.pixel(93, 87, 6768442);
            uLCD.pixel(94, 87, 4465176);
            uLCD.pixel(95, 87, 3675142);
            uLCD.pixel(96, 87, 3148288);
            uLCD.pixel(97, 87, 2884608);
            uLCD.pixel(98, 87, 2686976);
            uLCD.pixel(99, 87, 9132591);
            uLCD.pixel(100, 87, 15247985);
            uLCD.pixel(101, 87, 16496245);
            uLCD.pixel(102, 87, 16760699);
            uLCD.pixel(103, 87, 16235379);
            uLCD.pixel(104, 87, 16368507);
            uLCD.pixel(105, 87, 15711865);
            uLCD.pixel(106, 87, 15582342);
            uLCD.pixel(107, 87, 15254672);
            uLCD.pixel(108, 87, 11966833);
            uLCD.pixel(110, 87, 2627333);
            uLCD.pixel(80, 88, 4007695);
            uLCD.pixel(81, 88, 7954246);
            uLCD.pixel(82, 88, 11308660);
            uLCD.pixel(83, 88, 13741964);
            uLCD.pixel(84, 88, 14660737);
            uLCD.pixel(85, 88, 15251578);
            uLCD.pixel(86, 88, 15053684);
            uLCD.pixel(87, 88, 14132836);
            uLCD.pixel(88, 88, 14724460);
            uLCD.pixel(89, 88, 15513976);
            uLCD.pixel(90, 88, 15513724);
            uLCD.pixel(91, 88, 16369036);
            uLCD.pixel(92, 88, 16434325);
            uLCD.pixel(93, 88, 15316104);
            uLCD.pixel(94, 88, 16764840);
            uLCD.pixel(95, 88, 14066815);
            uLCD.pixel(96, 88, 12225124);
            uLCD.pixel(97, 88, 12225894);
            uLCD.pixel(98, 88, 13476472);
            uLCD.pixel(99, 88, 14198134);
            uLCD.pixel(100, 88, 13470804);
            uLCD.pixel(101, 88, 14521942);
            uLCD.pixel(102, 88, 16627827);
            uLCD.pixel(103, 88, 16761207);
            uLCD.pixel(104, 88, 15972458);
            uLCD.pixel(105, 88, 16696953);
            uLCD.pixel(106, 88, 15646324);
            uLCD.pixel(107, 88, 15844994);
            uLCD.pixel(108, 88, 16570272);
            uLCD.pixel(109, 88, 12295280);
            uLCD.pixel(110, 88, 4336396);
            uLCD.pixel(83, 89, 4666139);
            uLCD.pixel(84, 89, 9402187);
            uLCD.pixel(85, 89, 11637597);
            uLCD.pixel(86, 89, 13545075);
            uLCD.pixel(87, 89, 13806442);
            uLCD.pixel(88, 89, 14594413);
            uLCD.pixel(89, 89, 16105848);
            uLCD.pixel(90, 89, 16433271);
            uLCD.pixel(91, 89, 16695160);
            uLCD.pixel(92, 89, 16761470);
            uLCD.pixel(93, 89, 16760446);
            uLCD.pixel(94, 89, 15970936);
            uLCD.pixel(95, 89, 16695691);
            uLCD.pixel(96, 89, 16763543);
            uLCD.pixel(97, 89, 15513734);
            uLCD.pixel(98, 89, 15777935);
            uLCD.pixel(99, 89, 16237198);
            uLCD.pixel(100, 89, 15904884);
            uLCD.pixel(101, 89, 14192975);
            uLCD.pixel(102, 89, 15378015);
            uLCD.pixel(103, 89, 16760434);
            uLCD.pixel(104, 89, 16234600);
            uLCD.pixel(105, 89, 16762996);
            uLCD.pixel(106, 89, 15644517);
            uLCD.pixel(107, 89, 16632959);
            uLCD.pixel(108, 89, 14660720);
            uLCD.pixel(109, 89, 15846803);
            uLCD.pixel(110, 89, 13808519);
            uLCD.pixel(111, 89, 4533261);
            uLCD.pixel(86, 90, 5983777);
            uLCD.pixel(87, 90, 10718809);
            uLCD.pixel(88, 90, 13676145);
            uLCD.pixel(89, 90, 14792306);
            uLCD.pixel(90, 90, 15052647);
            uLCD.pixel(91, 90, 15971692);
            uLCD.pixel(92, 90, 16628593);
            uLCD.pixel(93, 90, 16759410);
            uLCD.pixel(94, 90, 15640932);
            uLCD.pixel(95, 90, 16762501);
            uLCD.pixel(96, 90, 16102775);
            uLCD.pixel(97, 90, 16564356);
            uLCD.pixel(98, 90, 16763278);
            uLCD.pixel(99, 90, 16169855);
            uLCD.pixel(100, 90, 16036980);
            uLCD.pixel(101, 90, 16496754);
            uLCD.pixel(102, 90, 16761207);
            uLCD.pixel(103, 90, 16629359);
            uLCD.pixel(104, 90, 16760685);
            uLCD.pixel(105, 90, 16761967);
            uLCD.pixel(106, 90, 15906916);
            uLCD.pixel(107, 90, 16302447);
            uLCD.pixel(108, 90, 16172409);
            uLCD.pixel(109, 90, 15252346);
            uLCD.pixel(110, 90, 16438172);
            uLCD.pixel(111, 90, 13742213);
            uLCD.pixel(112, 90, 3282176);
            uLCD.pixel(123, 90, 2494464);
            uLCD.pixel(124, 90, 4796442);
            uLCD.pixel(125, 90, 5980971);
            uLCD.pixel(126, 90, 7756869);
            uLCD.pixel(127, 90, 9072727);
            uLCD.pixel(76, 91, 9999232);
            uLCD.pixel(77, 91, 9406320);
            uLCD.pixel(78, 91, 10194805);
            uLCD.pixel(79, 91, 8220241);
            uLCD.pixel(80, 91, 7034684);
            uLCD.pixel(81, 91, 5915946);
            uLCD.pixel(82, 91, 5323041);
            uLCD.pixel(83, 91, 5126687);
            uLCD.pixel(84, 91, 4207895);
            uLCD.pixel(85, 91, 2498048);
            uLCD.pixel(88, 91, 3610880);
            uLCD.pixel(89, 91, 7885332);
            uLCD.pixel(90, 91, 11698752);
            uLCD.pixel(91, 91, 13737046);
            uLCD.pixel(92, 91, 16564344);
            uLCD.pixel(93, 91, 16432243);
            uLCD.pixel(94, 91, 16760952);
            uLCD.pixel(95, 91, 16036972);
            uLCD.pixel(96, 91, 16761210);
            uLCD.pixel(97, 91, 16103025);
            uLCD.pixel(98, 91, 15642990);
            uLCD.pixel(99, 91, 16761471);
            uLCD.pixel(100, 91, 16695932);
            uLCD.pixel(101, 91, 16366965);
            uLCD.pixel(102, 91, 16629620);
            uLCD.pixel(103, 91, 16498032);
            uLCD.pixel(104, 91, 16761715);
            uLCD.pixel(105, 91, 16366440);
            uLCD.pixel(106, 91, 16762226);
            uLCD.pixel(107, 91, 16300907);
            uLCD.pixel(108, 91, 16630903);
            uLCD.pixel(109, 91, 15908215);
            uLCD.pixel(110, 91, 14856820);
            uLCD.pixel(111, 91, 16042386);
            uLCD.pixel(112, 91, 12819822);
            uLCD.pixel(113, 91, 10847323);
            uLCD.pixel(114, 91, 10255962);
            uLCD.pixel(115, 91, 9993049);
            uLCD.pixel(116, 91, 9400651);
            uLCD.pixel(117, 91, 9927250);
            uLCD.pixel(118, 91, 10650973);
            uLCD.pixel(119, 91, 11439719);
            uLCD.pixel(120, 91, 11900268);
            uLCD.pixel(121, 91, 12426612);
            uLCD.pixel(122, 91, 13413248);
            uLCD.pixel(123, 91, 14268557);
            uLCD.pixel(124, 91, 14860435);
            uLCD.pixel(125, 91, 15320986);
            uLCD.pixel(126, 91, 15978145);
            uLCD.pixel(127, 91, 16175524);
            uLCD.pixel(75, 92, 7364940);
            uLCD.pixel(76, 92, 15522233);
            uLCD.pixel(77, 92, 14534301);
            uLCD.pixel(78, 92, 15387549);
            uLCD.pixel(79, 92, 15846811);
            uLCD.pixel(80, 92, 15647632);
            uLCD.pixel(81, 92, 16107154);
            uLCD.pixel(82, 92, 16106384);
            uLCD.pixel(83, 92, 15448970);
            uLCD.pixel(84, 92, 16241569);
            uLCD.pixel(85, 92, 14597773);
            uLCD.pixel(86, 92, 13874050);
            uLCD.pixel(87, 92, 10518605);
            uLCD.pixel(88, 92, 5386752);
            uLCD.pixel(89, 92, 3017984);
            uLCD.pixel(90, 92, 2293760);
            uLCD.pixel(91, 92, 2884864);
            uLCD.pixel(92, 92, 9265959);
            uLCD.pixel(93, 92, 15712897);
            uLCD.pixel(94, 92, 15909246);
            uLCD.pixel(95, 92, 15842163);
            uLCD.pixel(96, 92, 16763007);
            uLCD.pixel(97, 92, 16169839);
            uLCD.pixel(98, 92, 15313501);
            uLCD.pixel(99, 92, 16761718);
            uLCD.pixel(100, 92, 16104816);
            uLCD.pixel(101, 92, 16171381);
            uLCD.pixel(102, 92, 16039025);
            uLCD.pixel(103, 92, 16038253);
            uLCD.pixel(104, 92, 16563827);
            uLCD.pixel(105, 92, 16760947);
            uLCD.pixel(106, 92, 16563568);
            uLCD.pixel(107, 92, 16497775);
            uLCD.pixel(108, 92, 16629109);
            uLCD.pixel(109, 92, 16301172);
            uLCD.pixel(110, 92, 15907190);
            uLCD.pixel(111, 92, 15579769);
            uLCD.pixel(112, 92, 16040840);
            uLCD.pixel(113, 92, 16436628);
            uLCD.pixel(114, 92, 15779729);
            uLCD.pixel(115, 92, 15911826);
            uLCD.pixel(116, 92, 15845772);
            uLCD.pixel(117, 92, 15846025);
            uLCD.pixel(118, 92, 15846025);
            uLCD.pixel(119, 92, 15911303);
            uLCD.pixel(120, 92, 15911303);
            uLCD.pixel(121, 92, 15779717);
            uLCD.pixel(122, 92, 15844994);
            uLCD.pixel(123, 92, 15844994);
            uLCD.pixel(124, 92, 15515515);
            uLCD.pixel(125, 92, 15515515);
            uLCD.pixel(126, 92, 15646585);
            uLCD.pixel(127, 92, 15646585);
            uLCD.pixel(75, 93, 8745305);
            uLCD.pixel(76, 93, 15125673);
            uLCD.pixel(77, 93, 14465934);
            uLCD.pixel(78, 93, 15451023);
            uLCD.pixel(79, 93, 14923130);
            uLCD.pixel(80, 93, 14790255);
            uLCD.pixel(81, 93, 16301695);
            uLCD.pixel(82, 93, 16498303);
            uLCD.pixel(83, 93, 16695940);
            uLCD.pixel(84, 93, 15184759);
            uLCD.pixel(85, 93, 14527602);
            uLCD.pixel(86, 93, 15976079);
            uLCD.pixel(87, 93, 15384973);
            uLCD.pixel(88, 93, 15187852);
            uLCD.pixel(89, 93, 13938814);
            uLCD.pixel(90, 93, 11373657);
            uLCD.pixel(91, 93, 8346407);
            uLCD.pixel(92, 93, 9333296);
            uLCD.pixel(93, 93, 15385220);
            uLCD.pixel(94, 93, 15910786);
            uLCD.pixel(95, 93, 16106875);
            uLCD.pixel(96, 93, 15381093);
            uLCD.pixel(97, 93, 16762229);
            uLCD.pixel(98, 93, 13799745);
            uLCD.pixel(99, 93, 14721361);
            uLCD.pixel(100, 93, 16105584);
            uLCD.pixel(101, 93, 16106613);
            uLCD.pixel(102, 93, 16500346);
            uLCD.pixel(103, 93, 16762749);
            uLCD.pixel(104, 93, 16695930);
            uLCD.pixel(105, 93, 16168816);
            uLCD.pixel(106, 93, 16168559);
            uLCD.pixel(107, 93, 16761467);
            uLCD.pixel(108, 93, 16761210);
            uLCD.pixel(109, 93, 16761466);
            uLCD.pixel(110, 93, 16695160);
            uLCD.pixel(111, 93, 16301685);
            uLCD.pixel(112, 93, 16433530);
            uLCD.pixel(113, 93, 16302973);
            uLCD.pixel(114, 93, 15843194);
            uLCD.pixel(115, 93, 15908987);
            uLCD.pixel(116, 93, 15843190);
            uLCD.pixel(117, 93, 15843443);
            uLCD.pixel(118, 93, 15909236);
            uLCD.pixel(119, 93, 15909236);
            uLCD.pixel(120, 93, 16040052);
            uLCD.pixel(121, 93, 15974513);
            uLCD.pixel(122, 93, 16039793);
            uLCD.pixel(123, 93, 15974000);
            uLCD.pixel(124, 93, 16236656);
            uLCD.pixel(125, 93, 16236656);
            uLCD.pixel(126, 93, 16301934);
            uLCD.pixel(127, 93, 16301934);
            uLCD.pixel(75, 94, 6179126);
            uLCD.pixel(76, 94, 11441013);
            uLCD.pixel(77, 94, 12689784);
            uLCD.pixel(78, 94, 14859916);
            uLCD.pixel(79, 94, 14134389);
            uLCD.pixel(80, 94, 13606499);
            uLCD.pixel(81, 94, 14197864);
            uLCD.pixel(82, 94, 13867870);
            uLCD.pixel(83, 94, 14591077);
            uLCD.pixel(84, 94, 15445873);
            uLCD.pixel(85, 94, 14261858);
            uLCD.pixel(86, 94, 15841921);
            uLCD.pixel(87, 94, 15579779);
            uLCD.pixel(88, 94, 16501142);
            uLCD.pixel(89, 94, 15778448);
            uLCD.pixel(90, 94, 16437146);
            uLCD.pixel(91, 94, 16042899);
            uLCD.pixel(92, 94, 16042893);
            uLCD.pixel(93, 94, 15187064);
            uLCD.pixel(94, 94, 16304767);
            uLCD.pixel(95, 94, 16632443);
            uLCD.pixel(96, 94, 16170861);
            uLCD.pixel(97, 94, 16695664);
            uLCD.pixel(98, 94, 14062915);
            uLCD.pixel(99, 94, 14590286);
            uLCD.pixel(100, 94, 14527063);
            uLCD.pixel(101, 94, 15580782);
            uLCD.pixel(102, 94, 16040823);
            uLCD.pixel(103, 94, 15907956);
            uLCD.pixel(104, 94, 16367228);
            uLCD.pixel(105, 94, 16761987);
            uLCD.pixel(106, 94, 16761217);
            uLCD.pixel(107, 94, 16759931);
            uLCD.pixel(108, 94, 16167789);
            uLCD.pixel(109, 94, 16233581);
            uLCD.pixel(110, 94, 16431214);
            uLCD.pixel(111, 94, 16366189);
            uLCD.pixel(112, 94, 16498032);
            uLCD.pixel(113, 94, 16432239);
            uLCD.pixel(114, 94, 16433011);
            uLCD.pixel(115, 94, 16498804);
            uLCD.pixel(116, 94, 16169839);
            uLCD.pixel(117, 94, 16235632);
            uLCD.pixel(118, 94, 16235632);
            uLCD.pixel(119, 94, 16301425);
            uLCD.pixel(120, 94, 16432241);
            uLCD.pixel(121, 94, 16432241);
            uLCD.pixel(122, 94, 16432241);
            uLCD.pixel(123, 94, 16432239);
            uLCD.pixel(124, 94, 16629361);
            uLCD.pixel(125, 94, 16629361);
            uLCD.pixel(126, 94, 16760177);
            uLCD.pixel(127, 94, 16760177);
            uLCD.pixel(76, 95, 3087107);
            uLCD.pixel(77, 95, 4993812);
            uLCD.pixel(78, 95, 7361580);
            uLCD.pixel(79, 95, 9399873);
            uLCD.pixel(80, 95, 11701852);
            uLCD.pixel(81, 95, 13543027);
            uLCD.pixel(82, 95, 14069113);
            uLCD.pixel(83, 95, 14659708);
            uLCD.pixel(84, 95, 13737064);
            uLCD.pixel(85, 95, 12880474);
            uLCD.pixel(86, 95, 14262642);
            uLCD.pixel(87, 95, 14921087);
            uLCD.pixel(88, 95, 15842702);
            uLCD.pixel(89, 95, 14790014);
            uLCD.pixel(90, 95, 15382148);
            uLCD.pixel(91, 95, 15448191);
            uLCD.pixel(92, 95, 15645821);
            uLCD.pixel(93, 95, 16106366);
            uLCD.pixel(94, 95, 16697470);
            uLCD.pixel(95, 95, 15249507);
            uLCD.pixel(96, 95, 16761974);
            uLCD.pixel(97, 95, 16563825);
            uLCD.pixel(98, 95, 13997641);
            uLCD.pixel(99, 95, 14984793);
            uLCD.pixel(100, 95, 12816447);
            uLCD.pixel(101, 95, 14988132);
            uLCD.pixel(102, 95, 16303995);
            uLCD.pixel(103, 95, 16105337);
            uLCD.pixel(104, 95, 16038522);
            uLCD.pixel(105, 95, 16300669);
            uLCD.pixel(106, 95, 16365947);
            uLCD.pixel(107, 95, 16168309);
            uLCD.pixel(108, 95, 16760442);
            uLCD.pixel(109, 95, 16760182);
            uLCD.pixel(110, 95, 16760948);
            uLCD.pixel(111, 95, 16760687);
            uLCD.pixel(112, 95, 16760687);
            uLCD.pixel(113, 95, 16299879);
            uLCD.pixel(114, 95, 16760945);
            uLCD.pixel(115, 95, 16563568);
            uLCD.pixel(116, 95, 16629109);
            uLCD.pixel(117, 95, 16629109);
            uLCD.pixel(118, 95, 16629110);
            uLCD.pixel(119, 95, 16629109);
            uLCD.pixel(120, 95, 16759926);
            uLCD.pixel(121, 95, 16759925);
            uLCD.pixel(122, 95, 16759925);
            uLCD.pixel(123, 95, 16759925);
            uLCD.pixel(124, 95, 16759668);
            uLCD.pixel(125, 95, 16759668);
            uLCD.pixel(126, 95, 16759668);
            uLCD.pixel(127, 95, 16759668);
            uLCD.pixel(81, 96, 3021312);
            uLCD.pixel(82, 96, 7033908);
            uLCD.pixel(83, 96, 9730649);
            uLCD.pixel(84, 96, 11570030);
            uLCD.pixel(85, 96, 12884093);
            uLCD.pixel(86, 96, 13870475);
            uLCD.pixel(87, 96, 14198665);
            uLCD.pixel(88, 96, 14263428);
            uLCD.pixel(89, 96, 14591617);
            uLCD.pixel(90, 96, 15380355);
            uLCD.pixel(91, 96, 15577210);
            uLCD.pixel(92, 96, 16432255);
            uLCD.pixel(93, 96, 16497785);
            uLCD.pixel(94, 96, 15905387);
            uLCD.pixel(95, 96, 16760953);
            uLCD.pixel(96, 96, 15576168);
            uLCD.pixel(97, 96, 16563324);
            uLCD.pixel(98, 96, 15115881);
            uLCD.pixel(99, 96, 14129755);
            uLCD.pixel(100, 96, 13999443);
            uLCD.pixel(101, 96, 13737040);
            uLCD.pixel(102, 96, 14131545);
            uLCD.pixel(103, 96, 15644018);
            uLCD.pixel(104, 96, 16761989);
            uLCD.pixel(105, 96, 16564354);
            uLCD.pixel(106, 96, 16169338);
            uLCD.pixel(107, 96, 16498299);
            uLCD.pixel(108, 96, 16761467);
            uLCD.pixel(109, 96, 16563827);
            uLCD.pixel(110, 96, 16695152);
            uLCD.pixel(111, 96, 16497772);
            uLCD.pixel(112, 96, 16431980);
            uLCD.pixel(113, 96, 15576673);
            uLCD.pixel(114, 96, 16760693);
            uLCD.pixel(115, 96, 16430961);
            uLCD.pixel(116, 96, 16759931);
            uLCD.pixel(117, 96, 16759931);
            uLCD.pixel(118, 96, 16759676);
            uLCD.pixel(119, 96, 16759674);
            uLCD.pixel(120, 96, 16693883);
            uLCD.pixel(121, 96, 16693883);
            uLCD.pixel(122, 96, 16628090);
            uLCD.pixel(123, 96, 16628090);
            uLCD.pixel(124, 96, 16628090);
            uLCD.pixel(125, 96, 16628090);
            uLCD.pixel(126, 96, 16628092);
            uLCD.pixel(127, 96, 16628092);
            uLCD.pixel(84, 97, 2032384);
            uLCD.pixel(85, 97, 3346688);
            uLCD.pixel(86, 97, 4661768);
            uLCD.pixel(87, 97, 8147767);
            uLCD.pixel(88, 97, 11435359);
            uLCD.pixel(89, 97, 13276785);
            uLCD.pixel(90, 97, 13603944);
            uLCD.pixel(91, 97, 12748111);
            uLCD.pixel(92, 97, 15971959);
            uLCD.pixel(93, 97, 16168818);
            uLCD.pixel(94, 97, 16102765);
            uLCD.pixel(95, 97, 16763009);
            uLCD.pixel(96, 97, 15905648);
            uLCD.pixel(97, 97, 14984809);
            uLCD.pixel(98, 97, 15642489);
            uLCD.pixel(99, 97, 14458726);
            uLCD.pixel(100, 97, 15906673);
            uLCD.pixel(101, 97, 14591066);
            uLCD.pixel(102, 97, 13274953);
            uLCD.pixel(103, 97, 13735508);
            uLCD.pixel(104, 97, 15380079);
            uLCD.pixel(105, 97, 16235388);
            uLCD.pixel(106, 97, 16564607);
            uLCD.pixel(107, 97, 16763010);
            uLCD.pixel(108, 97, 16236145);
            uLCD.pixel(109, 97, 15907176);
            uLCD.pixel(110, 97, 16235628);
            uLCD.pixel(111, 97, 16104042);
            uLCD.pixel(112, 97, 16103276);
            uLCD.pixel(113, 97, 14984285);
            uLCD.pixel(114, 97, 16760958);
            uLCD.pixel(115, 97, 16431479);
            uLCD.pixel(116, 97, 16759931);
            uLCD.pixel(117, 97, 16694649);
            uLCD.pixel(118, 97, 16628856);
            uLCD.pixel(119, 97, 16563063);
            uLCD.pixel(120, 97, 16497270);
            uLCD.pixel(121, 97, 16497272);
            uLCD.pixel(122, 97, 16497272);
            uLCD.pixel(123, 97, 16497274);
            uLCD.pixel(124, 97, 16628860);
            uLCD.pixel(125, 97, 16628860);
            uLCD.pixel(126, 97, 16628606);
            uLCD.pixel(127, 97, 16628606);
            uLCD.pixel(78, 98, 3548697);
            uLCD.pixel(79, 98, 4337951);
            uLCD.pixel(80, 98, 4007955);
            uLCD.pixel(81, 98, 3876109);
            uLCD.pixel(82, 98, 3283456);
            uLCD.pixel(83, 98, 2954240);
            uLCD.pixel(84, 98, 2821888);
            uLCD.pixel(85, 98, 3611136);
            uLCD.pixel(86, 98, 4268032);
            uLCD.pixel(87, 98, 5057026);
            uLCD.pixel(88, 98, 5516548);
            uLCD.pixel(89, 98, 4068096);
            uLCD.pixel(90, 98, 4067328);
            uLCD.pixel(91, 98, 3803392);
            uLCD.pixel(92, 98, 8935188);
            uLCD.pixel(93, 98, 16434811);
            uLCD.pixel(94, 98, 16765572);
            uLCD.pixel(95, 98, 14658140);
            uLCD.pixel(96, 98, 16631677);
            uLCD.pixel(97, 98, 14591330);
            uLCD.pixel(98, 98, 14261858);
            uLCD.pixel(99, 98, 14787943);
            uLCD.pixel(100, 98, 15905646);
            uLCD.pixel(101, 98, 16761467);
            uLCD.pixel(102, 98, 16497785);
            uLCD.pixel(103, 98, 14786913);
            uLCD.pixel(104, 98, 13800788);
            uLCD.pixel(105, 98, 14196059);
            uLCD.pixel(106, 98, 15182950);
            uLCD.pixel(107, 98, 15973232);
            uLCD.pixel(108, 98, 16565619);
            uLCD.pixel(109, 98, 16434032);
            uLCD.pixel(110, 98, 16763511);
            uLCD.pixel(111, 98, 16696694);
            uLCD.pixel(112, 98, 16038000);
            uLCD.pixel(113, 98, 14261339);
            uLCD.pixel(114, 98, 16760454);
            uLCD.pixel(115, 98, 16300155);
            uLCD.pixel(116, 98, 16760695);
            uLCD.pixel(117, 98, 16629872);
            uLCD.pixel(118, 98, 16564079);
            uLCD.pixel(119, 98, 16498286);
            uLCD.pixel(120, 98, 16498286);
            uLCD.pixel(121, 98, 16498032);
            uLCD.pixel(122, 98, 16563825);
            uLCD.pixel(123, 98, 16563827);
            uLCD.pixel(124, 98, 16433011);
            uLCD.pixel(125, 98, 16433011);
            uLCD.pixel(126, 98, 16432757);
            uLCD.pixel(127, 98, 16432757);
            uLCD.pixel(77, 99, 4403754);
            uLCD.pixel(78, 99, 12495002);
            uLCD.pixel(79, 99, 14928564);
            uLCD.pixel(80, 99, 14730666);
            uLCD.pixel(81, 99, 15453872);
            uLCD.pixel(82, 99, 13742225);
            uLCD.pixel(83, 99, 13741961);
            uLCD.pixel(84, 99, 13479033);
            uLCD.pixel(85, 99, 15123341);
            uLCD.pixel(86, 99, 15715223);
            uLCD.pixel(87, 99, 14662278);
            uLCD.pixel(88, 99, 15253645);
            uLCD.pixel(89, 99, 13476976);
            uLCD.pixel(90, 99, 13081955);
            uLCD.pixel(91, 99, 10976060);
            uLCD.pixel(92, 99, 12028740);
            uLCD.pixel(93, 99, 15777908);
            uLCD.pixel(94, 99, 16238201);
            uLCD.pixel(95, 99, 16172406);
            uLCD.pixel(96, 99, 16040306);
            uLCD.pixel(97, 99, 16237432);
            uLCD.pixel(98, 99, 15315821);
            uLCD.pixel(99, 99, 13736019);
            uLCD.pixel(100, 99, 14787165);
            uLCD.pixel(101, 99, 15971180);
            uLCD.pixel(102, 99, 16760442);
            uLCD.pixel(103, 99, 16761214);
            uLCD.pixel(104, 99, 16563576);
            uLCD.pixel(105, 99, 15511656);
            uLCD.pixel(106, 99, 14459480);
            uLCD.pixel(107, 99, 14130767);
            uLCD.pixel(108, 99, 15052379);
            uLCD.pixel(109, 99, 15315551);
            uLCD.pixel(110, 99, 16433520);
            uLCD.pixel(111, 99, 16301938);
            uLCD.pixel(112, 99, 15577708);
            uLCD.pixel(113, 99, 13735254);
            uLCD.pixel(114, 99, 16695177);
            uLCD.pixel(115, 99, 16432257);
            uLCD.pixel(116, 99, 16432758);
            uLCD.pixel(117, 99, 16367727);
            uLCD.pixel(118, 99, 16301934);
            uLCD.pixel(119, 99, 16301934);
            uLCD.pixel(120, 99, 16301936);
            uLCD.pixel(121, 99, 16367729);
            uLCD.pixel(122, 99, 16433524);
            uLCD.pixel(123, 99, 16433524);
            uLCD.pixel(124, 99, 16302195);
            uLCD.pixel(125, 99, 16302195);
            uLCD.pixel(126, 99, 16302197);
            uLCD.pixel(127, 99, 16302197);
            uLCD.pixel(77, 100, 6442816);
            uLCD.pixel(78, 100, 15520188);
            uLCD.pixel(79, 100, 14861222);
            uLCD.pixel(80, 100, 14728344);
            uLCD.pixel(81, 100, 14924947);
            uLCD.pixel(82, 100, 14726538);
            uLCD.pixel(83, 100, 14726275);
            uLCD.pixel(84, 100, 15975564);
            uLCD.pixel(85, 100, 16238219);
            uLCD.pixel(86, 100, 15711875);
            uLCD.pixel(87, 100, 13935465);
            uLCD.pixel(88, 100, 15580290);
            uLCD.pixel(89, 100, 16303755);
            uLCD.pixel(90, 100, 16237960);
            uLCD.pixel(91, 100, 16369798);
            uLCD.pixel(92, 100, 15843194);
            uLCD.pixel(93, 100, 15908983);
            uLCD.pixel(94, 100, 16303225);
            uLCD.pixel(95, 100, 15645548);
            uLCD.pixel(96, 100, 16303476);
            uLCD.pixel(97, 100, 16566646);
            uLCD.pixel(98, 100, 13605961);
            uLCD.pixel(99, 100, 16500342);
            uLCD.pixel(100, 100, 15314789);
            uLCD.pixel(101, 100, 15182691);
            uLCD.pixel(102, 100, 16564343);
            uLCD.pixel(103, 100, 16629622);
            uLCD.pixel(104, 100, 16300655);
            uLCD.pixel(105, 100, 16762232);
            uLCD.pixel(106, 100, 16629872);
            uLCD.pixel(107, 100, 16235114);
            uLCD.pixel(108, 100, 15774563);
            uLCD.pixel(109, 100, 16762229);
            uLCD.pixel(110, 100, 16696181);
            uLCD.pixel(111, 100, 15511655);
            uLCD.pixel(112, 100, 14459227);
            uLCD.pixel(113, 100, 13867094);
            uLCD.pixel(114, 100, 14327392);
            uLCD.pixel(115, 100, 15709558);
            uLCD.pixel(116, 100, 15381362);
            uLCD.pixel(117, 100, 15052908);
            uLCD.pixel(118, 100, 14723943);
            uLCD.pixel(119, 100, 14526564);
            uLCD.pixel(120, 100, 14526564);
            uLCD.pixel(121, 100, 14592357);
            uLCD.pixel(122, 100, 14658150);
            uLCD.pixel(123, 100, 14658150);
            uLCD.pixel(124, 100, 14460258);
            uLCD.pixel(125, 100, 14591844);
            uLCD.pixel(126, 100, 14789223);
            uLCD.pixel(127, 100, 14855016);
            uLCD.pixel(77, 101, 4074781);
            uLCD.pixel(78, 101, 11112570);
            uLCD.pixel(79, 101, 13019531);
            uLCD.pixel(80, 101, 14399379);
            uLCD.pixel(81, 101, 14398603);
            uLCD.pixel(82, 101, 13937022);
            uLCD.pixel(83, 101, 14199931);
            uLCD.pixel(84, 101, 14396532);
            uLCD.pixel(85, 101, 14724981);
            uLCD.pixel(86, 101, 14922359);
            uLCD.pixel(87, 101, 13803878);
            uLCD.pixel(88, 101, 15185272);
            uLCD.pixel(89, 101, 15711614);
            uLCD.pixel(90, 101, 15777148);
            uLCD.pixel(91, 101, 15777147);
            uLCD.pixel(92, 101, 16434561);
            uLCD.pixel(93, 101, 15381871);
            uLCD.pixel(94, 101, 16763520);
            uLCD.pixel(95, 101, 15842416);
            uLCD.pixel(96, 101, 15316070);
            uLCD.pixel(97, 101, 16302963);
            uLCD.pixel(98, 101, 15841898);
            uLCD.pixel(99, 101, 15644265);
            uLCD.pixel(100, 101, 16301685);
            uLCD.pixel(101, 101, 16104052);
            uLCD.pixel(102, 101, 16761723);
            uLCD.pixel(103, 101, 16235378);
            uLCD.pixel(104, 101, 16037483);
            uLCD.pixel(105, 101, 16695411);
            uLCD.pixel(106, 101, 16629359);
            uLCD.pixel(107, 101, 16695152);
            uLCD.pixel(108, 101, 16761204);
            uLCD.pixel(109, 101, 15905895);
            uLCD.pixel(110, 101, 16169585);
            uLCD.pixel(111, 101, 15841134);
            uLCD.pixel(112, 101, 13867090);
            uLCD.pixel(113, 101, 13275468);
            uLCD.pixel(114, 101, 14197088);
            uLCD.pixel(115, 101, 14394980);
            uLCD.pixel(116, 101, 13869150);
            uLCD.pixel(117, 101, 13738077);
            uLCD.pixel(118, 101, 13737565);
            uLCD.pixel(119, 101, 13803357);
            uLCD.pixel(120, 101, 13934944);
            uLCD.pixel(121, 101, 14000736);
            uLCD.pixel(122, 101, 14000736);
            uLCD.pixel(123, 101, 13934943);
            uLCD.pixel(124, 101, 14197601);
            uLCD.pixel(125, 101, 14131806);
            uLCD.pixel(126, 101, 14066015);
            uLCD.pixel(127, 101, 13868634);
            uLCD.pixel(78, 102, 3482644);
            uLCD.pixel(79, 102, 5981488);
            uLCD.pixel(80, 102, 7756865);
            uLCD.pixel(81, 102, 9006156);
            uLCD.pixel(82, 102, 10057813);
            uLCD.pixel(83, 102, 11241827);
            uLCD.pixel(84, 102, 12228715);
            uLCD.pixel(85, 102, 12688747);
            uLCD.pixel(86, 102, 13741176);
            uLCD.pixel(87, 102, 13609071);
            uLCD.pixel(88, 102, 14398326);
            uLCD.pixel(89, 102, 14727029);
            uLCD.pixel(90, 102, 14791792);
            uLCD.pixel(91, 102, 14857067);
            uLCD.pixel(92, 102, 14856295);
            uLCD.pixel(93, 102, 14658402);
            uLCD.pixel(94, 102, 16630909);
            uLCD.pixel(95, 102, 16433019);
            uLCD.pixel(96, 102, 16696191);
            uLCD.pixel(97, 102, 16169336);
            uLCD.pixel(98, 102, 15773810);
            uLCD.pixel(99, 102, 14655329);
            uLCD.pixel(100, 102, 16037750);
            uLCD.pixel(101, 102, 16432508);
            uLCD.pixel(102, 102, 16761985);
            uLCD.pixel(103, 102, 16497783);
            uLCD.pixel(104, 102, 16497781);
            uLCD.pixel(105, 102, 16761465);
            uLCD.pixel(106, 102, 16432241);
            uLCD.pixel(107, 102, 16695413);
            uLCD.pixel(108, 102, 16301425);
            uLCD.pixel(109, 102, 16564856);
            uLCD.pixel(110, 102, 16039026);
            uLCD.pixel(111, 102, 14855268);
            uLCD.pixel(112, 102, 14131293);
            uLCD.pixel(113, 102, 13737050);
            uLCD.pixel(114, 102, 13540185);
            uLCD.pixel(115, 102, 13737564);
            uLCD.pixel(116, 102, 14132574);
            uLCD.pixel(117, 102, 14198365);
            uLCD.pixel(118, 102, 14264160);
            uLCD.pixel(119, 102, 14329951);
            uLCD.pixel(120, 102, 14329953);
            uLCD.pixel(121, 102, 14264158);
            uLCD.pixel(122, 102, 14066779);
            uLCD.pixel(123, 102, 13935193);
            uLCD.pixel(124, 102, 14395230);
            uLCD.pixel(125, 102, 14395228);
            uLCD.pixel(126, 102, 14329437);
            uLCD.pixel(127, 102, 14263642);
            uLCD.pixel(84, 103, 2757888);
            uLCD.pixel(85, 103, 4073993);
            uLCD.pixel(86, 103, 7231026);
            uLCD.pixel(87, 103, 8875590);
            uLCD.pixel(88, 103, 9795660);
            uLCD.pixel(89, 103, 9992263);
            uLCD.pixel(90, 103, 9399350);
            uLCD.pixel(91, 103, 9003561);
            uLCD.pixel(92, 103, 10975807);
            uLCD.pixel(93, 103, 12816983);
            uLCD.pixel(94, 103, 15381624);
            uLCD.pixel(95, 103, 16039039);
            uLCD.pixel(96, 103, 16695942);
            uLCD.pixel(97, 103, 16761736);
            uLCD.pixel(98, 103, 16299901);
            uLCD.pixel(99, 103, 13405009);
            uLCD.pixel(100, 103, 14524513);
            uLCD.pixel(101, 103, 15511408);
            uLCD.pixel(102, 103, 15906164);
            uLCD.pixel(103, 103, 15708785);
            uLCD.pixel(104, 103, 16169334);
            uLCD.pixel(105, 103, 16235381);
            uLCD.pixel(106, 103, 15906416);
            uLCD.pixel(107, 103, 16169845);
            uLCD.pixel(108, 103, 15841395);
            uLCD.pixel(109, 103, 15644786);
            uLCD.pixel(110, 103, 14131808);
            uLCD.pixel(111, 103, 13145941);
            uLCD.pixel(112, 103, 14067304);
            uLCD.pixel(113, 103, 14133613);
            uLCD.pixel(114, 103, 13607270);
            uLCD.pixel(115, 103, 14002027);
            uLCD.pixel(116, 103, 13673314);
            uLCD.pixel(117, 103, 13673312);
            uLCD.pixel(118, 103, 13673312);
            uLCD.pixel(119, 103, 13673312);
            uLCD.pixel(120, 103, 13739105);
            uLCD.pixel(121, 103, 13673312);
            uLCD.pixel(122, 103, 13607519);
            uLCD.pixel(123, 103, 13607518);
            uLCD.pixel(124, 103, 13870176);
            uLCD.pixel(125, 103, 13870176);
            uLCD.pixel(126, 103, 13870176);
            uLCD.pixel(127, 103, 13804383);
            uLCD.pixel(91, 104, 2295040);
            uLCD.pixel(92, 104, 2162688);
            uLCD.pixel(93, 104, 3212800);
            uLCD.pixel(94, 104, 9001265);
            uLCD.pixel(95, 104, 15711628);
            uLCD.pixel(96, 104, 15776899);
            uLCD.pixel(97, 104, 15973246);
            uLCD.pixel(98, 104, 15972216);
            uLCD.pixel(99, 104, 13011785);
            uLCD.pixel(100, 104, 13735508);
            uLCD.pixel(101, 104, 14656610);
            uLCD.pixel(102, 104, 14459231);
            uLCD.pixel(103, 104, 14261852);
            uLCD.pixel(104, 104, 14722403);
            uLCD.pixel(105, 104, 14788709);
            uLCD.pixel(106, 104, 14920041);
            uLCD.pixel(107, 104, 15118191);
            uLCD.pixel(108, 104, 14592622);
            uLCD.pixel(109, 104, 13343070);
            uLCD.pixel(110, 104, 13541223);
            uLCD.pixel(111, 104, 14134391);
            uLCD.pixel(112, 104, 13476721);
            uLCD.pixel(113, 104, 13476982);
            uLCD.pixel(114, 104, 14266500);
            uLCD.pixel(115, 104, 14201477);
            uLCD.pixel(116, 104, 12819822);
            uLCD.pixel(117, 104, 12754029);
            uLCD.pixel(118, 104, 12754029);
            uLCD.pixel(119, 104, 12885615);
            uLCD.pixel(120, 104, 13082994);
            uLCD.pixel(121, 104, 13411959);
            uLCD.pixel(122, 104, 13806717);
            uLCD.pixel(123, 104, 14069887);
            uLCD.pixel(124, 104, 13740408);
            uLCD.pixel(125, 104, 14003580);
            uLCD.pixel(126, 104, 14332545);
            uLCD.pixel(127, 104, 14595717);
            uLCD.pixel(92, 105, 3280384);
            uLCD.pixel(93, 105, 4002816);
            uLCD.pixel(94, 105, 9132851);
            uLCD.pixel(95, 105, 16303765);
            uLCD.pixel(96, 105, 16763023);
            uLCD.pixel(97, 105, 15578741);
            uLCD.pixel(98, 105, 14525020);
            uLCD.pixel(99, 105, 13538125);
            uLCD.pixel(100, 105, 13736019);
            uLCD.pixel(101, 105, 14328672);
            uLCD.pixel(102, 105, 14065502);
            uLCD.pixel(103, 105, 14065502);
            uLCD.pixel(104, 105, 14065760);
            uLCD.pixel(105, 105, 13803360);
            uLCD.pixel(106, 105, 13803621);
            uLCD.pixel(107, 105, 13409123);
            uLCD.pixel(108, 105, 13870451);
            uLCD.pixel(109, 105, 13739895);
            uLCD.pixel(110, 105, 13609085);
            uLCD.pixel(111, 105, 13412739);
            uLCD.pixel(112, 105, 12886655);
            uLCD.pixel(113, 105, 11439470);
            uLCD.pixel(114, 105, 8281923);
            uLCD.pixel(115, 105, 5058325);
            uLCD.pixel(116, 105, 2953728);
            uLCD.pixel(117, 105, 2888448);
            uLCD.pixel(118, 105, 2822656);
            uLCD.pixel(119, 105, 2888448);
            uLCD.pixel(120, 105, 3085824);
            uLCD.pixel(121, 105, 3480576);
            uLCD.pixel(122, 105, 4072198);
            uLCD.pixel(123, 105, 4466956);
            uLCD.pixel(124, 105, 5782816);
            uLCD.pixel(125, 105, 6243366);
            uLCD.pixel(126, 105, 6835503);
            uLCD.pixel(127, 105, 7427640);
            uLCD.pixel(88, 106, 3743245);
            uLCD.pixel(89, 106, 8347464);
            uLCD.pixel(90, 106, 11175785);
            uLCD.pixel(91, 106, 13937800);
            uLCD.pixel(92, 106, 14594693);
            uLCD.pixel(93, 106, 16303763);
            uLCD.pixel(94, 106, 16566414);
            uLCD.pixel(95, 106, 16104315);
            uLCD.pixel(96, 106, 16038259);
            uLCD.pixel(97, 106, 16366450);
            uLCD.pixel(98, 106, 15115868);
            uLCD.pixel(99, 106, 13932623);
            uLCD.pixel(100, 106, 13868375);
            uLCD.pixel(101, 106, 14132835);
            uLCD.pixel(102, 106, 14001250);
            uLCD.pixel(103, 106, 14330474);
            uLCD.pixel(104, 106, 14067820);
            uLCD.pixel(105, 106, 13739115);
            uLCD.pixel(106, 106, 13740148);
            uLCD.pixel(107, 106, 12687466);
            uLCD.pixel(108, 106, 13411967);
            uLCD.pixel(109, 106, 13281159);
            uLCD.pixel(110, 106, 9926748);
            uLCD.pixel(111, 106, 5519395);
            uLCD.pixel(112, 106, 3348233);
            uLCD.pixel(84, 107, 2888967);
            uLCD.pixel(85, 107, 6570800);
            uLCD.pixel(86, 107, 9530968);
            uLCD.pixel(87, 107, 12294268);
            uLCD.pixel(88, 107, 14596760);
            uLCD.pixel(89, 107, 16372906);
            uLCD.pixel(90, 107, 14727049);
            uLCD.pixel(91, 107, 14594942);
            uLCD.pixel(92, 107, 16041611);
            uLCD.pixel(93, 107, 14527855);
            uLCD.pixel(94, 107, 15185010);
            uLCD.pixel(95, 107, 14460258);
            uLCD.pixel(96, 107, 14196570);
            uLCD.pixel(97, 107, 13867090);
            uLCD.pixel(98, 107, 14524763);
            uLCD.pixel(99, 107, 14525537);
            uLCD.pixel(100, 107, 13869923);
            uLCD.pixel(101, 107, 13608552);
            uLCD.pixel(102, 107, 13213541);
            uLCD.pixel(103, 107, 13477485);
            uLCD.pixel(104, 107, 13214832);
            uLCD.pixel(105, 107, 13347193);
            uLCD.pixel(106, 107, 14268557);
            uLCD.pixel(107, 107, 13019268);
            uLCD.pixel(108, 107, 9269845);
            uLCD.pixel(109, 107, 4072719);
            uLCD.pixel(83, 108, 5589307);
            uLCD.pixel(84, 108, 14664606);
            uLCD.pixel(85, 108, 15583126);
            uLCD.pixel(86, 108, 15978138);
            uLCD.pixel(87, 108, 14399103);
            uLCD.pixel(88, 108, 13938036);
            uLCD.pixel(89, 108, 14398585);
            uLCD.pixel(90, 108, 13082466);
            uLCD.pixel(91, 108, 12161363);
            uLCD.pixel(92, 108, 14727544);
            uLCD.pixel(93, 108, 14398066);
            uLCD.pixel(94, 108, 13937517);
            uLCD.pixel(95, 108, 14068333);
            uLCD.pixel(96, 108, 14397043);
            uLCD.pixel(97, 108, 14659958);
            uLCD.pixel(98, 108, 14593913);
            uLCD.pixel(99, 108, 14200186);
            uLCD.pixel(100, 108, 13938303);
            uLCD.pixel(101, 108, 13808004);
            uLCD.pixel(102, 108, 13742213);
            uLCD.pixel(103, 108, 13281921);
            uLCD.pixel(104, 108, 12295545);
            uLCD.pixel(105, 108, 10059614);
            uLCD.pixel(106, 108, 6704944);
            uLCD.pixel(107, 108, 3810829);
            uLCD.pixel(83, 109, 12365726);
            uLCD.pixel(84, 109, 14664855);
            uLCD.pixel(85, 109, 14465409);
            uLCD.pixel(86, 109, 13808249);
            uLCD.pixel(87, 109, 12689514);
            uLCD.pixel(88, 109, 13150065);
            uLCD.pixel(89, 109, 14268547);
            uLCD.pixel(90, 109, 13216118);
            uLCD.pixel(91, 109, 12229225);
            uLCD.pixel(92, 109, 10321487);
            uLCD.pixel(93, 109, 8940605);
            uLCD.pixel(94, 109, 7756077);
            uLCD.pixel(95, 109, 8019251);
            uLCD.pixel(96, 109, 9203784);
            uLCD.pixel(97, 109, 10059094);
            uLCD.pixel(98, 109, 9795924);
            uLCD.pixel(99, 109, 9137740);
            uLCD.pixel(100, 109, 7625020);
            uLCD.pixel(101, 109, 6638386);
            uLCD.pixel(102, 109, 4927770);
            uLCD.pixel(103, 109, 3217410);
            uLCD.pixel(104, 109, 2231552);
            uLCD.pixel(83, 110, 9668214);
            uLCD.pixel(84, 110, 13548185);
            uLCD.pixel(85, 110, 12823683);
            uLCD.pixel(86, 110, 11902842);
            uLCD.pixel(87, 110, 10390121);
            uLCD.pixel(88, 110, 9534561);
            uLCD.pixel(89, 110, 8218707);
            uLCD.pixel(90, 110, 5192747);
            uLCD.pixel(91, 110, 2956558);
            uLCD.pixel(84, 111, 4732711);
            uLCD.pixel(85, 111, 3876887);
            uLCD.pixel(86, 111, 2692873);
        }

        // Draw left Rock
        void drawLeftRock() {
            uLCD.pixel(34, 76, 3216640);
            uLCD.pixel(35, 76, 6374955);
            uLCD.pixel(36, 76, 7888194);
            uLCD.pixel(37, 76, 8152136);
            uLCD.pixel(38, 76, 3218693);
            uLCD.pixel(32, 77, 4728584);
            uLCD.pixel(33, 77, 10517077);
            uLCD.pixel(34, 77, 13938052);
            uLCD.pixel(35, 77, 15517082);
            uLCD.pixel(36, 77, 16569770);
            uLCD.pixel(37, 77, 16044970);
            uLCD.pixel(38, 77, 9729877);
            uLCD.pixel(30, 78, 4401163);
            uLCD.pixel(31, 78, 11241827);
            uLCD.pixel(32, 78, 15318667);
            uLCD.pixel(33, 78, 16765335);
            uLCD.pixel(34, 78, 16303753);
            uLCD.pixel(35, 78, 15645821);
            uLCD.pixel(36, 78, 14659441);
            uLCD.pixel(37, 78, 15582089);
            uLCD.pixel(38, 78, 15057043);
            uLCD.pixel(39, 78, 4400646);
            uLCD.pixel(29, 79, 6703142);
            uLCD.pixel(30, 79, 14924945);
            uLCD.pixel(31, 79, 16107152);
            uLCD.pixel(32, 79, 16040833);
            uLCD.pixel(33, 79, 15381612);
            uLCD.pixel(34, 79, 15578474);
            uLCD.pixel(35, 79, 16763263);
            uLCD.pixel(36, 79, 16367991);
            uLCD.pixel(37, 79, 15777147);
            uLCD.pixel(38, 79, 16766111);
            uLCD.pixel(39, 79, 7360553);
            uLCD.pixel(28, 80, 5848092);
            uLCD.pixel(29, 80, 16042909);
            uLCD.pixel(30, 80, 16171656);
            uLCD.pixel(31, 80, 16038776);
            uLCD.pixel(32, 80, 16170358);
            uLCD.pixel(33, 80, 16763774);
            uLCD.pixel(34, 80, 16696179);
            uLCD.pixel(35, 80, 15511391);
            uLCD.pixel(36, 80, 16498802);
            uLCD.pixel(37, 80, 15907956);
            uLCD.pixel(38, 80, 16238990);
            uLCD.pixel(39, 80, 11636324);
            uLCD.pixel(27, 81, 3350278);
            uLCD.pixel(28, 81, 15254939);
            uLCD.pixel(29, 81, 14724468);
            uLCD.pixel(30, 81, 16629110);
            uLCD.pixel(31, 81, 16759664);
            uLCD.pixel(32, 81, 16235379);
            uLCD.pixel(33, 81, 15841134);
            uLCD.pixel(34, 81, 15511137);
            uLCD.pixel(35, 81, 12813365);
            uLCD.pixel(36, 81, 14524242);
            uLCD.pixel(37, 81, 15907186);
            uLCD.pixel(38, 81, 16369806);
            uLCD.pixel(39, 81, 14267528);
            uLCD.pixel(40, 81, 2822912);
            uLCD.pixel(27, 82, 10586730);
            uLCD.pixel(28, 82, 15121546);
            uLCD.pixel(29, 82, 16762756);
            uLCD.pixel(30, 82, 16761713);
            uLCD.pixel(31, 82, 16759915);
            uLCD.pixel(32, 82, 16762499);
            uLCD.pixel(33, 82, 14262112);
            uLCD.pixel(34, 82, 14458716);
            uLCD.pixel(35, 82, 13076545);
            uLCD.pixel(36, 82, 14129233);
            uLCD.pixel(37, 82, 15315053);
            uLCD.pixel(38, 82, 14790776);
            uLCD.pixel(39, 82, 12754289);
            uLCD.pixel(40, 82, 6112553);
            uLCD.pixel(41, 82, 2694413);
            uLCD.pixel(26, 83, 5060894);
            uLCD.pixel(27, 83, 15387549);
            uLCD.pixel(28, 83, 16173194);
            uLCD.pixel(29, 83, 16169067);
            uLCD.pixel(30, 83, 16758626);
            uLCD.pixel(31, 83, 16759657);
            uLCD.pixel(32, 83, 14524773);
            uLCD.pixel(33, 83, 12881239);
            uLCD.pixel(34, 83, 12682315);
            uLCD.pixel(35, 83, 11629621);
            uLCD.pixel(36, 83, 13800790);
            uLCD.pixel(37, 83, 14919788);
            uLCD.pixel(38, 83, 14066540);
            uLCD.pixel(39, 83, 14200446);
            uLCD.pixel(40, 83, 14136979);
            uLCD.pixel(41, 83, 11837575);
            uLCD.pixel(42, 83, 2694931);
            uLCD.pixel(25, 84, 2032640);
            uLCD.pixel(26, 84, 13149816);
            uLCD.pixel(27, 84, 15779717);
            uLCD.pixel(28, 84, 16106097);
            uLCD.pixel(29, 84, 16762221);
            uLCD.pixel(30, 84, 16628581);
            uLCD.pixel(31, 84, 16761204);
            uLCD.pixel(32, 84, 12947030);
            uLCD.pixel(33, 84, 12092500);
            uLCD.pixel(34, 84, 12551761);
            uLCD.pixel(35, 84, 14525034);
            uLCD.pixel(36, 84, 10907189);
            uLCD.pixel(37, 84, 14394476);
            uLCD.pixel(38, 84, 14197097);
            uLCD.pixel(39, 84, 14131822);
            uLCD.pixel(40, 84, 14329720);
            uLCD.pixel(41, 84, 14398351);
            uLCD.pixel(42, 84, 10126447);
            uLCD.pixel(25, 85, 9399372);
            uLCD.pixel(26, 85, 15582089);
            uLCD.pixel(27, 85, 16172409);
            uLCD.pixel(28, 85, 15907429);
            uLCD.pixel(29, 85, 16169570);
            uLCD.pixel(30, 85, 16760940);
            uLCD.pixel(31, 85, 16761979);
            uLCD.pixel(32, 85, 14198124);
            uLCD.pixel(33, 85, 11304011);
            uLCD.pixel(34, 85, 14394476);
            uLCD.pixel(35, 85, 14460011);
            uLCD.pixel(36, 85, 13868131);
            uLCD.pixel(37, 85, 11762755);
            uLCD.pixel(38, 85, 13604698);
            uLCD.pixel(39, 85, 14525030);
            uLCD.pixel(40, 85, 13077586);
            uLCD.pixel(41, 85, 13343595);
            uLCD.pixel(42, 85, 12756104);
            uLCD.pixel(24, 86, 5256471);
            uLCD.pixel(25, 86, 15057297);
            uLCD.pixel(26, 86, 16238987);
            uLCD.pixel(27, 86, 16171128);
            uLCD.pixel(28, 86, 16104044);
            uLCD.pixel(29, 86, 16760944);
            uLCD.pixel(30, 86, 16760688);
            uLCD.pixel(31, 86, 16563827);
            uLCD.pixel(32, 86, 14000996);
            uLCD.pixel(33, 86, 12028237);
            uLCD.pixel(34, 86, 14197601);
            uLCD.pixel(35, 86, 14197086);
            uLCD.pixel(36, 86, 14789736);
            uLCD.pixel(37, 86, 13079118);
            uLCD.pixel(38, 86, 13144650);
            uLCD.pixel(39, 86, 12420157);
            uLCD.pixel(40, 86, 13472847);
            uLCD.pixel(41, 86, 13673063);
            uLCD.pixel(42, 86, 12493435);
            uLCD.pixel(23, 87, 2626560);
            uLCD.pixel(24, 87, 12756080);
            uLCD.pixel(25, 87, 15845771);
            uLCD.pixel(26, 87, 15646072);
            uLCD.pixel(27, 87, 16499064);
            uLCD.pixel(28, 87, 16563829);
            uLCD.pixel(29, 87, 16762749);
            uLCD.pixel(30, 87, 16430699);
            uLCD.pixel(31, 87, 16498036);
            uLCD.pixel(32, 87, 12355914);
            uLCD.pixel(33, 87, 14001511);
            uLCD.pixel(34, 87, 14921324);
            uLCD.pixel(35, 87, 14723684);
            uLCD.pixel(36, 87, 13868634);
            uLCD.pixel(37, 87, 14789477);
            uLCD.pixel(38, 87, 14393947);
            uLCD.pixel(39, 87, 13867857);
            uLCD.pixel(40, 87, 12814917);
            uLCD.pixel(41, 87, 13212511);
            uLCD.pixel(42, 87, 6703651);
            uLCD.pixel(23, 88, 10521169);
            uLCD.pixel(24, 88, 16110476);
            uLCD.pixel(25, 88, 15450226);
            uLCD.pixel(26, 88, 15908209);
            uLCD.pixel(27, 88, 16761210);
            uLCD.pixel(28, 88, 16760699);
            uLCD.pixel(29, 88, 16759415);
            uLCD.pixel(30, 88, 16298604);
            uLCD.pixel(31, 88, 16762499);
            uLCD.pixel(32, 88, 11566147);
            uLCD.pixel(33, 88, 13014365);
            uLCD.pixel(34, 88, 13802592);
            uLCD.pixel(35, 88, 12815436);
            uLCD.pixel(36, 88, 12815695);
            uLCD.pixel(37, 88, 12552010);
            uLCD.pixel(38, 88, 13143631);
            uLCD.pixel(39, 88, 13274703);
            uLCD.pixel(40, 88, 13406549);
            uLCD.pixel(41, 88, 14067571);
            uLCD.pixel(42, 88, 4795406);
            uLCD.pixel(22, 89, 8481593);
            uLCD.pixel(23, 89, 15585161);
            uLCD.pixel(24, 89, 15450736);
            uLCD.pixel(25, 89, 16566899);
            uLCD.pixel(26, 89, 16301421);
            uLCD.pixel(27, 89, 16497007);
            uLCD.pixel(28, 89, 16761728);
            uLCD.pixel(29, 89, 16429939);
            uLCD.pixel(30, 89, 16759672);
            uLCD.pixel(31, 89, 16760703);
            uLCD.pixel(32, 89, 10513716);
            uLCD.pixel(33, 89, 12356435);
            uLCD.pixel(34, 89, 13539420);
            uLCD.pixel(35, 89, 14196319);
            uLCD.pixel(36, 89, 15578488);
            uLCD.pixel(37, 89, 15710074);
            uLCD.pixel(38, 89, 16170109);
            uLCD.pixel(39, 89, 15972217);
            uLCD.pixel(40, 89, 15972476);
            uLCD.pixel(41, 89, 16435865);
            uLCD.pixel(42, 89, 9993053);
            uLCD.pixel(20, 90, 2166528);
            uLCD.pixel(21, 90, 6967593);
            uLCD.pixel(22, 90, 15255691);
            uLCD.pixel(23, 90, 15779450);
            uLCD.pixel(24, 90, 15448418);
            uLCD.pixel(25, 90, 16763505);
            uLCD.pixel(26, 90, 16628842);
            uLCD.pixel(27, 90, 16364906);
            uLCD.pixel(28, 90, 16761212);
            uLCD.pixel(29, 90, 16759417);
            uLCD.pixel(30, 90, 16760959);
            uLCD.pixel(31, 90, 15511919);
            uLCD.pixel(32, 90, 12553552);
            uLCD.pixel(33, 90, 15777920);
            uLCD.pixel(34, 90, 16500354);
            uLCD.pixel(35, 90, 16764296);
            uLCD.pixel(36, 90, 16170876);
            uLCD.pixel(37, 90, 16434302);
            uLCD.pixel(38, 90, 16367737);
            uLCD.pixel(39, 90, 16367224);
            uLCD.pixel(40, 90, 16301948);
            uLCD.pixel(41, 90, 15975564);
            uLCD.pixel(42, 90, 13414539);
            uLCD.pixel(20, 91, 6966563);
            uLCD.pixel(21, 91, 15583892);
            uLCD.pixel(22, 91, 15516029);
            uLCD.pixel(23, 91, 16040306);
            uLCD.pixel(24, 91, 16696686);
            uLCD.pixel(25, 91, 16431714);
            uLCD.pixel(26, 91, 16760941);
            uLCD.pixel(27, 91, 16760689);
            uLCD.pixel(28, 91, 16430701);
            uLCD.pixel(29, 91, 16628856);
            uLCD.pixel(30, 91, 16497531);
            uLCD.pixel(31, 91, 15051627);
            uLCD.pixel(32, 91, 15119477);
            uLCD.pixel(33, 91, 16172419);
            uLCD.pixel(34, 91, 15907958);
            uLCD.pixel(35, 91, 16302198);
            uLCD.pixel(36, 91, 16302714);
            uLCD.pixel(37, 91, 15907956);
            uLCD.pixel(38, 91, 16564857);
            uLCD.pixel(39, 91, 16433271);
            uLCD.pixel(40, 91, 16236153);
            uLCD.pixel(41, 91, 14988923);
            uLCD.pixel(42, 91, 13611916);
            uLCD.pixel(14, 92, 2561287);
            uLCD.pixel(15, 92, 4139541);
            uLCD.pixel(16, 92, 7822652);
            uLCD.pixel(17, 92, 10124111);
            uLCD.pixel(18, 92, 11439196);
            uLCD.pixel(19, 92, 12754278);
            uLCD.pixel(20, 92, 14924412);
            uLCD.pixel(21, 92, 15975297);
            uLCD.pixel(22, 92, 15907958);
            uLCD.pixel(23, 92, 16498036);
            uLCD.pixel(24, 92, 16760175);
            uLCD.pixel(25, 92, 16760173);
            uLCD.pixel(26, 92, 16760168);
            uLCD.pixel(27, 92, 16760427);
            uLCD.pixel(28, 92, 16760175);
            uLCD.pixel(29, 92, 16761979);
            uLCD.pixel(30, 92, 16104569);
            uLCD.pixel(31, 92, 13407832);
            uLCD.pixel(32, 92, 13935203);
            uLCD.pixel(33, 92, 14922352);
            uLCD.pixel(34, 92, 14723684);
            uLCD.pixel(35, 92, 14788705);
            uLCD.pixel(36, 92, 14986856);
            uLCD.pixel(37, 92, 14592096);
            uLCD.pixel(38, 92, 14722399);
            uLCD.pixel(39, 92, 14722399);
            uLCD.pixel(40, 92, 14262365);
            uLCD.pixel(41, 92, 14528118);
            uLCD.pixel(42, 92, 10716772);
            uLCD.pixel(0, 93, 2033920);
            uLCD.pixel(1, 93, 2231296);
            uLCD.pixel(2, 93, 2626048);
            uLCD.pixel(3, 93, 3283203);
            uLCD.pixel(4, 93, 3809802);
            uLCD.pixel(5, 93, 4270351);
            uLCD.pixel(6, 93, 4730389);
            uLCD.pixel(7, 93, 4927766);
            uLCD.pixel(8, 93, 6177576);
            uLCD.pixel(9, 93, 6506539);
            uLCD.pixel(10, 93, 7690298);
            uLCD.pixel(11, 93, 9203535);
            uLCD.pixel(12, 93, 10716261);
            uLCD.pixel(13, 93, 12032375);
            uLCD.pixel(14, 93, 13479821);
            uLCD.pixel(15, 93, 14926235);
            uLCD.pixel(16, 93, 15516819);
            uLCD.pixel(17, 93, 16370835);
            uLCD.pixel(18, 93, 16107653);
            uLCD.pixel(19, 93, 15843705);
            uLCD.pixel(20, 93, 16434810);
            uLCD.pixel(21, 93, 16762235);
            uLCD.pixel(22, 93, 16760696);
            uLCD.pixel(23, 93, 16760955);
            uLCD.pixel(24, 93, 16561006);
            uLCD.pixel(25, 93, 16760692);
            uLCD.pixel(26, 93, 16759400);
            uLCD.pixel(27, 93, 16760170);
            uLCD.pixel(28, 93, 16695151);
            uLCD.pixel(29, 93, 15972973);
            uLCD.pixel(30, 93, 16237182);
            uLCD.pixel(31, 93, 12092488);
            uLCD.pixel(32, 93, 13014105);
            uLCD.pixel(33, 93, 14197864);
            uLCD.pixel(34, 93, 14262111);
            uLCD.pixel(35, 93, 14393438);
            uLCD.pixel(36, 93, 14722916);
            uLCD.pixel(37, 93, 14459744);
            uLCD.pixel(38, 93, 14525024);
            uLCD.pixel(39, 93, 14656610);
            uLCD.pixel(40, 93, 14261599);
            uLCD.pixel(41, 93, 14133110);
            uLCD.pixel(42, 93, 7098161);
            uLCD.pixel(0, 94, 14069622);
            uLCD.pixel(1, 94, 14201206);
            uLCD.pixel(2, 94, 14464378);
            uLCD.pixel(3, 94, 14858877);
            uLCD.pixel(4, 94, 15253635);
            uLCD.pixel(5, 94, 15582599);
            uLCD.pixel(6, 94, 15911307);
            uLCD.pixel(7, 94, 16042891);
            uLCD.pixel(8, 94, 16240270);
            uLCD.pixel(9, 94, 15977096);
            uLCD.pixel(10, 94, 16173959);
            uLCD.pixel(11, 94, 16437130);
            uLCD.pixel(12, 94, 16437130);
            uLCD.pixel(13, 94, 16108419);
            uLCD.pixel(14, 94, 15910527);
            uLCD.pixel(15, 94, 16107136);
            uLCD.pixel(16, 94, 16105598);
            uLCD.pixel(17, 94, 16301946);
            uLCD.pixel(18, 94, 16170350);
            uLCD.pixel(19, 94, 16104295);
            uLCD.pixel(20, 94, 16235365);
            uLCD.pixel(21, 94, 16497258);
            uLCD.pixel(22, 94, 16627569);
            uLCD.pixel(23, 94, 16758389);
            uLCD.pixel(24, 94, 16757619);
            uLCD.pixel(25, 94, 16760699);
            uLCD.pixel(26, 94, 16759405);
            uLCD.pixel(27, 94, 16760686);
            uLCD.pixel(28, 94, 16366699);
            uLCD.pixel(29, 94, 16105586);
            uLCD.pixel(30, 94, 15448693);
            uLCD.pixel(31, 94, 11961928);
            uLCD.pixel(32, 94, 12355922);
            uLCD.pixel(33, 94, 13737062);
            uLCD.pixel(34, 94, 13801309);
            uLCD.pixel(35, 94, 13735257);
            uLCD.pixel(36, 94, 13801309);
            uLCD.pixel(37, 94, 13340758);
            uLCD.pixel(38, 94, 13406038);
            uLCD.pixel(39, 94, 13471831);
            uLCD.pixel(40, 94, 13406041);
            uLCD.pixel(41, 94, 12750692);
            uLCD.pixel(42, 94, 2557952);
            uLCD.pixel(0, 95, 16303227);
            uLCD.pixel(1, 95, 16303227);
            uLCD.pixel(2, 95, 16302712);
            uLCD.pixel(3, 95, 16236919);
            uLCD.pixel(4, 95, 16171126);
            uLCD.pixel(5, 95, 16105588);
            uLCD.pixel(6, 95, 16039795);
            uLCD.pixel(7, 95, 15974000);
            uLCD.pixel(8, 95, 16236402);
            uLCD.pixel(9, 95, 15973484);
            uLCD.pixel(10, 95, 15907689);
            uLCD.pixel(11, 95, 16105067);
            uLCD.pixel(12, 95, 16170860);
            uLCD.pixel(13, 95, 16039274);
            uLCD.pixel(14, 95, 15973224);
            uLCD.pixel(15, 95, 16038249);
            uLCD.pixel(16, 95, 16432241);
            uLCD.pixel(17, 95, 16300396);
            uLCD.pixel(18, 95, 16695403);
            uLCD.pixel(19, 95, 16762478);
            uLCD.pixel(20, 95, 16761965);
            uLCD.pixel(21, 95, 16761198);
            uLCD.pixel(22, 95, 16760950);
            uLCD.pixel(23, 95, 16759929);
            uLCD.pixel(24, 95, 16759420);
            uLCD.pixel(25, 95, 16758903);
            uLCD.pixel(26, 95, 16759665);
            uLCD.pixel(27, 95, 16760432);
            uLCD.pixel(28, 95, 16038251);
            uLCD.pixel(29, 95, 16697982);
            uLCD.pixel(30, 95, 13409623);
            uLCD.pixel(31, 95, 13212509);
            uLCD.pixel(32, 95, 11763783);
            uLCD.pixel(33, 95, 13604959);
            uLCD.pixel(34, 95, 13932634);
            uLCD.pixel(35, 95, 14063962);
            uLCD.pixel(36, 95, 14261599);
            uLCD.pixel(37, 95, 14130015);
            uLCD.pixel(38, 95, 14392672);
            uLCD.pixel(39, 95, 14590053);
            uLCD.pixel(40, 95, 15379828);
            uLCD.pixel(41, 95, 14461308);
            uLCD.pixel(42, 95, 4203018);
            uLCD.pixel(0, 96, 16628860);
            uLCD.pixel(1, 96, 16628860);
            uLCD.pixel(2, 96, 16628860);
            uLCD.pixel(3, 96, 16628858);
            uLCD.pixel(4, 96, 16628858);
            uLCD.pixel(5, 96, 16628856);
            uLCD.pixel(6, 96, 16628856);
            uLCD.pixel(7, 96, 16629110);
            uLCD.pixel(8, 96, 16760183);
            uLCD.pixel(9, 96, 16759925);
            uLCD.pixel(10, 96, 16694132);
            uLCD.pixel(11, 96, 16760179);
            uLCD.pixel(12, 96, 16760436);
            uLCD.pixel(13, 96, 16760693);
            uLCD.pixel(14, 96, 16761207);
            uLCD.pixel(15, 96, 16761978);
            uLCD.pixel(16, 96, 16761465);
            uLCD.pixel(17, 96, 16759918);
            uLCD.pixel(18, 96, 16759915);
            uLCD.pixel(19, 96, 16760424);
            uLCD.pixel(20, 96, 16562788);
            uLCD.pixel(21, 96, 16431204);
            uLCD.pixel(22, 96, 16693612);
            uLCD.pixel(23, 96, 16758896);
            uLCD.pixel(24, 96, 16760442);
            uLCD.pixel(25, 96, 16758386);
            uLCD.pixel(26, 96, 16693363);
            uLCD.pixel(27, 96, 16431730);
            uLCD.pixel(28, 96, 16762236);
            uLCD.pixel(29, 96, 15447918);
            uLCD.pixel(30, 96, 12291142);
            uLCD.pixel(31, 96, 13804897);
            uLCD.pixel(32, 96, 13935456);
            uLCD.pixel(33, 96, 15974008);
            uLCD.pixel(34, 96, 16433270);
            uLCD.pixel(35, 96, 16498804);
            uLCD.pixel(36, 96, 16762235);
            uLCD.pixel(37, 96, 16564856);
            uLCD.pixel(38, 96, 16762236);
            uLCD.pixel(39, 96, 16762751);
            uLCD.pixel(40, 96, 16630396);
            uLCD.pixel(41, 96, 16567185);
            uLCD.pixel(42, 96, 9466959);
            uLCD.pixel(0, 97, 16758904);
            uLCD.pixel(1, 97, 16758904);
            uLCD.pixel(2, 97, 16759161);
            uLCD.pixel(3, 97, 16759672);
            uLCD.pixel(4, 97, 16759673);
            uLCD.pixel(5, 97, 16760186);
            uLCD.pixel(6, 97, 16760441);
            uLCD.pixel(7, 97, 16760698);
            uLCD.pixel(8, 97, 16759925);
            uLCD.pixel(9, 97, 16760439);
            uLCD.pixel(10, 97, 16760437);
            uLCD.pixel(11, 97, 16760180);
            uLCD.pixel(12, 97, 16693873);
            uLCD.pixel(13, 97, 16628080);
            uLCD.pixel(14, 97, 16628080);
            uLCD.pixel(15, 97, 16759666);
            uLCD.pixel(16, 97, 16760180);
            uLCD.pixel(17, 97, 16760178);
            uLCD.pixel(18, 97, 16759918);
            uLCD.pixel(19, 97, 16628844);
            uLCD.pixel(20, 97, 16694635);
            uLCD.pixel(21, 97, 16760685);
            uLCD.pixel(22, 97, 16760686);
            uLCD.pixel(23, 97, 16761202);
            uLCD.pixel(24, 97, 16759924);
            uLCD.pixel(25, 97, 16760440);
            uLCD.pixel(26, 97, 16628088);
            uLCD.pixel(27, 97, 16365945);
            uLCD.pixel(28, 97, 16764301);
            uLCD.pixel(29, 97, 13276499);
            uLCD.pixel(30, 97, 13146453);
            uLCD.pixel(31, 97, 13344600);
            uLCD.pixel(32, 97, 14396259);
            uLCD.pixel(33, 97, 16369017);
            uLCD.pixel(34, 97, 16696694);
            uLCD.pixel(35, 97, 16499055);
            uLCD.pixel(36, 97, 16565108);
            uLCD.pixel(37, 97, 16236143);
            uLCD.pixel(38, 97, 16235630);
            uLCD.pixel(39, 97, 16169839);
            uLCD.pixel(40, 97, 15709547);
            uLCD.pixel(41, 97, 16567438);
            uLCD.pixel(42, 97, 11835504);
            uLCD.pixel(0, 98, 16759921);
            uLCD.pixel(1, 98, 16759921);
            uLCD.pixel(2, 98, 16759664);
            uLCD.pixel(3, 98, 16694384);
            uLCD.pixel(4, 98, 16693871);
            uLCD.pixel(5, 98, 16628589);
            uLCD.pixel(6, 98, 16628332);
            uLCD.pixel(7, 98, 16562796);
            uLCD.pixel(8, 98, 16628844);
            uLCD.pixel(9, 98, 16760430);
            uLCD.pixel(10, 98, 16760944);
            uLCD.pixel(11, 98, 16760687);
            uLCD.pixel(12, 98, 16760687);
            uLCD.pixel(13, 98, 16760687);
            uLCD.pixel(14, 98, 16760428);
            uLCD.pixel(15, 98, 16760430);
            uLCD.pixel(16, 98, 16497005);
            uLCD.pixel(17, 98, 16761210);
            uLCD.pixel(18, 98, 16694649);
            uLCD.pixel(19, 98, 16365938);
            uLCD.pixel(20, 98, 16695413);
            uLCD.pixel(21, 98, 16695665);
            uLCD.pixel(22, 98, 16432231);
            uLCD.pixel(23, 98, 16563815);
            uLCD.pixel(24, 98, 16694637);
            uLCD.pixel(25, 98, 16761721);
            uLCD.pixel(26, 98, 16628860);
            uLCD.pixel(27, 98, 16366464);
            uLCD.pixel(28, 98, 15314548);
            uLCD.pixel(29, 98, 12749904);
            uLCD.pixel(30, 98, 14330727);
            uLCD.pixel(31, 98, 13080658);
            uLCD.pixel(32, 98, 13474903);
            uLCD.pixel(33, 98, 15579504);
            uLCD.pixel(34, 98, 16038512);
            uLCD.pixel(35, 98, 16038251);
            uLCD.pixel(36, 98, 16301684);
            uLCD.pixel(37, 98, 16170098);
            uLCD.pixel(38, 98, 16301171);
            uLCD.pixel(39, 98, 16103793);
            uLCD.pixel(40, 98, 15709296);
            uLCD.pixel(41, 98, 15777671);
            uLCD.pixel(42, 98, 9269326);
            uLCD.pixel(0, 99, 16760430);
            uLCD.pixel(1, 99, 16760430);
            uLCD.pixel(2, 99, 16629358);
            uLCD.pixel(3, 99, 16629358);
            uLCD.pixel(4, 99, 16695151);
            uLCD.pixel(5, 99, 16695151);
            uLCD.pixel(6, 99, 16695151);
            uLCD.pixel(7, 99, 16695151);
            uLCD.pixel(8, 99, 16695151);
            uLCD.pixel(9, 99, 16695405);
            uLCD.pixel(10, 99, 16629358);
            uLCD.pixel(11, 99, 16563565);
            uLCD.pixel(12, 99, 16629358);
            uLCD.pixel(13, 99, 16695151);
            uLCD.pixel(14, 99, 16695405);
            uLCD.pixel(15, 99, 16563565);
            uLCD.pixel(16, 99, 16431212);
            uLCD.pixel(17, 99, 16761981);
            uLCD.pixel(18, 99, 16562549);
            uLCD.pixel(19, 99, 15576168);
            uLCD.pixel(20, 99, 16168816);
            uLCD.pixel(21, 99, 16432239);
            uLCD.pixel(22, 99, 16235111);
            uLCD.pixel(23, 99, 16629869);
            uLCD.pixel(24, 99, 16497772);
            uLCD.pixel(25, 99, 16563316);
            uLCD.pixel(26, 99, 16563326);
            uLCD.pixel(27, 99, 16366466);
            uLCD.pixel(28, 99, 12156486);
            uLCD.pixel(29, 99, 13670493);
            uLCD.pixel(30, 99, 14658666);
            uLCD.pixel(31, 99, 13211733);
            uLCD.pixel(32, 99, 12488270);
            uLCD.pixel(33, 99, 14461288);
            uLCD.pixel(34, 99, 14854500);
            uLCD.pixel(35, 99, 14853726);
            uLCD.pixel(36, 99, 15116898);
            uLCD.pixel(37, 99, 14919521);
            uLCD.pixel(38, 99, 14787681);
            uLCD.pixel(39, 99, 14393184);
            uLCD.pixel(40, 99, 14526315);
            uLCD.pixel(41, 99, 13081452);
            uLCD.pixel(42, 99, 3875332);
            uLCD.pixel(0, 100, 16498286);
            uLCD.pixel(1, 100, 16498286);
            uLCD.pixel(2, 100, 16498286);
            uLCD.pixel(3, 100, 16564079);
            uLCD.pixel(4, 100, 16564079);
            uLCD.pixel(5, 100, 16564079);
            uLCD.pixel(6, 100, 16629618);
            uLCD.pixel(7, 100, 16629618);
            uLCD.pixel(8, 100, 16498032);
            uLCD.pixel(9, 100, 16563825);
            uLCD.pixel(10, 100, 16563827);
            uLCD.pixel(11, 100, 16629620);
            uLCD.pixel(12, 100, 16629620);
            uLCD.pixel(13, 100, 16629620);
            uLCD.pixel(14, 100, 16629620);
            uLCD.pixel(15, 100, 16694900);
            uLCD.pixel(16, 100, 16760435);
            uLCD.pixel(17, 100, 16760436);
            uLCD.pixel(18, 100, 16298602);
            uLCD.pixel(19, 100, 16101738);
            uLCD.pixel(20, 100, 15378272);
            uLCD.pixel(21, 100, 16761981);
            uLCD.pixel(22, 100, 16497521);
            uLCD.pixel(23, 100, 16498036);
            uLCD.pixel(24, 100, 16761981);
            uLCD.pixel(25, 100, 15379818);
            uLCD.pixel(26, 100, 13800790);
            uLCD.pixel(27, 100, 13208911);
            uLCD.pixel(28, 100, 13866841);
            uLCD.pixel(29, 100, 14591077);
            uLCD.pixel(30, 100, 14656869);
            uLCD.pixel(31, 100, 14000739);
            uLCD.pixel(32, 100, 12094290);
            uLCD.pixel(33, 100, 11041602);
            uLCD.pixel(34, 100, 13013076);
            uLCD.pixel(35, 100, 12945738);
            uLCD.pixel(36, 100, 13339208);
            uLCD.pixel(37, 100, 13931347);
            uLCD.pixel(38, 100, 13800535);
            uLCD.pixel(39, 100, 13078616);
            uLCD.pixel(40, 100, 13278833);
            uLCD.pixel(41, 100, 7557679);
            uLCD.pixel(0, 101, 16498286);
            uLCD.pixel(1, 101, 16564079);
            uLCD.pixel(2, 101, 16564079);
            uLCD.pixel(3, 101, 16564079);
            uLCD.pixel(4, 101, 16564079);
            uLCD.pixel(5, 101, 16498032);
            uLCD.pixel(6, 101, 16366446);
            uLCD.pixel(7, 101, 16366446);
            uLCD.pixel(8, 101, 16694900);
            uLCD.pixel(9, 101, 16694900);
            uLCD.pixel(10, 101, 16629107);
            uLCD.pixel(11, 101, 16629107);
            uLCD.pixel(12, 101, 16629109);
            uLCD.pixel(13, 101, 16629109);
            uLCD.pixel(14, 101, 16760182);
            uLCD.pixel(15, 101, 16760436);
            uLCD.pixel(16, 101, 16562285);
            uLCD.pixel(17, 101, 16760949);
            uLCD.pixel(18, 101, 16760951);
            uLCD.pixel(19, 101, 16759666);
            uLCD.pixel(20, 101, 14983514);
            uLCD.pixel(21, 101, 16234352);
            uLCD.pixel(22, 101, 15905646);
            uLCD.pixel(23, 101, 16103541);
            uLCD.pixel(24, 101, 15446126);
            uLCD.pixel(25, 101, 13867607);
            uLCD.pixel(26, 101, 13209423);
            uLCD.pixel(27, 101, 13933916);
            uLCD.pixel(28, 101, 14591076);
            uLCD.pixel(29, 101, 14196318);
            uLCD.pixel(30, 101, 14130525);
            uLCD.pixel(31, 101, 14395243);
            uLCD.pixel(32, 101, 12291417);
            uLCD.pixel(33, 101, 14331002);
            uLCD.pixel(34, 101, 14987382);
            uLCD.pixel(35, 101, 14787943);
            uLCD.pixel(36, 101, 15312998);
            uLCD.pixel(37, 101, 14522712);
            uLCD.pixel(38, 101, 13932121);
            uLCD.pixel(39, 101, 14197613);
            uLCD.pixel(40, 101, 14924945);
            uLCD.pixel(41, 101, 8612427);
            uLCD.pixel(0, 102, 16563051);
            uLCD.pixel(1, 102, 16628844);
            uLCD.pixel(2, 102, 16760430);
            uLCD.pixel(3, 102, 16760687);
            uLCD.pixel(4, 102, 16760688);
            uLCD.pixel(5, 102, 16760689);
            uLCD.pixel(6, 102, 16760432);
            uLCD.pixel(7, 102, 16760175);
            uLCD.pixel(8, 102, 16760690);
            uLCD.pixel(9, 102, 16760433);
            uLCD.pixel(10, 102, 16760176);
            uLCD.pixel(11, 102, 16759919);
            uLCD.pixel(12, 102, 16759662);
            uLCD.pixel(13, 102, 16759662);
            uLCD.pixel(14, 102, 16759406);
            uLCD.pixel(15, 102, 16759921);
            uLCD.pixel(16, 102, 16431728);
            uLCD.pixel(17, 102, 16563827);
            uLCD.pixel(18, 102, 16564343);
            uLCD.pixel(19, 102, 15972207);
            uLCD.pixel(20, 102, 13275207);
            uLCD.pixel(21, 102, 14393947);
            uLCD.pixel(22, 102, 14197340);
            uLCD.pixel(23, 102, 14263392);
            uLCD.pixel(24, 102, 14131806);
            uLCD.pixel(25, 102, 13869150);
            uLCD.pixel(26, 102, 13869151);
            uLCD.pixel(27, 102, 14067043);
            uLCD.pixel(28, 102, 14263909);
            uLCD.pixel(29, 102, 14132323);
            uLCD.pixel(30, 102, 13934943);
            uLCD.pixel(31, 102, 13803619);
            uLCD.pixel(32, 102, 13672813);
            uLCD.pixel(33, 102, 16764314);
            uLCD.pixel(34, 102, 16302213);
            uLCD.pixel(35, 102, 16366713);
            uLCD.pixel(36, 102, 16763009);
            uLCD.pixel(37, 102, 16761721);
            uLCD.pixel(38, 102, 16564603);
            uLCD.pixel(39, 102, 15908993);
            uLCD.pixel(40, 102, 16175776);
            uLCD.pixel(41, 102, 11968120);
            uLCD.pixel(0, 103, 16562798);
            uLCD.pixel(1, 103, 16628591);
            uLCD.pixel(2, 103, 16694384);
            uLCD.pixel(3, 103, 16760177);
            uLCD.pixel(4, 103, 16760432);
            uLCD.pixel(5, 103, 16760432);
            uLCD.pixel(6, 103, 16760689);
            uLCD.pixel(7, 103, 16760176);
            uLCD.pixel(8, 103, 16759661);
            uLCD.pixel(9, 103, 16759661);
            uLCD.pixel(10, 103, 16759918);
            uLCD.pixel(11, 103, 16759918);
            uLCD.pixel(12, 103, 16759919);
            uLCD.pixel(13, 103, 16759917);
            uLCD.pixel(14, 103, 16760174);
            uLCD.pixel(15, 103, 16760432);
            uLCD.pixel(16, 103, 16762491);
            uLCD.pixel(17, 103, 16104818);
            uLCD.pixel(18, 103, 15710061);
            uLCD.pixel(19, 103, 15052645);
            uLCD.pixel(20, 103, 12552513);
            uLCD.pixel(21, 103, 14066265);
            uLCD.pixel(22, 103, 14000988);
            uLCD.pixel(23, 103, 13803611);
            uLCD.pixel(24, 103, 14001247);
            uLCD.pixel(25, 103, 14396007);
            uLCD.pixel(26, 103, 14396007);
            uLCD.pixel(27, 103, 14001762);
            uLCD.pixel(28, 103, 13935456);
            uLCD.pixel(29, 103, 14132835);
            uLCD.pixel(30, 103, 14067040);
            uLCD.pixel(31, 103, 13803871);
            uLCD.pixel(32, 103, 12421713);
            uLCD.pixel(33, 103, 14789234);
            uLCD.pixel(34, 103, 15972216);
            uLCD.pixel(35, 103, 16629367);
            uLCD.pixel(36, 103, 16431212);
            uLCD.pixel(37, 103, 16563825);
            uLCD.pixel(38, 103, 16367991);
            uLCD.pixel(39, 103, 14660209);
            uLCD.pixel(40, 103, 13610617);
            uLCD.pixel(41, 103, 11573875);
            uLCD.pixel(0, 104, 16498553);
            uLCD.pixel(1, 104, 16432760);
            uLCD.pixel(2, 104, 16497781);
            uLCD.pixel(3, 104, 16431988);
            uLCD.pixel(4, 104, 16431730);
            uLCD.pixel(5, 104, 16431728);
            uLCD.pixel(6, 104, 16562800);
            uLCD.pixel(7, 104, 16628078);
            uLCD.pixel(8, 104, 16693612);
            uLCD.pixel(9, 104, 16759149);
            uLCD.pixel(10, 104, 16759918);
            uLCD.pixel(11, 104, 16760176);
            uLCD.pixel(12, 104, 16759918);
            uLCD.pixel(13, 104, 16759915);
            uLCD.pixel(14, 104, 16759658);
            uLCD.pixel(15, 104, 16759659);
            uLCD.pixel(16, 104, 16103274);
            uLCD.pixel(17, 104, 14986337);
            uLCD.pixel(18, 104, 14591579);
            uLCD.pixel(19, 104, 14328922);
            uLCD.pixel(20, 104, 12355134);
            uLCD.pixel(21, 104, 14197851);
            uLCD.pixel(22, 104, 14329953);
            uLCD.pixel(23, 104, 14198367);
            uLCD.pixel(24, 104, 14198880);
            uLCD.pixel(25, 104, 13672282);
            uLCD.pixel(26, 104, 13672282);
            uLCD.pixel(27, 104, 14198626);
            uLCD.pixel(28, 104, 14329953);
            uLCD.pixel(29, 104, 13803609);
            uLCD.pixel(30, 104, 13935195);
            uLCD.pixel(31, 104, 14658150);
            uLCD.pixel(32, 104, 13078865);
            uLCD.pixel(33, 104, 12947022);
            uLCD.pixel(34, 104, 14656095);
            uLCD.pixel(35, 104, 15642727);
            uLCD.pixel(36, 104, 15708259);
            uLCD.pixel(37, 104, 15380323);
            uLCD.pixel(38, 104, 14132574);
            uLCD.pixel(39, 104, 13411173);
            uLCD.pixel(40, 104, 13874309);
            uLCD.pixel(41, 104, 8547917);
            uLCD.pixel(0, 105, 16563576);
            uLCD.pixel(1, 105, 16563574);
            uLCD.pixel(2, 105, 16563317);
            uLCD.pixel(3, 105, 16563317);
            uLCD.pixel(4, 105, 16629109);
            uLCD.pixel(5, 105, 16694902);
            uLCD.pixel(6, 105, 16694902);
            uLCD.pixel(7, 105, 16760695);
            uLCD.pixel(8, 105, 16760950);
            uLCD.pixel(9, 105, 16760693);
            uLCD.pixel(10, 105, 16760436);
            uLCD.pixel(11, 105, 16628593);
            uLCD.pixel(12, 105, 16365421);
            uLCD.pixel(13, 105, 16036454);
            uLCD.pixel(14, 105, 15707489);
            uLCD.pixel(15, 105, 15379040);
            uLCD.pixel(16, 105, 14458968);
            uLCD.pixel(17, 105, 14130777);
            uLCD.pixel(18, 105, 14196570);
            uLCD.pixel(19, 105, 14131547);
            uLCD.pixel(20, 105, 12289089);
            uLCD.pixel(21, 105, 13868123);
            uLCD.pixel(22, 105, 14000222);
            uLCD.pixel(23, 105, 14263394);
            uLCD.pixel(24, 105, 14066529);
            uLCD.pixel(25, 105, 13869150);
            uLCD.pixel(26, 105, 14000222);
            uLCD.pixel(27, 105, 14263394);
            uLCD.pixel(28, 105, 14329185);
            uLCD.pixel(29, 105, 14328672);
            uLCD.pixel(30, 105, 14262879);
            uLCD.pixel(31, 105, 14328672);
            uLCD.pixel(32, 105, 14131293);
            uLCD.pixel(33, 105, 12552515);
            uLCD.pixel(34, 105, 12748609);
            uLCD.pixel(35, 105, 12090933);
            uLCD.pixel(36, 105, 13340746);
            uLCD.pixel(37, 105, 12750153);
            uLCD.pixel(38, 105, 12488788);
            uLCD.pixel(39, 105, 14333059);
            uLCD.pixel(40, 105, 12099193);
            uLCD.pixel(41, 105, 4008723);
            uLCD.pixel(0, 106, 16758892);
            uLCD.pixel(1, 106, 16759406);
            uLCD.pixel(2, 106, 16759919);
            uLCD.pixel(3, 106, 16760433);
            uLCD.pixel(4, 106, 16760435);
            uLCD.pixel(5, 106, 16760693);
            uLCD.pixel(6, 106, 16629367);
            uLCD.pixel(7, 106, 16432760);
            uLCD.pixel(8, 106, 16104054);
            uLCD.pixel(9, 106, 15907190);
            uLCD.pixel(10, 106, 15447668);
            uLCD.pixel(11, 106, 14987632);
            uLCD.pixel(12, 106, 14527340);
            uLCD.pixel(13, 106, 14133097);
            uLCD.pixel(14, 106, 13869925);
            uLCD.pixel(15, 106, 13803619);
            uLCD.pixel(16, 106, 14327653);
            uLCD.pixel(17, 106, 14721641);
            uLCD.pixel(18, 106, 14787434);
            uLCD.pixel(19, 106, 14853486);
            uLCD.pixel(20, 106, 13274454);
            uLCD.pixel(21, 106, 14458986);
            uLCD.pixel(22, 106, 14130021);
            uLCD.pixel(23, 106, 14656365);
            uLCD.pixel(24, 106, 14261607);
            uLCD.pixel(25, 106, 14787951);
            uLCD.pixel(26, 106, 14853486);
            uLCD.pixel(27, 106, 14261349);
            uLCD.pixel(28, 106, 14261347);
            uLCD.pixel(29, 106, 14853227);
            uLCD.pixel(30, 106, 14787432);
            uLCD.pixel(31, 106, 13998427);
            uLCD.pixel(32, 106, 14460512);
            uLCD.pixel(33, 106, 14066265);
            uLCD.pixel(34, 106, 14329183);
            uLCD.pixel(35, 106, 11960639);
            uLCD.pixel(36, 106, 12487246);
            uLCD.pixel(37, 106, 11962195);
            uLCD.pixel(38, 106, 12950385);
            uLCD.pixel(39, 106, 12295293);
            uLCD.pixel(40, 106, 4270616);
            uLCD.pixel(0, 107, 16759918);
            uLCD.pixel(1, 107, 16760175);
            uLCD.pixel(2, 107, 16760433);
            uLCD.pixel(3, 107, 16760435);
            uLCD.pixel(4, 107, 16694386);
            uLCD.pixel(5, 107, 16168558);
            uLCD.pixel(6, 107, 15577451);
            uLCD.pixel(7, 107, 15249258);
            uLCD.pixel(8, 107, 14526051);
            uLCD.pixel(9, 107, 14198115);
            uLCD.pixel(10, 107, 14000996);
            uLCD.pixel(11, 107, 13804132);
            uLCD.pixel(12, 107, 13607269);
            uLCD.pixel(13, 107, 13607527);
            uLCD.pixel(14, 107, 13608297);
            uLCD.pixel(15, 107, 13870442);
            uLCD.pixel(16, 107, 14196837);
            uLCD.pixel(17, 107, 14524519);
            uLCD.pixel(18, 107, 14130276);
            uLCD.pixel(19, 107, 14393448);
            uLCD.pixel(20, 107, 13407323);
            uLCD.pixel(21, 107, 14657135);
            uLCD.pixel(22, 107, 13999205);
            uLCD.pixel(23, 107, 14459756);
            uLCD.pixel(24, 107, 14393963);
            uLCD.pixel(25, 107, 14131046);
            uLCD.pixel(26, 107, 14196069);
            uLCD.pixel(27, 107, 14393446);
            uLCD.pixel(28, 107, 14458726);
            uLCD.pixel(29, 107, 14261601);
            uLCD.pixel(30, 107, 14392674);
            uLCD.pixel(31, 107, 14591077);
            uLCD.pixel(32, 107, 14198369);
            uLCD.pixel(33, 107, 13541211);
            uLCD.pixel(34, 107, 14133865);
            uLCD.pixel(35, 107, 12489048);
            uLCD.pixel(36, 107, 13936759);
            uLCD.pixel(37, 107, 13872261);
            uLCD.pixel(38, 107, 11900538);
            uLCD.pixel(39, 107, 2690816);
            uLCD.pixel(0, 108, 16563574);
            uLCD.pixel(1, 108, 15972207);
            uLCD.pixel(2, 108, 15380070);
            uLCD.pixel(3, 108, 14919519);
            uLCD.pixel(4, 108, 14787935);
            uLCD.pixel(5, 108, 14590813);
            uLCD.pixel(6, 108, 14459742);
            uLCD.pixel(7, 108, 14197340);
            uLCD.pixel(8, 108, 14263133);
            uLCD.pixel(9, 108, 14197597);
            uLCD.pixel(10, 108, 14197599);
            uLCD.pixel(11, 108, 14197599);
            uLCD.pixel(12, 108, 14132576);
            uLCD.pixel(13, 108, 14132322);
            uLCD.pixel(14, 108, 14132322);
            uLCD.pixel(15, 108, 14198369);
            uLCD.pixel(16, 108, 14066783);
            uLCD.pixel(17, 108, 14000988);
            uLCD.pixel(18, 108, 13803868);
            uLCD.pixel(19, 108, 13803868);
            uLCD.pixel(20, 108, 14132833);
            uLCD.pixel(21, 108, 14396007);
            uLCD.pixel(22, 108, 14264934);
            uLCD.pixel(23, 108, 13870176);
            uLCD.pixel(24, 108, 13869663);
            uLCD.pixel(25, 108, 13935454);
            uLCD.pixel(26, 108, 14066783);
            uLCD.pixel(27, 108, 13935195);
            uLCD.pixel(28, 108, 13868632);
            uLCD.pixel(29, 108, 13803093);
            uLCD.pixel(30, 108, 14065752);
            uLCD.pixel(31, 108, 14066783);
            uLCD.pixel(32, 108, 13278817);
            uLCD.pixel(33, 108, 13740659);
            uLCD.pixel(34, 108, 12951660);
            uLCD.pixel(35, 108, 13872770);
            uLCD.pixel(36, 108, 14794909);
            uLCD.pixel(37, 108, 9598812);
            uLCD.pixel(38, 108, 2757381);
            uLCD.pixel(0, 109, 14065500);
            uLCD.pixel(1, 109, 14197086);
            uLCD.pixel(2, 109, 14328672);
            uLCD.pixel(3, 109, 14394465);
            uLCD.pixel(4, 109, 14394465);
            uLCD.pixel(5, 109, 14262879);
            uLCD.pixel(6, 109, 14131293);
            uLCD.pixel(7, 109, 13999961);
            uLCD.pixel(8, 109, 14065754);
            uLCD.pixel(9, 109, 14131545);
            uLCD.pixel(10, 109, 14263131);
            uLCD.pixel(11, 109, 14525533);
            uLCD.pixel(12, 109, 14657119);
            uLCD.pixel(13, 109, 14525533);
            uLCD.pixel(14, 109, 14262361);
            uLCD.pixel(15, 109, 13737818);
            uLCD.pixel(16, 109, 13673573);
            uLCD.pixel(17, 109, 13938288);
            uLCD.pixel(18, 109, 14333046);
            uLCD.pixel(19, 109, 13873011);
            uLCD.pixel(20, 109, 13149288);
            uLCD.pixel(21, 109, 12688737);
            uLCD.pixel(22, 109, 12886116);
            uLCD.pixel(23, 109, 13280874);
            uLCD.pixel(24, 109, 13873011);
            uLCD.pixel(25, 109, 13873009);
            uLCD.pixel(26, 109, 14069874);
            uLCD.pixel(27, 109, 14069873);
            uLCD.pixel(28, 109, 14200946);
            uLCD.pixel(29, 109, 14135407);
            uLCD.pixel(30, 109, 14069101);
            uLCD.pixel(31, 109, 13871984);
            uLCD.pixel(32, 109, 13872769);
            uLCD.pixel(33, 109, 14268819);
            uLCD.pixel(34, 109, 13348235);
            uLCD.pixel(35, 109, 10914670);
            uLCD.pixel(36, 109, 7230783);
            uLCD.pixel(37, 109, 2495236);
            uLCD.pixel(0, 110, 14263911);
            uLCD.pixel(1, 110, 14198118);
            uLCD.pixel(2, 110, 14066530);
            uLCD.pixel(3, 110, 13869151);
            uLCD.pixel(4, 110, 13934429);
            uLCD.pixel(5, 110, 14066015);
            uLCD.pixel(6, 110, 14394980);
            uLCD.pixel(7, 110, 14723430);
            uLCD.pixel(8, 110, 14789223);
            uLCD.pixel(9, 110, 14525535);
            uLCD.pixel(10, 110, 14130777);
            uLCD.pixel(11, 110, 14064471);
            uLCD.pixel(12, 110, 14327641);
            uLCD.pixel(13, 110, 14722399);
            uLCD.pixel(14, 110, 14985825);
            uLCD.pixel(15, 110, 14593135);
            uLCD.pixel(16, 110, 13544836);
            uLCD.pixel(17, 110, 11309940);
            uLCD.pixel(18, 110, 8744013);
            uLCD.pixel(19, 110, 6375979);
            uLCD.pixel(20, 110, 4533775);
            uLCD.pixel(21, 110, 3481088);
            uLCD.pixel(22, 110, 3349504);
            uLCD.pixel(23, 110, 3744259);
            uLCD.pixel(24, 110, 4270603);
            uLCD.pixel(25, 110, 5454877);
            uLCD.pixel(26, 110, 7428154);
            uLCD.pixel(27, 110, 9467736);
            uLCD.pixel(28, 110, 10848876);
            uLCD.pixel(29, 110, 10849130);
            uLCD.pixel(30, 110, 10058844);
            uLCD.pixel(31, 110, 9006673);
            uLCD.pixel(32, 110, 6769719);
            uLCD.pixel(33, 110, 4599583);
            uLCD.pixel(34, 110, 3152396);
            uLCD.pixel(35, 110, 2363651);
            uLCD.pixel(0, 111, 13868383);
            uLCD.pixel(1, 111, 13934174);
            uLCD.pixel(2, 111, 14065762);
            uLCD.pixel(3, 111, 14000739);
            uLCD.pixel(4, 111, 14000739);
            uLCD.pixel(5, 111, 13869412);
            uLCD.pixel(6, 111, 13737826);
            uLCD.pixel(7, 111, 13540706);
            uLCD.pixel(8, 111, 13409121);
            uLCD.pixel(9, 111, 13803879);
            uLCD.pixel(10, 111, 14330739);
            uLCD.pixel(11, 111, 14791290);
            uLCD.pixel(12, 111, 14462840);
            uLCD.pixel(13, 111, 13212773);
            uLCD.pixel(14, 111, 11436362);
            uLCD.pixel(15, 111, 9727811);
            uLCD.pixel(16, 111, 5191970);
            uLCD.pixel(17, 111, 2759697);
            uLCD.pixel(0, 112, 14721120);
            uLCD.pixel(1, 112, 14524511);
            uLCD.pixel(2, 112, 14524770);
            uLCD.pixel(3, 112, 14591593);
            uLCD.pixel(4, 112, 14790003);
            uLCD.pixel(5, 112, 14724729);
            uLCD.pixel(6, 112, 14068345);
            uLCD.pixel(7, 112, 13543547);
            uLCD.pixel(8, 112, 12952699);
            uLCD.pixel(9, 112, 11637613);
            uLCD.pixel(10, 112, 9533783);
            uLCD.pixel(11, 112, 7363390);
            uLCD.pixel(12, 112, 5192997);
            uLCD.pixel(13, 112, 3219979);
            uLCD.pixel(0, 113, 14527352);
            uLCD.pixel(1, 113, 13870192);
            uLCD.pixel(2, 113, 13080936);
            uLCD.pixel(3, 113, 11963230);
            uLCD.pixel(4, 113, 10582607);
            uLCD.pixel(5, 113, 8609850);
            uLCD.pixel(6, 113, 6374177);
            uLCD.pixel(7, 113, 4730641);
            uLCD.pixel(8, 113, 2297600);
            uLCD.pixel(0, 114, 7167561);
            uLCD.pixel(1, 114, 5654324);
            uLCD.pixel(2, 114, 3286290);
        }

        // Draw right Rock
        void drawRightRock() {
            uLCD.pixel(89, 76, 3087631);
            uLCD.pixel(90, 76, 8087123);
            uLCD.pixel(91, 76, 7888715);
            uLCD.pixel(92, 76, 6112302);
            uLCD.pixel(93, 76, 3086594);
            uLCD.pixel(89, 77, 9796961);
            uLCD.pixel(90, 77, 15322536);
            uLCD.pixel(91, 77, 16045227);
            uLCD.pixel(92, 77, 15518624);
            uLCD.pixel(93, 77, 13545347);
            uLCD.pixel(94, 77, 10255960);
            uLCD.pixel(95, 77, 3874818);
            uLCD.pixel(96, 77, 2033920);
            uLCD.pixel(97, 77, 2166272);
            uLCD.pixel(88, 78, 4006664);
            uLCD.pixel(89, 78, 14663828);
            uLCD.pixel(90, 78, 15583888);
            uLCD.pixel(91, 78, 14398579);
            uLCD.pixel(92, 78, 14793076);
            uLCD.pixel(93, 78, 16437647);
            uLCD.pixel(94, 78, 16240278);
            uLCD.pixel(95, 78, 14596492);
            uLCD.pixel(96, 78, 11834228);
            uLCD.pixel(97, 78, 4202765);
            uLCD.pixel(88, 79, 7098157);
            uLCD.pixel(89, 79, 16504994);
            uLCD.pixel(90, 79, 15910787);
            uLCD.pixel(91, 79, 15449198);
            uLCD.pixel(92, 79, 16765311);
            uLCD.pixel(93, 79, 15579755);
            uLCD.pixel(94, 79, 14790763);
            uLCD.pixel(95, 79, 16567701);
            uLCD.pixel(96, 79, 15516055);
            uLCD.pixel(97, 79, 15516842);
            uLCD.pixel(98, 79, 7096119);
            uLCD.pixel(88, 80, 11176548);
            uLCD.pixel(89, 80, 16108692);
            uLCD.pixel(90, 80, 15711865);
            uLCD.pixel(91, 80, 16500342);
            uLCD.pixel(92, 80, 15314779);
            uLCD.pixel(93, 80, 15577951);
            uLCD.pixel(94, 80, 16766090);
            uLCD.pixel(95, 80, 15776120);
            uLCD.pixel(96, 80, 15316868);
            uLCD.pixel(97, 80, 15515542);
            uLCD.pixel(98, 80, 16371120);
            uLCD.pixel(99, 80, 6110249);
            uLCD.pixel(87, 81, 2823424);
            uLCD.pixel(88, 81, 14465684);
            uLCD.pixel(89, 81, 16108181);
            uLCD.pixel(90, 81, 15184496);
            uLCD.pixel(91, 81, 14327635);
            uLCD.pixel(92, 81, 13339194);
            uLCD.pixel(93, 81, 16299879);
            uLCD.pixel(94, 81, 16562798);
            uLCD.pixel(95, 81, 15643244);
            uLCD.pixel(96, 81, 15710074);
            uLCD.pixel(97, 81, 16171918);
            uLCD.pixel(98, 81, 14264956);
            uLCD.pixel(99, 81, 15254690);
            uLCD.pixel(100, 81, 3679510);
            uLCD.pixel(86, 82, 2628873);
            uLCD.pixel(87, 82, 4929051);
            uLCD.pixel(88, 82, 12820860);
            uLCD.pixel(89, 82, 14659716);
            uLCD.pixel(90, 82, 15380858);
            uLCD.pixel(91, 82, 14194265);
            uLCD.pixel(92, 82, 13337666);
            uLCD.pixel(93, 82, 14061642);
            uLCD.pixel(94, 82, 14785365);
            uLCD.pixel(95, 82, 16764037);
            uLCD.pixel(96, 82, 16763010);
            uLCD.pixel(97, 82, 16171389);
            uLCD.pixel(98, 82, 16567434);
            uLCD.pixel(99, 82, 14728071);
            uLCD.pixel(100, 82, 9403235);
            uLCD.pixel(85, 83, 2893326);
            uLCD.pixel(86, 83, 11772802);
            uLCD.pixel(87, 83, 14401432);
            uLCD.pixel(88, 83, 14134659);
            uLCD.pixel(89, 83, 13671790);
            uLCD.pixel(90, 83, 14722676);
            uLCD.pixel(91, 83, 13668699);
            uLCD.pixel(92, 83, 11759925);
            uLCD.pixel(93, 83, 13404231);
            uLCD.pixel(94, 83, 13733450);
            uLCD.pixel(95, 83, 14522964);
            uLCD.pixel(96, 83, 16366195);
            uLCD.pixel(97, 83, 15775341);
            uLCD.pixel(98, 83, 15908466);
            uLCD.pixel(99, 83, 16240270);
            uLCD.pixel(100, 83, 15453868);
            uLCD.pixel(101, 83, 4534817);
            uLCD.pixel(85, 84, 9797990);
            uLCD.pixel(86, 84, 14268555);
            uLCD.pixel(87, 84, 14068596);
            uLCD.pixel(88, 84, 14197867);
            uLCD.pixel(89, 84, 14394218);
            uLCD.pixel(90, 84, 13604449);
            uLCD.pixel(91, 84, 11170621);
            uLCD.pixel(92, 84, 14197350);
            uLCD.pixel(93, 84, 13012815);
            uLCD.pixel(94, 84, 12156222);
            uLCD.pixel(95, 84, 13602639);
            uLCD.pixel(96, 84, 16761729);
            uLCD.pixel(97, 84, 16103025);
            uLCD.pixel(98, 84, 16565110);
            uLCD.pixel(99, 84, 16303743);
            uLCD.pixel(100, 84, 15582099);
            uLCD.pixel(101, 84, 13478027);
            uLCD.pixel(102, 84, 2491648);
            uLCD.pixel(85, 85, 13085838);
            uLCD.pixel(86, 85, 12753511);
            uLCD.pixel(87, 85, 13079894);
            uLCD.pixel(88, 85, 14327904);
            uLCD.pixel(89, 85, 13537876);
            uLCD.pixel(90, 85, 12486481);
            uLCD.pixel(91, 85, 13671784);
            uLCD.pixel(92, 85, 14264429);
            uLCD.pixel(93, 85, 13606238);
            uLCD.pixel(94, 85, 12157506);
            uLCD.pixel(95, 85, 14590306);
            uLCD.pixel(96, 85, 16628860);
            uLCD.pixel(97, 85, 16761213);
            uLCD.pixel(98, 85, 16169067);
            uLCD.pixel(99, 85, 15775853);
            uLCD.pixel(100, 85, 15711875);
            uLCD.pixel(101, 85, 15581847);
            uLCD.pixel(102, 85, 9727312);
            uLCD.pixel(103, 85, 2031616);
            uLCD.pixel(104, 85, 2164997);
            uLCD.pixel(84, 86, 2035456);
            uLCD.pixel(85, 86, 12296322);
            uLCD.pixel(86, 86, 13016683);
            uLCD.pixel(87, 86, 12553550);
            uLCD.pixel(88, 86, 13012044);
            uLCD.pixel(89, 86, 13208911);
            uLCD.pixel(90, 86, 13473374);
            uLCD.pixel(91, 86, 14000747);
            uLCD.pixel(92, 86, 14132843);
            uLCD.pixel(93, 86, 14000996);
            uLCD.pixel(94, 86, 12749643);
            uLCD.pixel(95, 86, 14327134);
            uLCD.pixel(96, 86, 16234361);
            uLCD.pixel(97, 86, 16761985);
            uLCD.pixel(98, 86, 16367216);
            uLCD.pixel(99, 86, 16171379);
            uLCD.pixel(100, 86, 15843453);
            uLCD.pixel(101, 86, 16108179);
            uLCD.pixel(102, 86, 15122324);
            uLCD.pixel(103, 86, 5650200);
            uLCD.pixel(105, 86, 2167307);
            uLCD.pixel(85, 87, 6309160);
            uLCD.pixel(86, 87, 13477234);
            uLCD.pixel(87, 87, 12487757);
            uLCD.pixel(88, 87, 13275216);
            uLCD.pixel(89, 87, 14130013);
            uLCD.pixel(90, 87, 14920307);
            uLCD.pixel(91, 87, 14000234);
            uLCD.pixel(92, 87, 14198379);
            uLCD.pixel(93, 87, 14593133);
            uLCD.pixel(94, 87, 14459491);
            uLCD.pixel(95, 87, 13011274);
            uLCD.pixel(96, 87, 16761733);
            uLCD.pixel(97, 87, 16234613);
            uLCD.pixel(98, 87, 16367218);
            uLCD.pixel(99, 87, 16368756);
            uLCD.pixel(100, 87, 16238459);
            uLCD.pixel(101, 87, 15647615);
            uLCD.pixel(102, 87, 15385480);
            uLCD.pixel(103, 87, 12689778);
            uLCD.pixel(104, 87, 3020032);
            uLCD.pixel(85, 88, 5322265);
            uLCD.pixel(86, 88, 13871992);
            uLCD.pixel(87, 88, 12553550);
            uLCD.pixel(88, 88, 14327645);
            uLCD.pixel(89, 88, 13011531);
            uLCD.pixel(90, 88, 12091463);
            uLCD.pixel(91, 88, 12487249);
            uLCD.pixel(92, 88, 12619345);
            uLCD.pixel(93, 88, 13540699);
            uLCD.pixel(94, 88, 13735767);
            uLCD.pixel(95, 88, 11103275);
            uLCD.pixel(96, 88, 16762761);
            uLCD.pixel(97, 88, 16037234);
            uLCD.pixel(98, 88, 15972973);
            uLCD.pixel(99, 88, 16171631);
            uLCD.pixel(100, 88, 16237681);
            uLCD.pixel(101, 88, 15844467);
            uLCD.pixel(102, 88, 14924911);
            uLCD.pixel(103, 88, 16636827);
            uLCD.pixel(104, 88, 10651482);
            uLCD.pixel(85, 89, 9927775);
            uLCD.pixel(86, 89, 15714196);
            uLCD.pixel(87, 89, 15251063);
            uLCD.pixel(88, 89, 16301435);
            uLCD.pixel(89, 89, 16103543);
            uLCD.pixel(90, 89, 15775871);
            uLCD.pixel(91, 89, 15579519);
            uLCD.pixel(92, 89, 13474654);
            uLCD.pixel(93, 89, 13934944);
            uLCD.pixel(94, 89, 13077837);
            uLCD.pixel(95, 89, 10840103);
            uLCD.pixel(96, 89, 16300154);
            uLCD.pixel(97, 89, 16695164);
            uLCD.pixel(98, 89, 16170098);
            uLCD.pixel(99, 89, 16697205);
            uLCD.pixel(100, 89, 15776354);
            uLCD.pixel(101, 89, 16369518);
            uLCD.pixel(102, 89, 16305014);
            uLCD.pixel(103, 89, 15056756);
            uLCD.pixel(104, 89, 15847578);
            uLCD.pixel(105, 89, 8283203);
            uLCD.pixel(85, 90, 13349011);
            uLCD.pixel(86, 90, 15977368);
            uLCD.pixel(87, 90, 16106626);
            uLCD.pixel(88, 90, 15775089);
            uLCD.pixel(89, 90, 16629885);
            uLCD.pixel(90, 90, 16763022);
            uLCD.pixel(91, 90, 15644796);
            uLCD.pixel(92, 90, 16764302);
            uLCD.pixel(93, 90, 16237698);
            uLCD.pixel(94, 90, 15578225);
            uLCD.pixel(95, 90, 13471823);
            uLCD.pixel(96, 90, 15708017);
            uLCD.pixel(97, 90, 16564094);
            uLCD.pixel(98, 90, 16367991);
            uLCD.pixel(99, 90, 16499826);
            uLCD.pixel(100, 90, 15907167);
            uLCD.pixel(101, 90, 16434022);
            uLCD.pixel(102, 90, 16764533);
            uLCD.pixel(103, 90, 14462560);
            uLCD.pixel(104, 90, 15977357);
            uLCD.pixel(105, 90, 15255450);
            uLCD.pixel(106, 90, 7032631);
            uLCD.pixel(107, 90, 2823434);
            uLCD.pixel(85, 91, 13349011);
            uLCD.pixel(86, 91, 14398336);
            uLCD.pixel(87, 91, 15580282);
            uLCD.pixel(88, 91, 16762241);
            uLCD.pixel(89, 91, 16432506);
            uLCD.pixel(90, 91, 15840890);
            uLCD.pixel(91, 91, 16500103);
            uLCD.pixel(92, 91, 16171906);
            uLCD.pixel(93, 91, 15514229);
            uLCD.pixel(94, 91, 16764041);
            uLCD.pixel(95, 91, 15314540);
            uLCD.pixel(96, 91, 15445360);
            uLCD.pixel(97, 91, 15840373);
            uLCD.pixel(98, 91, 16499577);
            uLCD.pixel(99, 91, 15776103);
            uLCD.pixel(100, 91, 16761706);
            uLCD.pixel(101, 91, 16564068);
            uLCD.pixel(102, 91, 16038756);
            uLCD.pixel(103, 91, 16765058);
            uLCD.pixel(104, 91, 15646587);
            uLCD.pixel(105, 91, 15056004);
            uLCD.pixel(106, 91, 15912869);
            uLCD.pixel(107, 91, 6571815);
            uLCD.pixel(85, 92, 10717293);
            uLCD.pixel(86, 92, 14135163);
            uLCD.pixel(87, 92, 13803870);
            uLCD.pixel(88, 92, 15051364);
            uLCD.pixel(89, 92, 14523993);
            uLCD.pixel(90, 92, 14985835);
            uLCD.pixel(91, 92, 14657897);
            uLCD.pixel(92, 92, 14658666);
            uLCD.pixel(93, 92, 14461539);
            uLCD.pixel(94, 92, 15380844);
            uLCD.pixel(95, 92, 14196059);
            uLCD.pixel(96, 92, 14129500);
            uLCD.pixel(97, 92, 16103802);
            uLCD.pixel(98, 92, 16434300);
            uLCD.pixel(99, 92, 16170350);
            uLCD.pixel(100, 92, 16760940);
            uLCD.pixel(101, 92, 16760170);
            uLCD.pixel(102, 92, 16694382);
            uLCD.pixel(103, 92, 16498036);
            uLCD.pixel(104, 92, 16105337);
            uLCD.pixel(105, 92, 15843454);
            uLCD.pixel(106, 92, 15449986);
            uLCD.pixel(107, 92, 14925701);
            uLCD.pixel(108, 92, 12492138);
            uLCD.pixel(109, 92, 11572071);
            uLCD.pixel(110, 92, 9730131);
            uLCD.pixel(111, 92, 7033395);
            uLCD.pixel(112, 92, 4599314);
            uLCD.pixel(113, 92, 2888704);
            uLCD.pixel(85, 93, 6703920);
            uLCD.pixel(86, 93, 13608819);
            uLCD.pixel(87, 93, 13934943);
            uLCD.pixel(88, 93, 14853728);
            uLCD.pixel(89, 93, 14523991);
            uLCD.pixel(90, 93, 14787942);
            uLCD.pixel(91, 93, 14921069);
            uLCD.pixel(92, 93, 14000990);
            uLCD.pixel(93, 93, 13737816);
            uLCD.pixel(94, 93, 14854500);
            uLCD.pixel(95, 93, 13209164);
            uLCD.pixel(96, 93, 12418882);
            uLCD.pixel(97, 93, 16432768);
            uLCD.pixel(98, 93, 15578993);
            uLCD.pixel(99, 93, 16301684);
            uLCD.pixel(100, 93, 16760431);
            uLCD.pixel(101, 93, 16759661);
            uLCD.pixel(102, 93, 16759153);
            uLCD.pixel(103, 93, 16628340);
            uLCD.pixel(104, 93, 16563576);
            uLCD.pixel(105, 93, 16367991);
            uLCD.pixel(106, 93, 16040822);
            uLCD.pixel(107, 93, 15910007);
            uLCD.pixel(108, 93, 15187833);
            uLCD.pixel(109, 93, 15583113);
            uLCD.pixel(110, 93, 15977884);
            uLCD.pixel(111, 93, 15715492);
            uLCD.pixel(112, 93, 14925723);
            uLCD.pixel(113, 93, 13544583);
            uLCD.pixel(114, 93, 12097647);
            uLCD.pixel(115, 93, 11111522);
            uLCD.pixel(116, 93, 8216640);
            uLCD.pixel(117, 93, 7559227);
            uLCD.pixel(118, 93, 6835504);
            uLCD.pixel(119, 93, 6045990);
            uLCD.pixel(120, 93, 5388317);
            uLCD.pixel(121, 93, 4796182);
            uLCD.pixel(122, 93, 4204045);
            uLCD.pixel(123, 93, 3809289);
            uLCD.pixel(124, 93, 3085824);
            uLCD.pixel(125, 93, 2888448);
            uLCD.pixel(126, 93, 2559488);
            uLCD.pixel(127, 93, 2231296);
            uLCD.pixel(85, 94, 2295808);
            uLCD.pixel(86, 94, 12424288);
            uLCD.pixel(87, 94, 13211220);
            uLCD.pixel(88, 94, 13472073);
            uLCD.pixel(89, 94, 13471303);
            uLCD.pixel(90, 94, 13011531);
            uLCD.pixel(91, 94, 13539158);
            uLCD.pixel(92, 94, 13605460);
            uLCD.pixel(93, 94, 13474128);
            uLCD.pixel(94, 94, 14130777);
            uLCD.pixel(95, 94, 12485441);
            uLCD.pixel(96, 94, 12550468);
            uLCD.pixel(97, 94, 16103803);
            uLCD.pixel(98, 94, 16105594);
            uLCD.pixel(99, 94, 16565370);
            uLCD.pixel(100, 94, 16760180);
            uLCD.pixel(101, 94, 16759154);
            uLCD.pixel(102, 94, 16758389);
            uLCD.pixel(103, 94, 16693109);
            uLCD.pixel(104, 94, 16694132);
            uLCD.pixel(105, 94, 16629872);
            uLCD.pixel(106, 94, 16499818);
            uLCD.pixel(107, 94, 16369259);
            uLCD.pixel(108, 94, 15909485);
            uLCD.pixel(109, 94, 15712115);
            uLCD.pixel(110, 94, 15646082);
            uLCD.pixel(111, 94, 15646862);
            uLCD.pixel(112, 94, 15712402);
            uLCD.pixel(113, 94, 15647379);
            uLCD.pixel(114, 94, 15779727);
            uLCD.pixel(115, 94, 15977357);
            uLCD.pixel(116, 94, 16700821);
            uLCD.pixel(117, 94, 16503440);
            uLCD.pixel(118, 94, 16174475);
            uLCD.pixel(119, 94, 15977098);
            uLCD.pixel(120, 94, 15780232);
            uLCD.pixel(121, 94, 15648392);
            uLCD.pixel(122, 94, 15385220);
            uLCD.pixel(123, 94, 15253635);
            uLCD.pixel(124, 94, 14924670);
            uLCD.pixel(125, 94, 14661500);
            uLCD.pixel(126, 94, 14332281);
            uLCD.pixel(127, 94, 14069622);
            uLCD.pixel(85, 95, 4203786);
            uLCD.pixel(86, 95, 14200699);
            uLCD.pixel(87, 95, 14724459);
            uLCD.pixel(88, 95, 14918749);
            uLCD.pixel(89, 95, 15050077);
            uLCD.pixel(90, 95, 14327645);
            uLCD.pixel(91, 95, 14394467);
            uLCD.pixel(92, 95, 13671253);
            uLCD.pixel(93, 95, 13803093);
            uLCD.pixel(94, 95, 13604433);
            uLCD.pixel(95, 95, 12288062);
            uLCD.pixel(96, 95, 13603156);
            uLCD.pixel(97, 95, 13604182);
            uLCD.pixel(98, 95, 16105596);
            uLCD.pixel(99, 95, 15710577);
            uLCD.pixel(100, 95, 16759926);
            uLCD.pixel(101, 95, 16759157);
            uLCD.pixel(102, 95, 16758904);
            uLCD.pixel(103, 95, 16693363);
            uLCD.pixel(104, 95, 16693873);
            uLCD.pixel(105, 95, 16628842);
            uLCD.pixel(106, 95, 16564066);
            uLCD.pixel(107, 95, 16367970);
            uLCD.pixel(108, 95, 16762989);
            uLCD.pixel(109, 95, 16236654);
            uLCD.pixel(110, 95, 15776118);
            uLCD.pixel(111, 95, 15710589);
            uLCD.pixel(112, 95, 15645313);
            uLCD.pixel(113, 95, 15645312);
            uLCD.pixel(114, 95, 15777660);
            uLCD.pixel(115, 95, 16172155);
            uLCD.pixel(116, 95, 15579755);
            uLCD.pixel(117, 95, 15579240);
            uLCD.pixel(118, 95, 15645033);
            uLCD.pixel(119, 95, 15842412);
            uLCD.pixel(120, 95, 15974513);
            uLCD.pixel(121, 95, 16106099);
            uLCD.pixel(122, 95, 16105845);
            uLCD.pixel(123, 95, 16105845);
            uLCD.pixel(124, 95, 16368505);
            uLCD.pixel(125, 95, 16303225);
            uLCD.pixel(126, 95, 16302714);
            uLCD.pixel(127, 95, 16303227);
            uLCD.pixel(85, 96, 9204054);
            uLCD.pixel(86, 96, 16371868);
            uLCD.pixel(87, 96, 16171905);
            uLCD.pixel(88, 96, 16629622);
            uLCD.pixel(89, 96, 16761723);
            uLCD.pixel(90, 96, 16761471);
            uLCD.pixel(91, 96, 16433534);
            uLCD.pixel(92, 96, 16237434);
            uLCD.pixel(93, 96, 16040053);
            uLCD.pixel(94, 96, 15907186);
            uLCD.pixel(95, 96, 14656610);
            uLCD.pixel(96, 96, 14722150);
            uLCD.pixel(97, 96, 13012045);
            uLCD.pixel(98, 96, 15579252);
            uLCD.pixel(99, 96, 16697731);
            uLCD.pixel(100, 96, 16431992);
            uLCD.pixel(101, 96, 16694135);
            uLCD.pixel(102, 96, 16759672);
            uLCD.pixel(103, 96, 16759923);
            uLCD.pixel(104, 96, 16759918);
            uLCD.pixel(105, 96, 16760169);
            uLCD.pixel(106, 96, 16629093);
            uLCD.pixel(107, 96, 16629093);
            uLCD.pixel(108, 96, 16432231);
            uLCD.pixel(109, 96, 16432493);
            uLCD.pixel(110, 96, 16695160);
            uLCD.pixel(111, 96, 16761985);
            uLCD.pixel(112, 96, 16762241);
            uLCD.pixel(113, 96, 16498810);
            uLCD.pixel(114, 96, 16039023);
            uLCD.pixel(115, 96, 15907178);
            uLCD.pixel(116, 96, 16630136);
            uLCD.pixel(117, 96, 16760953);
            uLCD.pixel(118, 96, 16695160);
            uLCD.pixel(119, 96, 16695160);
            uLCD.pixel(120, 96, 16629369);
            uLCD.pixel(121, 96, 16563576);
            uLCD.pixel(122, 96, 16431992);
            uLCD.pixel(123, 96, 16366199);
            uLCD.pixel(124, 96, 16563067);
            uLCD.pixel(125, 96, 16497531);
            uLCD.pixel(126, 96, 16628860);
            uLCD.pixel(127, 96, 16629117);
            uLCD.pixel(85, 97, 11243637);
            uLCD.pixel(86, 97, 16371613);
            uLCD.pixel(87, 97, 15645561);
            uLCD.pixel(88, 97, 16366450);
            uLCD.pixel(89, 97, 16629107);
            uLCD.pixel(90, 97, 16762239);
            uLCD.pixel(91, 97, 16433532);
            uLCD.pixel(92, 97, 16434813);
            uLCD.pixel(93, 97, 15974260);
            uLCD.pixel(94, 97, 16630909);
            uLCD.pixel(95, 97, 15117159);
            uLCD.pixel(96, 97, 13274706);
            uLCD.pixel(97, 97, 13406549);
            uLCD.pixel(98, 97, 13145681);
            uLCD.pixel(99, 97, 16697733);
            uLCD.pixel(100, 97, 16038263);
            uLCD.pixel(101, 97, 16431992);
            uLCD.pixel(102, 97, 16694902);
            uLCD.pixel(103, 97, 16760945);
            uLCD.pixel(104, 97, 16760942);
            uLCD.pixel(105, 97, 16760683);
            uLCD.pixel(106, 97, 16760426);
            uLCD.pixel(107, 97, 16760174);
            uLCD.pixel(108, 97, 16760692);
            uLCD.pixel(109, 97, 16760950);
            uLCD.pixel(110, 97, 16760182);
            uLCD.pixel(111, 97, 16497521);
            uLCD.pixel(112, 97, 16431982);
            uLCD.pixel(113, 97, 16629359);
            uLCD.pixel(114, 97, 16761455);
            uLCD.pixel(115, 97, 16761457);
            uLCD.pixel(116, 97, 16497521);
            uLCD.pixel(117, 97, 16497523);
            uLCD.pixel(118, 97, 16563316);
            uLCD.pixel(119, 97, 16629109);
            uLCD.pixel(120, 97, 16629110);
            uLCD.pixel(121, 97, 16629110);
            uLCD.pixel(122, 97, 16759928);
            uLCD.pixel(123, 97, 16759928);
            uLCD.pixel(124, 97, 16760188);
            uLCD.pixel(125, 97, 16693881);
            uLCD.pixel(126, 97, 16562295);
            uLCD.pixel(127, 97, 16496502);
            uLCD.pixel(85, 98, 9006675);
            uLCD.pixel(86, 98, 15318925);
            uLCD.pixel(87, 98, 15185010);
            uLCD.pixel(88, 98, 16103278);
            uLCD.pixel(89, 98, 15905384);
            uLCD.pixel(90, 98, 16235381);
            uLCD.pixel(91, 98, 16038772);
            uLCD.pixel(92, 98, 15645295);
            uLCD.pixel(93, 98, 15513709);
            uLCD.pixel(94, 98, 16104565);
            uLCD.pixel(95, 98, 14393436);
            uLCD.pixel(96, 98, 13208913);
            uLCD.pixel(97, 98, 14985581);
            uLCD.pixel(98, 98, 12948048);
            uLCD.pixel(99, 98, 14987885);
            uLCD.pixel(100, 98, 16104315);
            uLCD.pixel(101, 98, 16301433);
            uLCD.pixel(102, 98, 16498800);
            uLCD.pixel(103, 98, 16695916);
            uLCD.pixel(104, 98, 16629608);
            uLCD.pixel(105, 98, 16760426);
            uLCD.pixel(106, 98, 16759921);
            uLCD.pixel(107, 98, 16759927);
            uLCD.pixel(108, 98, 16430452);
            uLCD.pixel(109, 98, 16760188);
            uLCD.pixel(110, 98, 16760696);
            uLCD.pixel(111, 98, 16562539);
            uLCD.pixel(112, 98, 16431204);
            uLCD.pixel(113, 98, 16694887);
            uLCD.pixel(114, 98, 16760680);
            uLCD.pixel(115, 98, 16366438);
            uLCD.pixel(116, 98, 16629869);
            uLCD.pixel(117, 98, 16499055);
            uLCD.pixel(118, 98, 16629872);
            uLCD.pixel(119, 98, 16629872);
            uLCD.pixel(120, 98, 16629872);
            uLCD.pixel(121, 98, 16629872);
            uLCD.pixel(122, 98, 16695152);
            uLCD.pixel(123, 98, 16695152);
            uLCD.pixel(124, 98, 16760947);
            uLCD.pixel(125, 98, 16629361);
            uLCD.pixel(126, 98, 16497775);
            uLCD.pixel(127, 98, 16431982);
            uLCD.pixel(85, 99, 4072721);
            uLCD.pixel(86, 99, 12754289);
            uLCD.pixel(87, 99, 13869672);
            uLCD.pixel(88, 99, 15051368);
            uLCD.pixel(89, 99, 14721370);
            uLCD.pixel(90, 99, 14919521);
            uLCD.pixel(91, 99, 15182950);
            uLCD.pixel(92, 99, 14592094);
            uLCD.pixel(93, 99, 14921572);
            uLCD.pixel(94, 99, 14460512);
            uLCD.pixel(95, 99, 12552261);
            uLCD.pixel(96, 99, 13604698);
            uLCD.pixel(97, 99, 15052657);
            uLCD.pixel(98, 99, 13145940);
            uLCD.pixel(99, 99, 11698494);
            uLCD.pixel(100, 99, 16170879);
            uLCD.pixel(101, 99, 16367741);
            uLCD.pixel(102, 99, 16367988);
            uLCD.pixel(103, 99, 16302189);
            uLCD.pixel(104, 99, 16235881);
            uLCD.pixel(105, 99, 16300907);
            uLCD.pixel(106, 99, 16431731);
            uLCD.pixel(107, 99, 16628090);
            uLCD.pixel(108, 99, 15772270);
            uLCD.pixel(109, 99, 16627577);
            uLCD.pixel(110, 99, 16760953);
            uLCD.pixel(111, 99, 16694124);
            uLCD.pixel(112, 99, 16563047);
            uLCD.pixel(113, 99, 16761708);
            uLCD.pixel(114, 99, 16761965);
            uLCD.pixel(115, 99, 16498024);
            uLCD.pixel(116, 99, 16367467);
            uLCD.pixel(117, 99, 16302189);
            uLCD.pixel(118, 99, 16367469);
            uLCD.pixel(119, 99, 16367469);
            uLCD.pixel(120, 99, 16301676);
            uLCD.pixel(121, 99, 16367469);
            uLCD.pixel(122, 99, 16564078);
            uLCD.pixel(123, 99, 16629871);
            uLCD.pixel(124, 99, 16432492);
            uLCD.pixel(125, 99, 16498285);
            uLCD.pixel(126, 99, 16629358);
            uLCD.pixel(127, 99, 16695151);
            uLCD.pixel(86, 100, 7097395);
            uLCD.pixel(87, 100, 13410679);
            uLCD.pixel(88, 100, 13539169);
            uLCD.pixel(89, 100, 13077067);
            uLCD.pixel(90, 100, 14655579);
            uLCD.pixel(91, 100, 12944959);
            uLCD.pixel(92, 100, 13012548);
            uLCD.pixel(93, 100, 13408081);
            uLCD.pixel(94, 100, 10974771);
            uLCD.pixel(95, 100, 12488268);
            uLCD.pixel(96, 100, 13869923);
            uLCD.pixel(97, 100, 14330472);
            uLCD.pixel(98, 100, 14330214);
            uLCD.pixel(99, 100, 13408599);
            uLCD.pixel(100, 100, 12881490);
            uLCD.pixel(101, 100, 13670493);
            uLCD.pixel(102, 100, 14920811);
            uLCD.pixel(103, 100, 16433534);
            uLCD.pixel(104, 100, 16498812);
            uLCD.pixel(105, 100, 16301433);
            uLCD.pixel(106, 100, 16366713);
            uLCD.pixel(107, 100, 15247464);
            uLCD.pixel(108, 100, 15905135);
            uLCD.pixel(109, 100, 16365684);
            uLCD.pixel(110, 100, 16760695);
            uLCD.pixel(111, 100, 16760693);
            uLCD.pixel(112, 100, 16695152);
            uLCD.pixel(113, 100, 16695152);
            uLCD.pixel(114, 100, 16695152);
            uLCD.pixel(115, 100, 16432493);
            uLCD.pixel(116, 100, 16433011);
            uLCD.pixel(117, 100, 16367731);
            uLCD.pixel(118, 100, 16433011);
            uLCD.pixel(119, 100, 16433011);
            uLCD.pixel(120, 100, 16563825);
            uLCD.pixel(121, 100, 16563825);
            uLCD.pixel(122, 100, 16629872);
            uLCD.pixel(123, 100, 16629872);
            uLCD.pixel(124, 100, 16498286);
            uLCD.pixel(125, 100, 16498286);
            uLCD.pixel(126, 100, 16498286);
            uLCD.pixel(127, 100, 16498286);
            uLCD.pixel(86, 101, 8348493);
            uLCD.pixel(87, 101, 14990489);
            uLCD.pixel(88, 101, 13868909);
            uLCD.pixel(89, 101, 14590564);
            uLCD.pixel(90, 101, 13799757);
            uLCD.pixel(91, 101, 15445348);
            uLCD.pixel(92, 101, 14459227);
            uLCD.pixel(93, 101, 14658150);
            uLCD.pixel(94, 101, 14264679);
            uLCD.pixel(95, 101, 13080923);
            uLCD.pixel(96, 101, 13738853);
            uLCD.pixel(97, 101, 13606751);
            uLCD.pixel(98, 101, 13803358);
            uLCD.pixel(99, 101, 14263139);
            uLCD.pixel(100, 101, 14197348);
            uLCD.pixel(101, 101, 13342039);
            uLCD.pixel(102, 101, 13670745);
            uLCD.pixel(103, 101, 15512948);
            uLCD.pixel(104, 101, 16104569);
            uLCD.pixel(105, 101, 15644016);
            uLCD.pixel(106, 101, 15709294);
            uLCD.pixel(107, 101, 14919521);
            uLCD.pixel(108, 101, 16234609);
            uLCD.pixel(109, 101, 16498036);
            uLCD.pixel(110, 101, 16563827);
            uLCD.pixel(111, 101, 16366448);
            uLCD.pixel(112, 101, 16300653);
            uLCD.pixel(113, 101, 16498032);
            uLCD.pixel(114, 101, 16695665);
            uLCD.pixel(115, 101, 16761204);
            uLCD.pixel(116, 101, 16432243);
            uLCD.pixel(117, 101, 16366964);
            uLCD.pixel(118, 101, 16563829);
            uLCD.pixel(119, 101, 16629620);
            uLCD.pixel(120, 101, 16694900);
            uLCD.pixel(121, 101, 16563568);
            uLCD.pixel(122, 101, 16497775);
            uLCD.pixel(123, 101, 16431980);
            uLCD.pixel(124, 101, 16760945);
            uLCD.pixel(125, 101, 16695151);
            uLCD.pixel(126, 101, 16695151);
            uLCD.pixel(127, 101, 16629358);
            uLCD.pixel(86, 102, 12691080);
            uLCD.pixel(87, 102, 16701356);
            uLCD.pixel(88, 102, 15185021);
            uLCD.pixel(89, 102, 16565120);
            uLCD.pixel(90, 102, 16695160);
            uLCD.pixel(91, 102, 16763521);
            uLCD.pixel(92, 102, 16498810);
            uLCD.pixel(93, 102, 16565634);
            uLCD.pixel(94, 102, 16766101);
            uLCD.pixel(95, 102, 13277277);
            uLCD.pixel(96, 102, 14000745);
            uLCD.pixel(97, 102, 14526061);
            uLCD.pixel(98, 102, 14525802);
            uLCD.pixel(99, 102, 14722663);
            uLCD.pixel(100, 102, 14065754);
            uLCD.pixel(101, 102, 13999957);
            uLCD.pixel(102, 102, 14065236);
            uLCD.pixel(103, 102, 14328407);
            uLCD.pixel(104, 102, 14196308);
            uLCD.pixel(105, 102, 14459734);
            uLCD.pixel(106, 102, 14722391);
            uLCD.pixel(107, 102, 13340738);
            uLCD.pixel(108, 102, 16366700);
            uLCD.pixel(109, 102, 16564079);
            uLCD.pixel(110, 102, 16760944);
            uLCD.pixel(111, 102, 16629358);
            uLCD.pixel(112, 102, 16497772);
            uLCD.pixel(113, 102, 16497772);
            uLCD.pixel(114, 102, 16563565);
            uLCD.pixel(115, 102, 16694637);
            uLCD.pixel(116, 102, 16760434);
            uLCD.pixel(117, 102, 16760434);
            uLCD.pixel(118, 102, 16760434);
            uLCD.pixel(119, 102, 16760432);
            uLCD.pixel(120, 102, 16760432);
            uLCD.pixel(121, 102, 16760431);
            uLCD.pixel(122, 102, 16760175);
            uLCD.pixel(123, 102, 16760172);
            uLCD.pixel(124, 102, 16760429);
            uLCD.pixel(125, 102, 16760172);
            uLCD.pixel(126, 102, 16759915);
            uLCD.pixel(127, 102, 16694122);
            uLCD.pixel(86, 103, 11507573);
            uLCD.pixel(87, 103, 13478012);
            uLCD.pixel(88, 103, 14856569);
            uLCD.pixel(89, 103, 16499843);
            uLCD.pixel(90, 103, 16630139);
            uLCD.pixel(91, 103, 15839851);
            uLCD.pixel(92, 103, 16630396);
            uLCD.pixel(93, 103, 15577971);
            uLCD.pixel(94, 103, 15184243);
            uLCD.pixel(95, 103, 12224076);
            uLCD.pixel(96, 103, 13999718);
            uLCD.pixel(97, 103, 14460011);
            uLCD.pixel(98, 103, 14195554);
            uLCD.pixel(99, 103, 13998427);
            uLCD.pixel(100, 103, 14328408);
            uLCD.pixel(101, 103, 14855519);
            uLCD.pixel(102, 103, 14986335);
            uLCD.pixel(103, 103, 14525784);
            uLCD.pixel(104, 103, 13999183);
            uLCD.pixel(105, 103, 14459732);
            uLCD.pixel(106, 103, 14525012);
            uLCD.pixel(107, 103, 12551222);
            uLCD.pixel(108, 103, 15445598);
            uLCD.pixel(109, 103, 15906149);
            uLCD.pixel(110, 103, 16497773);
            uLCD.pixel(111, 103, 16761202);
            uLCD.pixel(112, 103, 16761202);
            uLCD.pixel(113, 103, 16695152);
            uLCD.pixel(114, 103, 16628589);
            uLCD.pixel(115, 103, 16431212);
            uLCD.pixel(116, 103, 16760434);
            uLCD.pixel(117, 103, 16760177);
            uLCD.pixel(118, 103, 16628591);
            uLCD.pixel(119, 103, 16628332);
            uLCD.pixel(120, 103, 16628332);
            uLCD.pixel(121, 103, 16759661);
            uLCD.pixel(122, 103, 16760175);
            uLCD.pixel(123, 103, 16760687);
            uLCD.pixel(124, 103, 16759916);
            uLCD.pixel(125, 103, 16759915);
            uLCD.pixel(126, 103, 16759404);
            uLCD.pixel(127, 103, 16759404);
            uLCD.pixel(86, 104, 8678734);
            uLCD.pixel(87, 104, 14136973);
            uLCD.pixel(88, 104, 13738863);
            uLCD.pixel(89, 104, 14329450);
            uLCD.pixel(90, 104, 15512432);
            uLCD.pixel(91, 104, 15314536);
            uLCD.pixel(92, 104, 15446124);
            uLCD.pixel(93, 104, 14262111);
            uLCD.pixel(94, 104, 12618316);
            uLCD.pixel(95, 104, 13539420);
            uLCD.pixel(96, 104, 15117169);
            uLCD.pixel(97, 104, 14590566);
            uLCD.pixel(98, 104, 14589537);
            uLCD.pixel(99, 104, 14985062);
            uLCD.pixel(100, 104, 14853987);
            uLCD.pixel(101, 104, 14196568);
            uLCD.pixel(102, 104, 14064469);
            uLCD.pixel(103, 104, 14788192);
            uLCD.pixel(104, 104, 14919778);
            uLCD.pixel(105, 104, 14722399);
            uLCD.pixel(106, 104, 14393177);
            uLCD.pixel(107, 104, 12616766);
            uLCD.pixel(108, 104, 14523993);
            uLCD.pixel(109, 104, 14852958);
            uLCD.pixel(110, 104, 15444582);
            uLCD.pixel(111, 104, 16036719);
            uLCD.pixel(112, 104, 16496756);
            uLCD.pixel(113, 104, 16694135);
            uLCD.pixel(114, 104, 16759672);
            uLCD.pixel(115, 104, 16760183);
            uLCD.pixel(116, 104, 16497523);
            uLCD.pixel(117, 104, 16497521);
            uLCD.pixel(118, 104, 16431728);
            uLCD.pixel(119, 104, 16497005);
            uLCD.pixel(120, 104, 16497005);
            uLCD.pixel(121, 104, 16562539);
            uLCD.pixel(122, 104, 16628332);
            uLCD.pixel(123, 104, 16759405);
            uLCD.pixel(124, 104, 16760176);
            uLCD.pixel(125, 104, 16760175);
            uLCD.pixel(126, 104, 16759919);
            uLCD.pixel(127, 104, 16760175);
            uLCD.pixel(86, 105, 4139541);
            uLCD.pixel(87, 105, 11901048);
            uLCD.pixel(88, 105, 14726796);
            uLCD.pixel(89, 105, 12093781);
            uLCD.pixel(90, 105, 12487246);
            uLCD.pixel(91, 105, 13539159);
            uLCD.pixel(92, 105, 11696955);
            uLCD.pixel(93, 105, 13473623);
            uLCD.pixel(94, 105, 12157763);
            uLCD.pixel(95, 105, 13868381);
            uLCD.pixel(96, 105, 14130526);
            uLCD.pixel(97, 105, 13998426);
            uLCD.pixel(98, 105, 14655581);
            uLCD.pixel(99, 105, 14524509);
            uLCD.pixel(100, 105, 14262365);
            uLCD.pixel(101, 105, 14130525);
            uLCD.pixel(102, 105, 13998939);
            uLCD.pixel(103, 105, 14327904);
            uLCD.pixel(104, 105, 14130525);
            uLCD.pixel(105, 105, 14262111);
            uLCD.pixel(106, 105, 14261599);
            uLCD.pixel(107, 105, 12616774);
            uLCD.pixel(108, 105, 14655844);
            uLCD.pixel(109, 105, 14524513);
            uLCD.pixel(110, 105, 14589536);
            uLCD.pixel(111, 105, 14786915);
            uLCD.pixel(112, 105, 15115367);
            uLCD.pixel(113, 105, 15510125);
            uLCD.pixel(114, 105, 16101748);
            uLCD.pixel(115, 105, 16365688);
            uLCD.pixel(116, 105, 16235381);
            uLCD.pixel(117, 105, 16301685);
            uLCD.pixel(118, 105, 16564344);
            uLCD.pixel(119, 105, 16761465);
            uLCD.pixel(120, 105, 16761465);
            uLCD.pixel(121, 105, 16760693);
            uLCD.pixel(122, 105, 16563314);
            uLCD.pixel(123, 105, 16628593);
            uLCD.pixel(124, 105, 16760179);
            uLCD.pixel(125, 105, 16760179);
            uLCD.pixel(126, 105, 16760179);
            uLCD.pixel(127, 105, 16760179);
            uLCD.pixel(87, 106, 4269846);
            uLCD.pixel(88, 106, 13084041);
            uLCD.pixel(89, 106, 13213559);
            uLCD.pixel(90, 106, 11436111);
            uLCD.pixel(91, 106, 12685146);
            uLCD.pixel(92, 106, 11040573);
            uLCD.pixel(93, 106, 14527342);
            uLCD.pixel(94, 106, 13474652);
            uLCD.pixel(95, 106, 14330214);
            uLCD.pixel(96, 106, 13934425);
            uLCD.pixel(97, 106, 14394717);
            uLCD.pixel(98, 106, 15117410);
            uLCD.pixel(99, 106, 14525274);
            uLCD.pixel(100, 106, 14065503);
            uLCD.pixel(101, 106, 14854769);
            uLCD.pixel(102, 106, 14986355);
            uLCD.pixel(103, 106, 14460011);
            uLCD.pixel(104, 106, 13802081);
            uLCD.pixel(105, 106, 14262632);
            uLCD.pixel(106, 106, 14591597);
            uLCD.pixel(107, 106, 13012565);
            uLCD.pixel(108, 106, 14853999);
            uLCD.pixel(109, 106, 14590312);
            uLCD.pixel(110, 106, 14392674);
            uLCD.pixel(111, 106, 14326881);
            uLCD.pixel(112, 106, 14523744);
            uLCD.pixel(113, 106, 14589537);
            uLCD.pixel(114, 106, 14917989);
            uLCD.pixel(115, 106, 15050857);
            uLCD.pixel(116, 106, 15315567);
            uLCD.pixel(117, 106, 15447664);
            uLCD.pixel(118, 106, 15710579);
            uLCD.pixel(119, 106, 15973749);
            uLCD.pixel(120, 106, 16236151);
            uLCD.pixel(121, 106, 16433017);
            uLCD.pixel(122, 106, 16433017);
            uLCD.pixel(123, 106, 16432760);
            uLCD.pixel(124, 106, 16366967);
            uLCD.pixel(125, 106, 16366967);
            uLCD.pixel(126, 106, 16301174);
            uLCD.pixel(127, 106, 16301174);
            uLCD.pixel(88, 107, 2427392);
            uLCD.pixel(89, 107, 11570803);
            uLCD.pixel(90, 107, 14662036);
            uLCD.pixel(91, 107, 13476984);
            uLCD.pixel(92, 107, 12489826);
            uLCD.pixel(93, 107, 13871217);
            uLCD.pixel(94, 107, 12687195);
            uLCD.pixel(95, 107, 14199915);
            uLCD.pixel(96, 107, 14330727);
            uLCD.pixel(97, 107, 13672536);
            uLCD.pixel(98, 107, 13934677);
            uLCD.pixel(99, 107, 14263390);
            uLCD.pixel(100, 107, 14263659);
            uLCD.pixel(101, 107, 13605991);
            uLCD.pixel(102, 107, 13605991);
            uLCD.pixel(103, 107, 14395507);
            uLCD.pixel(104, 107, 14329714);
            uLCD.pixel(105, 107, 14066540);
            uLCD.pixel(106, 107, 14132333);
            uLCD.pixel(107, 107, 13079645);
            uLCD.pixel(108, 107, 14000488);
            uLCD.pixel(109, 107, 13999717);
            uLCD.pixel(110, 107, 14196837);
            uLCD.pixel(111, 107, 14525800);
            uLCD.pixel(112, 107, 14656870);
            uLCD.pixel(113, 107, 14393697);
            uLCD.pixel(114, 107, 14261852);
            uLCD.pixel(115, 107, 14196572);
            uLCD.pixel(116, 107, 13934943);
            uLCD.pixel(117, 107, 13935456);
            uLCD.pixel(118, 107, 14066783);
            uLCD.pixel(119, 107, 14264162);
            uLCD.pixel(120, 107, 14855270);
            uLCD.pixel(121, 107, 15315821);
            uLCD.pixel(122, 107, 15907188);
            uLCD.pixel(123, 107, 16170358);
            uLCD.pixel(124, 107, 16433019);
            uLCD.pixel(125, 107, 16433017);
            uLCD.pixel(126, 107, 16367226);
            uLCD.pixel(127, 107, 16301431);
            uLCD.pixel(89, 108, 3152135);
            uLCD.pixel(90, 108, 8875089);
            uLCD.pixel(91, 108, 15058853);
            uLCD.pixel(92, 108, 13018749);
            uLCD.pixel(93, 108, 13216122);
            uLCD.pixel(94, 108, 13280884);
            uLCD.pixel(95, 108, 12951657);
            uLCD.pixel(96, 108, 13148261);
            uLCD.pixel(97, 108, 13476964);
            uLCD.pixel(98, 108, 13541985);
            uLCD.pixel(99, 108, 13147229);
            uLCD.pixel(100, 108, 13541736);
            uLCD.pixel(101, 108, 13738863);
            uLCD.pixel(102, 108, 13804656);
            uLCD.pixel(103, 108, 13738863);
            uLCD.pixel(104, 108, 13673840);
            uLCD.pixel(105, 108, 13871217);
            uLCD.pixel(106, 108, 13871471);
            uLCD.pixel(107, 108, 13674090);
            uLCD.pixel(108, 108, 13410403);
            uLCD.pixel(109, 108, 13673314);
            uLCD.pixel(110, 108, 13935714);
            uLCD.pixel(111, 108, 13870174);
            uLCD.pixel(112, 108, 14001501);
            uLCD.pixel(113, 108, 14264412);
            uLCD.pixel(114, 108, 14526813);
            uLCD.pixel(115, 108, 14330205);
            uLCD.pixel(116, 108, 14198880);
            uLCD.pixel(117, 108, 14067040);
            uLCD.pixel(118, 108, 14000990);
            uLCD.pixel(119, 108, 13935197);
            uLCD.pixel(120, 108, 14197340);
            uLCD.pixel(121, 108, 14394717);
            uLCD.pixel(122, 108, 14722912);
            uLCD.pixel(123, 108, 14854239);
            uLCD.pixel(124, 108, 14787935);
            uLCD.pixel(125, 108, 15314277);
            uLCD.pixel(126, 108, 15972209);
            uLCD.pixel(127, 108, 16301172);
            uLCD.pixel(90, 109, 3285263);
            uLCD.pixel(91, 109, 6705721);
            uLCD.pixel(92, 109, 11310454);
            uLCD.pixel(93, 109, 12823431);
            uLCD.pixel(94, 109, 14138260);
            uLCD.pixel(95, 109, 13940621);
            uLCD.pixel(96, 109, 13347453);
            uLCD.pixel(97, 109, 13281400);
            uLCD.pixel(98, 109, 13807998);
            uLCD.pixel(99, 109, 14465158);
            uLCD.pixel(100, 109, 14135941);
            uLCD.pixel(101, 109, 13806976);
            uLCD.pixel(102, 109, 13609597);
            uLCD.pixel(103, 109, 13609597);
            uLCD.pixel(104, 109, 13346425);
            uLCD.pixel(105, 109, 12820849);
            uLCD.pixel(106, 109, 12689517);
            uLCD.pixel(107, 109, 12755307);
            uLCD.pixel(108, 109, 13873270);
            uLCD.pixel(109, 109, 13938802);
            uLCD.pixel(110, 109, 14004080);
            uLCD.pixel(111, 109, 13674854);
            uLCD.pixel(112, 109, 13345629);
            uLCD.pixel(113, 109, 13279318);
            uLCD.pixel(114, 109, 13410902);
            uLCD.pixel(115, 109, 13673561);
            uLCD.pixel(116, 109, 13935967);
            uLCD.pixel(117, 109, 13869663);
            uLCD.pixel(118, 109, 13803357);
            uLCD.pixel(119, 109, 13803611);
            uLCD.pixel(120, 109, 14131547);
            uLCD.pixel(121, 109, 14197338);
            uLCD.pixel(122, 109, 14393434);
            uLCD.pixel(123, 109, 14327895);
            uLCD.pixel(124, 109, 14919519);
            uLCD.pixel(125, 109, 14656347);
            uLCD.pixel(126, 109, 14393175);
            uLCD.pixel(127, 109, 14130003);
            uLCD.pixel(93, 110, 2759171);
            uLCD.pixel(94, 110, 4271381);
            uLCD.pixel(95, 110, 6178864);
            uLCD.pixel(96, 110, 8481103);
            uLCD.pixel(97, 110, 10322792);
            uLCD.pixel(98, 110, 10914929);
            uLCD.pixel(99, 110, 10783084);
            uLCD.pixel(100, 110, 9598295);
            uLCD.pixel(101, 110, 7821884);
            uLCD.pixel(102, 110, 5848094);
            uLCD.pixel(103, 110, 4401416);
            uLCD.pixel(104, 110, 3480320);
            uLCD.pixel(105, 110, 3085568);
            uLCD.pixel(106, 110, 3678208);
            uLCD.pixel(107, 110, 4731144);
            uLCD.pixel(108, 110, 6967846);
            uLCD.pixel(109, 110, 8875069);
            uLCD.pixel(110, 110, 11506529);
            uLCD.pixel(111, 110, 13677180);
            uLCD.pixel(112, 110, 14137471);
            uLCD.pixel(113, 110, 13742452);
            uLCD.pixel(114, 110, 13610350);
            uLCD.pixel(115, 110, 13938285);
            uLCD.pixel(116, 110, 13607521);
            uLCD.pixel(117, 110, 13935457);
            uLCD.pixel(118, 110, 14263909);
            uLCD.pixel(119, 110, 14592873);
            uLCD.pixel(120, 110, 14855016);
            uLCD.pixel(121, 110, 14657891);
            uLCD.pixel(122, 110, 14459227);
            uLCD.pixel(123, 110, 14130262);
            uLCD.pixel(124, 110, 14130003);
            uLCD.pixel(125, 110, 14523991);
            uLCD.pixel(126, 110, 14853211);
            uLCD.pixel(127, 110, 14919004);
            uLCD.pixel(110, 111, 2692352);
            uLCD.pixel(111, 111, 5586714);
            uLCD.pixel(112, 111, 8612677);
            uLCD.pixel(113, 111, 10783586);
            uLCD.pixel(114, 111, 12296307);
            uLCD.pixel(115, 111, 13413501);
            uLCD.pixel(116, 111, 14464128);
            uLCD.pixel(117, 111, 14331254);
            uLCD.pixel(118, 111, 13739115);
            uLCD.pixel(119, 111, 13212512);
            uLCD.pixel(120, 111, 13080156);
            uLCD.pixel(121, 111, 13343068);
            uLCD.pixel(122, 111, 13869153);
            uLCD.pixel(123, 111, 14394725);
            uLCD.pixel(124, 111, 14197089);
            uLCD.pixel(125, 111, 14327904);
            uLCD.pixel(126, 111, 14458977);
            uLCD.pixel(127, 111, 14459231);
            uLCD.pixel(114, 112, 3482383);
            uLCD.pixel(115, 112, 6112557);
            uLCD.pixel(116, 112, 7887416);
            uLCD.pixel(117, 112, 9531209);
            uLCD.pixel(118, 112, 11571046);
            uLCD.pixel(119, 112, 13281149);
            uLCD.pixel(120, 112, 14201224);
            uLCD.pixel(121, 112, 14332293);
            uLCD.pixel(122, 112, 14134399);
            uLCD.pixel(123, 112, 14068347);
            uLCD.pixel(124, 112, 14265210);
            uLCD.pixel(125, 112, 13804145);
            uLCD.pixel(126, 112, 13343078);
            uLCD.pixel(127, 112, 13343078);
            uLCD.pixel(119, 113, 2560256);
            uLCD.pixel(120, 113, 3940873);
            uLCD.pixel(121, 113, 5980197);
            uLCD.pixel(122, 113, 8413766);
            uLCD.pixel(123, 113, 10124124);
            uLCD.pixel(124, 113, 11702640);
            uLCD.pixel(125, 113, 12689276);
            uLCD.pixel(126, 113, 13807242);
            uLCD.pixel(127, 113, 14268048);
            uLCD.pixel(125, 114, 3218957);
            uLCD.pixel(126, 114, 5653552);
            uLCD.pixel(127, 114, 7166019);
        }

        // Draw left Scissors
        void drawLeftScissors() {
            uLCD.pixel(16, 82, 2232576);
            uLCD.pixel(17, 82, 4730379);
            uLCD.pixel(18, 82, 6835239);
            uLCD.pixel(19, 82, 7953460);
            uLCD.pixel(20, 82, 9071169);
            uLCD.pixel(21, 82, 10584149);
            uLCD.pixel(22, 82, 11636837);
            uLCD.pixel(23, 82, 11834475);
            uLCD.pixel(24, 82, 11638126);
            uLCD.pixel(25, 82, 7164981);
            uLCD.pixel(15, 83, 5390889);
            uLCD.pixel(16, 83, 12755829);
            uLCD.pixel(17, 83, 15188105);
            uLCD.pixel(18, 83, 16700829);
            uLCD.pixel(19, 83, 16437398);
            uLCD.pixel(20, 83, 16041868);
            uLCD.pixel(21, 83, 16239502);
            uLCD.pixel(22, 83, 16304782);
            uLCD.pixel(23, 83, 15778696);
            uLCD.pixel(24, 83, 15516042);
            uLCD.pixel(25, 83, 16635814);
            uLCD.pixel(26, 83, 11439717);
            uLCD.pixel(27, 83, 3217920);
            uLCD.pixel(9, 84, 2101248);
            uLCD.pixel(12, 84, 2889216);
            uLCD.pixel(13, 84, 6770727);
            uLCD.pixel(14, 84, 11770992);
            uLCD.pixel(15, 84, 15584920);
            uLCD.pixel(16, 84, 15778688);
            uLCD.pixel(17, 84, 16105848);
            uLCD.pixel(18, 84, 16105848);
            uLCD.pixel(19, 84, 16040055);
            uLCD.pixel(20, 84, 16105337);
            uLCD.pixel(21, 84, 16170358);
            uLCD.pixel(22, 84, 16301685);
            uLCD.pixel(23, 84, 16366967);
            uLCD.pixel(24, 84, 16104054);
            uLCD.pixel(25, 84, 16039293);
            uLCD.pixel(26, 84, 16567701);
            uLCD.pixel(27, 84, 10648655);
            uLCD.pixel(0, 85, 7756614);
            uLCD.pixel(1, 85, 7231038);
            uLCD.pixel(2, 85, 7164730);
            uLCD.pixel(3, 85, 7691326);
            uLCD.pixel(4, 85, 8612681);
            uLCD.pixel(5, 85, 9862231);
            uLCD.pixel(6, 85, 11440746);
            uLCD.pixel(7, 85, 12756347);
            uLCD.pixel(8, 85, 13742726);
            uLCD.pixel(9, 85, 13413246);
            uLCD.pixel(10, 85, 13149814);
            uLCD.pixel(11, 85, 13741175);
            uLCD.pixel(12, 85, 15056515);
            uLCD.pixel(13, 85, 16109197);
            uLCD.pixel(14, 85, 15911557);
            uLCD.pixel(15, 85, 15383665);
            uLCD.pixel(16, 85, 16368242);
            uLCD.pixel(17, 85, 16564078);
            uLCD.pixel(18, 85, 16433007);
            uLCD.pixel(19, 85, 16367216);
            uLCD.pixel(20, 85, 16367216);
            uLCD.pixel(21, 85, 16498032);
            uLCD.pixel(22, 85, 16694382);
            uLCD.pixel(23, 85, 16759918);
            uLCD.pixel(24, 85, 16759921);
            uLCD.pixel(25, 85, 16365938);
            uLCD.pixel(26, 85, 16433281);
            uLCD.pixel(27, 85, 15515015);
            uLCD.pixel(28, 85, 8017711);
            uLCD.pixel(41, 85, 3088143);
            uLCD.pixel(42, 85, 4601121);
            uLCD.pixel(43, 85, 4995618);
            uLCD.pixel(44, 85, 5257762);
            uLCD.pixel(45, 85, 6770485);
            uLCD.pixel(46, 85, 8414797);
            uLCD.pixel(47, 85, 9204052);
            uLCD.pixel(48, 85, 10716774);
            uLCD.pixel(49, 85, 10848876);
            uLCD.pixel(50, 85, 8218707);
            uLCD.pixel(0, 86, 16501910);
            uLCD.pixel(1, 86, 16239249);
            uLCD.pixel(2, 86, 16304783);
            uLCD.pixel(3, 86, 16436366);
            uLCD.pixel(4, 86, 16305034);
            uLCD.pixel(5, 86, 16106883);
            uLCD.pixel(6, 86, 15909759);
            uLCD.pixel(7, 86, 16106623);
            uLCD.pixel(8, 86, 15974780);
            uLCD.pixel(9, 86, 16500352);
            uLCD.pixel(10, 86, 16631681);
            uLCD.pixel(11, 86, 16433271);
            uLCD.pixel(12, 86, 16235630);
            uLCD.pixel(13, 86, 16432490);
            uLCD.pixel(14, 86, 16563815);
            uLCD.pixel(15, 86, 16498022);
            uLCD.pixel(16, 86, 16760683);
            uLCD.pixel(17, 86, 16760428);
            uLCD.pixel(18, 86, 16629358);
            uLCD.pixel(19, 86, 16498286);
            uLCD.pixel(20, 86, 16498286);
            uLCD.pixel(21, 86, 16563566);
            uLCD.pixel(22, 86, 16694382);
            uLCD.pixel(23, 86, 16759918);
            uLCD.pixel(24, 86, 16761206);
            uLCD.pixel(25, 86, 15904616);
            uLCD.pixel(26, 86, 16564607);
            uLCD.pixel(27, 86, 16040328);
            uLCD.pixel(28, 86, 15253393);
            uLCD.pixel(29, 86, 5782036);
            uLCD.pixel(30, 86, 3679495);
            uLCD.pixel(31, 86, 2298880);
            uLCD.pixel(36, 86, 3613700);
            uLCD.pixel(37, 86, 5784093);
            uLCD.pixel(38, 86, 9007175);
            uLCD.pixel(39, 86, 11506532);
            uLCD.pixel(40, 86, 13874048);
            uLCD.pixel(41, 86, 14334593);
            uLCD.pixel(42, 86, 16109973);
            uLCD.pixel(43, 86, 15977870);
            uLCD.pixel(44, 86, 15517060);
            uLCD.pixel(45, 86, 15977607);
            uLCD.pixel(46, 86, 15648385);
            uLCD.pixel(47, 86, 15845764);
            uLCD.pixel(48, 86, 16174729);
            uLCD.pixel(49, 86, 15714699);
            uLCD.pixel(50, 86, 15979428);
            uLCD.pixel(51, 86, 11836538);
            uLCD.pixel(52, 86, 2166784);
            uLCD.pixel(0, 87, 15972207);
            uLCD.pixel(1, 87, 15972207);
            uLCD.pixel(2, 87, 16104046);
            uLCD.pixel(3, 87, 16433009);
            uLCD.pixel(4, 87, 16498800);
            uLCD.pixel(5, 87, 16301421);
            uLCD.pixel(6, 87, 16366700);
            uLCD.pixel(7, 87, 16432493);
            uLCD.pixel(8, 87, 16300396);
            uLCD.pixel(9, 87, 16694384);
            uLCD.pixel(10, 87, 16760175);
            uLCD.pixel(11, 87, 16627818);
            uLCD.pixel(12, 87, 16692836);
            uLCD.pixel(13, 87, 16759140);
            uLCD.pixel(14, 87, 16760421);
            uLCD.pixel(15, 87, 16760935);
            uLCD.pixel(16, 87, 16760168);
            uLCD.pixel(17, 87, 16760426);
            uLCD.pixel(18, 87, 16760428);
            uLCD.pixel(19, 87, 16694637);
            uLCD.pixel(20, 87, 16563566);
            uLCD.pixel(21, 87, 16694382);
            uLCD.pixel(22, 87, 16760175);
            uLCD.pixel(23, 87, 16760175);
            uLCD.pixel(24, 87, 16759664);
            uLCD.pixel(25, 87, 16760950);
            uLCD.pixel(26, 87, 16432506);
            uLCD.pixel(27, 87, 15973759);
            uLCD.pixel(28, 87, 15383688);
            uLCD.pixel(29, 87, 14399113);
            uLCD.pixel(30, 87, 12821887);
            uLCD.pixel(31, 87, 13547152);
            uLCD.pixel(32, 87, 12298366);
            uLCD.pixel(33, 87, 11969400);
            uLCD.pixel(34, 87, 12561019);
            uLCD.pixel(35, 87, 13217660);
            uLCD.pixel(36, 87, 15058575);
            uLCD.pixel(37, 87, 15386250);
            uLCD.pixel(38, 87, 16174477);
            uLCD.pixel(39, 87, 16502410);
            uLCD.pixel(40, 87, 16238461);
            uLCD.pixel(41, 87, 14395997);
            uLCD.pixel(42, 87, 15579755);
            uLCD.pixel(43, 87, 16106099);
            uLCD.pixel(44, 87, 15909488);
            uLCD.pixel(45, 87, 15777902);
            uLCD.pixel(46, 87, 14857057);
            uLCD.pixel(47, 87, 16107124);
            uLCD.pixel(48, 87, 15383654);
            uLCD.pixel(49, 87, 15779190);
            uLCD.pixel(50, 87, 15188354);
            uLCD.pixel(51, 87, 15848102);
            uLCD.pixel(52, 87, 6376244);
            uLCD.pixel(0, 88, 16760953);
            uLCD.pixel(1, 88, 16760436);
            uLCD.pixel(2, 88, 16628591);
            uLCD.pixel(3, 88, 16562796);
            uLCD.pixel(4, 88, 16497003);
            uLCD.pixel(5, 88, 16497003);
            uLCD.pixel(6, 88, 16628591);
            uLCD.pixel(7, 88, 16760436);
            uLCD.pixel(8, 88, 16759670);
            uLCD.pixel(9, 88, 16759670);
            uLCD.pixel(10, 88, 16759417);
            uLCD.pixel(11, 88, 16759929);
            uLCD.pixel(12, 88, 16760699);
            uLCD.pixel(13, 88, 16760695);
            uLCD.pixel(14, 88, 16758894);
            uLCD.pixel(15, 88, 16757348);
            uLCD.pixel(16, 88, 16759914);
            uLCD.pixel(17, 88, 16759914);
            uLCD.pixel(18, 88, 16760172);
            uLCD.pixel(19, 88, 16759917);
            uLCD.pixel(20, 88, 16760175);
            uLCD.pixel(21, 88, 16760177);
            uLCD.pixel(22, 88, 16759921);
            uLCD.pixel(23, 88, 16760178);
            uLCD.pixel(24, 88, 16759664);
            uLCD.pixel(25, 88, 16628593);
            uLCD.pixel(26, 88, 16760953);
            uLCD.pixel(27, 88, 16762757);
            uLCD.pixel(28, 88, 15447931);
            uLCD.pixel(29, 88, 15844493);
            uLCD.pixel(30, 88, 14200957);
            uLCD.pixel(31, 88, 13939067);
            uLCD.pixel(32, 88, 15584393);
            uLCD.pixel(33, 88, 15584131);
            uLCD.pixel(34, 88, 15319930);
            uLCD.pixel(35, 88, 14529383);
            uLCD.pixel(36, 88, 16106615);
            uLCD.pixel(37, 88, 16499574);
            uLCD.pixel(38, 88, 16564593);
            uLCD.pixel(39, 88, 16103528);
            uLCD.pixel(40, 88, 16431980);
            uLCD.pixel(41, 88, 14129227);
            uLCD.pixel(42, 88, 15050588);
            uLCD.pixel(43, 88, 15709548);
            uLCD.pixel(44, 88, 15184494);
            uLCD.pixel(45, 88, 14132835);
            uLCD.pixel(46, 88, 13014614);
            uLCD.pixel(47, 88, 14659690);
            uLCD.pixel(48, 88, 15119970);
            uLCD.pixel(49, 88, 15647086);
            uLCD.pixel(50, 88, 14069614);
            uLCD.pixel(51, 88, 13610625);
            uLCD.pixel(52, 88, 4665111);
            uLCD.pixel(0, 89, 16628080);
            uLCD.pixel(1, 89, 16628591);
            uLCD.pixel(2, 89, 16760432);
            uLCD.pixel(3, 89, 16761202);
            uLCD.pixel(4, 89, 16760946);
            uLCD.pixel(5, 89, 16695152);
            uLCD.pixel(6, 89, 16497775);
            uLCD.pixel(7, 89, 16431730);
            uLCD.pixel(8, 89, 16562549);
            uLCD.pixel(9, 89, 16759674);
            uLCD.pixel(10, 89, 16759677);
            uLCD.pixel(11, 89, 16758906);
            uLCD.pixel(12, 89, 16626548);
            uLCD.pixel(13, 89, 16757873);
            uLCD.pixel(14, 89, 16759157);
            uLCD.pixel(15, 89, 16760694);
            uLCD.pixel(16, 89, 16759660);
            uLCD.pixel(17, 89, 16759914);
            uLCD.pixel(18, 89, 16760172);
            uLCD.pixel(19, 89, 16760174);
            uLCD.pixel(20, 89, 16760177);
            uLCD.pixel(21, 89, 16760179);
            uLCD.pixel(22, 89, 16760436);
            uLCD.pixel(23, 89, 16760436);
            uLCD.pixel(24, 89, 16102249);
            uLCD.pixel(25, 89, 14654803);
            uLCD.pixel(26, 89, 16300145);
            uLCD.pixel(27, 89, 15972209);
            uLCD.pixel(28, 89, 16763273);
            uLCD.pixel(29, 89, 15316599);
            uLCD.pixel(30, 89, 16304012);
            uLCD.pixel(31, 89, 13540958);
            uLCD.pixel(32, 89, 14659429);
            uLCD.pixel(33, 89, 16238199);
            uLCD.pixel(34, 89, 16435064);
            uLCD.pixel(35, 89, 15512933);
            uLCD.pixel(36, 89, 16366446);
            uLCD.pixel(37, 89, 16760691);
            uLCD.pixel(38, 89, 16562285);
            uLCD.pixel(39, 89, 15970150);
            uLCD.pixel(40, 89, 15443808);
            uLCD.pixel(41, 89, 13339208);
            uLCD.pixel(42, 89, 13406032);
            uLCD.pixel(43, 89, 13671006);
            uLCD.pixel(44, 89, 13935467);
            uLCD.pixel(45, 89, 13937014);
            uLCD.pixel(46, 89, 13345648);
            uLCD.pixel(47, 89, 13938038);
            uLCD.pixel(48, 89, 14529904);
            uLCD.pixel(49, 89, 13213790);
            uLCD.pixel(50, 89, 12820331);
            uLCD.pixel(51, 89, 9335373);
            uLCD.pixel(0, 90, 16629618);
            uLCD.pixel(1, 90, 16433007);
            uLCD.pixel(2, 90, 16301421);
            uLCD.pixel(3, 90, 16104810);
            uLCD.pixel(4, 90, 16170090);
            uLCD.pixel(5, 90, 16236141);
            uLCD.pixel(6, 90, 16367729);
            uLCD.pixel(7, 90, 16433270);
            uLCD.pixel(8, 90, 16761982);
            uLCD.pixel(9, 90, 16433019);
            uLCD.pixel(10, 90, 16300922);
            uLCD.pixel(11, 90, 16563324);
            uLCD.pixel(12, 90, 16760957);
            uLCD.pixel(13, 90, 16760699);
            uLCD.pixel(14, 90, 16629110);
            uLCD.pixel(15, 90, 16562798);
            uLCD.pixel(16, 90, 16759918);
            uLCD.pixel(17, 90, 16759916);
            uLCD.pixel(18, 90, 16759919);
            uLCD.pixel(19, 90, 16759921);
            uLCD.pixel(20, 90, 16629107);
            uLCD.pixel(21, 90, 16629622);
            uLCD.pixel(22, 90, 16629367);
            uLCD.pixel(23, 90, 16695160);
            uLCD.pixel(24, 90, 13010752);
            uLCD.pixel(25, 90, 13010752);
            uLCD.pixel(26, 90, 16037230);
            uLCD.pixel(27, 90, 16564346);
            uLCD.pixel(28, 90, 15972468);
            uLCD.pixel(29, 90, 16170362);
            uLCD.pixel(30, 90, 16301948);
            uLCD.pixel(31, 90, 14525537);
            uLCD.pixel(32, 90, 13801301);
            uLCD.pixel(33, 90, 15906164);
            uLCD.pixel(34, 90, 15773810);
            uLCD.pixel(35, 90, 14589536);
            uLCD.pixel(36, 90, 14589024);
            uLCD.pixel(37, 90, 15246956);
            uLCD.pixel(38, 90, 14851946);
            uLCD.pixel(39, 90, 14852204);
            uLCD.pixel(40, 90, 14326893);
            uLCD.pixel(41, 90, 13801836);
            uLCD.pixel(42, 90, 14198138);
            uLCD.pixel(43, 90, 14463367);
            uLCD.pixel(44, 90, 14069897);
            uLCD.pixel(45, 90, 12558201);
            uLCD.pixel(46, 90, 9993817);
            uLCD.pixel(47, 90, 7954236);
            uLCD.pixel(48, 90, 6966312);
            uLCD.pixel(49, 90, 5782301);
            uLCD.pixel(50, 90, 3809802);
            uLCD.pixel(0, 91, 16366700);
            uLCD.pixel(1, 91, 16367469);
            uLCD.pixel(2, 91, 16499055);
            uLCD.pixel(3, 91, 16499053);
            uLCD.pixel(4, 91, 16564846);
            uLCD.pixel(5, 91, 16499568);
            uLCD.pixel(6, 91, 16367727);
            uLCD.pixel(7, 91, 16170609);
            uLCD.pixel(8, 91, 16104819);
            uLCD.pixel(9, 91, 16170358);
            uLCD.pixel(10, 91, 16367226);
            uLCD.pixel(11, 91, 16433017);
            uLCD.pixel(12, 91, 16366965);
            uLCD.pixel(13, 91, 16366964);
            uLCD.pixel(14, 91, 16629620);
            uLCD.pixel(15, 91, 16761459);
            uLCD.pixel(16, 91, 16760175);
            uLCD.pixel(17, 91, 16759919);
            uLCD.pixel(18, 91, 16759921);
            uLCD.pixel(19, 91, 16760179);
            uLCD.pixel(20, 91, 16563829);
            uLCD.pixel(21, 91, 16498551);
            uLCD.pixel(22, 91, 16498810);
            uLCD.pixel(23, 91, 16498812);
            uLCD.pixel(24, 91, 14788194);
            uLCD.pixel(25, 91, 11564337);
            uLCD.pixel(26, 91, 14985573);
            uLCD.pixel(27, 91, 13143367);
            uLCD.pixel(28, 91, 14787935);
            uLCD.pixel(29, 91, 16630139);
            uLCD.pixel(30, 91, 16498551);
            uLCD.pixel(31, 91, 16498553);
            uLCD.pixel(32, 91, 13537616);
            uLCD.pixel(33, 91, 15379822);
            uLCD.pixel(34, 91, 14655846);
            uLCD.pixel(35, 91, 13735005);
            uLCD.pixel(36, 91, 13537888);
            uLCD.pixel(37, 91, 14590839);
            uLCD.pixel(38, 91, 14065528);
            uLCD.pixel(39, 91, 14329219);
            uLCD.pixel(40, 91, 14067593);
            uLCD.pixel(41, 91, 12753023);
            uLCD.pixel(42, 91, 10517604);
            uLCD.pixel(43, 91, 8084805);
            uLCD.pixel(44, 91, 5124894);
            uLCD.pixel(45, 91, 2692096);
            uLCD.pixel(0, 92, 16759917);
            uLCD.pixel(1, 92, 16694635);
            uLCD.pixel(2, 92, 16694633);
            uLCD.pixel(3, 92, 16760426);
            uLCD.pixel(4, 92, 16760680);
            uLCD.pixel(5, 92, 16629610);
            uLCD.pixel(6, 92, 16629612);
            uLCD.pixel(7, 92, 16564078);
            uLCD.pixel(8, 92, 16234860);
            uLCD.pixel(9, 92, 16762234);
            uLCD.pixel(10, 92, 16036970);
            uLCD.pixel(11, 92, 16037224);
            uLCD.pixel(12, 92, 16694382);
            uLCD.pixel(13, 92, 16761713);
            uLCD.pixel(14, 92, 16497254);
            uLCD.pixel(15, 92, 16761199);
            uLCD.pixel(16, 92, 16760946);
            uLCD.pixel(17, 92, 16431214);
            uLCD.pixel(18, 92, 16563316);
            uLCD.pixel(19, 92, 16695160);
            uLCD.pixel(20, 92, 16366967);
            uLCD.pixel(21, 92, 16564605);
            uLCD.pixel(22, 92, 16367741);
            uLCD.pixel(23, 92, 15315569);
            uLCD.pixel(24, 92, 14065760);
            uLCD.pixel(25, 92, 12486983);
            uLCD.pixel(26, 92, 13341779);
            uLCD.pixel(27, 92, 12222782);
            uLCD.pixel(28, 92, 15051366);
            uLCD.pixel(29, 92, 16764036);
            uLCD.pixel(30, 92, 15708520);
            uLCD.pixel(31, 92, 16761722);
            uLCD.pixel(32, 92, 13276747);
            uLCD.pixel(33, 92, 13606741);
            uLCD.pixel(34, 92, 14133093);
            uLCD.pixel(35, 92, 13410148);
            uLCD.pixel(36, 92, 13608820);
            uLCD.pixel(37, 92, 13806979);
            uLCD.pixel(38, 92, 11373677);
            uLCD.pixel(39, 92, 8151114);
            uLCD.pixel(40, 92, 4796192);
            uLCD.pixel(41, 92, 2626055);
            uLCD.pixel(0, 93, 16760176);
            uLCD.pixel(1, 93, 16760176);
            uLCD.pixel(2, 93, 16760175);
            uLCD.pixel(3, 93, 16760429);
            uLCD.pixel(4, 93, 16760683);
            uLCD.pixel(5, 93, 16760683);
            uLCD.pixel(6, 93, 16760685);
            uLCD.pixel(7, 93, 16760430);
            uLCD.pixel(8, 93, 16629361);
            uLCD.pixel(9, 93, 16761718);
            uLCD.pixel(10, 93, 16102247);
            uLCD.pixel(11, 93, 15575901);
            uLCD.pixel(12, 93, 16694124);
            uLCD.pixel(13, 93, 16694376);
            uLCD.pixel(14, 93, 16760167);
            uLCD.pixel(15, 93, 16761197);
            uLCD.pixel(16, 93, 16761207);
            uLCD.pixel(17, 93, 16695160);
            uLCD.pixel(18, 93, 16629367);
            uLCD.pixel(19, 93, 16038002);
            uLCD.pixel(20, 93, 15709296);
            uLCD.pixel(21, 93, 16367741);
            uLCD.pixel(22, 93, 16105085);
            uLCD.pixel(23, 93, 14592876);
            uLCD.pixel(24, 93, 14198377);
            uLCD.pixel(25, 93, 14329963);
            uLCD.pixel(26, 93, 10842932);
            uLCD.pixel(27, 93, 13407830);
            uLCD.pixel(28, 93, 15710325);
            uLCD.pixel(29, 93, 16104052);
            uLCD.pixel(30, 93, 16763007);
            uLCD.pixel(31, 93, 16432757);
            uLCD.pixel(32, 93, 13540689);
            uLCD.pixel(33, 93, 13476186);
            uLCD.pixel(34, 93, 14266480);
            uLCD.pixel(35, 93, 14136444);
            uLCD.pixel(36, 93, 8084526);
            uLCD.pixel(37, 93, 3941376);
            uLCD.pixel(0, 94, 16758903);
            uLCD.pixel(1, 94, 16758900);
            uLCD.pixel(2, 94, 16759155);
            uLCD.pixel(3, 94, 16759153);
            uLCD.pixel(4, 94, 16693871);
            uLCD.pixel(5, 94, 16628078);
            uLCD.pixel(6, 94, 16562800);
            uLCD.pixel(7, 94, 16562546);
            uLCD.pixel(8, 94, 16760697);
            uLCD.pixel(9, 94, 16760440);
            uLCD.pixel(10, 94, 15970410);
            uLCD.pixel(11, 94, 15575651);
            uLCD.pixel(12, 94, 16760692);
            uLCD.pixel(13, 94, 16496745);
            uLCD.pixel(14, 94, 16760943);
            uLCD.pixel(15, 94, 16761458);
            uLCD.pixel(16, 94, 15313762);
            uLCD.pixel(17, 94, 15774830);
            uLCD.pixel(18, 94, 16695932);
            uLCD.pixel(19, 94, 16762753);
            uLCD.pixel(20, 94, 16696191);
            uLCD.pixel(21, 94, 16236669);
            uLCD.pixel(22, 94, 15315827);
            uLCD.pixel(23, 94, 13803619);
            uLCD.pixel(24, 94, 14198636);
            uLCD.pixel(25, 94, 13738856);
            uLCD.pixel(26, 94, 10843963);
            uLCD.pixel(27, 94, 14198890);
            uLCD.pixel(28, 94, 15710585);
            uLCD.pixel(29, 94, 16104569);
            uLCD.pixel(30, 94, 15906416);
            uLCD.pixel(31, 94, 15972209);
            uLCD.pixel(32, 94, 13144401);
            uLCD.pixel(33, 94, 13737828);
            uLCD.pixel(34, 94, 13541484);
            uLCD.pixel(35, 94, 12885874);
            uLCD.pixel(36, 94, 4006144);
            uLCD.pixel(0, 95, 16759675);
            uLCD.pixel(1, 95, 16759929);
            uLCD.pixel(2, 95, 16759927);
            uLCD.pixel(3, 95, 16760182);
            uLCD.pixel(4, 95, 16760436);
            uLCD.pixel(5, 95, 16694900);
            uLCD.pixel(6, 95, 16694902);
            uLCD.pixel(7, 95, 16629367);
            uLCD.pixel(8, 95, 16628856);
            uLCD.pixel(9, 95, 16563063);
            uLCD.pixel(10, 95, 15378789);
            uLCD.pixel(11, 95, 16036973);
            uLCD.pixel(12, 95, 16761464);
            uLCD.pixel(13, 95, 16694382);
            uLCD.pixel(14, 95, 16760943);
            uLCD.pixel(15, 95, 16695152);
            uLCD.pixel(16, 95, 15709035);
            uLCD.pixel(17, 95, 13932885);
            uLCD.pixel(18, 95, 13209160);
            uLCD.pixel(19, 95, 14261848);
            uLCD.pixel(20, 95, 15182950);
            uLCD.pixel(21, 95, 14788707);
            uLCD.pixel(22, 95, 13539671);
            uLCD.pixel(23, 95, 12553550);
            uLCD.pixel(24, 95, 11699273);
            uLCD.pixel(25, 95, 11107395);
            uLCD.pixel(26, 95, 11304774);
            uLCD.pixel(27, 95, 13607270);
            uLCD.pixel(28, 95, 14922100);
            uLCD.pixel(29, 95, 15841913);
            uLCD.pixel(30, 95, 14525022);
            uLCD.pixel(31, 95, 15445611);
            uLCD.pixel(32, 95, 13800535);
            uLCD.pixel(33, 95, 14262632);
            uLCD.pixel(34, 95, 14132335);
            uLCD.pixel(35, 95, 14989962);
            uLCD.pixel(36, 95, 6965282);
            uLCD.pixel(37, 95, 2033152);
            uLCD.pixel(0, 96, 16563316);
            uLCD.pixel(1, 96, 16498036);
            uLCD.pixel(2, 96, 16498034);
            uLCD.pixel(3, 96, 16367216);
            uLCD.pixel(4, 96, 16433007);
            uLCD.pixel(5, 96, 16367727);
            uLCD.pixel(6, 96, 16367729);
            uLCD.pixel(7, 96, 16302195);
            uLCD.pixel(8, 96, 16301684);
            uLCD.pixel(9, 96, 16235892);
            uLCD.pixel(10, 96, 14327895);
            uLCD.pixel(11, 96, 16301684);
            uLCD.pixel(12, 96, 16301423);
            uLCD.pixel(13, 96, 16499055);
            uLCD.pixel(14, 96, 16432744);
            uLCD.pixel(15, 96, 16301676);
            uLCD.pixel(16, 96, 16762750);
            uLCD.pixel(17, 96, 16367224);
            uLCD.pixel(18, 96, 15840621);
            uLCD.pixel(19, 96, 15116898);
            uLCD.pixel(20, 96, 13669452);
            uLCD.pixel(21, 96, 12090679);
            uLCD.pixel(22, 96, 12025917);
            uLCD.pixel(23, 96, 13079635);
            uLCD.pixel(24, 96, 13278304);
            uLCD.pixel(25, 96, 13870701);
            uLCD.pixel(26, 96, 12357978);
            uLCD.pixel(27, 96, 13739115);
            uLCD.pixel(28, 96, 15185531);
            uLCD.pixel(29, 96, 13671004);
            uLCD.pixel(30, 96, 14656869);
            uLCD.pixel(31, 96, 12879170);
            uLCD.pixel(32, 96, 14062415);
            uLCD.pixel(33, 96, 14589273);
            uLCD.pixel(34, 96, 14130012);
            uLCD.pixel(35, 96, 16697230);
            uLCD.pixel(36, 96, 15515274);
            uLCD.pixel(37, 96, 11438682);
            uLCD.pixel(38, 96, 6769444);
            uLCD.pixel(39, 96, 2494720);
            uLCD.pixel(0, 97, 16498034);
            uLCD.pixel(1, 97, 16367218);
            uLCD.pixel(2, 97, 16433009);
            uLCD.pixel(3, 97, 16367727);
            uLCD.pixel(4, 97, 16367727);
            uLCD.pixel(5, 97, 16367727);
            uLCD.pixel(6, 97, 16302449);
            uLCD.pixel(7, 97, 16302195);
            uLCD.pixel(8, 97, 16565369);
            uLCD.pixel(9, 97, 16236405);
            uLCD.pixel(10, 97, 13801551);
            uLCD.pixel(11, 97, 16499064);
            uLCD.pixel(12, 97, 16038253);
            uLCD.pixel(13, 97, 16498802);
            uLCD.pixel(14, 97, 16498285);
            uLCD.pixel(15, 97, 16433007);
            uLCD.pixel(16, 97, 16104306);
            uLCD.pixel(17, 97, 16367224);
            uLCD.pixel(18, 97, 16432243);
            uLCD.pixel(19, 97, 16629107);
            uLCD.pixel(20, 97, 16761978);
            uLCD.pixel(21, 97, 16695415);
            uLCD.pixel(22, 97, 15314536);
            uLCD.pixel(23, 97, 14394980);
            uLCD.pixel(24, 97, 13935718);
            uLCD.pixel(25, 97, 14265459);
            uLCD.pixel(26, 97, 12226392);
            uLCD.pixel(27, 97, 12423257);
            uLCD.pixel(28, 97, 15448704);
            uLCD.pixel(29, 97, 14329450);
            uLCD.pixel(30, 97, 16764302);
            uLCD.pixel(31, 97, 13932374);
            uLCD.pixel(32, 97, 13602378);
            uLCD.pixel(33, 97, 15838826);
            uLCD.pixel(34, 97, 14918753);
            uLCD.pixel(35, 97, 14196318);
            uLCD.pixel(36, 97, 16105345);
            uLCD.pixel(37, 97, 16370575);
            uLCD.pixel(38, 97, 16108694);
            uLCD.pixel(39, 97, 14530953);
            uLCD.pixel(40, 97, 10585178);
            uLCD.pixel(41, 97, 7954751);
            uLCD.pixel(42, 97, 4929308);
            uLCD.pixel(43, 97, 2495745);
            uLCD.pixel(0, 98, 16760950);
            uLCD.pixel(1, 98, 16695413);
            uLCD.pixel(2, 98, 16695411);
            uLCD.pixel(3, 98, 16629618);
            uLCD.pixel(4, 98, 16629618);
            uLCD.pixel(5, 98, 16433009);
            uLCD.pixel(6, 98, 16433011);
            uLCD.pixel(7, 98, 16432758);
            uLCD.pixel(8, 98, 16235127);
            uLCD.pixel(9, 98, 15642992);
            uLCD.pixel(10, 98, 13536846);
            uLCD.pixel(11, 98, 16563324);
            uLCD.pixel(12, 98, 16497272);
            uLCD.pixel(13, 98, 16563317);
            uLCD.pixel(14, 98, 16760953);
            uLCD.pixel(15, 98, 16629109);
            uLCD.pixel(16, 98, 16103793);
            uLCD.pixel(17, 98, 16761723);
            uLCD.pixel(18, 98, 16760693);
            uLCD.pixel(19, 98, 16497005);
            uLCD.pixel(20, 98, 16760175);
            uLCD.pixel(21, 98, 16299626);
            uLCD.pixel(22, 98, 14919519);
            uLCD.pixel(23, 98, 14262365);
            uLCD.pixel(24, 98, 14395754);
            uLCD.pixel(25, 98, 13344098);
            uLCD.pixel(26, 98, 12818015);
            uLCD.pixel(27, 98, 10975811);
            uLCD.pixel(28, 98, 14001774);
            uLCD.pixel(29, 98, 14461551);
            uLCD.pixel(30, 98, 16433797);
            uLCD.pixel(31, 98, 13801561);
            uLCD.pixel(32, 98, 13998688);
            uLCD.pixel(33, 98, 14393446);
            uLCD.pixel(34, 98, 14196065);
            uLCD.pixel(35, 98, 14591076);
            uLCD.pixel(36, 98, 16696704);
            uLCD.pixel(37, 98, 16104565);
            uLCD.pixel(38, 98, 15644784);
            uLCD.pixel(39, 98, 16105594);
            uLCD.pixel(40, 98, 16764812);
            uLCD.pixel(41, 98, 15581057);
            uLCD.pixel(42, 98, 15647628);
            uLCD.pixel(43, 98, 15451024);
            uLCD.pixel(44, 98, 13017463);
            uLCD.pixel(45, 98, 9794382);
            uLCD.pixel(46, 98, 6110237);
            uLCD.pixel(0, 99, 15773800);
            uLCD.pixel(1, 99, 15773800);
            uLCD.pixel(2, 99, 15642727);
            uLCD.pixel(3, 99, 15576934);
            uLCD.pixel(4, 99, 15445348);
            uLCD.pixel(5, 99, 15248484);
            uLCD.pixel(6, 99, 15182693);
            uLCD.pixel(7, 99, 15182441);
            uLCD.pixel(8, 99, 15182443);
            uLCD.pixel(9, 99, 14655329);
            uLCD.pixel(10, 99, 13076298);
            uLCD.pixel(11, 99, 16168055);
            uLCD.pixel(12, 99, 16760447);
            uLCD.pixel(13, 99, 16430963);
            uLCD.pixel(14, 99, 16760955);
            uLCD.pixel(15, 99, 16430960);
            uLCD.pixel(16, 99, 16563829);
            uLCD.pixel(17, 99, 16564597);
            uLCD.pixel(18, 99, 16366446);
            uLCD.pixel(19, 99, 16629361);
            uLCD.pixel(20, 99, 16761719);
            uLCD.pixel(21, 99, 16234349);
            uLCD.pixel(22, 99, 15051107);
            uLCD.pixel(23, 99, 15117420);
            uLCD.pixel(24, 99, 14066280);
            uLCD.pixel(25, 99, 13606502);
            uLCD.pixel(26, 99, 13278312);
            uLCD.pixel(27, 99, 11501901);
            uLCD.pixel(28, 99, 13935983);
            uLCD.pixel(29, 99, 14396018);
            uLCD.pixel(30, 99, 16303242);
            uLCD.pixel(31, 99, 13803108);
            uLCD.pixel(32, 99, 14132333);
            uLCD.pixel(33, 99, 14066540);
            uLCD.pixel(34, 99, 13605729);
            uLCD.pixel(35, 99, 13078865);
            uLCD.pixel(36, 99, 14722914);
            uLCD.pixel(37, 99, 15841133);
            uLCD.pixel(38, 99, 15972460);
            uLCD.pixel(39, 99, 16629618);
            uLCD.pixel(40, 99, 16433009);
            uLCD.pixel(41, 99, 14657113);
            uLCD.pixel(42, 99, 15183463);
            uLCD.pixel(43, 99, 16368255);
            uLCD.pixel(44, 99, 16040322);
            uLCD.pixel(45, 99, 16303500);
            uLCD.pixel(46, 99, 15843980);
            uLCD.pixel(47, 99, 13345915);
            uLCD.pixel(48, 99, 7691336);
            uLCD.pixel(49, 99, 3614238);
            uLCD.pixel(0, 100, 14852958);
            uLCD.pixel(1, 100, 14589786);
            uLCD.pixel(2, 100, 14195544);
            uLCD.pixel(3, 100, 14130266);
            uLCD.pixel(4, 100, 14327645);
            uLCD.pixel(5, 100, 14458977);
            uLCD.pixel(6, 100, 14327905);
            uLCD.pixel(7, 100, 14196065);
            uLCD.pixel(8, 100, 14853738);
            uLCD.pixel(9, 100, 13603669);
            uLCD.pixel(10, 100, 13800790);
            uLCD.pixel(11, 100, 15576429);
            uLCD.pixel(12, 100, 16497270);
            uLCD.pixel(13, 100, 16562546);
            uLCD.pixel(14, 100, 16759666);
            uLCD.pixel(15, 100, 16761462);
            uLCD.pixel(16, 100, 16695665);
            uLCD.pixel(17, 100, 16235630);
            uLCD.pixel(18, 100, 16762490);
            uLCD.pixel(19, 100, 16235378);
            uLCD.pixel(20, 100, 16103795);
            uLCD.pixel(21, 100, 14064473);
            uLCD.pixel(22, 100, 12880205);
            uLCD.pixel(23, 100, 13604702);
            uLCD.pixel(24, 100, 14658166);
            uLCD.pixel(25, 100, 12816221);
            uLCD.pixel(26, 100, 12554079);
            uLCD.pixel(27, 100, 13870452);
            uLCD.pixel(28, 100, 12357213);
            uLCD.pixel(29, 100, 13804658);
            uLCD.pixel(30, 100, 14857346);
            uLCD.pixel(31, 100, 12423003);
            uLCD.pixel(32, 100, 11963220);
            uLCD.pixel(33, 100, 13608299);
            uLCD.pixel(34, 100, 14133871);
            uLCD.pixel(35, 100, 12948823);
            uLCD.pixel(36, 100, 14592104);
            uLCD.pixel(37, 100, 13933398);
            uLCD.pixel(38, 100, 14919778);
            uLCD.pixel(39, 100, 15313762);
            uLCD.pixel(40, 100, 15444835);
            uLCD.pixel(41, 100, 13931594);
            uLCD.pixel(42, 100, 15247969);
            uLCD.pixel(43, 100, 16762495);
            uLCD.pixel(44, 100, 16301431);
            uLCD.pixel(45, 100, 15907188);
            uLCD.pixel(46, 100, 16565118);
            uLCD.pixel(47, 100, 15973759);
            uLCD.pixel(48, 100, 16237198);
            uLCD.pixel(49, 100, 15448719);
            uLCD.pixel(50, 100, 10910293);
            uLCD.pixel(51, 100, 6701348);
            uLCD.pixel(52, 100, 2756096);
            uLCD.pixel(0, 101, 14195798);
            uLCD.pixel(1, 101, 14327130);
            uLCD.pixel(2, 101, 14459231);
            uLCD.pixel(3, 101, 14591076);
            uLCD.pixel(4, 101, 14656870);
            uLCD.pixel(5, 101, 14394214);
            uLCD.pixel(6, 101, 14196837);
            uLCD.pixel(7, 101, 13999458);
            uLCD.pixel(8, 101, 14065249);
            uLCD.pixel(9, 101, 14525283);
            uLCD.pixel(10, 101, 14130266);
            uLCD.pixel(11, 101, 13603661);
            uLCD.pixel(12, 101, 14655319);
            uLCD.pixel(13, 101, 16365419);
            uLCD.pixel(14, 101, 16760689);
            uLCD.pixel(15, 101, 16430952);
            uLCD.pixel(16, 101, 16563565);
            uLCD.pixel(17, 101, 16564079);
            uLCD.pixel(18, 101, 16235632);
            uLCD.pixel(19, 101, 16630650);
            uLCD.pixel(20, 101, 15644018);
            uLCD.pixel(21, 101, 12419908);
            uLCD.pixel(22, 101, 15381113);
            uLCD.pixel(23, 101, 14789236);
            uLCD.pixel(24, 101, 11565897);
            uLCD.pixel(25, 101, 12816223);
            uLCD.pixel(26, 101, 11369290);
            uLCD.pixel(27, 101, 15120006);
            uLCD.pixel(28, 101, 14264696);
            uLCD.pixel(29, 101, 11765075);
            uLCD.pixel(30, 101, 12225626);
            uLCD.pixel(31, 101, 13541484);
            uLCD.pixel(32, 101, 14002803);
            uLCD.pixel(33, 101, 11831888);
            uLCD.pixel(34, 101, 12554839);
            uLCD.pixel(35, 101, 14067821);
            uLCD.pixel(36, 101, 14264172);
            uLCD.pixel(37, 101, 14263657);
            uLCD.pixel(38, 101, 13736797);
            uLCD.pixel(39, 101, 13736538);
            uLCD.pixel(40, 101, 13867353);
            uLCD.pixel(41, 101, 12617027);
            uLCD.pixel(42, 101, 13669713);
            uLCD.pixel(43, 101, 15709294);
            uLCD.pixel(44, 101, 15972720);
            uLCD.pixel(45, 101, 15973232);
            uLCD.pixel(46, 101, 16104305);
            uLCD.pixel(47, 101, 15380582);
            uLCD.pixel(48, 101, 16037230);
            uLCD.pixel(49, 101, 16695678);
            uLCD.pixel(50, 101, 16697230);
            uLCD.pixel(51, 101, 16173207);
            uLCD.pixel(52, 101, 12688761);
            uLCD.pixel(53, 101, 4796184);
            uLCD.pixel(0, 102, 14788446);
            uLCD.pixel(1, 102, 14591580);
            uLCD.pixel(2, 102, 14328154);
            uLCD.pixel(3, 102, 13934168);
            uLCD.pixel(4, 102, 13736535);
            uLCD.pixel(5, 102, 13737050);
            uLCD.pixel(6, 102, 13999967);
            uLCD.pixel(7, 102, 14263139);
            uLCD.pixel(8, 102, 14131808);
            uLCD.pixel(9, 102, 14328672);
            uLCD.pixel(10, 102, 14525535);
            uLCD.pixel(11, 102, 14920032);
            uLCD.pixel(12, 102, 14984795);
            uLCD.pixel(13, 102, 14195018);
            uLCD.pixel(14, 102, 14918226);
            uLCD.pixel(15, 102, 16761199);
            uLCD.pixel(16, 102, 16761713);
            uLCD.pixel(17, 102, 16762229);
            uLCD.pixel(18, 102, 16234603);
            uLCD.pixel(19, 102, 16432758);
            uLCD.pixel(20, 102, 16169849);
            uLCD.pixel(21, 102, 11828541);
            uLCD.pixel(22, 102, 15249784);
            uLCD.pixel(23, 102, 14527091);
            uLCD.pixel(24, 102, 14263921);
            uLCD.pixel(25, 102, 14132592);
            uLCD.pixel(26, 102, 10118962);
            uLCD.pixel(27, 102, 12421717);
            uLCD.pixel(28, 102, 12882266);
            uLCD.pixel(29, 102, 14000488);
            uLCD.pixel(30, 102, 14790004);
            uLCD.pixel(31, 102, 15776128);
            uLCD.pixel(32, 102, 16434058);
            uLCD.pixel(33, 102, 15841921);
            uLCD.pixel(34, 102, 14132074);
            uLCD.pixel(35, 102, 12750680);
            uLCD.pixel(36, 102, 12685146);
            uLCD.pixel(37, 102, 14067571);
            uLCD.pixel(38, 102, 14791553);
            uLCD.pixel(39, 102, 14463358);
            uLCD.pixel(40, 102, 14068598);
            uLCD.pixel(41, 102, 13015394);
            uLCD.pixel(42, 102, 12818011);
            uLCD.pixel(43, 102, 13475681);
            uLCD.pixel(44, 102, 13870176);
            uLCD.pixel(45, 102, 14133087);
            uLCD.pixel(46, 102, 14198365);
            uLCD.pixel(47, 102, 14066262);
            uLCD.pixel(48, 102, 16105584);
            uLCD.pixel(49, 102, 15645548);
            uLCD.pixel(50, 102, 15843962);
            uLCD.pixel(51, 102, 15583113);
            uLCD.pixel(52, 102, 15519134);
            uLCD.pixel(53, 102, 10324324);
            uLCD.pixel(0, 103, 13409370);
            uLCD.pixel(1, 103, 13672542);
            uLCD.pixel(2, 103, 13870439);
            uLCD.pixel(3, 103, 14265197);
            uLCD.pixel(4, 103, 14397043);
            uLCD.pixel(5, 103, 14528629);
            uLCD.pixel(6, 103, 14463608);
            uLCD.pixel(7, 103, 14463608);
            uLCD.pixel(8, 103, 13607527);
            uLCD.pixel(9, 103, 14660470);
            uLCD.pixel(10, 103, 14199404);
            uLCD.pixel(11, 103, 13475163);
            uLCD.pixel(12, 103, 14198369);
            uLCD.pixel(13, 103, 14461023);
            uLCD.pixel(14, 103, 14131543);
            uLCD.pixel(15, 103, 14525527);
            uLCD.pixel(16, 103, 15905636);
            uLCD.pixel(17, 103, 16760432);
            uLCD.pixel(18, 103, 16760693);
            uLCD.pixel(19, 103, 15906414);
            uLCD.pixel(20, 103, 16630913);
            uLCD.pixel(21, 103, 12618314);
            uLCD.pixel(22, 103, 11368765);
            uLCD.pixel(23, 103, 12553299);
            uLCD.pixel(24, 103, 14988155);
            uLCD.pixel(25, 103, 15711878);
            uLCD.pixel(26, 103, 13145436);
            uLCD.pixel(27, 103, 11302974);
            uLCD.pixel(28, 103, 12223047);
            uLCD.pixel(29, 103, 15643511);
            uLCD.pixel(30, 103, 15511666);
            uLCD.pixel(31, 103, 16762246);
            uLCD.pixel(32, 103, 15510890);
            uLCD.pixel(33, 103, 15511404);
            uLCD.pixel(34, 103, 16763017);
            uLCD.pixel(35, 103, 15908484);
            uLCD.pixel(36, 103, 11765073);
            uLCD.pixel(37, 103, 7029268);
            uLCD.pixel(38, 103, 9596741);
            uLCD.pixel(39, 103, 10518617);
            uLCD.pixel(40, 103, 12427129);
            uLCD.pixel(41, 103, 12887935);
            uLCD.pixel(42, 103, 13413761);
            uLCD.pixel(43, 103, 13742464);
            uLCD.pixel(44, 103, 14070141);
            uLCD.pixel(45, 103, 13938036);
            uLCD.pixel(46, 103, 13805676);
            uLCD.pixel(47, 103, 14133863);
            uLCD.pixel(48, 103, 13279057);
            uLCD.pixel(49, 103, 14200671);
            uLCD.pixel(50, 103, 15254650);
            uLCD.pixel(51, 103, 14269307);
            uLCD.pixel(52, 103, 14665876);
            uLCD.pixel(53, 103, 14140829);
            uLCD.pixel(0, 104, 13808516);
            uLCD.pixel(1, 104, 13282172);
            uLCD.pixel(2, 104, 12230001);
            uLCD.pixel(3, 104, 11374692);
            uLCD.pixel(4, 104, 10453851);
            uLCD.pixel(5, 104, 9533519);
            uLCD.pixel(6, 104, 8809797);
            uLCD.pixel(7, 104, 8349246);
            uLCD.pixel(8, 104, 9730898);
            uLCD.pixel(9, 104, 10125140);
            uLCD.pixel(10, 104, 10058832);
            uLCD.pixel(11, 104, 11242589);
            uLCD.pixel(12, 104, 13479033);
            uLCD.pixel(13, 104, 13939067);
            uLCD.pixel(14, 104, 13149549);
            uLCD.pixel(15, 104, 13674345);
            uLCD.pixel(16, 104, 13998678);
            uLCD.pixel(17, 104, 15247456);
            uLCD.pixel(18, 104, 16169586);
            uLCD.pixel(19, 104, 16038261);
            uLCD.pixel(20, 104, 16565636);
            uLCD.pixel(21, 104, 14658667);
            uLCD.pixel(22, 104, 11566657);
            uLCD.pixel(23, 104, 13145948);
            uLCD.pixel(24, 104, 14461808);
            uLCD.pixel(25, 104, 13540449);
            uLCD.pixel(26, 104, 15776896);
            uLCD.pixel(27, 104, 15183730);
            uLCD.pixel(28, 104, 13077324);
            uLCD.pixel(29, 104, 13734995);
            uLCD.pixel(30, 104, 14720861);
            uLCD.pixel(31, 104, 15444065);
            uLCD.pixel(32, 104, 15575641);
            uLCD.pixel(33, 104, 15707740);
            uLCD.pixel(34, 104, 16038512);
            uLCD.pixel(35, 104, 16106112);
            uLCD.pixel(36, 104, 15845520);
            uLCD.pixel(37, 104, 7031838);
            uLCD.pixel(39, 104, 2100992);
            uLCD.pixel(41, 104, 2562821);
            uLCD.pixel(42, 104, 4337949);
            uLCD.pixel(43, 104, 5981998);
            uLCD.pixel(44, 104, 7888451);
            uLCD.pixel(45, 104, 9466194);
            uLCD.pixel(46, 104, 10781279);
            uLCD.pixel(47, 104, 12030566);
            uLCD.pixel(48, 104, 13610350);
            uLCD.pixel(49, 104, 13742957);
            uLCD.pixel(50, 104, 13282927);
            uLCD.pixel(51, 104, 13152889);
            uLCD.pixel(52, 104, 13548686);
            uLCD.pixel(53, 104, 12102277);
            uLCD.pixel(0, 105, 4930591);
            uLCD.pixel(1, 105, 3943442);
            uLCD.pixel(2, 105, 2561792);
            uLCD.pixel(11, 105, 2167296);
            uLCD.pixel(12, 105, 6903350);
            uLCD.pixel(13, 105, 11179894);
            uLCD.pixel(14, 105, 12692874);
            uLCD.pixel(15, 105, 13150589);
            uLCD.pixel(16, 105, 14132846);
            uLCD.pixel(17, 105, 14130526);
            uLCD.pixel(18, 105, 13539159);
            uLCD.pixel(19, 105, 14197346);
            uLCD.pixel(20, 105, 13803360);
            uLCD.pixel(21, 105, 14264168);
            uLCD.pixel(22, 105, 13146200);
            uLCD.pixel(23, 105, 12225098);
            uLCD.pixel(24, 105, 14067302);
            uLCD.pixel(25, 105, 12948308);
            uLCD.pixel(26, 105, 15185011);
            uLCD.pixel(27, 105, 16565636);
            uLCD.pixel(28, 105, 15314286);
            uLCD.pixel(29, 105, 13537616);
            uLCD.pixel(30, 105, 14721120);
            uLCD.pixel(31, 105, 14655319);
            uLCD.pixel(32, 105, 15444309);
            uLCD.pixel(33, 105, 15182162);
            uLCD.pixel(34, 105, 16696953);
            uLCD.pixel(35, 105, 15515515);
            uLCD.pixel(36, 105, 14992269);
            uLCD.pixel(37, 105, 10586720);
            uLCD.pixel(47, 105, 2295552);
            uLCD.pixel(48, 105, 2164736);
            uLCD.pixel(49, 105, 5718290);
            uLCD.pixel(50, 105, 8152892);
            uLCD.pixel(51, 105, 10851181);
            uLCD.pixel(52, 105, 11115131);
            uLCD.pixel(53, 105, 5852467);
            uLCD.pixel(14, 106, 5129272);
            uLCD.pixel(15, 106, 10390644);
            uLCD.pixel(16, 106, 13675139);
            uLCD.pixel(17, 106, 14396795);
            uLCD.pixel(18, 106, 14133364);
            uLCD.pixel(19, 106, 14067569);
            uLCD.pixel(20, 106, 13344098);
            uLCD.pixel(21, 106, 13870439);
            uLCD.pixel(22, 106, 14001509);
            uLCD.pixel(23, 106, 11895874);
            uLCD.pixel(24, 106, 11830080);
            uLCD.pixel(25, 106, 14461287);
            uLCD.pixel(26, 106, 15118703);
            uLCD.pixel(27, 106, 14855276);
            uLCD.pixel(28, 106, 16763016);
            uLCD.pixel(29, 106, 15315316);
            uLCD.pixel(30, 106, 13012563);
            uLCD.pixel(31, 106, 14393951);
            uLCD.pixel(32, 106, 14196047);
            uLCD.pixel(33, 106, 14197071);
            uLCD.pixel(34, 106, 13804122);
            uLCD.pixel(35, 106, 13411944);
            uLCD.pixel(36, 106, 14993818);
            uLCD.pixel(37, 106, 9733218);
            uLCD.pixel(16, 107, 5914663);
            uLCD.pixel(17, 107, 10320985);
            uLCD.pixel(18, 107, 13873288);
            uLCD.pixel(19, 107, 13412218);
            uLCD.pixel(20, 107, 13740405);
            uLCD.pixel(21, 107, 13608299);
            uLCD.pixel(22, 107, 13212509);
            uLCD.pixel(23, 107, 12948562);
            uLCD.pixel(24, 107, 13474905);
            uLCD.pixel(25, 107, 11500602);
            uLCD.pixel(26, 107, 14198116);
            uLCD.pixel(27, 107, 14132584);
            uLCD.pixel(28, 107, 13277535);
            uLCD.pixel(29, 107, 16041359);
            uLCD.pixel(30, 107, 13344107);
            uLCD.pixel(31, 107, 10646592);
            uLCD.pixel(32, 107, 14002027);
            uLCD.pixel(33, 107, 14726263);
            uLCD.pixel(34, 107, 14004347);
            uLCD.pixel(35, 107, 13348736);
            uLCD.pixel(36, 107, 13021839);
            uLCD.pixel(37, 107, 4668195);
            uLCD.pixel(18, 108, 4995103);
            uLCD.pixel(19, 108, 10454372);
            uLCD.pixel(20, 108, 13873799);
            uLCD.pixel(21, 108, 13806969);
            uLCD.pixel(22, 108, 13344355);
            uLCD.pixel(23, 108, 13606753);
            uLCD.pixel(24, 108, 14461801);
            uLCD.pixel(25, 108, 10908725);
            uLCD.pixel(26, 108, 12225616);
            uLCD.pixel(27, 108, 13871217);
            uLCD.pixel(28, 108, 12819306);
            uLCD.pixel(29, 108, 13939079);
            uLCD.pixel(30, 108, 11044962);
            uLCD.pixel(32, 108, 4663307);
            uLCD.pixel(33, 108, 7755838);
            uLCD.pixel(34, 108, 9467487);
            uLCD.pixel(35, 108, 8876639);
            uLCD.pixel(36, 108, 5193520);
            uLCD.pixel(20, 109, 6046754);
            uLCD.pixel(21, 109, 11702630);
            uLCD.pixel(22, 109, 14398336);
            uLCD.pixel(23, 109, 13937010);
            uLCD.pixel(24, 109, 13146719);
            uLCD.pixel(25, 109, 13673322);
            uLCD.pixel(26, 109, 12292702);
            uLCD.pixel(27, 109, 11635807);
            uLCD.pixel(28, 109, 13479817);
            uLCD.pixel(29, 109, 12757386);
            uLCD.pixel(30, 109, 6574135);
            uLCD.pixel(21, 110, 3480320);
            uLCD.pixel(22, 110, 8215603);
            uLCD.pixel(23, 110, 12622702);
            uLCD.pixel(24, 110, 13674361);
            uLCD.pixel(25, 110, 14201477);
            uLCD.pixel(26, 110, 13808008);
            uLCD.pixel(27, 110, 13020297);
            uLCD.pixel(28, 110, 10192750);
            uLCD.pixel(29, 110, 3944220);
            uLCD.pixel(22, 111, 2032896);
            uLCD.pixel(23, 111, 3479552);
            uLCD.pixel(24, 111, 7295025);
            uLCD.pixel(25, 111, 8742984);
            uLCD.pixel(26, 111, 8414795);
            uLCD.pixel(27, 111, 4535067);
        }

        // Draw right Scissors
        void drawRightScissors() {
            uLCD.pixel(101, 82, 2362112);
            uLCD.pixel(102, 82, 6769972);
            uLCD.pixel(103, 82, 11112562);
            uLCD.pixel(104, 82, 11901816);
            uLCD.pixel(105, 82, 11243368);
            uLCD.pixel(106, 82, 10256472);
            uLCD.pixel(107, 82, 8809796);
            uLCD.pixel(108, 82, 8020794);
            uLCD.pixel(109, 82, 6376230);
            uLCD.pixel(110, 82, 4205324);
            uLCD.pixel(111, 82, 2561280);
            uLCD.pixel(100, 83, 3742464);
            uLCD.pixel(101, 83, 11701349);
            uLCD.pixel(102, 83, 16438699);
            uLCD.pixel(103, 83, 15780507);
            uLCD.pixel(104, 83, 15187851);
            uLCD.pixel(105, 83, 16174998);
            uLCD.pixel(106, 83, 16306836);
            uLCD.pixel(107, 83, 15451527);
            uLCD.pixel(108, 83, 15846801);
            uLCD.pixel(109, 83, 16242590);
            uLCD.pixel(110, 83, 15518873);
            uLCD.pixel(111, 83, 11769450);
            uLCD.pixel(112, 83, 6243616);
            uLCD.pixel(113, 83, 2098944);
            uLCD.pixel(100, 84, 10976599);
            uLCD.pixel(101, 84, 16566163);
            uLCD.pixel(102, 84, 15908231);
            uLCD.pixel(103, 84, 16039554);
            uLCD.pixel(104, 84, 15908219);
            uLCD.pixel(105, 84, 16631681);
            uLCD.pixel(106, 84, 15776881);
            uLCD.pixel(107, 84, 15842673);
            uLCD.pixel(108, 84, 16040822);
            uLCD.pixel(109, 84, 15777910);
            uLCD.pixel(110, 84, 15712380);
            uLCD.pixel(111, 84, 15976328);
            uLCD.pixel(112, 84, 15582602);
            uLCD.pixel(113, 84, 12950890);
            uLCD.pixel(114, 84, 7819554);
            uLCD.pixel(115, 84, 3149824);
            uLCD.pixel(77, 85, 8020817);
            uLCD.pixel(78, 85, 10322794);
            uLCD.pixel(79, 85, 11637625);
            uLCD.pixel(80, 85, 9466458);
            uLCD.pixel(81, 85, 8216138);
            uLCD.pixel(82, 85, 7032384);
            uLCD.pixel(83, 85, 5256484);
            uLCD.pixel(84, 85, 4994590);
            uLCD.pixel(85, 85, 4535320);
            uLCD.pixel(86, 85, 3219207);
            uLCD.pixel(87, 85, 2364160);
            uLCD.pixel(99, 85, 7559229);
            uLCD.pixel(100, 85, 15316615);
            uLCD.pixel(101, 85, 16763792);
            uLCD.pixel(102, 85, 15840373);
            uLCD.pixel(103, 85, 16168820);
            uLCD.pixel(104, 85, 16169071);
            uLCD.pixel(105, 85, 16366446);
            uLCD.pixel(106, 85, 16103527);
            uLCD.pixel(107, 85, 16762225);
            uLCD.pixel(108, 85, 16367467);
            uLCD.pixel(109, 85, 16499568);
            uLCD.pixel(110, 85, 16302449);
            uLCD.pixel(111, 85, 15908467);
            uLCD.pixel(112, 85, 15843194);
            uLCD.pixel(113, 85, 16106885);
            uLCD.pixel(114, 85, 16106633);
            uLCD.pixel(115, 85, 15384971);
            uLCD.pixel(116, 85, 12886902);
            uLCD.pixel(117, 85, 13151364);
            uLCD.pixel(118, 85, 13611916);
            uLCD.pixel(119, 85, 13415053);
            uLCD.pixel(120, 85, 12690562);
            uLCD.pixel(121, 85, 11178095);
            uLCD.pixel(122, 85, 9861981);
            uLCD.pixel(123, 85, 9007186);
            uLCD.pixel(124, 85, 7756608);
            uLCD.pixel(125, 85, 7427902);
            uLCD.pixel(126, 85, 7362111);
            uLCD.pixel(127, 85, 7560003);
            uLCD.pixel(75, 86, 2430981);
            uLCD.pixel(76, 86, 12232836);
            uLCD.pixel(77, 86, 15324066);
            uLCD.pixel(78, 86, 15059856);
            uLCD.pixel(79, 86, 15519629);
            uLCD.pixel(80, 86, 15190662);
            uLCD.pixel(81, 86, 15388041);
            uLCD.pixel(82, 86, 16045973);
            uLCD.pixel(83, 86, 14861446);
            uLCD.pixel(84, 86, 16044957);
            uLCD.pixel(85, 86, 15781788);
            uLCD.pixel(86, 86, 14203017);
            uLCD.pixel(87, 86, 13874310);
            uLCD.pixel(88, 86, 11111781);
            uLCD.pixel(89, 86, 8875336);
            uLCD.pixel(90, 86, 6046754);
            uLCD.pixel(91, 86, 3810052);
            uLCD.pixel(96, 86, 3152640);
            uLCD.pixel(97, 86, 3745028);
            uLCD.pixel(98, 86, 5652253);
            uLCD.pixel(99, 86, 14729110);
            uLCD.pixel(100, 86, 16039817);
            uLCD.pixel(101, 86, 16300154);
            uLCD.pixel(102, 86, 15905394);
            uLCD.pixel(103, 86, 16760956);
            uLCD.pixel(104, 86, 16761978);
            uLCD.pixel(105, 86, 16760945);
            uLCD.pixel(106, 86, 16431979);
            uLCD.pixel(107, 86, 16761198);
            uLCD.pixel(108, 86, 16366440);
            uLCD.pixel(109, 86, 16695664);
            uLCD.pixel(110, 86, 16630388);
            uLCD.pixel(111, 86, 16236404);
            uLCD.pixel(112, 86, 15907956);
            uLCD.pixel(113, 86, 15843194);
            uLCD.pixel(114, 86, 15974527);
            uLCD.pixel(115, 86, 15909247);
            uLCD.pixel(116, 86, 15909246);
            uLCD.pixel(117, 86, 16040832);
            uLCD.pixel(118, 86, 16106626);
            uLCD.pixel(119, 86, 15975297);
            uLCD.pixel(120, 86, 15908993);
            uLCD.pixel(121, 86, 15843715);
            uLCD.pixel(122, 86, 15975047);
            uLCD.pixel(123, 86, 16041611);
            uLCD.pixel(124, 86, 16435601);
            uLCD.pixel(125, 86, 16107152);
            uLCD.pixel(126, 86, 16107152);
            uLCD.pixel(127, 86, 16239251);
            uLCD.pixel(75, 87, 5259815);
            uLCD.pixel(76, 87, 14798753);
            uLCD.pixel(77, 87, 14270853);
            uLCD.pixel(78, 87, 15388292);
            uLCD.pixel(79, 87, 14466411);
            uLCD.pixel(80, 87, 15190387);
            uLCD.pixel(81, 87, 13808219);
            uLCD.pixel(82, 87, 14466662);
            uLCD.pixel(83, 87, 15847036);
            uLCD.pixel(84, 87, 15516282);
            uLCD.pixel(85, 87, 15119990);
            uLCD.pixel(86, 87, 13936486);
            uLCD.pixel(87, 87, 16239502);
            uLCD.pixel(88, 87, 16043153);
            uLCD.pixel(89, 87, 16635549);
            uLCD.pixel(90, 87, 15583892);
            uLCD.pixel(91, 87, 14926477);
            uLCD.pixel(92, 87, 13874050);
            uLCD.pixel(93, 87, 12953207);
            uLCD.pixel(94, 87, 12097898);
            uLCD.pixel(95, 87, 12625012);
            uLCD.pixel(96, 87, 13677700);
            uLCD.pixel(97, 87, 12953975);
            uLCD.pixel(98, 87, 13743491);
            uLCD.pixel(99, 87, 15188621);
            uLCD.pixel(100, 87, 16565896);
            uLCD.pixel(101, 87, 16431738);
            uLCD.pixel(102, 87, 16760442);
            uLCD.pixel(103, 87, 16694903);
            uLCD.pixel(104, 87, 16497007);
            uLCD.pixel(105, 87, 16562796);
            uLCD.pixel(106, 87, 16760944);
            uLCD.pixel(107, 87, 16497256);
            uLCD.pixel(108, 87, 16694635);
            uLCD.pixel(109, 87, 16563565);
            uLCD.pixel(110, 87, 16432493);
            uLCD.pixel(111, 87, 16235630);
            uLCD.pixel(112, 87, 16367477);
            uLCD.pixel(113, 87, 16367991);
            uLCD.pixel(114, 87, 15776370);
            uLCD.pixel(115, 87, 15381096);
            uLCD.pixel(116, 87, 16367216);
            uLCD.pixel(117, 87, 16498286);
            uLCD.pixel(118, 87, 16498286);
            uLCD.pixel(119, 87, 16366446);
            uLCD.pixel(120, 87, 16300653);
            uLCD.pixel(121, 87, 16432241);
            uLCD.pixel(122, 87, 16629622);
            uLCD.pixel(123, 87, 16695929);
            uLCD.pixel(124, 87, 16235379);
            uLCD.pixel(125, 87, 16038002);
            uLCD.pixel(126, 87, 15972209);
            uLCD.pixel(127, 87, 16038259);
            uLCD.pixel(75, 88, 4667166);
            uLCD.pixel(76, 88, 13481870);
            uLCD.pixel(77, 88, 13414778);
            uLCD.pixel(78, 88, 15190151);
            uLCD.pixel(79, 88, 14268269);
            uLCD.pixel(80, 88, 14530923);
            uLCD.pixel(81, 88, 12425801);
            uLCD.pixel(82, 88, 13149524);
            uLCD.pixel(83, 88, 15055981);
            uLCD.pixel(84, 88, 15776368);
            uLCD.pixel(85, 88, 15051618);
            uLCD.pixel(86, 88, 13802064);
            uLCD.pixel(87, 88, 15907956);
            uLCD.pixel(88, 88, 15447918);
            uLCD.pixel(89, 88, 15777399);
            uLCD.pixel(90, 88, 15580792);
            uLCD.pixel(91, 88, 16041859);
            uLCD.pixel(92, 88, 14265962);
            uLCD.pixel(93, 88, 15384959);
            uLCD.pixel(94, 88, 16109197);
            uLCD.pixel(95, 88, 16109197);
            uLCD.pixel(96, 88, 14135664);
            uLCD.pixel(97, 88, 14201459);
            uLCD.pixel(98, 88, 15319940);
            uLCD.pixel(99, 88, 15121017);
            uLCD.pixel(100, 88, 16696706);
            uLCD.pixel(101, 88, 16563576);
            uLCD.pixel(102, 88, 16563317);
            uLCD.pixel(103, 88, 16563316);
            uLCD.pixel(104, 88, 16562800);
            uLCD.pixel(105, 88, 16760175);
            uLCD.pixel(106, 88, 16761973);
            uLCD.pixel(107, 88, 16496745);
            uLCD.pixel(108, 88, 16694122);
            uLCD.pixel(109, 88, 16760172);
            uLCD.pixel(110, 88, 16694637);
            uLCD.pixel(111, 88, 16431979);
            uLCD.pixel(112, 88, 16366700);
            uLCD.pixel(113, 88, 16564595);
            uLCD.pixel(114, 88, 16762490);
            uLCD.pixel(115, 88, 16763262);
            uLCD.pixel(116, 88, 16628591);
            uLCD.pixel(117, 88, 16759921);
            uLCD.pixel(118, 88, 16760178);
            uLCD.pixel(119, 88, 16760180);
            uLCD.pixel(120, 88, 16693873);
            uLCD.pixel(121, 88, 16365421);
            uLCD.pixel(122, 88, 16167788);
            uLCD.pixel(123, 88, 16101995);
            uLCD.pixel(124, 88, 16760440);
            uLCD.pixel(125, 88, 16694133);
            uLCD.pixel(126, 88, 16628340);
            uLCD.pixel(127, 88, 16629110);
            uLCD.pixel(76, 89, 8679250);
            uLCD.pixel(77, 89, 12032884);
            uLCD.pixel(78, 89, 12558192);
            uLCD.pixel(79, 89, 13939067);
            uLCD.pixel(80, 89, 13806966);
            uLCD.pixel(81, 89, 13412462);
            uLCD.pixel(82, 89, 13872759);
            uLCD.pixel(83, 89, 13213541);
            uLCD.pixel(84, 89, 13407573);
            uLCD.pixel(85, 89, 13208651);
            uLCD.pixel(86, 89, 12945992);
            uLCD.pixel(87, 89, 15511917);
            uLCD.pixel(88, 89, 15775600);
            uLCD.pixel(89, 89, 16105335);
            uLCD.pixel(90, 89, 16040053);
            uLCD.pixel(91, 89, 16105846);
            uLCD.pixel(92, 89, 15580018);
            uLCD.pixel(93, 89, 15975289);
            uLCD.pixel(94, 89, 15712119);
            uLCD.pixel(95, 89, 14528102);
            uLCD.pixel(96, 89, 13541209);
            uLCD.pixel(97, 89, 16436101);
            uLCD.pixel(98, 89, 15449208);
            uLCD.pixel(99, 89, 16567174);
            uLCD.pixel(100, 89, 16236153);
            uLCD.pixel(101, 89, 15840623);
            uLCD.pixel(102, 89, 14458198);
            uLCD.pixel(103, 89, 15971179);
            uLCD.pixel(104, 89, 16761464);
            uLCD.pixel(105, 89, 16760692);
            uLCD.pixel(106, 89, 16761206);
            uLCD.pixel(107, 89, 16693612);
            uLCD.pixel(108, 89, 16627818);
            uLCD.pixel(109, 89, 16759918);
            uLCD.pixel(110, 89, 16760943);
            uLCD.pixel(111, 89, 16760429);
            uLCD.pixel(112, 89, 16563049);
            uLCD.pixel(113, 89, 16103014);
            uLCD.pixel(114, 89, 15971428);
            uLCD.pixel(115, 89, 15905636);
            uLCD.pixel(116, 89, 16562798);
            uLCD.pixel(117, 89, 16497007);
            uLCD.pixel(118, 89, 16431214);
            uLCD.pixel(119, 89, 16431214);
            uLCD.pixel(120, 89, 16562800);
            uLCD.pixel(121, 89, 16760693);
            uLCD.pixel(122, 89, 16761721);
            uLCD.pixel(123, 89, 16762494);
            uLCD.pixel(124, 89, 16759925);
            uLCD.pixel(125, 89, 16497523);
            uLCD.pixel(126, 89, 16694132);
            uLCD.pixel(127, 89, 16694902);
            uLCD.pixel(77, 90, 4796192);
            uLCD.pixel(78, 90, 5256223);
            uLCD.pixel(79, 90, 7492157);
            uLCD.pixel(80, 90, 8083522);
            uLCD.pixel(81, 90, 10254693);
            uLCD.pixel(82, 90, 12755342);
            uLCD.pixel(83, 90, 13938581);
            uLCD.pixel(84, 90, 14856333);
            uLCD.pixel(85, 90, 14526331);
            uLCD.pixel(86, 90, 13539434);
            uLCD.pixel(87, 90, 13868652);
            uLCD.pixel(88, 90, 13803109);
            uLCD.pixel(89, 90, 14197864);
            uLCD.pixel(90, 90, 14592104);
            uLCD.pixel(91, 90, 13934429);
            uLCD.pixel(92, 90, 14000220);
            uLCD.pixel(93, 90, 15052906);
            uLCD.pixel(94, 90, 15842422);
            uLCD.pixel(95, 90, 13868375);
            uLCD.pixel(96, 90, 14460258);
            uLCD.pixel(97, 90, 16236669);
            uLCD.pixel(98, 90, 15315569);
            uLCD.pixel(99, 90, 15907190);
            uLCD.pixel(100, 90, 16170360);
            uLCD.pixel(101, 90, 15907186);
            uLCD.pixel(102, 90, 12156472);
            uLCD.pixel(103, 90, 14261589);
            uLCD.pixel(104, 90, 16168559);
            uLCD.pixel(105, 90, 16233581);
            uLCD.pixel(106, 90, 16693875);
            uLCD.pixel(107, 90, 16759923);
            uLCD.pixel(108, 90, 16759921);
            uLCD.pixel(109, 90, 16759405);
            uLCD.pixel(110, 90, 16693611);
            uLCD.pixel(111, 90, 16760172);
            uLCD.pixel(112, 90, 16761200);
            uLCD.pixel(113, 90, 16761711);
            uLCD.pixel(114, 90, 16761454);
            uLCD.pixel(115, 90, 16761455);
            uLCD.pixel(116, 90, 16630388);
            uLCD.pixel(117, 90, 16630136);
            uLCD.pixel(118, 90, 16630136);
            uLCD.pixel(119, 90, 16630136);
            uLCD.pixel(120, 90, 16498804);
            uLCD.pixel(121, 90, 16301425);
            uLCD.pixel(122, 90, 16038253);
            uLCD.pixel(123, 90, 15775594);
            uLCD.pixel(124, 90, 16367218);
            uLCD.pixel(125, 90, 16170352);
            uLCD.pixel(126, 90, 16301425);
            uLCD.pixel(127, 90, 16367731);
            uLCD.pixel(82, 91, 2822416);
            uLCD.pixel(83, 91, 5190188);
            uLCD.pixel(84, 91, 8214600);
            uLCD.pixel(85, 91, 10647907);
            uLCD.pixel(86, 91, 12687230);
            uLCD.pixel(87, 91, 13673861);
            uLCD.pixel(88, 91, 13805183);
            uLCD.pixel(89, 91, 14067579);
            uLCD.pixel(90, 91, 14329973);
            uLCD.pixel(91, 91, 13079643);
            uLCD.pixel(92, 91, 13276762);
            uLCD.pixel(93, 91, 14131553);
            uLCD.pixel(94, 91, 15512178);
            uLCD.pixel(95, 91, 13143884);
            uLCD.pixel(96, 91, 16367228);
            uLCD.pixel(97, 91, 16300924);
            uLCD.pixel(98, 91, 16765330);
            uLCD.pixel(99, 91, 14524513);
            uLCD.pixel(100, 91, 13012812);
            uLCD.pixel(101, 91, 14789734);
            uLCD.pixel(102, 91, 11301678);
            uLCD.pixel(103, 91, 14327643);
            uLCD.pixel(104, 91, 16695678);
            uLCD.pixel(105, 91, 16760958);
            uLCD.pixel(106, 91, 16760699);
            uLCD.pixel(107, 91, 16760440);
            uLCD.pixel(108, 91, 16759668);
            uLCD.pixel(109, 91, 16759666);
            uLCD.pixel(110, 91, 16760178);
            uLCD.pixel(111, 91, 16760431);
            uLCD.pixel(112, 91, 16759915);
            uLCD.pixel(113, 91, 16563047);
            uLCD.pixel(114, 91, 16694633);
            uLCD.pixel(115, 91, 16761198);
            uLCD.pixel(116, 91, 16433009);
            uLCD.pixel(117, 91, 16301938);
            uLCD.pixel(118, 91, 16301425);
            uLCD.pixel(119, 91, 16301938);
            uLCD.pixel(120, 91, 16433009);
            uLCD.pixel(121, 91, 16499315);
            uLCD.pixel(122, 91, 16630386);
            uLCD.pixel(123, 91, 16565106);
            uLCD.pixel(124, 91, 16433007);
            uLCD.pixel(125, 91, 16301934);
            uLCD.pixel(126, 91, 16367216);
            uLCD.pixel(127, 91, 16367729);
            uLCD.pixel(85, 92, 2099978);
            uLCD.pixel(86, 92, 2296583);
            uLCD.pixel(87, 92, 4664353);
            uLCD.pixel(88, 92, 8479310);
            uLCD.pixel(89, 92, 11504752);
            uLCD.pixel(90, 92, 13674628);
            uLCD.pixel(91, 92, 13673591);
            uLCD.pixel(92, 92, 14198387);
            uLCD.pixel(93, 92, 13737316);
            uLCD.pixel(94, 92, 13670493);
            uLCD.pixel(95, 92, 13274704);
            uLCD.pixel(96, 92, 16762248);
            uLCD.pixel(97, 92, 15905397);
            uLCD.pixel(98, 92, 16760193);
            uLCD.pixel(99, 92, 15774325);
            uLCD.pixel(100, 92, 11434295);
            uLCD.pixel(101, 92, 13474905);
            uLCD.pixel(102, 92, 12750155);
            uLCD.pixel(103, 92, 13802330);
            uLCD.pixel(104, 92, 15643764);
            uLCD.pixel(105, 92, 16169338);
            uLCD.pixel(106, 92, 16761731);
            uLCD.pixel(107, 92, 16694651);
            uLCD.pixel(108, 92, 16761213);
            uLCD.pixel(109, 92, 16759925);
            uLCD.pixel(110, 92, 16628593);
            uLCD.pixel(111, 92, 16760177);
            uLCD.pixel(112, 92, 16760687);
            uLCD.pixel(113, 92, 16563819);
            uLCD.pixel(114, 92, 16498024);
            uLCD.pixel(115, 92, 16563819);
            uLCD.pixel(116, 92, 15971429);
            uLCD.pixel(117, 92, 16168810);
            uLCD.pixel(118, 92, 16761205);
            uLCD.pixel(119, 92, 16300394);
            uLCD.pixel(120, 92, 16760687);
            uLCD.pixel(121, 92, 16563565);
            uLCD.pixel(122, 92, 16760942);
            uLCD.pixel(123, 92, 16563819);
            uLCD.pixel(124, 92, 16694633);
            uLCD.pixel(125, 92, 16563817);
            uLCD.pixel(126, 92, 16694635);
            uLCD.pixel(127, 92, 16563819);
            uLCD.pixel(90, 93, 4596998);
            uLCD.pixel(91, 93, 8345649);
            uLCD.pixel(92, 93, 13936761);
            uLCD.pixel(93, 93, 15185023);
            uLCD.pixel(94, 93, 13933924);
            uLCD.pixel(95, 93, 14459237);
            uLCD.pixel(96, 93, 16366462);
            uLCD.pixel(97, 93, 16760962);
            uLCD.pixel(98, 93, 16694399);
            uLCD.pixel(99, 93, 15445360);
            uLCD.pixel(100, 93, 13737567);
            uLCD.pixel(101, 93, 10448687);
            uLCD.pixel(102, 93, 14198375);
            uLCD.pixel(103, 93, 14329704);
            uLCD.pixel(104, 93, 14591593);
            uLCD.pixel(105, 93, 16763788);
            uLCD.pixel(106, 93, 15905911);
            uLCD.pixel(107, 93, 15708015);
            uLCD.pixel(108, 93, 16103027);
            uLCD.pixel(109, 93, 16299891);
            uLCD.pixel(110, 93, 16629109);
            uLCD.pixel(111, 93, 16761207);
            uLCD.pixel(112, 93, 16761202);
            uLCD.pixel(113, 93, 16498285);
            uLCD.pixel(114, 93, 16629869);
            uLCD.pixel(115, 93, 16761972);
            uLCD.pixel(116, 93, 15773284);
            uLCD.pixel(117, 93, 16035945);
            uLCD.pixel(118, 93, 16760951);
            uLCD.pixel(119, 93, 16759921);
            uLCD.pixel(120, 93, 16761206);
            uLCD.pixel(121, 93, 16760689);
            uLCD.pixel(122, 93, 16760945);
            uLCD.pixel(123, 93, 16759917);
            uLCD.pixel(124, 93, 16760429);
            uLCD.pixel(125, 93, 16760429);
            uLCD.pixel(126, 93, 16760431);
            uLCD.pixel(127, 93, 16760431);
            uLCD.pixel(91, 94, 4596992);
            uLCD.pixel(92, 94, 13147758);
            uLCD.pixel(93, 94, 13738604);
            uLCD.pixel(94, 94, 13474143);
            uLCD.pixel(95, 94, 13275733);
            uLCD.pixel(96, 94, 15906423);
            uLCD.pixel(97, 94, 15971957);
            uLCD.pixel(98, 94, 16629887);
            uLCD.pixel(99, 94, 15709557);
            uLCD.pixel(100, 94, 14396269);
            uLCD.pixel(101, 94, 10318132);
            uLCD.pixel(102, 94, 14002025);
            uLCD.pixel(103, 94, 14593648);
            uLCD.pixel(104, 94, 13671520);
            uLCD.pixel(105, 94, 15052657);
            uLCD.pixel(106, 94, 16762246);
            uLCD.pixel(107, 94, 16761732);
            uLCD.pixel(108, 94, 16763786);
            uLCD.pixel(109, 94, 16695162);
            uLCD.pixel(110, 94, 15971437);
            uLCD.pixel(111, 94, 15840106);
            uLCD.pixel(112, 94, 16169069);
            uLCD.pixel(113, 94, 16235630);
            uLCD.pixel(114, 94, 16301421);
            uLCD.pixel(115, 94, 16366448);
            uLCD.pixel(116, 94, 15641193);
            uLCD.pixel(117, 94, 15509096);
            uLCD.pixel(118, 94, 16759931);
            uLCD.pixel(119, 94, 16693622);
            uLCD.pixel(120, 94, 16760186);
            uLCD.pixel(121, 94, 16693620);
            uLCD.pixel(122, 94, 16693875);
            uLCD.pixel(123, 94, 16628080);
            uLCD.pixel(124, 94, 16759153);
            uLCD.pixel(125, 94, 16759153);
            uLCD.pixel(126, 94, 16759153);
            uLCD.pixel(127, 94, 16759153);
            uLCD.pixel(90, 95, 2427136);
            uLCD.pixel(91, 95, 6702102);
            uLCD.pixel(92, 95, 15319180);
            uLCD.pixel(93, 95, 13870442);
            uLCD.pixel(94, 95, 14329450);
            uLCD.pixel(95, 95, 13144658);
            uLCD.pixel(96, 95, 15183213);
            uLCD.pixel(97, 95, 14986088);
            uLCD.pixel(98, 95, 15249258);
            uLCD.pixel(99, 95, 15842426);
            uLCD.pixel(100, 95, 13541476);
            uLCD.pixel(101, 95, 11041600);
            uLCD.pixel(102, 95, 10975549);
            uLCD.pixel(103, 95, 11895881);
            uLCD.pixel(104, 95, 13210969);
            uLCD.pixel(105, 95, 12749902);
            uLCD.pixel(106, 95, 15249007);
            uLCD.pixel(107, 95, 14919528);
            uLCD.pixel(108, 95, 13800786);
            uLCD.pixel(109, 95, 13669454);
            uLCD.pixel(110, 95, 14195026);
            uLCD.pixel(111, 95, 15313762);
            uLCD.pixel(112, 95, 16563829);
            uLCD.pixel(113, 95, 16763004);
            uLCD.pixel(114, 95, 16761976);
            uLCD.pixel(115, 95, 16432243);
            uLCD.pixel(116, 95, 16299895);
            uLCD.pixel(117, 95, 15378539);
            uLCD.pixel(118, 95, 16760703);
            uLCD.pixel(119, 95, 16628858);
            uLCD.pixel(120, 95, 16694649);
            uLCD.pixel(121, 95, 16563317);
            uLCD.pixel(122, 95, 16759925);
            uLCD.pixel(123, 95, 16760696);
            uLCD.pixel(124, 95, 16760182);
            uLCD.pixel(125, 95, 16760182);
            uLCD.pixel(126, 95, 16760182);
            uLCD.pixel(127, 95, 16760182);
            uLCD.pixel(88, 96, 3283456);
            uLCD.pixel(89, 96, 7098149);
            uLCD.pixel(90, 96, 11109717);
            uLCD.pixel(91, 96, 15845524);
            uLCD.pixel(92, 96, 15646599);
            uLCD.pixel(93, 96, 13935205);
            uLCD.pixel(94, 96, 13934944);
            uLCD.pixel(95, 96, 13144913);
            uLCD.pixel(96, 96, 12552774);
            uLCD.pixel(97, 96, 15184494);
            uLCD.pixel(98, 96, 13013325);
            uLCD.pixel(99, 96, 15053937);
            uLCD.pixel(100, 96, 13673062);
            uLCD.pixel(101, 96, 12949597);
            uLCD.pixel(102, 96, 14659957);
            uLCD.pixel(103, 96, 12751444);
            uLCD.pixel(104, 96, 12816465);
            uLCD.pixel(105, 96, 11828798);
            uLCD.pixel(106, 96, 12025403);
            uLCD.pixel(107, 96, 13801299);
            uLCD.pixel(108, 96, 15314279);
            uLCD.pixel(109, 96, 16037230);
            uLCD.pixel(110, 96, 16760953);
            uLCD.pixel(111, 96, 16762236);
            uLCD.pixel(112, 96, 16761979);
            uLCD.pixel(113, 96, 16695415);
            uLCD.pixel(114, 96, 16366964);
            uLCD.pixel(115, 96, 16301172);
            uLCD.pixel(116, 96, 16169847);
            uLCD.pixel(117, 96, 14656608);
            uLCD.pixel(118, 96, 16301431);
            uLCD.pixel(119, 96, 16301685);
            uLCD.pixel(120, 96, 16301684);
            uLCD.pixel(121, 96, 16301938);
            uLCD.pixel(122, 96, 16301423);
            uLCD.pixel(123, 96, 16564593);
            uLCD.pixel(124, 96, 16367214);
            uLCD.pixel(125, 96, 16367214);
            uLCD.pixel(126, 96, 16498032);
            uLCD.pixel(127, 96, 16367216);
            uLCD.pixel(84, 97, 2166016);
            uLCD.pixel(85, 97, 5191695);
            uLCD.pixel(86, 97, 8677694);
            uLCD.pixel(87, 97, 10979418);
            uLCD.pixel(88, 97, 13938816);
            uLCD.pixel(89, 97, 16437919);
            uLCD.pixel(90, 97, 16305044);
            uLCD.pixel(91, 97, 15448704);
            uLCD.pixel(92, 97, 14855796);
            uLCD.pixel(93, 97, 13999969);
            uLCD.pixel(94, 97, 15184241);
            uLCD.pixel(95, 97, 13539416);
            uLCD.pixel(96, 97, 13145427);
            uLCD.pixel(97, 97, 16764555);
            uLCD.pixel(98, 97, 14396520);
            uLCD.pixel(99, 97, 15580541);
            uLCD.pixel(100, 97, 12620375);
            uLCD.pixel(101, 97, 11896652);
            uLCD.pixel(102, 97, 14527601);
            uLCD.pixel(103, 97, 13869412);
            uLCD.pixel(104, 97, 14789483);
            uLCD.pixel(105, 97, 15776118);
            uLCD.pixel(106, 97, 15906675);
            uLCD.pixel(107, 97, 16432758);
            uLCD.pixel(108, 97, 16366195);
            uLCD.pixel(109, 97, 16563316);
            uLCD.pixel(110, 97, 16563316);
            uLCD.pixel(111, 97, 16300144);
            uLCD.pixel(112, 97, 16168558);
            uLCD.pixel(113, 97, 16234864);
            uLCD.pixel(114, 97, 16497781);
            uLCD.pixel(115, 97, 16564346);
            uLCD.pixel(116, 97, 16038772);
            uLCD.pixel(117, 97, 13933396);
            uLCD.pixel(118, 97, 15972979);
            uLCD.pixel(119, 97, 16302198);
            uLCD.pixel(120, 97, 16433781);
            uLCD.pixel(121, 97, 16565108);
            uLCD.pixel(122, 97, 16170348);
            uLCD.pixel(123, 97, 16433520);
            uLCD.pixel(124, 97, 16301934);
            uLCD.pixel(125, 97, 16367214);
            uLCD.pixel(126, 97, 16367216);
            uLCD.pixel(127, 97, 16367216);
            uLCD.pixel(80, 98, 2231040);
            uLCD.pixel(81, 98, 5388579);
            uLCD.pixel(82, 98, 9467998);
            uLCD.pixel(83, 98, 12493953);
            uLCD.pixel(84, 98, 15715741);
            uLCD.pixel(85, 98, 15188103);
            uLCD.pixel(86, 98, 15384456);
            uLCD.pixel(87, 98, 16567701);
            uLCD.pixel(88, 98, 16106121);
            uLCD.pixel(89, 98, 15381370);
            uLCD.pixel(90, 98, 16236420);
            uLCD.pixel(91, 98, 16763279);
            uLCD.pixel(92, 98, 14064222);
            uLCD.pixel(93, 98, 13866843);
            uLCD.pixel(94, 98, 15183730);
            uLCD.pixel(95, 98, 13407832);
            uLCD.pixel(96, 98, 13540447);
            uLCD.pixel(97, 98, 15975301);
            uLCD.pixel(98, 98, 14396783);
            uLCD.pixel(99, 98, 13936747);
            uLCD.pixel(100, 98, 11304515);
            uLCD.pixel(101, 98, 12882777);
            uLCD.pixel(102, 98, 13803621);
            uLCD.pixel(103, 98, 14263911);
            uLCD.pixel(104, 98, 14065502);
            uLCD.pixel(105, 98, 14262363);
            uLCD.pixel(106, 98, 16695930);
            uLCD.pixel(107, 98, 16629620);
            uLCD.pixel(108, 98, 16629107);
            uLCD.pixel(109, 98, 16760434);
            uLCD.pixel(110, 98, 16760691);
            uLCD.pixel(111, 98, 16760950);
            uLCD.pixel(112, 98, 16761723);
            uLCD.pixel(113, 98, 16761980);
            uLCD.pixel(114, 98, 16694903);
            uLCD.pixel(115, 98, 16103025);
            uLCD.pixel(116, 98, 16498301);
            uLCD.pixel(117, 98, 13735508);
            uLCD.pixel(118, 98, 15775089);
            uLCD.pixel(119, 98, 16235638);
            uLCD.pixel(120, 98, 16433271);
            uLCD.pixel(121, 98, 16695929);
            uLCD.pixel(122, 98, 16235632);
            uLCD.pixel(123, 98, 16498802);
            uLCD.pixel(124, 98, 16564595);
            uLCD.pixel(125, 98, 16695411);
            uLCD.pixel(126, 98, 16695413);
            uLCD.pixel(127, 98, 16695413);
            uLCD.pixel(78, 99, 4137993);
            uLCD.pixel(79, 99, 8281920);
            uLCD.pixel(80, 99, 12820860);
            uLCD.pixel(81, 99, 15518113);
            uLCD.pixel(82, 99, 15715490);
            uLCD.pixel(83, 99, 15187854);
            uLCD.pixel(84, 99, 15910025);
            uLCD.pixel(85, 99, 14658926);
            uLCD.pixel(86, 99, 14198116);
            uLCD.pixel(87, 99, 16171136);
            uLCD.pixel(88, 99, 16564866);
            uLCD.pixel(89, 99, 15906677);
            uLCD.pixel(90, 99, 16038009);
            uLCD.pixel(91, 99, 14656357);
            uLCD.pixel(92, 99, 13472085);
            uLCD.pixel(93, 99, 14064481);
            uLCD.pixel(94, 99, 13670752);
            uLCD.pixel(95, 99, 14658418);
            uLCD.pixel(96, 99, 13343330);
            uLCD.pixel(97, 99, 15975564);
            uLCD.pixel(98, 99, 14133875);
            uLCD.pixel(99, 99, 13739631);
            uLCD.pixel(100, 99, 11436362);
            uLCD.pixel(101, 99, 13607018);
            uLCD.pixel(102, 99, 13343328);
            uLCD.pixel(103, 99, 14197864);
            uLCD.pixel(104, 99, 14921069);
            uLCD.pixel(105, 99, 14986086);
            uLCD.pixel(106, 99, 16301172);
            uLCD.pixel(107, 99, 16498034);
            uLCD.pixel(108, 99, 16431982);
            uLCD.pixel(109, 99, 16760689);
            uLCD.pixel(110, 99, 16760689);
            uLCD.pixel(111, 99, 16562796);
            uLCD.pixel(112, 99, 16365419);
            uLCD.pixel(113, 99, 16431728);
            uLCD.pixel(114, 99, 16694900);
            uLCD.pixel(115, 99, 16760696);
            uLCD.pixel(116, 99, 15840371);
            uLCD.pixel(117, 99, 12682309);
            uLCD.pixel(118, 99, 14458720);
            uLCD.pixel(119, 99, 14853476);
            uLCD.pixel(120, 99, 14985060);
            uLCD.pixel(121, 99, 15380072);
            uLCD.pixel(122, 99, 15116130);
            uLCD.pixel(123, 99, 15510886);
            uLCD.pixel(124, 99, 15642472);
            uLCD.pixel(125, 99, 15642472);
            uLCD.pixel(126, 99, 15708008);
            uLCD.pixel(127, 99, 15708008);
            uLCD.pixel(75, 100, 2295808);
            uLCD.pixel(76, 100, 6636579);
            uLCD.pixel(77, 100, 10911572);
            uLCD.pixel(78, 100, 15056006);
            uLCD.pixel(79, 100, 16305040);
            uLCD.pixel(80, 100, 15646082);
            uLCD.pixel(81, 100, 15580030);
            uLCD.pixel(82, 100, 15974277);
            uLCD.pixel(83, 100, 16039300);
            uLCD.pixel(84, 100, 16565898);
            uLCD.pixel(85, 100, 14460518);
            uLCD.pixel(86, 100, 13933916);
            uLCD.pixel(87, 100, 14986856);
            uLCD.pixel(88, 100, 14855268);
            uLCD.pixel(89, 100, 14921059);
            uLCD.pixel(90, 100, 13539408);
            uLCD.pixel(91, 100, 14658152);
            uLCD.pixel(92, 100, 13342555);
            uLCD.pixel(93, 100, 14198124);
            uLCD.pixel(94, 100, 14395766);
            uLCD.pixel(95, 100, 11830355);
            uLCD.pixel(96, 100, 12751971);
            uLCD.pixel(97, 100, 14528128);
            uLCD.pixel(98, 100, 14134138);
            uLCD.pixel(99, 100, 11699797);
            uLCD.pixel(100, 100, 13739893);
            uLCD.pixel(101, 100, 12423520);
            uLCD.pixel(102, 100, 12423003);
            uLCD.pixel(103, 100, 14659188);
            uLCD.pixel(104, 100, 13539934);
            uLCD.pixel(105, 100, 12420677);
            uLCD.pixel(106, 100, 14196057);
            uLCD.pixel(107, 100, 16037485);
            uLCD.pixel(108, 100, 16629361);
            uLCD.pixel(109, 100, 16761201);
            uLCD.pixel(110, 100, 16628331);
            uLCD.pixel(111, 100, 16761714);
            uLCD.pixel(112, 100, 16760429);
            uLCD.pixel(113, 100, 16761199);
            uLCD.pixel(114, 100, 16431463);
            uLCD.pixel(115, 100, 16760947);
            uLCD.pixel(116, 100, 15577199);
            uLCD.pixel(117, 100, 13998429);
            uLCD.pixel(118, 100, 13668951);
            uLCD.pixel(119, 100, 14590053);
            uLCD.pixel(120, 100, 14919016);
            uLCD.pixel(121, 100, 14524258);
            uLCD.pixel(122, 100, 14392158);
            uLCD.pixel(123, 100, 14260572);
            uLCD.pixel(124, 100, 14325851);
            uLCD.pixel(125, 100, 14391644);
            uLCD.pixel(126, 100, 14720093);
            uLCD.pixel(127, 100, 14917472);
            uLCD.pixel(74, 101, 4532507);
            uLCD.pixel(75, 101, 12426111);
            uLCD.pixel(76, 101, 15451542);
            uLCD.pixel(77, 101, 16568982);
            uLCD.pixel(78, 101, 15647355);
            uLCD.pixel(79, 101, 15448945);
            uLCD.pixel(80, 101, 15381871);
            uLCD.pixel(81, 101, 16302462);
            uLCD.pixel(82, 101, 15709304);
            uLCD.pixel(83, 101, 15644285);
            uLCD.pixel(84, 101, 15776128);
            uLCD.pixel(85, 101, 12947799);
            uLCD.pixel(86, 101, 12158281);
            uLCD.pixel(87, 101, 13145428);
            uLCD.pixel(88, 101, 13211733);
            uLCD.pixel(89, 101, 14001247);
            uLCD.pixel(90, 101, 14593384);
            uLCD.pixel(91, 101, 13606492);
            uLCD.pixel(92, 101, 13606753);
            uLCD.pixel(93, 101, 13145949);
            uLCD.pixel(94, 101, 11698251);
            uLCD.pixel(95, 101, 14264950);
            uLCD.pixel(96, 101, 13804145);
            uLCD.pixel(97, 101, 12027735);
            uLCD.pixel(98, 101, 11764563);
            uLCD.pixel(99, 101, 14857347);
            uLCD.pixel(100, 101, 14792070);
            uLCD.pixel(101, 101, 10647109);
            uLCD.pixel(102, 101, 12423003);
            uLCD.pixel(103, 101, 11566919);
            uLCD.pixel(104, 101, 14263659);
            uLCD.pixel(105, 101, 15052398);
            uLCD.pixel(106, 101, 13603922);
            uLCD.pixel(107, 101, 15445863);
            uLCD.pixel(108, 101, 16694900);
            uLCD.pixel(109, 101, 16695154);
            uLCD.pixel(110, 101, 16760689);
            uLCD.pixel(111, 101, 16760687);
            uLCD.pixel(112, 101, 16234600);
            uLCD.pixel(113, 101, 16761458);
            uLCD.pixel(114, 101, 16168807);
            uLCD.pixel(115, 101, 14261842);
            uLCD.pixel(116, 101, 13143884);
            uLCD.pixel(117, 101, 13407319);
            uLCD.pixel(118, 101, 14196835);
            uLCD.pixel(119, 101, 14328421);
            uLCD.pixel(120, 101, 13735514);
            uLCD.pixel(121, 101, 13603928);
            uLCD.pixel(122, 101, 14590823);
            uLCD.pixel(123, 101, 15380082);
            uLCD.pixel(124, 101, 14722150);
            uLCD.pixel(125, 101, 14590051);
            uLCD.pixel(126, 101, 14392927);
            uLCD.pixel(127, 101, 14261339);
            uLCD.pixel(73, 102, 2364421);
            uLCD.pixel(74, 102, 9928547);
            uLCD.pixel(75, 102, 16507059);
            uLCD.pixel(76, 102, 15124107);
            uLCD.pixel(77, 102, 15320960);
            uLCD.pixel(78, 102, 15188342);
            uLCD.pixel(79, 102, 15582071);
            uLCD.pixel(80, 102, 13278553);
            uLCD.pixel(81, 102, 14264683);
            uLCD.pixel(82, 102, 14263667);
            uLCD.pixel(83, 102, 14000755);
            uLCD.pixel(84, 102, 13870452);
            uLCD.pixel(85, 102, 12291934);
            uLCD.pixel(86, 102, 12818278);
            uLCD.pixel(87, 102, 14397310);
            uLCD.pixel(88, 102, 14462588);
            uLCD.pixel(89, 102, 14726012);
            uLCD.pixel(90, 102, 13804649);
            uLCD.pixel(91, 102, 13541476);
            uLCD.pixel(92, 102, 12817235);
            uLCD.pixel(93, 102, 14856559);
            uLCD.pixel(94, 102, 15185011);
            uLCD.pixel(95, 102, 16500871);
            uLCD.pixel(96, 102, 16632205);
            uLCD.pixel(97, 102, 14197866);
            uLCD.pixel(98, 102, 13933925);
            uLCD.pixel(99, 102, 12750169);
            uLCD.pixel(100, 102, 12356953);
            uLCD.pixel(101, 102, 10580540);
            uLCD.pixel(102, 102, 13869674);
            uLCD.pixel(103, 102, 14856309);
            uLCD.pixel(104, 102, 14592106);
            uLCD.pixel(105, 102, 15381363);
            uLCD.pixel(106, 102, 11301167);
            uLCD.pixel(107, 102, 16498553);
            uLCD.pixel(108, 102, 16630137);
            uLCD.pixel(109, 102, 16563574);
            uLCD.pixel(110, 102, 16301171);
            uLCD.pixel(111, 102, 16564343);
            uLCD.pixel(112, 102, 16630649);
            uLCD.pixel(113, 102, 14262615);
            uLCD.pixel(114, 102, 13538892);
            uLCD.pixel(115, 102, 14921574);
            uLCD.pixel(116, 102, 14462313);
            uLCD.pixel(117, 102, 14199656);
            uLCD.pixel(118, 102, 14199656);
            uLCD.pixel(119, 102, 14002277);
            uLCD.pixel(120, 102, 13935714);
            uLCD.pixel(121, 102, 14133093);
            uLCD.pixel(122, 102, 13672542);
            uLCD.pixel(123, 102, 12685389);
            uLCD.pixel(124, 102, 13935454);
            uLCD.pixel(125, 102, 14000990);
            uLCD.pixel(126, 102, 14000988);
            uLCD.pixel(127, 102, 14132574);
            uLCD.pixel(73, 103, 2233602);
            uLCD.pixel(74, 103, 13548442);
            uLCD.pixel(75, 103, 13810827);
            uLCD.pixel(76, 103, 14336131);
            uLCD.pixel(77, 103, 14795902);
            uLCD.pixel(78, 103, 13347427);
            uLCD.pixel(79, 103, 13149537);
            uLCD.pixel(80, 103, 13806702);
            uLCD.pixel(81, 103, 14135163);
            uLCD.pixel(82, 103, 13279093);
            uLCD.pixel(83, 103, 14002823);
            uLCD.pixel(84, 103, 13939083);
            uLCD.pixel(85, 103, 13478790);
            uLCD.pixel(86, 103, 13018241);
            uLCD.pixel(87, 103, 12754556);
            uLCD.pixel(88, 103, 11043168);
            uLCD.pixel(89, 103, 9464130);
            uLCD.pixel(90, 103, 6765583);
            uLCD.pixel(91, 103, 11042120);
            uLCD.pixel(92, 103, 15515264);
            uLCD.pixel(93, 103, 15909244);
            uLCD.pixel(94, 103, 15711088);
            uLCD.pixel(95, 103, 14855521);
            uLCD.pixel(96, 103, 15578221);
            uLCD.pixel(97, 103, 15577712);
            uLCD.pixel(98, 103, 16169598);
            uLCD.pixel(99, 103, 12748621);
            uLCD.pixel(100, 103, 11105596);
            uLCD.pixel(101, 103, 12882264);
            uLCD.pixel(102, 103, 15514239);
            uLCD.pixel(103, 103, 14790255);
            uLCD.pixel(104, 103, 12815693);
            uLCD.pixel(105, 103, 11565368);
            uLCD.pixel(106, 103, 12683333);
            uLCD.pixel(107, 103, 16630913);
            uLCD.pixel(108, 103, 15644018);
            uLCD.pixel(109, 103, 15841397);
            uLCD.pixel(110, 103, 16763529);
            uLCD.pixel(111, 103, 15381875);
            uLCD.pixel(112, 103, 14000737);
            uLCD.pixel(113, 103, 13935203);
            uLCD.pixel(114, 103, 14988406);
            uLCD.pixel(115, 103, 13541989);
            uLCD.pixel(116, 103, 13017700);
            uLCD.pixel(117, 103, 13215594);
            uLCD.pixel(118, 103, 13610352);
            uLCD.pixel(119, 103, 13478766);
            uLCD.pixel(120, 103, 13412460);
            uLCD.pixel(121, 103, 14004597);
            uLCD.pixel(122, 103, 14399355);
            uLCD.pixel(123, 103, 14201460);
            uLCD.pixel(124, 103, 13675115);
            uLCD.pixel(125, 103, 13543529);
            uLCD.pixel(126, 103, 13346148);
            uLCD.pixel(127, 103, 13148769);
            uLCD.pixel(74, 104, 12628372);
            uLCD.pixel(75, 104, 13877911);
            uLCD.pixel(76, 104, 13087614);
            uLCD.pixel(77, 104, 12429165);
            uLCD.pixel(78, 104, 13547130);
            uLCD.pixel(79, 104, 13217654);
            uLCD.pixel(80, 104, 11835496);
            uLCD.pixel(81, 104, 10452824);
            uLCD.pixel(82, 104, 10057563);
            uLCD.pixel(83, 104, 8216389);
            uLCD.pixel(84, 104, 5586211);
            uLCD.pixel(85, 104, 4929310);
            uLCD.pixel(86, 104, 2954756);
            uLCD.pixel(88, 104, 2162944);
            uLCD.pixel(89, 104, 2820096);
            uLCD.pixel(90, 104, 7556911);
            uLCD.pixel(91, 104, 15977118);
            uLCD.pixel(92, 104, 15779721);
            uLCD.pixel(93, 104, 15909755);
            uLCD.pixel(94, 104, 14987616);
            uLCD.pixel(95, 104, 15512930);
            uLCD.pixel(96, 104, 15117149);
            uLCD.pixel(97, 104, 15708520);
            uLCD.pixel(98, 104, 13668175);
            uLCD.pixel(99, 104, 12484161);
            uLCD.pixel(100, 104, 15578742);
            uLCD.pixel(101, 104, 15776380);
            uLCD.pixel(102, 104, 14394725);
            uLCD.pixel(103, 104, 15184241);
            uLCD.pixel(104, 104, 13275986);
            uLCD.pixel(105, 104, 11762747);
            uLCD.pixel(106, 104, 15118191);
            uLCD.pixel(107, 104, 16368515);
            uLCD.pixel(108, 104, 16040068);
            uLCD.pixel(109, 104, 15645825);
            uLCD.pixel(110, 104, 14264430);
            uLCD.pixel(111, 104, 12752222);
            uLCD.pixel(112, 104, 14331770);
            uLCD.pixel(113, 104, 13871992);
            uLCD.pixel(114, 104, 13280371);
            uLCD.pixel(115, 104, 13084023);
            uLCD.pixel(116, 104, 10848863);
            uLCD.pixel(117, 104, 10323548);
            uLCD.pixel(118, 104, 10126169);
            uLCD.pixel(119, 104, 9534032);
            uLCD.pixel(120, 104, 8678211);
            uLCD.pixel(121, 104, 8744004);
            uLCD.pixel(122, 104, 9730898);
            uLCD.pixel(123, 104, 10453851);
            uLCD.pixel(124, 104, 11309414);
            uLCD.pixel(125, 104, 12098930);
            uLCD.pixel(126, 104, 12954237);
            uLCD.pixel(127, 104, 13546374);
            uLCD.pixel(74, 105, 6115391);
            uLCD.pixel(75, 105, 10589049);
            uLCD.pixel(76, 105, 10983285);
            uLCD.pixel(77, 105, 8680010);
            uLCD.pixel(78, 105, 5259028);
            uLCD.pixel(80, 105, 2560768);
            uLCD.pixel(90, 105, 10189927);
            uLCD.pixel(91, 105, 15123614);
            uLCD.pixel(92, 105, 14793861);
            uLCD.pixel(93, 105, 15779200);
            uLCD.pixel(94, 105, 14922852);
            uLCD.pixel(95, 105, 13934926);
            uLCD.pixel(96, 105, 14591318);
            uLCD.pixel(97, 105, 14458453);
            uLCD.pixel(98, 105, 13602382);
            uLCD.pixel(99, 105, 15708017);
            uLCD.pixel(100, 105, 16432767);
            uLCD.pixel(101, 105, 15578741);
            uLCD.pixel(102, 105, 12618056);
            uLCD.pixel(103, 105, 14526053);
            uLCD.pixel(104, 105, 12157763);
            uLCD.pixel(105, 105, 13342037);
            uLCD.pixel(106, 105, 14066278);
            uLCD.pixel(107, 105, 13803366);
            uLCD.pixel(108, 105, 13475432);
            uLCD.pixel(109, 105, 12950119);
            uLCD.pixel(110, 105, 13543029);
            uLCD.pixel(111, 105, 13543805);
            uLCD.pixel(112, 105, 13347457);
            uLCD.pixel(113, 105, 13150338);
            uLCD.pixel(114, 105, 11506029);
            uLCD.pixel(115, 105, 8020290);
            uLCD.pixel(116, 105, 2363904);
            uLCD.pixel(125, 105, 2627072);
            uLCD.pixel(126, 105, 4074516);
            uLCD.pixel(127, 105, 5061411);
            uLCD.pixel(75, 106, 2562328);
            uLCD.pixel(90, 106, 9665644);
            uLCD.pixel(91, 106, 14796456);
            uLCD.pixel(92, 106, 12953207);
            uLCD.pixel(93, 106, 13017702);
            uLCD.pixel(94, 106, 13674595);
            uLCD.pixel(95, 106, 13278035);
            uLCD.pixel(96, 106, 14131804);
            uLCD.pixel(97, 106, 13078605);
            uLCD.pixel(98, 106, 15445875);
            uLCD.pixel(99, 106, 16763277);
            uLCD.pixel(100, 106, 14985834);
            uLCD.pixel(101, 106, 15709811);
            uLCD.pixel(102, 106, 14262881);
            uLCD.pixel(103, 106, 11960384);
            uLCD.pixel(104, 106, 11763777);
            uLCD.pixel(105, 106, 13869412);
            uLCD.pixel(106, 106, 14725497);
            uLCD.pixel(107, 106, 12950119);
            uLCD.pixel(108, 106, 14003326);
            uLCD.pixel(109, 106, 13806979);
            uLCD.pixel(110, 106, 13478790);
            uLCD.pixel(111, 106, 13216908);
            uLCD.pixel(112, 106, 10585964);
            uLCD.pixel(113, 106, 5652520);
            uLCD.pixel(90, 107, 4601899);
            uLCD.pixel(91, 107, 13087643);
            uLCD.pixel(92, 107, 13020810);
            uLCD.pixel(93, 107, 13677701);
            uLCD.pixel(94, 107, 13807996);
            uLCD.pixel(95, 107, 13806450);
            uLCD.pixel(96, 107, 10844993);
            uLCD.pixel(97, 107, 13409637);
            uLCD.pixel(98, 107, 16369554);
            uLCD.pixel(99, 107, 13144925);
            uLCD.pixel(100, 107, 14526313);
            uLCD.pixel(101, 107, 14066015);
            uLCD.pixel(102, 107, 11763005);
            uLCD.pixel(103, 107, 13605727);
            uLCD.pixel(104, 107, 13145948);
            uLCD.pixel(105, 107, 13344359);
            uLCD.pixel(106, 107, 12358240);
            uLCD.pixel(107, 107, 14069891);
            uLCD.pixel(108, 107, 13281410);
            uLCD.pixel(109, 107, 13150856);
            uLCD.pixel(110, 107, 10059620);
            uLCD.pixel(111, 107, 5652521);
            uLCD.pixel(91, 108, 4536872);
            uLCD.pixel(92, 108, 8219990);
            uLCD.pixel(93, 108, 9731940);
            uLCD.pixel(94, 108, 7559739);
            uLCD.pixel(95, 108, 5124367);
            uLCD.pixel(96, 108, 2031616);
            uLCD.pixel(97, 108, 10847069);
            uLCD.pixel(98, 108, 14333839);
            uLCD.pixel(99, 108, 12884847);
            uLCD.pixel(100, 108, 14067567);
            uLCD.pixel(101, 108, 11895881);
            uLCD.pixel(102, 108, 11303745);
            uLCD.pixel(103, 108, 13738602);
            uLCD.pixel(104, 108, 13542256);
            uLCD.pixel(105, 108, 13411443);
            uLCD.pixel(106, 108, 13280633);
            uLCD.pixel(107, 108, 14071440);
            uLCD.pixel(108, 108, 10059360);
            uLCD.pixel(109, 108, 5388832);
            uLCD.pixel(97, 109, 7363138);
            uLCD.pixel(98, 109, 12033925);
            uLCD.pixel(99, 109, 13677457);
            uLCD.pixel(100, 109, 11635548);
            uLCD.pixel(101, 109, 13082218);
            uLCD.pixel(102, 109, 13805686);
            uLCD.pixel(103, 109, 12425064);
            uLCD.pixel(104, 109, 13544575);
            uLCD.pixel(105, 109, 14136719);
            uLCD.pixel(106, 109, 11440238);
            uLCD.pixel(107, 109, 5980708);
            uLCD.pixel(108, 109, 2428672);
            uLCD.pixel(98, 110, 4602410);
            uLCD.pixel(99, 110, 9864300);
            uLCD.pixel(100, 110, 13480332);
            uLCD.pixel(101, 110, 13150335);
            uLCD.pixel(102, 110, 13479302);
            uLCD.pixel(103, 110, 13019268);
            uLCD.pixel(104, 110, 11967611);
            uLCD.pixel(105, 110, 7625533);
            uLCD.pixel(106, 110, 3744523);
            uLCD.pixel(100, 111, 4535067);
            uLCD.pixel(101, 111, 8283722);
            uLCD.pixel(102, 111, 8876631);
            uLCD.pixel(103, 111, 6771514);
            uLCD.pixel(104, 111, 3021828);
        }

        // Draw left Spock 
        void drawLeftSpock() {
            uLCD.pixel(29, 75, 2036234);
            uLCD.pixel(28, 76, 4862490);
            uLCD.pixel(29, 76, 15127225);
            uLCD.pixel(30, 76, 4733990);
            uLCD.pixel(26, 77, 2098432);
            uLCD.pixel(28, 77, 12230262);
            uLCD.pixel(29, 77, 14929059);
            uLCD.pixel(30, 77, 8614488);
            uLCD.pixel(27, 78, 9596741);
            uLCD.pixel(28, 78, 15123856);
            uLCD.pixel(29, 78, 15322523);
            uLCD.pixel(30, 78, 9008728);
            uLCD.pixel(26, 79, 7491369);
            uLCD.pixel(27, 79, 15714963);
            uLCD.pixel(28, 79, 15189382);
            uLCD.pixel(29, 79, 15387800);
            uLCD.pixel(30, 79, 6639928);
            uLCD.pixel(25, 80, 5387543);
            uLCD.pixel(26, 80, 15517584);
            uLCD.pixel(27, 80, 15582851);
            uLCD.pixel(28, 80, 15057796);
            uLCD.pixel(29, 80, 13809287);
            uLCD.pixel(30, 80, 2626822);
            uLCD.pixel(25, 81, 12558703);
            uLCD.pixel(26, 81, 16109705);
            uLCD.pixel(27, 81, 14464362);
            uLCD.pixel(28, 81, 15255177);
            uLCD.pixel(29, 81, 8743236);
            uLCD.pixel(24, 82, 8810309);
            uLCD.pixel(25, 82, 16111764);
            uLCD.pixel(26, 82, 14925671);
            uLCD.pixel(27, 82, 14267232);
            uLCD.pixel(28, 82, 13083756);
            uLCD.pixel(29, 82, 2690816);
            uLCD.pixel(22, 83, 3481364);
            uLCD.pixel(23, 83, 10520173);
            uLCD.pixel(24, 83, 15650713);
            uLCD.pixel(25, 83, 15189373);
            uLCD.pixel(26, 83, 14991468);
            uLCD.pixel(27, 83, 14334062);
            uLCD.pixel(28, 83, 5782287);
            uLCD.pixel(21, 84, 6242850);
            uLCD.pixel(22, 84, 14333323);
            uLCD.pixel(23, 84, 15911317);
            uLCD.pixel(24, 84, 16042123);
            uLCD.pixel(25, 84, 14858615);
            uLCD.pixel(26, 84, 14201460);
            uLCD.pixel(27, 84, 8151088);
            uLCD.pixel(20, 85, 8544827);
            uLCD.pixel(21, 85, 16108696);
            uLCD.pixel(22, 85, 15712129);
            uLCD.pixel(23, 85, 15908734);
            uLCD.pixel(24, 85, 15514750);
            uLCD.pixel(25, 85, 14661248);
            uLCD.pixel(26, 85, 9137732);
            uLCD.pixel(19, 86, 6374175);
            uLCD.pixel(20, 86, 16106382);
            uLCD.pixel(21, 86, 16696452);
            uLCD.pixel(22, 86, 16498553);
            uLCD.pixel(23, 86, 16039292);
            uLCD.pixel(24, 86, 15977108);
            uLCD.pixel(25, 86, 10980195);
            uLCD.pixel(18, 87, 4073224);
            uLCD.pixel(19, 87, 15713683);
            uLCD.pixel(20, 87, 16432506);
            uLCD.pixel(21, 87, 16627819);
            uLCD.pixel(22, 87, 16233320);
            uLCD.pixel(23, 87, 16696706);
            uLCD.pixel(24, 87, 13543543);
            uLCD.pixel(25, 87, 3021568);
            uLCD.pixel(18, 88, 12360047);
            uLCD.pixel(19, 88, 16434310);
            uLCD.pixel(20, 88, 16760689);
            uLCD.pixel(21, 88, 16625500);
            uLCD.pixel(22, 88, 16763258);
            uLCD.pixel(23, 88, 16564605);
            uLCD.pixel(24, 88, 11504221);
            uLCD.pixel(17, 89, 9795922);
            uLCD.pixel(18, 89, 16568216);
            uLCD.pixel(19, 89, 16366713);
            uLCD.pixel(20, 89, 16560480);
            uLCD.pixel(21, 89, 16759140);
            uLCD.pixel(22, 89, 16760687);
            uLCD.pixel(23, 89, 16367226);
            uLCD.pixel(24, 89, 14004094);
            uLCD.pixel(25, 89, 2165760);
            uLCD.pixel(37, 89, 2299657);
            uLCD.pixel(38, 89, 3681051);
            uLCD.pixel(39, 89, 5325873);
            uLCD.pixel(40, 89, 5259564);
            uLCD.pixel(41, 89, 3680532);
            uLCD.pixel(42, 89, 4141853);
            uLCD.pixel(43, 89, 4602404);
            uLCD.pixel(44, 89, 3747352);
            uLCD.pixel(45, 89, 2563848);
            uLCD.pixel(16, 90, 9136190);
            uLCD.pixel(17, 90, 16304529);
            uLCD.pixel(18, 90, 16039293);
            uLCD.pixel(19, 90, 16761210);
            uLCD.pixel(20, 90, 16760175);
            uLCD.pixel(21, 90, 16762743);
            uLCD.pixel(22, 90, 16365419);
            uLCD.pixel(23, 90, 15972981);
            uLCD.pixel(24, 90, 15778698);
            uLCD.pixel(25, 90, 10320975);
            uLCD.pixel(26, 90, 3151616);
            uLCD.pixel(33, 90, 4070144);
            uLCD.pixel(34, 90, 6767896);
            uLCD.pixel(35, 90, 9727810);
            uLCD.pixel(36, 90, 12754029);
            uLCD.pixel(37, 90, 14267520);
            uLCD.pixel(38, 90, 15057035);
            uLCD.pixel(39, 90, 16307100);
            uLCD.pixel(40, 90, 15386509);
            uLCD.pixel(41, 90, 15912853);
            uLCD.pixel(42, 90, 14926728);
            uLCD.pixel(43, 90, 14730119);
            uLCD.pixel(44, 90, 14928270);
            uLCD.pixel(45, 90, 15192469);
            uLCD.pixel(46, 90, 12034407);
            uLCD.pixel(47, 90, 3482624);
            uLCD.pixel(15, 91, 6244393);
            uLCD.pixel(16, 91, 16436117);
            uLCD.pixel(17, 91, 16169334);
            uLCD.pixel(18, 91, 16761467);
            uLCD.pixel(19, 91, 15839593);
            uLCD.pixel(20, 91, 16760434);
            uLCD.pixel(21, 91, 16300396);
            uLCD.pixel(22, 91, 16103792);
            uLCD.pixel(23, 91, 16630909);
            uLCD.pixel(24, 91, 15777148);
            uLCD.pixel(25, 91, 16173454);
            uLCD.pixel(26, 91, 15187339);
            uLCD.pixel(27, 91, 13083254);
            uLCD.pixel(28, 91, 10847070);
            uLCD.pixel(29, 91, 10649952);
            uLCD.pixel(30, 91, 9466196);
            uLCD.pixel(31, 91, 10057296);
            uLCD.pixel(32, 91, 13738604);
            uLCD.pixel(33, 91, 15776378);
            uLCD.pixel(34, 91, 16368515);
            uLCD.pixel(35, 91, 16565636);
            uLCD.pixel(36, 91, 16763270);
            uLCD.pixel(37, 91, 15842165);
            uLCD.pixel(38, 91, 14921063);
            uLCD.pixel(39, 91, 15447405);
            uLCD.pixel(40, 91, 15974262);
            uLCD.pixel(41, 91, 16237948);
            uLCD.pixel(42, 91, 14396259);
            uLCD.pixel(43, 91, 15713148);
            uLCD.pixel(44, 91, 15451005);
            uLCD.pixel(45, 91, 15517311);
            uLCD.pixel(46, 91, 16175499);
            uLCD.pixel(47, 91, 9335614);
            uLCD.pixel(14, 92, 3943195);
            uLCD.pixel(15, 92, 14465946);
            uLCD.pixel(16, 92, 16367234);
            uLCD.pixel(17, 92, 16759664);
            uLCD.pixel(18, 92, 16628593);
            uLCD.pixel(19, 92, 16563316);
            uLCD.pixel(20, 92, 16366965);
            uLCD.pixel(21, 92, 16235892);
            uLCD.pixel(22, 92, 16235892);
            uLCD.pixel(23, 92, 16367478);
            uLCD.pixel(24, 92, 16301685);
            uLCD.pixel(25, 92, 16236405);
            uLCD.pixel(26, 92, 15775602);
            uLCD.pixel(27, 92, 16697735);
            uLCD.pixel(28, 92, 16435598);
            uLCD.pixel(29, 92, 15910800);
            uLCD.pixel(30, 92, 16306335);
            uLCD.pixel(31, 92, 15910804);
            uLCD.pixel(32, 92, 16499844);
            uLCD.pixel(33, 92, 16037234);
            uLCD.pixel(34, 92, 16760957);
            uLCD.pixel(35, 92, 16234098);
            uLCD.pixel(36, 92, 16628856);
            uLCD.pixel(37, 92, 16628342);
            uLCD.pixel(38, 92, 14785884);
            uLCD.pixel(39, 92, 16101744);
            uLCD.pixel(40, 92, 16694653);
            uLCD.pixel(41, 92, 16102775);
            uLCD.pixel(42, 92, 15379569);
            uLCD.pixel(43, 92, 15511416);
            uLCD.pixel(44, 92, 14854514);
            uLCD.pixel(45, 92, 15183994);
            uLCD.pixel(46, 92, 15710084);
            uLCD.pixel(47, 92, 7489570);
            uLCD.pixel(14, 93, 10717039);
            uLCD.pixel(15, 93, 15647900);
            uLCD.pixel(16, 93, 16497785);
            uLCD.pixel(17, 93, 16759662);
            uLCD.pixel(18, 93, 16760435);
            uLCD.pixel(19, 93, 16761466);
            uLCD.pixel(20, 93, 16696443);
            uLCD.pixel(21, 93, 16499577);
            uLCD.pixel(22, 93, 16433270);
            uLCD.pixel(23, 93, 16367218);
            uLCD.pixel(24, 93, 16629618);
            uLCD.pixel(25, 93, 16760945);
            uLCD.pixel(26, 93, 16366186);
            uLCD.pixel(27, 93, 16498286);
            uLCD.pixel(28, 93, 16301684);
            uLCD.pixel(29, 93, 15842422);
            uLCD.pixel(30, 93, 15777661);
            uLCD.pixel(31, 93, 15580282);
            uLCD.pixel(32, 93, 16631427);
            uLCD.pixel(33, 93, 15840882);
            uLCD.pixel(34, 93, 15972468);
            uLCD.pixel(35, 93, 15971955);
            uLCD.pixel(36, 93, 16497783);
            uLCD.pixel(37, 93, 15774060);
            uLCD.pixel(38, 93, 13997138);
            uLCD.pixel(39, 93, 14720861);
            uLCD.pixel(40, 93, 15049574);
            uLCD.pixel(41, 93, 13931094);
            uLCD.pixel(42, 93, 12549700);
            uLCD.pixel(43, 93, 12879183);
            uLCD.pixel(44, 93, 13734752);
            uLCD.pixel(45, 93, 13274716);
            uLCD.pixel(46, 93, 12353360);
            uLCD.pixel(47, 93, 8278060);
            uLCD.pixel(48, 93, 4929577);
            uLCD.pixel(0, 94, 7295277);
            uLCD.pixel(1, 94, 7295277);
            uLCD.pixel(2, 94, 7557679);
            uLCD.pixel(3, 94, 7755058);
            uLCD.pixel(4, 94, 7623474);
            uLCD.pixel(5, 94, 6702890);
            uLCD.pixel(6, 94, 5321495);
            uLCD.pixel(7, 94, 4203532);
            uLCD.pixel(8, 94, 2822400);
            uLCD.pixel(9, 94, 2559232);
            uLCD.pixel(12, 94, 2820352);
            uLCD.pixel(13, 94, 6372370);
            uLCD.pixel(14, 94, 15318673);
            uLCD.pixel(15, 94, 15908744);
            uLCD.pixel(16, 94, 16563576);
            uLCD.pixel(17, 94, 16759921);
            uLCD.pixel(18, 94, 16759666);
            uLCD.pixel(19, 94, 16497521);
            uLCD.pixel(20, 94, 16432241);
            uLCD.pixel(21, 94, 16498034);
            uLCD.pixel(22, 94, 16563825);
            uLCD.pixel(23, 94, 16563825);
            uLCD.pixel(24, 94, 16300907);
            uLCD.pixel(25, 94, 16762742);
            uLCD.pixel(26, 94, 16762226);
            uLCD.pixel(27, 94, 15511131);
            uLCD.pixel(28, 94, 15642976);
            uLCD.pixel(29, 94, 16366699);
            uLCD.pixel(30, 94, 16367214);
            uLCD.pixel(31, 94, 16434551);
            uLCD.pixel(32, 94, 15252856);
            uLCD.pixel(33, 94, 15977609);
            uLCD.pixel(34, 94, 15714178);
            uLCD.pixel(35, 94, 14331755);
            uLCD.pixel(36, 94, 13673311);
            uLCD.pixel(37, 94, 13672282);
            uLCD.pixel(38, 94, 13079886);
            uLCD.pixel(39, 94, 12750151);
            uLCD.pixel(40, 94, 13079116);
            uLCD.pixel(41, 94, 12947273);
            uLCD.pixel(42, 94, 13275984);
            uLCD.pixel(43, 94, 14657639);
            uLCD.pixel(44, 94, 15578999);
            uLCD.pixel(45, 94, 16040322);
            uLCD.pixel(46, 94, 16040322);
            uLCD.pixel(47, 94, 15977370);
            uLCD.pixel(48, 94, 14535864);
            uLCD.pixel(49, 94, 3880496);
            uLCD.pixel(0, 95, 16371351);
            uLCD.pixel(1, 95, 16108433);
            uLCD.pixel(2, 95, 15976077);
            uLCD.pixel(3, 95, 15976079);
            uLCD.pixel(4, 95, 16172945);
            uLCD.pixel(5, 95, 16041618);
            uLCD.pixel(6, 95, 15646863);
            uLCD.pixel(7, 95, 15121035);
            uLCD.pixel(8, 95, 14134399);
            uLCD.pixel(9, 95, 13937533);
            uLCD.pixel(10, 95, 13148271);
            uLCD.pixel(11, 95, 14069113);
            uLCD.pixel(12, 95, 14791290);
            uLCD.pixel(13, 95, 16435598);
            uLCD.pixel(14, 95, 16435078);
            uLCD.pixel(15, 95, 15972983);
            uLCD.pixel(16, 95, 16761210);
            uLCD.pixel(17, 95, 16761209);
            uLCD.pixel(18, 95, 16760436);
            uLCD.pixel(19, 95, 16694386);
            uLCD.pixel(20, 95, 16628591);
            uLCD.pixel(21, 95, 16760175);
            uLCD.pixel(22, 95, 16760947);
            uLCD.pixel(23, 95, 16760947);
            uLCD.pixel(24, 95, 16432239);
            uLCD.pixel(25, 95, 16564595);
            uLCD.pixel(26, 95, 15906663);
            uLCD.pixel(27, 95, 13669186);
            uLCD.pixel(28, 95, 15182166);
            uLCD.pixel(29, 95, 16761968);
            uLCD.pixel(30, 95, 16760937);
            uLCD.pixel(31, 95, 16433520);
            uLCD.pixel(32, 95, 16371337);
            uLCD.pixel(33, 95, 12096081);
            uLCD.pixel(34, 95, 8345623);
            uLCD.pixel(35, 95, 9463589);
            uLCD.pixel(36, 95, 12029000);
            uLCD.pixel(37, 95, 13212760);
            uLCD.pixel(38, 95, 14988655);
            uLCD.pixel(39, 95, 16041341);
            uLCD.pixel(40, 95, 15448947);
            uLCD.pixel(41, 95, 16041084);
            uLCD.pixel(42, 95, 16633221);
            uLCD.pixel(43, 95, 16567174);
            uLCD.pixel(44, 95, 14133348);
            uLCD.pixel(45, 95, 14397034);
            uLCD.pixel(46, 95, 14594414);
            uLCD.pixel(47, 95, 13413238);
            uLCD.pixel(48, 95, 13351844);
            uLCD.pixel(49, 95, 3419429);
            uLCD.pixel(0, 96, 15843444);
            uLCD.pixel(1, 96, 15842673);
            uLCD.pixel(2, 96, 15776623);
            uLCD.pixel(3, 96, 15973232);
            uLCD.pixel(4, 96, 16301684);
            uLCD.pixel(5, 96, 16564857);
            uLCD.pixel(6, 96, 16762239);
            uLCD.pixel(7, 96, 16762754);
            uLCD.pixel(8, 96, 16631429);
            uLCD.pixel(9, 96, 16368770);
            uLCD.pixel(10, 96, 16105596);
            uLCD.pixel(11, 96, 15776629);
            uLCD.pixel(12, 96, 15974002);
            uLCD.pixel(13, 96, 16763771);
            uLCD.pixel(14, 96, 15511905);
            uLCD.pixel(15, 96, 16763000);
            uLCD.pixel(16, 96, 16038512);
            uLCD.pixel(17, 96, 16366965);
            uLCD.pixel(18, 96, 16629622);
            uLCD.pixel(19, 96, 16760434);
            uLCD.pixel(20, 96, 16760432);
            uLCD.pixel(21, 96, 16760689);
            uLCD.pixel(22, 96, 16760177);
            uLCD.pixel(23, 96, 16431728);
            uLCD.pixel(24, 96, 16764292);
            uLCD.pixel(25, 96, 15578221);
            uLCD.pixel(26, 96, 14262361);
            uLCD.pixel(27, 96, 12880962);
            uLCD.pixel(28, 96, 15643495);
            uLCD.pixel(29, 96, 16761973);
            uLCD.pixel(30, 96, 16365157);
            uLCD.pixel(31, 96, 15971431);
            uLCD.pixel(32, 96, 15908219);
            uLCD.pixel(33, 96, 12224587);
            uLCD.pixel(34, 96, 9855526);
            uLCD.pixel(35, 96, 13079637);
            uLCD.pixel(36, 96, 16302722);
            uLCD.pixel(37, 96, 16302977);
            uLCD.pixel(38, 96, 16302975);
            uLCD.pixel(39, 96, 15316850);
            uLCD.pixel(40, 96, 13672025);
            uLCD.pixel(41, 96, 14922349);
            uLCD.pixel(42, 96, 14462313);
            uLCD.pixel(43, 96, 14200169);
            uLCD.pixel(44, 96, 12555860);
            uLCD.pixel(45, 96, 13609063);
            uLCD.pixel(46, 96, 14530424);
            uLCD.pixel(47, 96, 12756082);
            uLCD.pixel(48, 96, 9930608);
            uLCD.pixel(49, 96, 2629913);
            uLCD.pixel(0, 97, 15841896);
            uLCD.pixel(1, 97, 16236396);
            uLCD.pixel(2, 97, 16564848);
            uLCD.pixel(3, 97, 16761712);
            uLCD.pixel(4, 97, 16760685);
            uLCD.pixel(5, 97, 16628329);
            uLCD.pixel(6, 97, 16430952);
            uLCD.pixel(7, 97, 16233831);
            uLCD.pixel(8, 97, 16629107);
            uLCD.pixel(9, 97, 16432757);
            uLCD.pixel(10, 97, 16763518);
            uLCD.pixel(11, 97, 16367729);
            uLCD.pixel(12, 97, 16433007);
            uLCD.pixel(13, 97, 16037732);
            uLCD.pixel(14, 97, 16695403);
            uLCD.pixel(15, 97, 16629869);
            uLCD.pixel(16, 97, 16235891);
            uLCD.pixel(17, 97, 16367991);
            uLCD.pixel(18, 97, 16629622);
            uLCD.pixel(19, 97, 16431728);
            uLCD.pixel(20, 97, 16628591);
            uLCD.pixel(21, 97, 16760691);
            uLCD.pixel(22, 97, 16761209);
            uLCD.pixel(23, 97, 16629369);
            uLCD.pixel(24, 97, 15972983);
            uLCD.pixel(25, 97, 13934174);
            uLCD.pixel(26, 97, 13473623);
            uLCD.pixel(27, 97, 13276244);
            uLCD.pixel(28, 97, 15315053);
            uLCD.pixel(29, 97, 14656349);
            uLCD.pixel(30, 97, 15115870);
            uLCD.pixel(31, 97, 16168558);
            uLCD.pixel(32, 97, 16760957);
            uLCD.pixel(33, 97, 16763529);
            uLCD.pixel(34, 97, 16762501);
            uLCD.pixel(35, 97, 16762501);
            uLCD.pixel(36, 97, 16367228);
            uLCD.pixel(37, 97, 15906936);
            uLCD.pixel(38, 97, 16039293);
            uLCD.pixel(39, 97, 14527083);
            uLCD.pixel(40, 97, 12093260);
            uLCD.pixel(41, 97, 14462838);
            uLCD.pixel(42, 97, 13806198);
            uLCD.pixel(43, 97, 13150068);
            uLCD.pixel(44, 97, 11374175);
            uLCD.pixel(45, 97, 7888176);
            uLCD.pixel(46, 97, 4862470);
            uLCD.pixel(47, 97, 2560768);
            uLCD.pixel(0, 98, 16565369);
            uLCD.pixel(1, 98, 16565110);
            uLCD.pixel(2, 98, 16629618);
            uLCD.pixel(3, 98, 16694382);
            uLCD.pixel(4, 98, 16694125);
            uLCD.pixel(5, 98, 16759919);
            uLCD.pixel(6, 98, 16760949);
            uLCD.pixel(7, 98, 16761979);
            uLCD.pixel(8, 98, 16562547);
            uLCD.pixel(9, 98, 16365938);
            uLCD.pixel(10, 98, 16432760);
            uLCD.pixel(11, 98, 16366965);
            uLCD.pixel(12, 98, 16695929);
            uLCD.pixel(13, 98, 16169837);
            uLCD.pixel(14, 98, 16762743);
            uLCD.pixel(15, 98, 15840870);
            uLCD.pixel(16, 98, 16367731);
            uLCD.pixel(17, 98, 16696442);
            uLCD.pixel(18, 98, 16762233);
            uLCD.pixel(19, 98, 16629620);
            uLCD.pixel(20, 98, 16563829);
            uLCD.pixel(21, 98, 16695160);
            uLCD.pixel(22, 98, 16366713);
            uLCD.pixel(23, 98, 15972216);
            uLCD.pixel(24, 98, 13670491);
            uLCD.pixel(25, 98, 13276248);
            uLCD.pixel(26, 98, 13802338);
            uLCD.pixel(27, 98, 13145178);
            uLCD.pixel(28, 98, 13736545);
            uLCD.pixel(29, 98, 12552012);
            uLCD.pixel(30, 98, 14657388);
            uLCD.pixel(31, 98, 16300922);
            uLCD.pixel(32, 98, 16628078);
            uLCD.pixel(33, 98, 16561511);
            uLCD.pixel(34, 98, 16496233);
            uLCD.pixel(35, 98, 16562287);
            uLCD.pixel(36, 98, 15510375);
            uLCD.pixel(37, 98, 14656356);
            uLCD.pixel(38, 98, 14526061);
            uLCD.pixel(39, 98, 13737836);
            uLCD.pixel(40, 98, 14463624);
            uLCD.pixel(41, 98, 11833967);
            uLCD.pixel(42, 98, 7690815);
            uLCD.pixel(43, 98, 3678992);
            uLCD.pixel(0, 99, 16301171);
            uLCD.pixel(1, 99, 16366964);
            uLCD.pixel(2, 99, 16694900);
            uLCD.pixel(3, 99, 16760691);
            uLCD.pixel(4, 99, 16760176);
            uLCD.pixel(5, 99, 16759662);
            uLCD.pixel(6, 99, 16759151);
            uLCD.pixel(7, 99, 16693360);
            uLCD.pixel(8, 99, 16760696);
            uLCD.pixel(9, 99, 16761210);
            uLCD.pixel(10, 99, 16365938);
            uLCD.pixel(11, 99, 16563574);
            uLCD.pixel(12, 99, 16563829);
            uLCD.pixel(13, 99, 16695413);
            uLCD.pixel(14, 99, 15313760);
            uLCD.pixel(15, 99, 15709286);
            uLCD.pixel(16, 99, 14525525);
            uLCD.pixel(17, 99, 15446629);
            uLCD.pixel(18, 99, 16301425);
            uLCD.pixel(19, 99, 16433011);
            uLCD.pixel(20, 99, 16169585);
            uLCD.pixel(21, 99, 15511656);
            uLCD.pixel(22, 99, 14327130);
            uLCD.pixel(23, 99, 13208910);
            uLCD.pixel(24, 99, 14459491);
            uLCD.pixel(25, 99, 14920560);
            uLCD.pixel(26, 99, 14986612);
            uLCD.pixel(27, 99, 13473373);
            uLCD.pixel(28, 99, 13736546);
            uLCD.pixel(29, 99, 13736033);
            uLCD.pixel(30, 99, 16499339);
            uLCD.pixel(31, 99, 16432767);
            uLCD.pixel(32, 99, 16761203);
            uLCD.pixel(33, 99, 16760174);
            uLCD.pixel(34, 99, 16299891);
            uLCD.pixel(35, 99, 15182701);
            uLCD.pixel(36, 99, 14526061);
            uLCD.pixel(37, 99, 14725501);
            uLCD.pixel(38, 99, 13476471);
            uLCD.pixel(39, 99, 10714971);
            uLCD.pixel(40, 99, 5453081);
            uLCD.pixel(0, 100, 16760179);
            uLCD.pixel(1, 100, 16760177);
            uLCD.pixel(2, 100, 16760177);
            uLCD.pixel(3, 100, 16760432);
            uLCD.pixel(4, 100, 16760432);
            uLCD.pixel(5, 100, 16760431);
            uLCD.pixel(6, 100, 16760175);
            uLCD.pixel(7, 100, 16760431);
            uLCD.pixel(8, 100, 16760432);
            uLCD.pixel(9, 100, 16759918);
            uLCD.pixel(10, 100, 16694384);
            uLCD.pixel(11, 100, 16760434);
            uLCD.pixel(12, 100, 16760434);
            uLCD.pixel(13, 100, 16497005);
            uLCD.pixel(14, 100, 16233833);
            uLCD.pixel(15, 100, 16037224);
            uLCD.pixel(16, 100, 15446627);
            uLCD.pixel(17, 100, 14723417);
            uLCD.pixel(18, 100, 14262353);
            uLCD.pixel(19, 100, 14261842);
            uLCD.pixel(20, 100, 14458451);
            uLCD.pixel(21, 100, 14590039);
            uLCD.pixel(22, 100, 15181921);
            uLCD.pixel(23, 100, 15774830);
            uLCD.pixel(24, 100, 16301433);
            uLCD.pixel(25, 100, 16433534);
            uLCD.pixel(26, 100, 15446385);
            uLCD.pixel(27, 100, 13867354);
            uLCD.pixel(28, 100, 13735257);
            uLCD.pixel(29, 100, 16037499);
            uLCD.pixel(30, 100, 16036729);
            uLCD.pixel(31, 100, 16629117);
            uLCD.pixel(32, 100, 16565108);
            uLCD.pixel(33, 100, 16105594);
            uLCD.pixel(34, 100, 12620133);
            uLCD.pixel(35, 100, 10516826);
            uLCD.pixel(36, 100, 9993053);
            uLCD.pixel(37, 100, 7560771);
            uLCD.pixel(38, 100, 4009238);
            uLCD.pixel(0, 101, 16562800);
            uLCD.pixel(1, 101, 16562800);
            uLCD.pixel(2, 101, 16562798);
            uLCD.pixel(3, 101, 16628591);
            uLCD.pixel(4, 101, 16628589);
            uLCD.pixel(5, 101, 16628589);
            uLCD.pixel(6, 101, 16628844);
            uLCD.pixel(7, 101, 16628844);
            uLCD.pixel(8, 101, 16628844);
            uLCD.pixel(9, 101, 16628844);
            uLCD.pixel(10, 101, 16694382);
            uLCD.pixel(11, 101, 16760432);
            uLCD.pixel(12, 101, 16760434);
            uLCD.pixel(13, 101, 16497005);
            uLCD.pixel(14, 101, 16036456);
            uLCD.pixel(15, 101, 15444833);
            uLCD.pixel(16, 101, 16433524);
            uLCD.pixel(17, 101, 16104559);
            uLCD.pixel(18, 101, 16038253);
            uLCD.pixel(19, 101, 16432241);
            uLCD.pixel(20, 101, 16629109);
            uLCD.pixel(21, 101, 16563316);
            uLCD.pixel(22, 101, 16760953);
            uLCD.pixel(23, 101, 16762752);
            uLCD.pixel(24, 101, 16366965);
            uLCD.pixel(25, 101, 16630396);
            uLCD.pixel(26, 101, 16169845);
            uLCD.pixel(27, 101, 13801299);
            uLCD.pixel(28, 101, 14787681);
            uLCD.pixel(29, 101, 16431992);
            uLCD.pixel(30, 101, 16759933);
            uLCD.pixel(31, 101, 16498301);
            uLCD.pixel(32, 101, 16304002);
            uLCD.pixel(33, 101, 10976840);
            uLCD.pixel(34, 101, 2820352);
            uLCD.pixel(0, 102, 16629367);
            uLCD.pixel(1, 102, 16629367);
            uLCD.pixel(2, 102, 16629622);
            uLCD.pixel(3, 102, 16629622);
            uLCD.pixel(4, 102, 16695413);
            uLCD.pixel(5, 102, 16695413);
            uLCD.pixel(6, 102, 16695411);
            uLCD.pixel(7, 102, 16695411);
            uLCD.pixel(8, 102, 16563825);
            uLCD.pixel(9, 102, 16695411);
            uLCD.pixel(10, 102, 16695413);
            uLCD.pixel(11, 102, 16629620);
            uLCD.pixel(12, 102, 16695415);
            uLCD.pixel(13, 102, 16629622);
            uLCD.pixel(14, 102, 16037230);
            uLCD.pixel(15, 102, 15313507);
            uLCD.pixel(16, 102, 16761982);
            uLCD.pixel(17, 102, 16695162);
            uLCD.pixel(18, 102, 16760442);
            uLCD.pixel(19, 102, 16761213);
            uLCD.pixel(20, 102, 16760697);
            uLCD.pixel(21, 102, 16628340);
            uLCD.pixel(22, 102, 16431731);
            uLCD.pixel(23, 102, 16497781);
            uLCD.pixel(24, 102, 16235379);
            uLCD.pixel(25, 102, 16564856);
            uLCD.pixel(26, 102, 16367990);
            uLCD.pixel(27, 102, 13538891);
            uLCD.pixel(28, 102, 15709547);
            uLCD.pixel(29, 102, 16366964);
            uLCD.pixel(30, 102, 16761722);
            uLCD.pixel(31, 102, 15973499);
            uLCD.pixel(32, 102, 16174234);
            uLCD.pixel(33, 102, 7163693);
            uLCD.pixel(0, 103, 16235381);
            uLCD.pixel(1, 103, 16235381);
            uLCD.pixel(2, 103, 16301172);
            uLCD.pixel(3, 103, 16301172);
            uLCD.pixel(4, 103, 16301171);
            uLCD.pixel(5, 103, 16301171);
            uLCD.pixel(6, 103, 16301425);
            uLCD.pixel(7, 103, 16301425);
            uLCD.pixel(8, 103, 16235632);
            uLCD.pixel(9, 103, 16367218);
            uLCD.pixel(10, 103, 16235378);
            uLCD.pixel(11, 103, 16037999);
            uLCD.pixel(12, 103, 16169586);
            uLCD.pixel(13, 103, 16432758);
            uLCD.pixel(14, 103, 15906416);
            uLCD.pixel(15, 103, 15051107);
            uLCD.pixel(16, 103, 16497785);
            uLCD.pixel(17, 103, 16365686);
            uLCD.pixel(18, 103, 16496502);
            uLCD.pixel(19, 103, 16693622);
            uLCD.pixel(20, 103, 16693622);
            uLCD.pixel(21, 103, 16627827);
            uLCD.pixel(22, 103, 16628340);
            uLCD.pixel(23, 103, 16629622);
            uLCD.pixel(24, 103, 16432757);
            uLCD.pixel(25, 103, 16367988);
            uLCD.pixel(26, 103, 15907437);
            uLCD.pixel(27, 103, 13868622);
            uLCD.pixel(28, 103, 16236656);
            uLCD.pixel(29, 103, 16367729);
            uLCD.pixel(30, 103, 16498802);
            uLCD.pixel(31, 103, 15907704);
            uLCD.pixel(32, 103, 15122059);
            uLCD.pixel(33, 103, 4861199);
            uLCD.pixel(0, 104, 16563576);
            uLCD.pixel(1, 104, 16563576);
            uLCD.pixel(2, 104, 16563574);
            uLCD.pixel(3, 104, 16563574);
            uLCD.pixel(4, 104, 16629622);
            uLCD.pixel(5, 104, 16629622);
            uLCD.pixel(6, 104, 16629622);
            uLCD.pixel(7, 104, 16629622);
            uLCD.pixel(8, 104, 16563829);
            uLCD.pixel(9, 104, 16761208);
            uLCD.pixel(10, 104, 16695415);
            uLCD.pixel(11, 104, 16498036);
            uLCD.pixel(12, 104, 16629367);
            uLCD.pixel(13, 104, 16761210);
            uLCD.pixel(14, 104, 16168818);
            uLCD.pixel(15, 104, 15247716);
            uLCD.pixel(16, 104, 16761213);
            uLCD.pixel(17, 104, 16760699);
            uLCD.pixel(18, 104, 16760185);
            uLCD.pixel(19, 104, 16759927);
            uLCD.pixel(20, 104, 16759670);
            uLCD.pixel(21, 104, 16759413);
            uLCD.pixel(22, 104, 16694133);
            uLCD.pixel(23, 104, 16694902);
            uLCD.pixel(24, 104, 16761979);
            uLCD.pixel(25, 104, 16367988);
            uLCD.pixel(26, 104, 15183714);
            uLCD.pixel(27, 104, 15052896);
            uLCD.pixel(28, 104, 16499828);
            uLCD.pixel(29, 104, 16565106);
            uLCD.pixel(30, 104, 16235628);
            uLCD.pixel(31, 104, 16302197);
            uLCD.pixel(32, 104, 16567436);
            uLCD.pixel(33, 104, 6898454);
            uLCD.pixel(34, 104, 2229760);
            uLCD.pixel(0, 105, 16629371);
            uLCD.pixel(1, 105, 16629369);
            uLCD.pixel(2, 105, 16629369);
            uLCD.pixel(3, 105, 16629367);
            uLCD.pixel(4, 105, 16695160);
            uLCD.pixel(5, 105, 16695160);
            uLCD.pixel(6, 105, 16695160);
            uLCD.pixel(7, 105, 16695160);
            uLCD.pixel(8, 105, 16431988);
            uLCD.pixel(9, 105, 16629367);
            uLCD.pixel(10, 105, 16760953);
            uLCD.pixel(11, 105, 16760953);
            uLCD.pixel(12, 105, 16760955);
            uLCD.pixel(13, 105, 16629369);
            uLCD.pixel(14, 105, 15839853);
            uLCD.pixel(15, 105, 15050337);
            uLCD.pixel(16, 105, 16497781);
            uLCD.pixel(17, 105, 16563316);
            uLCD.pixel(18, 105, 16759925);
            uLCD.pixel(19, 105, 16760182);
            uLCD.pixel(20, 105, 16759926);
            uLCD.pixel(21, 105, 16759412);
            uLCD.pixel(22, 105, 16693875);
            uLCD.pixel(23, 105, 16431730);
            uLCD.pixel(24, 105, 16498804);
            uLCD.pixel(25, 105, 15775594);
            uLCD.pixel(26, 105, 14328405);
            uLCD.pixel(27, 105, 16039023);
            uLCD.pixel(28, 105, 16367729);
            uLCD.pixel(29, 105, 16696181);
            uLCD.pixel(30, 105, 16300653);
            uLCD.pixel(31, 105, 16498804);
            uLCD.pixel(32, 105, 15842161);
            uLCD.pixel(33, 105, 16765848);
            uLCD.pixel(34, 105, 9794132);
            uLCD.pixel(0, 106, 15182441);
            uLCD.pixel(1, 106, 15182439);
            uLCD.pixel(2, 106, 15182439);
            uLCD.pixel(3, 106, 15182439);
            uLCD.pixel(4, 106, 15182439);
            uLCD.pixel(5, 106, 15248486);
            uLCD.pixel(6, 106, 15248486);
            uLCD.pixel(7, 106, 15248486);
            uLCD.pixel(8, 106, 15051107);
            uLCD.pixel(9, 106, 15051107);
            uLCD.pixel(10, 106, 15051107);
            uLCD.pixel(11, 106, 15182693);
            uLCD.pixel(12, 106, 15182439);
            uLCD.pixel(13, 106, 14919267);
            uLCD.pixel(14, 106, 14524509);
            uLCD.pixel(15, 106, 14130005);
            uLCD.pixel(16, 106, 14657113);
            uLCD.pixel(17, 106, 14985563);
            uLCD.pixel(18, 106, 15511137);
            uLCD.pixel(19, 106, 15971431);
            uLCD.pixel(20, 106, 16497007);
            uLCD.pixel(21, 106, 16759923);
            uLCD.pixel(22, 106, 16760950);
            uLCD.pixel(23, 106, 16760950);
            uLCD.pixel(24, 106, 15642727);
            uLCD.pixel(25, 106, 14787932);
            uLCD.pixel(26, 106, 13801550);
            uLCD.pixel(27, 106, 16235378);
            uLCD.pixel(28, 106, 16300402);
            uLCD.pixel(29, 106, 16760696);
            uLCD.pixel(30, 106, 16694133);
            uLCD.pixel(31, 106, 16431214);
            uLCD.pixel(32, 106, 16301421);
            uLCD.pixel(33, 106, 16105846);
            uLCD.pixel(34, 106, 16174226);
            uLCD.pixel(35, 106, 13479039);
            uLCD.pixel(36, 106, 5456155);
            uLCD.pixel(0, 107, 13934178);
            uLCD.pixel(1, 107, 13934178);
            uLCD.pixel(2, 107, 13999971);
            uLCD.pixel(3, 107, 13999971);
            uLCD.pixel(4, 107, 13999969);
            uLCD.pixel(5, 107, 13999969);
            uLCD.pixel(6, 107, 13999969);
            uLCD.pixel(7, 107, 13999969);
            uLCD.pixel(8, 107, 14263143);
            uLCD.pixel(9, 107, 13934176);
            uLCD.pixel(10, 107, 13736797);
            uLCD.pixel(11, 107, 13868383);
            uLCD.pixel(12, 107, 13934178);
            uLCD.pixel(13, 107, 13868385);
            uLCD.pixel(14, 107, 13934178);
            uLCD.pixel(15, 107, 14131553);
            uLCD.pixel(16, 107, 13869400);
            uLCD.pixel(17, 107, 14066262);
            uLCD.pixel(18, 107, 14197591);
            uLCD.pixel(19, 107, 14459480);
            uLCD.pixel(20, 107, 14656346);
            uLCD.pixel(21, 107, 14918749);
            uLCD.pixel(22, 107, 15050335);
            uLCD.pixel(23, 107, 15050335);
            uLCD.pixel(24, 107, 14722140);
            uLCD.pixel(25, 107, 14064210);
            uLCD.pixel(26, 107, 13735245);
            uLCD.pixel(27, 107, 16300404);
            uLCD.pixel(28, 107, 16299891);
            uLCD.pixel(29, 107, 16760699);
            uLCD.pixel(30, 107, 16760958);
            uLCD.pixel(31, 107, 16233324);
            uLCD.pixel(32, 107, 14787414);
            uLCD.pixel(33, 107, 15645033);
            uLCD.pixel(34, 107, 15909494);
            uLCD.pixel(35, 107, 15648385);
            uLCD.pixel(36, 107, 15255693);
            uLCD.pixel(37, 107, 9796171);
            uLCD.pixel(38, 107, 2034176);
            uLCD.pixel(0, 108, 14266239);
            uLCD.pixel(1, 108, 14200446);
            uLCD.pixel(2, 108, 14134653);
            uLCD.pixel(3, 108, 14003067);
            uLCD.pixel(4, 108, 13871481);
            uLCD.pixel(5, 108, 13805688);
            uLCD.pixel(6, 108, 13739895);
            uLCD.pixel(7, 108, 13674102);
            uLCD.pixel(8, 108, 14002813);
            uLCD.pixel(9, 108, 13871481);
            uLCD.pixel(10, 108, 13871481);
            uLCD.pixel(11, 108, 14003067);
            uLCD.pixel(12, 108, 14200446);
            uLCD.pixel(13, 108, 14332032);
            uLCD.pixel(14, 108, 14332032);
            uLCD.pixel(15, 108, 14200699);
            uLCD.pixel(16, 108, 13740395);
            uLCD.pixel(17, 108, 13740134);
            uLCD.pixel(18, 108, 13804898);
            uLCD.pixel(19, 108, 13935457);
            uLCD.pixel(20, 108, 14065760);
            uLCD.pixel(21, 108, 14131295);
            uLCD.pixel(22, 108, 14327904);
            uLCD.pixel(23, 108, 14328158);
            uLCD.pixel(24, 108, 14130264);
            uLCD.pixel(25, 108, 14525022);
            uLCD.pixel(26, 108, 14590302);
            uLCD.pixel(27, 108, 14787165);
            uLCD.pixel(28, 108, 16299377);
            uLCD.pixel(29, 108, 16761983);
            uLCD.pixel(30, 108, 16232042);
            uLCD.pixel(31, 108, 13601351);
            uLCD.pixel(32, 108, 14196568);
            uLCD.pixel(33, 108, 14001240);
            uLCD.pixel(34, 108, 15448167);
            uLCD.pixel(35, 108, 15843441);
            uLCD.pixel(36, 108, 15909496);
            uLCD.pixel(37, 108, 16306065);
            uLCD.pixel(38, 108, 12097388);
            uLCD.pixel(39, 108, 4401937);
            uLCD.pixel(0, 109, 9335891);
            uLCD.pixel(1, 109, 8612168);
            uLCD.pixel(2, 109, 7362101);
            uLCD.pixel(3, 109, 5980448);
            uLCD.pixel(4, 109, 4927760);
            uLCD.pixel(5, 109, 4269830);
            uLCD.pixel(6, 109, 4006404);
            uLCD.pixel(7, 109, 3940611);
            uLCD.pixel(8, 109, 4532748);
            uLCD.pixel(9, 109, 5980448);
            uLCD.pixel(10, 109, 7362101);
            uLCD.pixel(11, 109, 7362101);
            uLCD.pixel(12, 109, 6572585);
            uLCD.pixel(13, 109, 6506792);
            uLCD.pixel(14, 109, 7888445);
            uLCD.pixel(15, 109, 9466957);
            uLCD.pixel(16, 109, 11506532);
            uLCD.pixel(17, 109, 12623981);
            uLCD.pixel(18, 109, 13807228);
            uLCD.pixel(19, 109, 14200957);
            uLCD.pixel(20, 109, 13936244);
            uLCD.pixel(21, 109, 13672041);
            uLCD.pixel(22, 109, 13803368);
            uLCD.pixel(23, 109, 14132073);
            uLCD.pixel(24, 109, 14395243);
            uLCD.pixel(25, 109, 14263139);
            uLCD.pixel(26, 109, 14131295);
            uLCD.pixel(27, 109, 14590817);
            uLCD.pixel(28, 109, 15445095);
            uLCD.pixel(29, 109, 16101996);
            uLCD.pixel(30, 109, 15969640);
            uLCD.pixel(31, 109, 15378275);
            uLCD.pixel(32, 109, 13801814);
            uLCD.pixel(33, 109, 13407822);
            uLCD.pixel(34, 109, 14197073);
            uLCD.pixel(35, 109, 15446627);
            uLCD.pixel(36, 109, 15446889);
            uLCD.pixel(37, 109, 14395497);
            uLCD.pixel(38, 109, 14200699);
            uLCD.pixel(39, 109, 14926748);
            uLCD.pixel(40, 109, 6705722);
            uLCD.pixel(17, 110, 3350019);
            uLCD.pixel(18, 110, 6309419);
            uLCD.pixel(19, 110, 9795161);
            uLCD.pixel(20, 110, 12622972);
            uLCD.pixel(21, 110, 14069386);
            uLCD.pixel(22, 110, 14134661);
            uLCD.pixel(23, 110, 13805434);
            uLCD.pixel(24, 110, 13410670);
            uLCD.pixel(25, 110, 13410150);
            uLCD.pixel(26, 110, 13672292);
            uLCD.pixel(27, 110, 13935457);
            uLCD.pixel(28, 110, 14328672);
            uLCD.pixel(29, 110, 14853985);
            uLCD.pixel(30, 110, 16037230);
            uLCD.pixel(31, 110, 16761724);
            uLCD.pixel(32, 110, 16562547);
            uLCD.pixel(33, 110, 15641445);
            uLCD.pixel(34, 110, 14523733);
            uLCD.pixel(35, 110, 14129751);
            uLCD.pixel(36, 110, 14064481);
            uLCD.pixel(37, 110, 13802855);
            uLCD.pixel(38, 110, 14725497);
            uLCD.pixel(39, 110, 16109207);
            uLCD.pixel(40, 110, 16636843);
            uLCD.pixel(41, 110, 11572333);
            uLCD.pixel(42, 110, 4205328);
            uLCD.pixel(20, 111, 2756352);
            uLCD.pixel(21, 111, 5650210);
            uLCD.pixel(22, 111, 8742220);
            uLCD.pixel(23, 111, 10913124);
            uLCD.pixel(24, 111, 12491894);
            uLCD.pixel(25, 111, 13544574);
            uLCD.pixel(26, 111, 14399363);
            uLCD.pixel(27, 111, 14267001);
            uLCD.pixel(28, 111, 13674090);
            uLCD.pixel(29, 111, 13541474);
            uLCD.pixel(30, 111, 14066532);
            uLCD.pixel(31, 111, 14722663);
            uLCD.pixel(32, 111, 16761221);
            uLCD.pixel(33, 111, 15837802);
            uLCD.pixel(34, 111, 15378789);
            uLCD.pixel(35, 111, 14722403);
            uLCD.pixel(36, 111, 13275997);
            uLCD.pixel(37, 111, 13737066);
            uLCD.pixel(38, 111, 14658675);
            uLCD.pixel(39, 111, 13803878);
            uLCD.pixel(40, 111, 15317117);
            uLCD.pixel(41, 111, 15778185);
            uLCD.pixel(42, 111, 14594950);
            uLCD.pixel(43, 111, 12163181);
            uLCD.pixel(44, 111, 5586965);
            uLCD.pixel(24, 112, 2823936);
            uLCD.pixel(25, 112, 3744773);
            uLCD.pixel(26, 112, 5586714);
            uLCD.pixel(27, 112, 7757621);
            uLCD.pixel(28, 112, 10125138);
            uLCD.pixel(29, 112, 12097898);
            uLCD.pixel(30, 112, 13544058);
            uLCD.pixel(31, 112, 14528128);
            uLCD.pixel(32, 112, 14391405);
            uLCD.pixel(33, 112, 13995867);
            uLCD.pixel(34, 112, 15577451);
            uLCD.pixel(35, 112, 16764290);
            uLCD.pixel(36, 112, 15053686);
            uLCD.pixel(37, 112, 13145438);
            uLCD.pixel(38, 112, 13210720);
            uLCD.pixel(39, 112, 13670240);
            uLCD.pixel(40, 112, 15182190);
            uLCD.pixel(41, 112, 15247464);
            uLCD.pixel(42, 112, 14920295);
            uLCD.pixel(43, 112, 15975550);
            uLCD.pixel(44, 112, 16506009);
            uLCD.pixel(45, 112, 11509354);
            uLCD.pixel(30, 113, 5389600);
            uLCD.pixel(31, 113, 9860955);
            uLCD.pixel(32, 113, 13870216);
            uLCD.pixel(33, 113, 14592385);
            uLCD.pixel(34, 113, 13935714);
            uLCD.pixel(35, 113, 14199391);
            uLCD.pixel(36, 113, 15712127);
            uLCD.pixel(37, 113, 15908484);
            uLCD.pixel(38, 113, 14722928);
            uLCD.pixel(39, 113, 14458728);
            uLCD.pixel(40, 113, 12813642);
            uLCD.pixel(41, 113, 14063707);
            uLCD.pixel(42, 113, 15183983);
            uLCD.pixel(43, 113, 14397034);
            uLCD.pixel(44, 113, 13808750);
            uLCD.pixel(45, 113, 15193244);
            uLCD.pixel(46, 113, 8023386);
            uLCD.pixel(32, 114, 3878178);
            uLCD.pixel(33, 114, 9666404);
            uLCD.pixel(34, 114, 13480571);
            uLCD.pixel(35, 114, 13938539);
            uLCD.pixel(36, 114, 14527594);
            uLCD.pixel(37, 114, 15314800);
            uLCD.pixel(38, 114, 15709044);
            uLCD.pixel(39, 114, 16236672);
            uLCD.pixel(40, 114, 15053435);
            uLCD.pixel(41, 114, 8739627);
            uLCD.pixel(42, 114, 8084017);
            uLCD.pixel(43, 114, 12296826);
            uLCD.pixel(44, 114, 12824961);
            uLCD.pixel(45, 114, 14470048);
            uLCD.pixel(46, 114, 9008225);
            uLCD.pixel(34, 115, 3483907);
            uLCD.pixel(35, 115, 7889199);
            uLCD.pixel(36, 115, 10846030);
            uLCD.pixel(37, 115, 12555106);
            uLCD.pixel(38, 115, 14331000);
            uLCD.pixel(39, 115, 15253132);
            uLCD.pixel(40, 115, 15913384);
            uLCD.pixel(41, 115, 6572844);
            uLCD.pixel(44, 115, 5063464);
            uLCD.pixel(45, 115, 8484187);
            uLCD.pixel(46, 115, 2363908);
            uLCD.pixel(37, 116, 2561799);
            uLCD.pixel(38, 116, 4798761);
            uLCD.pixel(39, 116, 6378563);
            uLCD.pixel(40, 116, 6970960);
        }

        // Draw right Spock
        void drawRightSpock() {
            uLCD.pixel(97, 76, 4142882);
            uLCD.pixel(98, 76, 15589317);
            uLCD.pixel(99, 76, 4470048);
            uLCD.pixel(97, 77, 7629646);
            uLCD.pixel(98, 77, 14865842);
            uLCD.pixel(99, 77, 10851446);
            uLCD.pixel(97, 78, 8813403);
            uLCD.pixel(98, 78, 14602409);
            uLCD.pixel(99, 78, 14798763);
            uLCD.pixel(100, 78, 9270366);
            uLCD.pixel(97, 79, 5983790);
            uLCD.pixel(98, 79, 14602150);
            uLCD.pixel(99, 79, 14402972);
            uLCD.pixel(100, 79, 14928296);
            uLCD.pixel(101, 79, 7032631);
            uLCD.pixel(97, 80, 2627584);
            uLCD.pixel(98, 80, 12693133);
            uLCD.pixel(99, 80, 14468507);
            uLCD.pixel(100, 80, 15190170);
            uLCD.pixel(101, 80, 14729621);
            uLCD.pixel(102, 80, 5059605);
            uLCD.pixel(98, 81, 8087115);
            uLCD.pixel(99, 81, 15125924);
            uLCD.pixel(100, 81, 14203007);
            uLCD.pixel(101, 81, 16374172);
            uLCD.pixel(102, 81, 12427634);
            uLCD.pixel(98, 82, 3349768);
            uLCD.pixel(99, 82, 11638125);
            uLCD.pixel(100, 82, 13281636);
            uLCD.pixel(101, 82, 14992246);
            uLCD.pixel(102, 82, 15914393);
            uLCD.pixel(103, 82, 8876100);
            uLCD.pixel(99, 83, 5849635);
            uLCD.pixel(100, 83, 14335100);
            uLCD.pixel(101, 83, 14795126);
            uLCD.pixel(102, 83, 14795140);
            uLCD.pixel(103, 83, 15782306);
            uLCD.pixel(104, 83, 10453604);
            uLCD.pixel(105, 83, 3480330);
            uLCD.pixel(100, 84, 7495476);
            uLCD.pixel(101, 84, 13743998);
            uLCD.pixel(102, 84, 14662537);
            uLCD.pixel(103, 84, 15845019);
            uLCD.pixel(104, 84, 16041120);
            uLCD.pixel(105, 84, 14659732);
            uLCD.pixel(106, 84, 6239776);
            uLCD.pixel(101, 85, 8350786);
            uLCD.pixel(102, 85, 13676422);
            uLCD.pixel(103, 85, 15778199);
            uLCD.pixel(104, 85, 15578249);
            uLCD.pixel(105, 85, 16038546);
            uLCD.pixel(106, 85, 16764842);
            uLCD.pixel(107, 85, 8543806);
            uLCD.pixel(102, 86, 11309679);
            uLCD.pixel(103, 86, 15846300);
            uLCD.pixel(104, 86, 15974537);
            uLCD.pixel(105, 86, 15710589);
            uLCD.pixel(106, 86, 16765081);
            uLCD.pixel(107, 86, 15055501);
            uLCD.pixel(108, 86, 7098161);
            uLCD.pixel(102, 87, 3810566);
            uLCD.pixel(103, 87, 12821362);
            uLCD.pixel(104, 87, 16305034);
            uLCD.pixel(105, 87, 15579504);
            uLCD.pixel(106, 87, 15447664);
            uLCD.pixel(107, 87, 16501392);
            uLCD.pixel(108, 87, 14595984);
            uLCD.pixel(109, 87, 5058844);
            uLCD.pixel(103, 88, 10980185);
            uLCD.pixel(104, 88, 15779970);
            uLCD.pixel(105, 88, 16699004);
            uLCD.pixel(106, 88, 15381347);
            uLCD.pixel(107, 88, 16170360);
            uLCD.pixel(108, 88, 16566424);
            uLCD.pixel(109, 88, 12884345);
            uLCD.pixel(110, 88, 2886144);
            uLCD.pixel(82, 89, 2561792);
            uLCD.pixel(83, 89, 4534804);
            uLCD.pixel(84, 89, 5191704);
            uLCD.pixel(85, 89, 4599567);
            uLCD.pixel(86, 89, 4731668);
            uLCD.pixel(87, 89, 4995101);
            uLCD.pixel(88, 89, 5390376);
            uLCD.pixel(89, 89, 4075290);
            uLCD.pixel(90, 89, 2628620);
            uLCD.pixel(102, 89, 2495232);
            uLCD.pixel(103, 89, 14203528);
            uLCD.pixel(104, 89, 16108935);
            uLCD.pixel(105, 89, 14988386);
            uLCD.pixel(106, 89, 16762740);
            uLCD.pixel(107, 89, 15642725);
            uLCD.pixel(108, 89, 16564354);
            uLCD.pixel(109, 89, 16236947);
            uLCD.pixel(110, 89, 11041889);
            uLCD.pixel(80, 90, 3548944);
            uLCD.pixel(81, 90, 12034691);
            uLCD.pixel(82, 90, 15454122);
            uLCD.pixel(83, 90, 14861207);
            uLCD.pixel(84, 90, 14992790);
            uLCD.pixel(85, 90, 14795150);
            uLCD.pixel(86, 90, 15518616);
            uLCD.pixel(87, 90, 15715995);
            uLCD.pixel(88, 90, 16241571);
            uLCD.pixel(89, 90, 14728078);
            uLCD.pixel(90, 90, 13741184);
            uLCD.pixel(91, 90, 12689012);
            uLCD.pixel(92, 90, 9465416);
            uLCD.pixel(93, 90, 7031337);
            uLCD.pixel(94, 90, 3808256);
            uLCD.pixel(100, 90, 2099968);
            uLCD.pixel(101, 90, 3283712);
            uLCD.pixel(102, 90, 10388058);
            uLCD.pixel(103, 90, 14596744);
            uLCD.pixel(104, 90, 15121019);
            uLCD.pixel(105, 90, 16369020);
            uLCD.pixel(106, 90, 16696181);
            uLCD.pixel(107, 90, 16695152);
            uLCD.pixel(108, 90, 16760952);
            uLCD.pixel(109, 90, 15972216);
            uLCD.pixel(110, 90, 16764060);
            uLCD.pixel(111, 90, 8411189);
            uLCD.pixel(112, 90, 2230528);
            uLCD.pixel(80, 91, 8481354);
            uLCD.pixel(81, 91, 15847850);
            uLCD.pixel(82, 91, 15648921);
            uLCD.pixel(83, 91, 15319180);
            uLCD.pixel(84, 91, 14924418);
            uLCD.pixel(85, 91, 14858877);
            uLCD.pixel(86, 91, 15713158);
            uLCD.pixel(87, 91, 15448957);
            uLCD.pixel(88, 91, 15580028);
            uLCD.pixel(89, 91, 14856046);
            uLCD.pixel(90, 91, 15973757);
            uLCD.pixel(91, 91, 16697482);
            uLCD.pixel(92, 91, 16237449);
            uLCD.pixel(93, 91, 16172429);
            uLCD.pixel(94, 91, 15317898);
            uLCD.pixel(95, 91, 13148019);
            uLCD.pixel(96, 91, 10583385);
            uLCD.pixel(97, 91, 9334608);
            uLCD.pixel(98, 91, 9796189);
            uLCD.pixel(99, 91, 10979946);
            uLCD.pixel(100, 91, 13018490);
            uLCD.pixel(101, 91, 14859916);
            uLCD.pixel(102, 91, 15779989);
            uLCD.pixel(103, 91, 15318665);
            uLCD.pixel(104, 91, 16435598);
            uLCD.pixel(105, 91, 15512948);
            uLCD.pixel(106, 91, 16300402);
            uLCD.pixel(107, 91, 16760946);
            uLCD.pixel(108, 91, 15839328);
            uLCD.pixel(109, 91, 16762746);
            uLCD.pixel(110, 91, 15578739);
            uLCD.pixel(111, 91, 16766112);
            uLCD.pixel(112, 91, 6176798);
            uLCD.pixel(80, 92, 7294760);
            uLCD.pixel(81, 92, 14990475);
            uLCD.pixel(82, 92, 15185534);
            uLCD.pixel(83, 92, 14526831);
            uLCD.pixel(84, 92, 15053688);
            uLCD.pixel(85, 92, 14658930);
            uLCD.pixel(86, 92, 15710587);
            uLCD.pixel(87, 92, 16630659);
            uLCD.pixel(88, 92, 15708783);
            uLCD.pixel(89, 92, 14589784);
            uLCD.pixel(90, 92, 16563314);
            uLCD.pixel(91, 92, 16300142);
            uLCD.pixel(92, 92, 16431728);
            uLCD.pixel(93, 92, 16695929);
            uLCD.pixel(94, 92, 15644014);
            uLCD.pixel(95, 92, 16500870);
            uLCD.pixel(96, 92, 16107914);
            uLCD.pixel(97, 92, 16240532);
            uLCD.pixel(98, 92, 16043928);
            uLCD.pixel(99, 92, 15714445);
            uLCD.pixel(100, 92, 16435590);
            uLCD.pixel(101, 92, 15908215);
            uLCD.pixel(102, 92, 15644792);
            uLCD.pixel(103, 92, 15973761);
            uLCD.pixel(104, 92, 16302215);
            uLCD.pixel(105, 92, 16235648);
            uLCD.pixel(106, 92, 16235127);
            uLCD.pixel(107, 92, 16563314);
            uLCD.pixel(108, 92, 16563047);
            uLCD.pixel(109, 92, 16695403);
            uLCD.pixel(110, 92, 16236143);
            uLCD.pixel(111, 92, 16106883);
            uLCD.pixel(112, 92, 14728078);
            uLCD.pixel(113, 92, 4006153);
            uLCD.pixel(79, 93, 5849121);
            uLCD.pixel(80, 93, 7491365);
            uLCD.pixel(81, 93, 11371087);
            uLCD.pixel(82, 93, 12750420);
            uLCD.pixel(83, 93, 13802331);
            uLCD.pixel(84, 93, 12617803);
            uLCD.pixel(85, 93, 12157252);
            uLCD.pixel(86, 93, 13603668);
            uLCD.pixel(87, 93, 14656095);
            uLCD.pixel(88, 93, 14721372);
            uLCD.pixel(89, 93, 14260561);
            uLCD.pixel(90, 93, 16233833);
            uLCD.pixel(91, 93, 16760175);
            uLCD.pixel(92, 93, 15774050);
            uLCD.pixel(93, 93, 16761715);
            uLCD.pixel(94, 93, 15775079);
            uLCD.pixel(95, 93, 16170609);
            uLCD.pixel(96, 93, 16434811);
            uLCD.pixel(97, 93, 15514738);
            uLCD.pixel(98, 93, 15121009);
            uLCD.pixel(99, 93, 16172409);
            uLCD.pixel(100, 93, 16103527);
            uLCD.pixel(101, 93, 16563049);
            uLCD.pixel(102, 93, 16694902);
            uLCD.pixel(103, 93, 16498299);
            uLCD.pixel(104, 93, 16301182);
            uLCD.pixel(105, 93, 16301182);
            uLCD.pixel(106, 93, 16629885);
            uLCD.pixel(107, 93, 16761979);
            uLCD.pixel(108, 93, 16762483);
            uLCD.pixel(109, 93, 16432744);
            uLCD.pixel(110, 93, 15973224);
            uLCD.pixel(111, 93, 16106364);
            uLCD.pixel(112, 93, 15450251);
            uLCD.pixel(113, 93, 11241315);
            uLCD.pixel(114, 93, 3282179);
            uLCD.pixel(78, 94, 4337692);
            uLCD.pixel(79, 94, 14928042);
            uLCD.pixel(80, 94, 15189146);
            uLCD.pixel(81, 94, 16108183);
            uLCD.pixel(82, 94, 16171656);
            uLCD.pixel(83, 94, 15578742);
            uLCD.pixel(84, 94, 14460260);
            uLCD.pixel(85, 94, 13407056);
            uLCD.pixel(86, 94, 13538642);
            uLCD.pixel(87, 94, 13209675);
            uLCD.pixel(88, 94, 13210191);
            uLCD.pixel(89, 94, 12749894);
            uLCD.pixel(90, 94, 13407824);
            uLCD.pixel(91, 94, 14263131);
            uLCD.pixel(92, 94, 14789475);
            uLCD.pixel(93, 94, 16302712);
            uLCD.pixel(94, 94, 16631677);
            uLCD.pixel(95, 94, 15908209);
            uLCD.pixel(96, 94, 16039795);
            uLCD.pixel(97, 94, 16171381);
            uLCD.pixel(98, 94, 16237172);
            uLCD.pixel(99, 94, 15248733);
            uLCD.pixel(100, 94, 16101724);
            uLCD.pixel(101, 94, 16759655);
            uLCD.pixel(102, 94, 16761460);
            uLCD.pixel(103, 94, 16760693);
            uLCD.pixel(104, 94, 16563317);
            uLCD.pixel(105, 94, 16629369);
            uLCD.pixel(106, 94, 16432760);
            uLCD.pixel(107, 94, 16234864);
            uLCD.pixel(108, 94, 16037481);
            uLCD.pixel(109, 94, 16366446);
            uLCD.pixel(110, 94, 16499063);
            uLCD.pixel(111, 94, 16697733);
            uLCD.pixel(112, 94, 15711876);
            uLCD.pixel(113, 94, 14924169);
            uLCD.pixel(114, 94, 6372118);
            uLCD.pixel(115, 94, 2820352);
            uLCD.pixel(118, 94, 2558208);
            uLCD.pixel(119, 94, 3281920);
            uLCD.pixel(120, 94, 4400136);
            uLCD.pixel(121, 94, 5518616);
            uLCD.pixel(122, 94, 6702374);
            uLCD.pixel(123, 94, 7294509);
            uLCD.pixel(124, 94, 7755060);
            uLCD.pixel(125, 94, 7689267);
            uLCD.pixel(126, 94, 7623474);
            uLCD.pixel(127, 94, 7491886);
            uLCD.pixel(78, 95, 3877400);
            uLCD.pixel(79, 95, 13612957);
            uLCD.pixel(80, 95, 13413510);
            uLCD.pixel(81, 95, 14135684);
            uLCD.pixel(82, 95, 14659965);
            uLCD.pixel(83, 95, 14198379);
            uLCD.pixel(84, 95, 16766098);
            uLCD.pixel(85, 95, 16172157);
            uLCD.pixel(86, 95, 16172159);
            uLCD.pixel(87, 95, 15251316);
            uLCD.pixel(88, 95, 16172419);
            uLCD.pixel(89, 95, 15317367);
            uLCD.pixel(90, 95, 13146198);
            uLCD.pixel(91, 95, 12290889);
            uLCD.pixel(92, 95, 10251306);
            uLCD.pixel(93, 95, 8672016);
            uLCD.pixel(94, 95, 12421958);
            uLCD.pixel(95, 95, 16500095);
            uLCD.pixel(96, 95, 16763009);
            uLCD.pixel(97, 95, 15972207);
            uLCD.pixel(98, 95, 16695929);
            uLCD.pixel(99, 95, 15379294);
            uLCD.pixel(100, 95, 14522696);
            uLCD.pixel(101, 95, 15837784);
            uLCD.pixel(102, 95, 16759915);
            uLCD.pixel(103, 95, 16760946);
            uLCD.pixel(104, 95, 16760691);
            uLCD.pixel(105, 95, 16760950);
            uLCD.pixel(106, 95, 16695415);
            uLCD.pixel(107, 95, 16563829);
            uLCD.pixel(108, 95, 16761465);
            uLCD.pixel(109, 95, 16763008);
            uLCD.pixel(110, 95, 15972466);
            uLCD.pixel(111, 95, 15841911);
            uLCD.pixel(112, 95, 15777150);
            uLCD.pixel(113, 95, 16369806);
            uLCD.pixel(114, 95, 15910286);
            uLCD.pixel(115, 95, 14989447);
            uLCD.pixel(116, 95, 13608309);
            uLCD.pixel(117, 95, 13739641);
            uLCD.pixel(118, 95, 14068860);
            uLCD.pixel(119, 95, 14463105);
            uLCD.pixel(120, 95, 14923654);
            uLCD.pixel(121, 95, 15318412);
            uLCD.pixel(122, 95, 15778448);
            uLCD.pixel(123, 95, 15975825);
            uLCD.pixel(124, 95, 16041618);
            uLCD.pixel(125, 95, 16107665);
            uLCD.pixel(126, 95, 16173204);
            uLCD.pixel(127, 95, 16305044);
            uLCD.pixel(78, 96, 3352347);
            uLCD.pixel(79, 96, 9930354);
            uLCD.pixel(80, 96, 12231302);
            uLCD.pixel(81, 96, 13874836);
            uLCD.pixel(82, 96, 13215358);
            uLCD.pixel(83, 96, 12227683);
            uLCD.pixel(84, 96, 13871724);
            uLCD.pixel(85, 96, 14135146);
            uLCD.pixel(86, 96, 14463857);
            uLCD.pixel(87, 96, 13016411);
            uLCD.pixel(88, 96, 14398066);
            uLCD.pixel(89, 96, 15516549);
            uLCD.pixel(90, 96, 15516549);
            uLCD.pixel(91, 96, 16239502);
            uLCD.pixel(92, 96, 12094030);
            uLCD.pixel(93, 96, 9395747);
            uLCD.pixel(94, 96, 12618832);
            uLCD.pixel(95, 96, 16302211);
            uLCD.pixel(96, 96, 16498561);
            uLCD.pixel(97, 96, 15511408);
            uLCD.pixel(98, 96, 16694912);
            uLCD.pixel(99, 96, 16103027);
            uLCD.pixel(100, 96, 13208133);
            uLCD.pixel(101, 96, 14524246);
            uLCD.pixel(102, 96, 16103276);
            uLCD.pixel(103, 96, 16761461);
            uLCD.pixel(104, 96, 16760945);
            uLCD.pixel(105, 96, 16431980);
            uLCD.pixel(106, 96, 16497775);
            uLCD.pixel(107, 96, 16760952);
            uLCD.pixel(108, 96, 16103025);
            uLCD.pixel(109, 96, 16695678);
            uLCD.pixel(110, 96, 15972470);
            uLCD.pixel(111, 96, 16302464);
            uLCD.pixel(112, 96, 16499843);
            uLCD.pixel(113, 96, 15316080);
            uLCD.pixel(114, 96, 16501124);
            uLCD.pixel(115, 96, 15580022);
            uLCD.pixel(116, 96, 15777147);
            uLCD.pixel(117, 96, 15974012);
            uLCD.pixel(118, 96, 16237184);
            uLCD.pixel(119, 96, 16499841);
            uLCD.pixel(120, 96, 16565888);
            uLCD.pixel(121, 96, 16631681);
            uLCD.pixel(122, 96, 16762495);
            uLCD.pixel(123, 96, 16696702);
            uLCD.pixel(124, 96, 15972979);
            uLCD.pixel(125, 96, 15973233);
            uLCD.pixel(126, 96, 15907956);
            uLCD.pixel(127, 96, 15973747);
            uLCD.pixel(80, 97, 2101504);
            uLCD.pixel(81, 97, 4666138);
            uLCD.pixel(82, 97, 7494460);
            uLCD.pixel(83, 97, 11243368);
            uLCD.pixel(84, 97, 13084534);
            uLCD.pixel(85, 97, 13610870);
            uLCD.pixel(86, 97, 13675893);
            uLCD.pixel(87, 97, 12491360);
            uLCD.pixel(88, 97, 14069622);
            uLCD.pixel(89, 97, 15253124);
            uLCD.pixel(90, 97, 15515524);
            uLCD.pixel(91, 97, 15448703);
            uLCD.pixel(92, 97, 16765591);
            uLCD.pixel(93, 97, 16763534);
            uLCD.pixel(94, 97, 16763278);
            uLCD.pixel(95, 97, 15972476);
            uLCD.pixel(96, 97, 15642741);
            uLCD.pixel(97, 97, 15182188);
            uLCD.pixel(98, 97, 14984295);
            uLCD.pixel(99, 97, 15051115);
            uLCD.pixel(100, 97, 13144660);
            uLCD.pixel(101, 97, 13342807);
            uLCD.pixel(102, 97, 14328926);
            uLCD.pixel(103, 97, 15643754);
            uLCD.pixel(104, 97, 16629618);
            uLCD.pixel(105, 97, 16761202);
            uLCD.pixel(106, 97, 16694384);
            uLCD.pixel(107, 97, 16562800);
            uLCD.pixel(108, 97, 16234098);
            uLCD.pixel(109, 97, 16563324);
            uLCD.pixel(110, 97, 16366974);
            uLCD.pixel(111, 97, 16367741);
            uLCD.pixel(112, 97, 16170360);
            uLCD.pixel(113, 97, 16302197);
            uLCD.pixel(114, 97, 16105070);
            uLCD.pixel(115, 97, 15973482);
            uLCD.pixel(116, 97, 16630903);
            uLCD.pixel(117, 97, 16630136);
            uLCD.pixel(118, 97, 16564343);
            uLCD.pixel(119, 97, 16366964);
            uLCD.pixel(120, 97, 16235632);
            uLCD.pixel(121, 97, 16234860);
            uLCD.pixel(122, 97, 16169067);
            uLCD.pixel(123, 97, 16103528);
            uLCD.pixel(124, 97, 16695665);
            uLCD.pixel(125, 97, 16629872);
            uLCD.pixel(126, 97, 16367214);
            uLCD.pixel(127, 97, 16235628);
            uLCD.pixel(84, 98, 3613189);
            uLCD.pixel(85, 98, 7625273);
            uLCD.pixel(86, 98, 11571822);
            uLCD.pixel(87, 98, 13149563);
            uLCD.pixel(88, 98, 14200446);
            uLCD.pixel(89, 98, 13869422);
            uLCD.pixel(90, 98, 14789233);
            uLCD.pixel(91, 98, 15051628);
            uLCD.pixel(92, 98, 15773808);
            uLCD.pixel(93, 98, 16102512);
            uLCD.pixel(94, 98, 16365684);
            uLCD.pixel(95, 98, 16563576);
            uLCD.pixel(96, 98, 16497785);
            uLCD.pixel(97, 98, 14853474);
            uLCD.pixel(98, 98, 12682820);
            uLCD.pixel(99, 98, 13540186);
            uLCD.pixel(100, 98, 12424538);
            uLCD.pixel(101, 98, 12490590);
            uLCD.pixel(102, 98, 12949850);
            uLCD.pixel(103, 98, 13935197);
            uLCD.pixel(104, 98, 15511656);
            uLCD.pixel(105, 98, 16760436);
            uLCD.pixel(106, 98, 16761206);
            uLCD.pixel(107, 98, 16759924);
            uLCD.pixel(108, 98, 16760954);
            uLCD.pixel(109, 98, 16761727);
            uLCD.pixel(110, 98, 16761985);
            uLCD.pixel(111, 98, 16038259);
            uLCD.pixel(112, 98, 15906926);
            uLCD.pixel(113, 98, 16696694);
            uLCD.pixel(114, 98, 16170088);
            uLCD.pixel(115, 98, 16762484);
            uLCD.pixel(116, 98, 16366964);
            uLCD.pixel(117, 98, 16431992);
            uLCD.pixel(118, 98, 16431990);
            uLCD.pixel(119, 98, 16497783);
            uLCD.pixel(120, 98, 16563574);
            uLCD.pixel(121, 98, 16694902);
            uLCD.pixel(122, 98, 16760952);
            uLCD.pixel(123, 98, 16761209);
            uLCD.pixel(124, 98, 16563829);
            uLCD.pixel(125, 98, 16629622);
            uLCD.pixel(126, 98, 16498550);
            uLCD.pixel(127, 98, 16564343);
            uLCD.pixel(86, 99, 2296320);
            uLCD.pixel(87, 99, 5453853);
            uLCD.pixel(88, 99, 10386269);
            uLCD.pixel(89, 99, 12819573);
            uLCD.pixel(90, 99, 14988679);
            uLCD.pixel(91, 99, 14395505);
            uLCD.pixel(92, 99, 15511925);
            uLCD.pixel(93, 99, 15840369);
            uLCD.pixel(94, 99, 16629367);
            uLCD.pixel(95, 99, 16761467);
            uLCD.pixel(96, 99, 16431988);
            uLCD.pixel(97, 99, 16630139);
            uLCD.pixel(98, 99, 14459229);
            uLCD.pixel(99, 99, 13474393);
            uLCD.pixel(100, 99, 13082466);
            uLCD.pixel(101, 99, 14069620);
            uLCD.pixel(102, 99, 14594673);
            uLCD.pixel(103, 99, 13803611);
            uLCD.pixel(104, 99, 13406793);
            uLCD.pixel(105, 99, 14392145);
            uLCD.pixel(106, 99, 15772769);
            uLCD.pixel(107, 99, 16364906);
            uLCD.pixel(108, 99, 16760179);
            uLCD.pixel(109, 99, 16300144);
            uLCD.pixel(110, 99, 15380070);
            uLCD.pixel(111, 99, 14459480);
            uLCD.pixel(112, 99, 15643495);
            uLCD.pixel(113, 99, 15511905);
            uLCD.pixel(114, 99, 16170088);
            uLCD.pixel(115, 99, 16761714);
            uLCD.pixel(116, 99, 16629109);
            uLCD.pixel(117, 99, 16628856);
            uLCD.pixel(118, 99, 16629110);
            uLCD.pixel(119, 99, 16629110);
            uLCD.pixel(120, 99, 16563317);
            uLCD.pixel(121, 99, 16431730);
            uLCD.pixel(122, 99, 16430960);
            uLCD.pixel(123, 99, 16234351);
            uLCD.pixel(124, 99, 16563316);
            uLCD.pixel(125, 99, 16563316);
            uLCD.pixel(126, 99, 16498036);
            uLCD.pixel(127, 99, 16498036);
            uLCD.pixel(89, 100, 4075039);
            uLCD.pixel(90, 100, 7495238);
            uLCD.pixel(91, 100, 9862233);
            uLCD.pixel(92, 100, 10583373);
            uLCD.pixel(93, 100, 12620634);
            uLCD.pixel(94, 100, 16500870);
            uLCD.pixel(95, 100, 16367739);
            uLCD.pixel(96, 100, 16629885);
            uLCD.pixel(97, 100, 16168820);
            uLCD.pixel(98, 100, 16036982);
            uLCD.pixel(99, 100, 13801047);
            uLCD.pixel(100, 100, 13671255);
            uLCD.pixel(101, 100, 15448434);
            uLCD.pixel(102, 100, 15908467);
            uLCD.pixel(103, 100, 16171381);
            uLCD.pixel(104, 100, 15841385);
            uLCD.pixel(105, 100, 14853461);
            uLCD.pixel(106, 100, 14787155);
            uLCD.pixel(107, 100, 14589776);
            uLCD.pixel(108, 100, 14523983);
            uLCD.pixel(109, 100, 14524242);
            uLCD.pixel(110, 100, 15182174);
            uLCD.pixel(111, 100, 15577702);
            uLCD.pixel(112, 100, 15971690);
            uLCD.pixel(113, 100, 15709288);
            uLCD.pixel(114, 100, 16169837);
            uLCD.pixel(115, 100, 16761204);
            uLCD.pixel(116, 100, 16760177);
            uLCD.pixel(117, 100, 16760177);
            uLCD.pixel(118, 100, 16760177);
            uLCD.pixel(119, 100, 16760177);
            uLCD.pixel(120, 100, 16760177);
            uLCD.pixel(121, 100, 16760177);
            uLCD.pixel(122, 100, 16759921);
            uLCD.pixel(123, 100, 16760177);
            uLCD.pixel(124, 100, 16760177);
            uLCD.pixel(125, 100, 16760177);
            uLCD.pixel(126, 100, 16760179);
            uLCD.pixel(127, 100, 16760179);
            uLCD.pixel(93, 101, 3347200);
            uLCD.pixel(94, 101, 10647364);
            uLCD.pixel(95, 101, 15974790);
            uLCD.pixel(96, 101, 16763016);
            uLCD.pixel(97, 101, 16038009);
            uLCD.pixel(98, 101, 16498303);
            uLCD.pixel(99, 101, 14788196);
            uLCD.pixel(100, 101, 13472845);
            uLCD.pixel(101, 101, 16433784);
            uLCD.pixel(102, 101, 16565369);
            uLCD.pixel(103, 101, 16433783);
            uLCD.pixel(104, 101, 16763261);
            uLCD.pixel(105, 101, 16564595);
            uLCD.pixel(106, 101, 16563825);
            uLCD.pixel(107, 101, 16761461);
            uLCD.pixel(108, 101, 16300653);
            uLCD.pixel(109, 101, 16168810);
            uLCD.pixel(110, 101, 16300142);
            uLCD.pixel(111, 101, 16431728);
            uLCD.pixel(112, 101, 15642214);
            uLCD.pixel(113, 101, 15774313);
            uLCD.pixel(114, 101, 16234609);
            uLCD.pixel(115, 101, 16563829);
            uLCD.pixel(116, 101, 16563568);
            uLCD.pixel(117, 101, 16694382);
            uLCD.pixel(118, 101, 16694382);
            uLCD.pixel(119, 101, 16694382);
            uLCD.pixel(120, 101, 16694382);
            uLCD.pixel(121, 101, 16694382);
            uLCD.pixel(122, 101, 16694384);
            uLCD.pixel(123, 101, 16694384);
            uLCD.pixel(124, 101, 16562798);
            uLCD.pixel(125, 101, 16562798);
            uLCD.pixel(126, 101, 16562800);
            uLCD.pixel(127, 101, 16562800);
            uLCD.pixel(93, 102, 2625024);
            uLCD.pixel(94, 102, 6832936);
            uLCD.pixel(95, 102, 16568489);
            uLCD.pixel(96, 102, 15185282);
            uLCD.pixel(97, 102, 16237958);
            uLCD.pixel(98, 102, 15843190);
            uLCD.pixel(99, 102, 15513709);
            uLCD.pixel(100, 102, 13342290);
            uLCD.pixel(101, 102, 16631429);
            uLCD.pixel(102, 102, 16696706);
            uLCD.pixel(103, 102, 15841397);
            uLCD.pixel(104, 102, 16695678);
            uLCD.pixel(105, 102, 16432760);
            uLCD.pixel(106, 102, 16103025);
            uLCD.pixel(107, 102, 16563317);
            uLCD.pixel(108, 102, 16761981);
            uLCD.pixel(109, 102, 16761211);
            uLCD.pixel(110, 102, 16760697);
            uLCD.pixel(111, 102, 16761725);
            uLCD.pixel(112, 102, 15509861);
            uLCD.pixel(113, 102, 16365170);
            uLCD.pixel(114, 102, 16760188);
            uLCD.pixel(115, 102, 16760699);
            uLCD.pixel(116, 102, 16629622);
            uLCD.pixel(117, 102, 16629620);
            uLCD.pixel(118, 102, 16629620);
            uLCD.pixel(119, 102, 16629620);
            uLCD.pixel(120, 102, 16629620);
            uLCD.pixel(121, 102, 16629620);
            uLCD.pixel(122, 102, 16629622);
            uLCD.pixel(123, 102, 16629622);
            uLCD.pixel(124, 102, 16629622);
            uLCD.pixel(125, 102, 16629622);
            uLCD.pixel(126, 102, 16629367);
            uLCD.pixel(127, 102, 16629367);
            uLCD.pixel(94, 103, 5583131);
            uLCD.pixel(95, 103, 14989972);
            uLCD.pixel(96, 103, 15975568);
            uLCD.pixel(97, 103, 15646075);
            uLCD.pixel(98, 103, 16435580);
            uLCD.pixel(99, 103, 15580269);
            uLCD.pixel(100, 103, 13802841);
            uLCD.pixel(101, 103, 15907707);
            uLCD.pixel(102, 103, 16433281);
            uLCD.pixel(103, 103, 15972729);
            uLCD.pixel(104, 103, 16366715);
            uLCD.pixel(105, 103, 16366715);
            uLCD.pixel(106, 103, 16365686);
            uLCD.pixel(107, 103, 16497272);
            uLCD.pixel(108, 103, 16430963);
            uLCD.pixel(109, 103, 16430963);
            uLCD.pixel(110, 103, 16562036);
            uLCD.pixel(111, 103, 16760957);
            uLCD.pixel(112, 103, 14983006);
            uLCD.pixel(113, 103, 16430452);
            uLCD.pixel(114, 103, 16759933);
            uLCD.pixel(115, 103, 16497272);
            uLCD.pixel(116, 103, 16366195);
            uLCD.pixel(117, 103, 16235378);
            uLCD.pixel(118, 103, 16235378);
            uLCD.pixel(119, 103, 16235378);
            uLCD.pixel(120, 103, 16235378);
            uLCD.pixel(121, 103, 16235378);
            uLCD.pixel(122, 103, 16235379);
            uLCD.pixel(123, 103, 16235379);
            uLCD.pixel(124, 103, 16235379);
            uLCD.pixel(125, 103, 16235379);
            uLCD.pixel(126, 103, 16235381);
            uLCD.pixel(127, 103, 16235381);
            uLCD.pixel(93, 104, 3478784);
            uLCD.pixel(94, 104, 6765593);
            uLCD.pixel(95, 104, 16238486);
            uLCD.pixel(96, 104, 16368517);
            uLCD.pixel(97, 104, 16301944);
            uLCD.pixel(98, 104, 15775592);
            uLCD.pixel(99, 104, 16764545);
            uLCD.pixel(100, 104, 15118188);
            uLCD.pixel(101, 104, 14920812);
            uLCD.pixel(102, 104, 16235902);
            uLCD.pixel(103, 104, 16762245);
            uLCD.pixel(104, 104, 16300922);
            uLCD.pixel(105, 104, 16366715);
            uLCD.pixel(106, 104, 16760701);
            uLCD.pixel(107, 104, 16431477);
            uLCD.pixel(108, 104, 16760442);
            uLCD.pixel(109, 104, 16760185);
            uLCD.pixel(110, 104, 16759672);
            uLCD.pixel(111, 104, 16761728);
            uLCD.pixel(112, 104, 15114590);
            uLCD.pixel(113, 104, 16562036);
            uLCD.pixel(114, 104, 16760445);
            uLCD.pixel(115, 104, 16563065);
            uLCD.pixel(116, 104, 16629367);
            uLCD.pixel(117, 104, 16629367);
            uLCD.pixel(118, 104, 16629367);
            uLCD.pixel(119, 104, 16629367);
            uLCD.pixel(120, 104, 16695160);
            uLCD.pixel(121, 104, 16695160);
            uLCD.pixel(122, 104, 16695160);
            uLCD.pixel(123, 104, 16695160);
            uLCD.pixel(124, 104, 16563576);
            uLCD.pixel(125, 104, 16563576);
            uLCD.pixel(126, 104, 16563576);
            uLCD.pixel(127, 104, 16563576);
            uLCD.pixel(93, 105, 10319437);
            uLCD.pixel(94, 105, 16238738);
            uLCD.pixel(95, 105, 16302722);
            uLCD.pixel(96, 105, 16104052);
            uLCD.pixel(97, 105, 15905897);
            uLCD.pixel(98, 105, 16763260);
            uLCD.pixel(99, 105, 16300655);
            uLCD.pixel(100, 105, 16301431);
            uLCD.pixel(101, 105, 14262363);
            uLCD.pixel(102, 105, 15578223);
            uLCD.pixel(103, 105, 16762755);
            uLCD.pixel(104, 105, 16169588);
            uLCD.pixel(105, 105, 16301174);
            uLCD.pixel(106, 105, 16695160);
            uLCD.pixel(107, 105, 16300145);
            uLCD.pixel(108, 105, 16761981);
            uLCD.pixel(109, 105, 16694649);
            uLCD.pixel(110, 105, 16431477);
            uLCD.pixel(111, 105, 16694649);
            uLCD.pixel(112, 105, 15049824);
            uLCD.pixel(113, 105, 16102512);
            uLCD.pixel(114, 105, 16563578);
            uLCD.pixel(115, 105, 16629371);
            uLCD.pixel(116, 105, 16629369);
            uLCD.pixel(117, 105, 16629369);
            uLCD.pixel(118, 105, 16629369);
            uLCD.pixel(119, 105, 16629369);
            uLCD.pixel(120, 105, 16695162);
            uLCD.pixel(121, 105, 16695162);
            uLCD.pixel(122, 105, 16760955);
            uLCD.pixel(123, 105, 16760955);
            uLCD.pixel(124, 105, 16629369);
            uLCD.pixel(125, 105, 16629369);
            uLCD.pixel(126, 105, 16629371);
            uLCD.pixel(127, 105, 16629369);
            uLCD.pixel(90, 106, 2559488);
            uLCD.pixel(91, 106, 5124110);
            uLCD.pixel(92, 106, 14333059);
            uLCD.pixel(93, 106, 15844229);
            uLCD.pixel(94, 106, 15908469);
            uLCD.pixel(95, 106, 16498802);
            uLCD.pixel(96, 106, 16694382);
            uLCD.pixel(97, 106, 16760947);
            uLCD.pixel(98, 106, 16692844);
            uLCD.pixel(99, 106, 16693873);
            uLCD.pixel(100, 106, 16300653);
            uLCD.pixel(101, 106, 13670216);
            uLCD.pixel(102, 106, 14591318);
            uLCD.pixel(103, 106, 16038251);
            uLCD.pixel(104, 106, 16038253);
            uLCD.pixel(105, 106, 16498804);
            uLCD.pixel(106, 106, 16564597);
            uLCD.pixel(107, 106, 16433011);
            uLCD.pixel(108, 106, 15445862);
            uLCD.pixel(109, 106, 14985312);
            uLCD.pixel(110, 106, 14722399);
            uLCD.pixel(111, 106, 14788192);
            uLCD.pixel(112, 106, 14064984);
            uLCD.pixel(113, 106, 14393949);
            uLCD.pixel(114, 106, 14723430);
            uLCD.pixel(115, 106, 15117674);
            uLCD.pixel(116, 106, 14985573);
            uLCD.pixel(117, 106, 15050853);
            uLCD.pixel(118, 106, 15050853);
            uLCD.pixel(119, 106, 15116646);
            uLCD.pixel(120, 106, 15116646);
            uLCD.pixel(121, 106, 15182439);
            uLCD.pixel(122, 106, 15182439);
            uLCD.pixel(123, 106, 15182439);
            uLCD.pixel(124, 106, 15182439);
            uLCD.pixel(125, 106, 15182439);
            uLCD.pixel(126, 106, 15182441);
            uLCD.pixel(127, 106, 15182439);
            uLCD.pixel(89, 107, 2954496);
            uLCD.pixel(90, 107, 9203274);
            uLCD.pixel(91, 107, 15912606);
            uLCD.pixel(92, 107, 15582342);
            uLCD.pixel(93, 107, 16040830);
            uLCD.pixel(94, 107, 16170611);
            uLCD.pixel(95, 107, 14787668);
            uLCD.pixel(96, 107, 15641694);
            uLCD.pixel(97, 107, 16760435);
            uLCD.pixel(98, 107, 16761209);
            uLCD.pixel(99, 107, 16562285);
            uLCD.pixel(100, 107, 16366699);
            uLCD.pixel(101, 107, 13933128);
            uLCD.pixel(102, 107, 13867335);
            uLCD.pixel(103, 107, 14459217);
            uLCD.pixel(104, 107, 14920283);
            uLCD.pixel(105, 107, 15249250);
            uLCD.pixel(106, 107, 14525273);
            uLCD.pixel(107, 107, 14591580);
            uLCD.pixel(108, 107, 14592096);
            uLCD.pixel(109, 107, 14131806);
            uLCD.pixel(110, 107, 14000736);
            uLCD.pixel(111, 107, 13935457);
            uLCD.pixel(112, 107, 13804130);
            uLCD.pixel(113, 107, 13344349);
            uLCD.pixel(114, 107, 13475681);
            uLCD.pixel(115, 107, 13738853);
            uLCD.pixel(116, 107, 13803106);
            uLCD.pixel(117, 107, 13934178);
            uLCD.pixel(118, 107, 13999971);
            uLCD.pixel(119, 107, 13999971);
            uLCD.pixel(120, 107, 14065764);
            uLCD.pixel(121, 107, 14065764);
            uLCD.pixel(122, 107, 14131557);
            uLCD.pixel(123, 107, 14131557);
            uLCD.pixel(124, 107, 13934178);
            uLCD.pixel(125, 107, 13934178);
            uLCD.pixel(126, 107, 13934178);
            uLCD.pixel(127, 107, 13934178);
            uLCD.pixel(88, 108, 4929302);
            uLCD.pixel(89, 108, 10980449);
            uLCD.pixel(90, 108, 16177057);
            uLCD.pixel(91, 108, 15123078);
            uLCD.pixel(92, 108, 15515779);
            uLCD.pixel(93, 108, 15054197);
            uLCD.pixel(94, 108, 14198115);
            uLCD.pixel(95, 108, 13670742);
            uLCD.pixel(96, 108, 13209160);
            uLCD.pixel(97, 108, 15709034);
            uLCD.pixel(98, 108, 16761721);
            uLCD.pixel(99, 108, 16169321);
            uLCD.pixel(100, 108, 14590803);
            uLCD.pixel(101, 108, 14525523);
            uLCD.pixel(102, 108, 14525525);
            uLCD.pixel(103, 108, 14459734);
            uLCD.pixel(104, 108, 14262615);
            uLCD.pixel(105, 108, 14131545);
            uLCD.pixel(106, 108, 14131806);
            uLCD.pixel(107, 108, 14066530);
            uLCD.pixel(108, 108, 14067304);
            uLCD.pixel(109, 108, 13607527);
            uLCD.pixel(110, 108, 13476459);
            uLCD.pixel(111, 108, 13740659);
            uLCD.pixel(112, 108, 14004860);
            uLCD.pixel(113, 108, 14005375);
            uLCD.pixel(114, 108, 13808255);
            uLCD.pixel(115, 108, 13807998);
            uLCD.pixel(116, 108, 13740154);
            uLCD.pixel(117, 108, 13937020);
            uLCD.pixel(118, 108, 14002813);
            uLCD.pixel(119, 108, 13937020);
            uLCD.pixel(120, 108, 13739641);
            uLCD.pixel(121, 108, 13608055);
            uLCD.pixel(122, 108, 13739641);
            uLCD.pixel(123, 108, 13937020);
            uLCD.pixel(124, 108, 13739641);
            uLCD.pixel(125, 108, 14068606);
            uLCD.pixel(126, 108, 14397571);
            uLCD.pixel(127, 108, 14397571);
            uLCD.pixel(87, 109, 6441771);
            uLCD.pixel(88, 109, 14664342);
            uLCD.pixel(89, 109, 14400132);
            uLCD.pixel(90, 109, 13543276);
            uLCD.pixel(91, 109, 14857849);
            uLCD.pixel(92, 109, 15252092);
            uLCD.pixel(93, 109, 13803619);
            uLCD.pixel(94, 109, 13145176);
            uLCD.pixel(95, 109, 14066532);
            uLCD.pixel(96, 109, 14197088);
            uLCD.pixel(97, 109, 15381612);
            uLCD.pixel(98, 109, 15841644);
            uLCD.pixel(99, 109, 15446886);
            uLCD.pixel(100, 109, 14328922);
            uLCD.pixel(101, 109, 14131545);
            uLCD.pixel(102, 109, 13933914);
            uLCD.pixel(103, 109, 13934429);
            uLCD.pixel(104, 109, 14000739);
            uLCD.pixel(105, 109, 14001000);
            uLCD.pixel(106, 109, 13672809);
            uLCD.pixel(107, 109, 13279084);
            uLCD.pixel(108, 109, 14200959);
            uLCD.pixel(109, 109, 13938563);
            uLCD.pixel(110, 109, 13215871);
            uLCD.pixel(111, 109, 11637868);
            uLCD.pixel(112, 109, 9467473);
            uLCD.pixel(113, 109, 7494711);
            uLCD.pixel(114, 109, 6508330);
            uLCD.pixel(115, 109, 6573355);
            uLCD.pixel(116, 109, 7822911);
            uLCD.pixel(117, 109, 7164468);
            uLCD.pixel(118, 109, 6045987);
            uLCD.pixel(119, 109, 4795920);
            uLCD.pixel(120, 109, 4006404);
            uLCD.pixel(121, 109, 3940611);
            uLCD.pixel(122, 109, 4401162);
            uLCD.pixel(123, 109, 4927506);
            uLCD.pixel(124, 109, 6638124);
            uLCD.pixel(125, 109, 7427894);
            uLCD.pixel(126, 109, 8480328);
            uLCD.pixel(127, 109, 9204305);
            uLCD.pixel(85, 110, 4336396);
            uLCD.pixel(86, 110, 11309161);
            uLCD.pixel(87, 110, 16373674);
            uLCD.pixel(88, 110, 16635040);
            uLCD.pixel(89, 110, 14330739);
            uLCD.pixel(90, 110, 13540449);
            uLCD.pixel(91, 110, 13868899);
            uLCD.pixel(92, 110, 13604959);
            uLCD.pixel(93, 110, 13539166);
            uLCD.pixel(94, 110, 14526831);
            uLCD.pixel(95, 110, 16434826);
            uLCD.pixel(96, 110, 15974527);
            uLCD.pixel(97, 110, 15711606);
            uLCD.pixel(98, 110, 14659170);
            uLCD.pixel(99, 110, 13869400);
            uLCD.pixel(100, 110, 13869671);
            uLCD.pixel(101, 110, 13541225);
            uLCD.pixel(102, 110, 13540973);
            uLCD.pixel(103, 110, 13936245);
            uLCD.pixel(104, 110, 14397060);
            uLCD.pixel(105, 110, 14397320);
            uLCD.pixel(106, 110, 13608835);
            uLCD.pixel(107, 110, 12754558);
            uLCD.pixel(108, 110, 9597012);
            uLCD.pixel(109, 110, 6571566);
            uLCD.pixel(110, 110, 3085824);
            uLCD.pixel(83, 111, 5325860);
            uLCD.pixel(84, 111, 11836787);
            uLCD.pixel(85, 111, 13413758);
            uLCD.pixel(86, 111, 15123086);
            uLCD.pixel(87, 111, 15055493);
            uLCD.pixel(88, 111, 13342817);
            uLCD.pixel(89, 111, 15446906);
            uLCD.pixel(90, 111, 14590312);
            uLCD.pixel(91, 111, 13208659);
            uLCD.pixel(92, 111, 15051376);
            uLCD.pixel(93, 111, 14986612);
            uLCD.pixel(94, 111, 15448446);
            uLCD.pixel(95, 111, 16172426);
            uLCD.pixel(96, 111, 14330992);
            uLCD.pixel(97, 111, 13475681);
            uLCD.pixel(98, 111, 13278556);
            uLCD.pixel(99, 111, 13739883);
            uLCD.pixel(100, 111, 14530442);
            uLCD.pixel(101, 111, 14004106);
            uLCD.pixel(102, 111, 13215105);
            uLCD.pixel(103, 111, 12425593);
            uLCD.pixel(104, 111, 10978408);
            uLCD.pixel(105, 111, 8413257);
            uLCD.pixel(106, 111, 5518625);
            uLCD.pixel(107, 111, 3282694);
            uLCD.pixel(82, 112, 11641737);
            uLCD.pixel(83, 112, 15259312);
            uLCD.pixel(84, 112, 14796431);
            uLCD.pixel(85, 112, 14267767);
            uLCD.pixel(86, 112, 15318145);
            uLCD.pixel(87, 112, 15250555);
            uLCD.pixel(88, 112, 13537626);
            uLCD.pixel(89, 112, 13668185);
            uLCD.pixel(90, 112, 14062428);
            uLCD.pixel(91, 112, 15510387);
            uLCD.pixel(92, 112, 16630408);
            uLCD.pixel(93, 112, 14855794);
            uLCD.pixel(94, 112, 12817753);
            uLCD.pixel(95, 112, 12950369);
            uLCD.pixel(96, 112, 13674612);
            uLCD.pixel(97, 112, 14530438);
            uLCD.pixel(98, 112, 12688236);
            uLCD.pixel(99, 112, 10123600);
            uLCD.pixel(100, 112, 7427641);
            uLCD.pixel(101, 112, 5915693);
            uLCD.pixel(102, 112, 4139284);
            uLCD.pixel(103, 112, 2691584);
            uLCD.pixel(81, 113, 8220251);
            uLCD.pixel(82, 113, 14733748);
            uLCD.pixel(83, 113, 13087884);
            uLCD.pixel(84, 113, 13480319);
            uLCD.pixel(85, 113, 14201724);
            uLCD.pixel(86, 113, 13212773);
            uLCD.pixel(87, 113, 11237182);
            uLCD.pixel(88, 113, 14721900);
            uLCD.pixel(89, 113, 15641973);
            uLCD.pixel(90, 113, 15970936);
            uLCD.pixel(91, 113, 16695688);
            uLCD.pixel(92, 113, 14724211);
            uLCD.pixel(93, 113, 14002289);
            uLCD.pixel(94, 113, 13675129);
            uLCD.pixel(95, 113, 13742726);
            uLCD.pixel(96, 113, 9993303);
            uLCD.pixel(97, 113, 5124885);
            uLCD.pixel(81, 114, 8812127);
            uLCD.pixel(82, 114, 14074787);
            uLCD.pixel(83, 114, 13153425);
            uLCD.pixel(84, 114, 12560008);
            uLCD.pixel(85, 114, 7360818);
            uLCD.pixel(86, 114, 8938297);
            uLCD.pixel(87, 114, 14792323);
            uLCD.pixel(88, 114, 16303755);
            uLCD.pixel(89, 114, 15185011);
            uLCD.pixel(90, 114, 15448183);
            uLCD.pixel(91, 114, 14067050);
            uLCD.pixel(92, 114, 13411441);
            uLCD.pixel(93, 114, 13545095);
            uLCD.pixel(94, 114, 9928547);
            uLCD.pixel(95, 114, 4403744);
            uLCD.pixel(81, 115, 2628362);
            uLCD.pixel(82, 115, 8483673);
            uLCD.pixel(83, 115, 5259303);
            uLCD.pixel(86, 115, 6375214);
            uLCD.pixel(87, 115, 16111539);
            uLCD.pixel(88, 115, 14597775);
            uLCD.pixel(89, 115, 13807226);
            uLCD.pixel(90, 115, 12360552);
            uLCD.pixel(91, 115, 10387281);
            uLCD.pixel(92, 115, 7823163);
            uLCD.pixel(93, 115, 4271895);
            uLCD.pixel(86, 116, 2497812);
            uLCD.pixel(87, 116, 6181960);
            uLCD.pixel(88, 116, 7102544);
            uLCD.pixel(89, 116, 4339493);
        }
};