#include "mbed.h"
#include "DS_3231.h"
#include "BlockDevice.h"
#include "FATFileSystem.h"


DS_3231 horloge(I2C_SDA,I2C_SCL);
DigitalOut Led_rouge(LED1,1);
DigitalOut Led_verte(LED2,1);
DigitalOut Led_bleue(LED3,1);
DigitalOut Cmd_GPS(PTB9,0);
static UnbufferedSerial serial_port(PTD3, PTD2); // liaison avec le GPS
char Rx_buffer[100];
char trame[100];
char trame_cpy[100];
volatile bool flag_ISR_read=0;
volatile int index=0;
/**************************************************************/
/*         Déclaration des Sous fonctions                                     */
/**************************************************************/
void ISR_read(); // lecture liaison serie
uint8_t gencrc2(uint8_t *data); // calcul crc NMEA
/**************************************************************/
/*         Programme Principal                                   */
/**************************************************************/

int main(void)
{
    printf("lancement programme\n");
    Led_rouge=1;
    Led_verte=1;
    Led_bleue=1;
    // Montage de la carte (Led Rouge temoin)
    Led_rouge=0;
    thread_sleep_for (1000);
    // Montage du systeme de fichier
    BlockDevice *bd = BlockDevice::get_default_instance();
    FATFileSystem fs("fs");
    printf("Montage de la carte SD ... : ");
    int err = fs.mount(bd);
    if (err!=0) printf("ERREUR !!! \n"); // Message d'erreur
    else {
        printf("OK \n");
        Led_rouge=1;
    }

    // Initialisation de l'horloge (Led verte)
    // initialisation variables horloge
    Led_verte=0;
    printf("Initialisation de l'horloge HTR a 0h0min0s \n");
    thread_sleep_for (1000);
    uint32_t secondes;
    uint32_t minutes;
    uint32_t heures;
    uint16_t test;
    DS_3231_time_t time = {0,0,0,0,0}; //secondes minutes heures mode 24h
    DS_3231_alrm_t alarm = {3,0,0,1,1,1,1,1,1,0,0,0}; // generation d'une alarme dans 3 secondes
    test = horloge.set_time(time);
    if(test==0) printf ("ecriture OK\n");
    else printf ("error\n");
    test = horloge.set_alarm(alarm,1);
    thread_sleep_for (4000);
    Led_verte=1; // automaintien actif
    
    // on charge la nouvelle alarme
    Led_bleue=0; // voyant led bleue pour alarme
    horloge.get_time(&time); // lecture heure courante sur htr
    printf ("Programme Lance a %d : %d : %d \n",time.hours,time.minutes,time.seconds);
    secondes=time.seconds;
    minutes=time.minutes+4;
    heures=time.hours;
    if (secondes>60)
    {
    secondes = secondes-60;
    minutes=minutes+1; // calcul temps alarme prochain
    if (minutes >59) {
        minutes=minutes-60;
        heures = heures+1;
        if (heures>23) heures=0;
    }//fin minutes
    }//fin secondes
    alarm.seconds=secondes;
    alarm.minutes=minutes;
    alarm.hours=heures;
    alarm.am1=0; // on declenche ici une alarme à l'heure reglee
    alarm.am2=0;
    alarm.am3=0;
    alarm.am4=1;
    test = horloge.set_alarm(alarm, 1);
    thread_sleep_for (1000);  // la led bleue signale la programmation de la prochaine alarme
    Led_bleue=1;
    /*
    // on coupe l'alarme alim repart a l'alerme programmee
    DS_3231_cntl_stat_t data = {0x07, 0x88}; // configuration restres etat et controle
    horloge.set_cntl_stat_reg(data);
    */

    // initialisation des variables du GPS
    static char type[20];
    static char horaire[20];
    static char alerte[3];
    static char lattitude[20];
    static char hemisphere[2];
    static char longitude[20];
    static char dir[2];
    static char vitesse[20];
    static char cap[20];
    static char date[20];
    static char magn[20];
    static char crc[10];
    static char qualif[10];
    static char nb_satellites[10];
    static char DOP[10];
    static char altitude[10];
    static char altitude_cor[10];
    const char * separators = ",";
    char i;
    size_t len;
    uint8_t val_crc;
    // Initialisation liaison serie GPS (9600-8-N-1).
    serial_port.baud(9600);
    serial_port.format(8,BufferedSerial::None,1);


    // on utilise le GPS
    Cmd_GPS=1;
    printf ("Allumage GPS \n");
    serial_port.attach(&ISR_read,SerialBase::RxIrq);

    while(true) {
        if (flag_ISR_read==1) {
            printf("%s",trame); // ligne de test gps
            char* token = strtok(trame,"*"); //on met dans trame cpy la trame sans crc
            strcpy(trame_cpy,token);
            token = strtok(NULL,"*");   // on copie le crc
            strcpy(crc,token);
            val_crc=gencrc2((uint8_t *)trame_cpy);  //calcul du crc sur la trame
            uint8_t val_crc2;
            sscanf(crc,"%x",&val_crc2);
            if (val_crc!=val_crc2) {//printf ("crc error\n");
            } else {
                //printf ("crc OK\n");
                char* token = strtok((char*)trame_cpy,separators);
                strcpy(type,token);
                if (strcmp(type,"$GPRMC")==0) { // traitement d'une trame RMC
                    token = strtok(NULL,separators);
                    strcpy(horaire,token);
                    token = strtok(NULL,separators);
                    strcpy(alerte,token);
                    token = strtok(NULL,separators);
                    strcpy(lattitude,token);
                    token = strtok(NULL,separators);
                    strcpy(hemisphere,token);
                    token = strtok(NULL,separators);
                    strcpy(longitude,token);
                    token = strtok(NULL,separators);
                    strcpy(dir,token);
                    token = strtok(NULL,separators);
                    strcpy(vitesse,token);
                    token = strtok(NULL,separators);
                    strcpy(cap,token);
                    token = strtok(NULL,separators);
                    strcpy(date,token);
                    token = strtok(NULL,separators);
                    strcpy(magn,token);
                    //printf ("%s : %s : %s : %s \n",date,horaire,lattitude, longitude);
                } // fin compare chaines RMC
                if (strcmp(type,"$GPGGA")==0) { // traitement d'une trame GGA
                    token = strtok(NULL,separators);
                    strcpy(horaire,token);
                    token = strtok(NULL,separators);
                    strcpy(lattitude,token);
                    token = strtok(NULL,separators);
                    strcpy(hemisphere,token);
                    token = strtok(NULL,separators);
                    strcpy(longitude,token);
                    token = strtok(NULL,separators);
                    strcpy(dir,token);
                    token = strtok(NULL,separators);
                    strcpy(qualif,token);
                    token = strtok(NULL,separators);
                    strcpy(nb_satellites,token);
                    token = strtok(NULL,separators);
                    strcpy(DOP,token);
                    token = strtok(NULL,separators);
                    strcpy(altitude,token);
                    token = strtok(NULL,separators);
                    strcpy(altitude_cor,token);
                    token = strtok(NULL,separators);
                    token = strtok(NULL,separators);
                    int n=atoi(nb_satellites); // calcul du nombre de satellites
                    if (n>4&&(strcmp(date,"")!=0)) { // si precision correcte on envoie la trame et on éteint le GPS
                        // enregistrement des donnees GPS dans la carte SD
                        Led_rouge=0;
                        thread_sleep_for (1000);
                        printf("Opening \"/fs/test1.txt\"... : ");
                        FILE *fichier = fopen("/fs/tracker.txt", "a");
                        if (fichier==NULL) printf("ERREUR !!! \n"); // Message d'erreur
                        else {
                            printf(" OK \n");
                            fprintf (fichier,"%s : %s : %s : %s : %s\n : %s \n ",date,horaire,lattitude, longitude,altitude,nb_satellites);
                            fclose(fichier); // Fermeture du fichier test1.txt
                            Cmd_GPS=0; // on eteintle GPS lors d'une lecture correcte
                            Led_rouge=1;
                            // on coupe l'alarme alim repart a l'alerme programmee
                            DS_3231_cntl_stat_t data = {0x07, 0x88}; // configuration restres etat et controle
                            horloge.set_cntl_stat_reg(data);
                        }// fin else
                    }// fin n>4
                } // fin compare chaines GGA
            } //fin traitement chaine sans erreur de crc
            flag_ISR_read=0; // raz ISR
        } //fin if (flag_ISR_read==1)
    }// fin while true
}// fin programme principal

/******* Sous fonctions ***************/
void ISR_read()   // lecture liaison serie
{
    char carac;
    serial_port.read(&carac, 1);
    if (index==100 || carac=='$') index=0;
    Rx_buffer[index]=carac;
    index++;
    if (carac==0x0a) {
        Rx_buffer[index]=0;
        for (char i=0; i<index+1; i++) trame[i] = Rx_buffer[i];
        index=0;
        flag_ISR_read=1;
    }
}

uint8_t gencrc(uint8_t *data, size_t len)   // calcul crc NMEA
{
    uint8_t crc;
    crc=data[0];
    for (char i = 1; i < len; i++) {
        crc = crc^data[i];
    }
    return crc;
}

uint8_t gencrc2(uint8_t *data)   // calcul crc NMEA
{
    uint8_t crc;
    crc=data[1];
    char i=2;
    while (data[i]!=0) {
        crc = crc^data[i];
        i++;
    }
    return crc;
}