#include "mbed.h"
#include "FATFileSystem.h"
#include <string.h>
static UnbufferedSerial serial_port(PTC17, PTC16);
// Maximum number of element the application buffer can contain
DigitalOut LedR(LED1,1);
DigitalOut Cmd_GPS(D5,0);
InterruptIn IT_GPS(D4);
Ticker timer_GPS;
char Rx_buffer[100];
char trame[100];
char trame_cpy[100];
volatile bool flag_ISR_read=0;
volatile int index=0;
/**************************************************************/
/*         Déclaration des Sous fonctions                                     */
/**************************************************************/
void ISR_read(); // lecture liaison serie
uint8_t gencrc2(uint8_t *data); // calcul crc NMEA
void IT_Power_GPS(void); // IT liee au BP marche GPS
void IT_Timer_GPS(void); 
/**************************************************/
/************** Programme principal ***************/
/**************************************************/
int main()
{
    static char type[20];
    static char horaire[20];
    static char alerte[3];
    static char lattitude[20];
    static char hemisphere[2];
    static char longitude[20];
    static char dir[2];
    static char vitesse[20];
    static char cap[20];
    static char date[20];
    static char magn[20];
    static char crc[10];
    static char qualif[10];
    static char nb_satellites[10];
    static char DOP[10];
    static char altitude[10];
    static char altitude_cor[10];
    const char * separators = ",";
    char i;
    size_t len;
    uint8_t val_crc;
// Set desired properties (9600-8-N-1).
    serial_port.baud(9600);
    serial_port.format(8,BufferedSerial::None,1);
    serial_port.attach(&ISR_read,SerialBase::RxIrq);
// Interruption liee au BP cmd_GPS
    IT_GPS.rise(IT_Power_GPS);
    // Interruption liee au timer timer_GPS
timer_GPS.attach(IT_Timer_GPS,120);
    printf("lancement\n");
    while(true) {
        if (flag_ISR_read==1) {
            LedR=0;
            char* token = strtok(trame,"*"); //on met dans trame cpy la trame sans crc
            strcpy(trame_cpy,token);
            token = strtok(NULL,"*");   // on copie le crc
            strcpy(crc,token);
            val_crc=gencrc2((uint8_t *)trame_cpy);  //calcul du crc sur la trame
            uint8_t val_crc2;
            sscanf(crc,"%x",&val_crc2);
            if (val_crc!=val_crc2) {//printf ("crc error\n");
            }
                else {
                    printf ("crc OK\n");
                    char* token = strtok((char*)trame_cpy,separators);
                    strcpy(type,token);
                    if (strcmp(type,"$GPRMC")==0) { // traitement d'une trame RMC
                        token = strtok(NULL,separators);
                        strcpy(horaire,token);
                        token = strtok(NULL,separators);
                        strcpy(alerte,token);
                        token = strtok(NULL,separators);
                        strcpy(lattitude,token);
                        token = strtok(NULL,separators);
                        strcpy(hemisphere,token);
                        token = strtok(NULL,separators);
                        strcpy(longitude,token);
                        token = strtok(NULL,separators);
                        strcpy(dir,token);
                        token = strtok(NULL,separators);
                        strcpy(vitesse,token);
                        token = strtok(NULL,separators);
                        strcpy(cap,token);
                        token = strtok(NULL,separators);
                        strcpy(date,token);
                        token = strtok(NULL,separators);
                        strcpy(magn,token);
                        //printf ("%s : %s : %s : %s \n",date,horaire,lattitude, longitude);
                        LedR=1;
                    } // fin compare chaines RMC
                    if (strcmp(type,"$GPGGA")==0) { // traitement d'une trame GGA
                    printf("trame : %s\n",trame);
                        /*token = strtok(NULL,separators);
                        strcpy(horaire,token);
                        token = strtok(NULL,separators);
                        strcpy(lattitude,token);
                        token = strtok(NULL,separators);
                        strcpy(hemisphere,token);
                        token = strtok(NULL,separators);
                        strcpy(longitude,token);
                        token = strtok(NULL,separators);
                        strcpy(dir,token);
                        token = strtok(NULL,separators);
                        strcpy(qualif,token);
                        token = strtok(NULL,separators);
                        strcpy(nb_satellites,token);
                        token = strtok(NULL,separators);
                        strcpy(DOP,token);
                        token = strtok(NULL,separators);
                        strcpy(altitude,token);
                        token = strtok(NULL,separators);
                        strcpy(altitude_cor,token);
                        token = strtok(NULL,separators);
                        token = strtok(NULL,separators);
                        int n=atoi(nb_satellites); // calcul du nombre de satellites
                        if (n>4&&(strcmp(date,"")!=0)) { // si precision correcte on envoie la trame et on éteint le GPS
                            printf ("%s : %s : %s : %s : %s\n : %s ou %d satellites\n ",date,horaire,lattitude, longitude,altitude,nb_satellites,n);
                            Cmd_GPS=0; // on eteintle GPS lors d'une lecture correcte
                            LedR=1;
                            }*/
                        } // fin compare chaines GGA
                    } //fin traitement chaine sans erreur de crc
                    flag_ISR_read=0; // raz ISR
                } //fin if (flag_ISR_read==1)
            }// fin while true
        } // fin prog


        void ISR_read() { // lecture liaison serie
            char carac;
            serial_port.read(&carac, 1);
            if (index==99 || carac=='$') index=0;
            Rx_buffer[index]=carac;
            index++;
            if (carac==0x0a) {
                Rx_buffer[index]=0; // 0 est le caractère de fin de chaine
                for (char i=0; i<index+1; i++) trame[i] = Rx_buffer[i];
                index=0;
                flag_ISR_read=1;
            }
        }

        uint8_t gencrc(uint8_t *data, size_t len) { // calcul crc NMEA
            uint8_t crc;
            crc=data[0];
            for (char i = 1; i < len; i++) {
                crc = crc^data[i];
            }
            return crc;
        }

        uint8_t gencrc2(uint8_t *data) { // calcul crc NMEA
            uint8_t crc;
            crc=data[1];
            char i=2;
            while (data[i]!=0) {
                crc = crc^data[i];
                i++;
            }
            return crc;
        }

        void IT_Timer_GPS(void) {
            Cmd_GPS=1; // on allume le GPS lors d'une IT temporelle
        }
        
                void IT_Power_GPS(void) {
            Cmd_GPS=1; // on allume le GPS lors d'un front montant sur IT_GPS
        }