#ifndef AFFICHEUR_H
#define AFFICHEUR_H

#include "mbed.h"

typedef enum {
    ERROR_KIM               = 0x00,     //!< Error returned by KIM
    OK_KIM                  = 0x01,     //!< OK return by KIM
    UNKNOWN_ERROR_KIM       = 0x02,     //!< Something unknown returned by KIM
    TIMEOUT_KIM             = 0x04      //!< Timeout, nothing returned by KIM
} RetStatusKIMTypeDef;

//This syntaxe is used to be compatible with old versions of gcc
const char AT_ID[] = "AT+ID=";
const char AT_SN[]= "AT+SN=";
const char AT_SW[]= "AT+SW=";
const char AT_PWR[]= "AT+PWR=";
const char AT_BAND[]= "AT+BAND=";
const char AT_FRQ[] = "AT+FRQ=";
const char AT_FW[]   = "AT+FW=";
const char AT_TCXOWU[]="AT+TCXOWU=";
const char AT_TX[] = "AT+TX=";
const char AT_REQUEST[]= {'?','\r','\0'};

class Emetteur
{
public :
    Emetteur (); //constructeur 1 (USB 9600,8,N,1 par defaut)
    /** @defgroup getGroup Get functions
     *  "Get functions" are used to read the KIM1 module configuration with AT
     *  Commands.
     *  All these functions have the same construction.
     *  An AT command is sent through the soft serial port to ask the chosen
     *  parameter. The answer is returned.
     *
     *
     *      get_ID();       To get the ID value
     *      return "+ID:28,7AC8998"
     *      get_PWR();      To get the transmition power value
     *      return "+PWR:750"
     *
     */
    char* get_ID(); // get ID of the module
    char* get_SN(); // get Serial Number
    char* get_FW(); // get firmware version
    char* get_PWR(); // get the transmit power of the module
    char* get_BAND(); // get the transmit band frequency of the module
    char* get_FRQ(); // get frequency offset of the module
    char* get_TCXOWU(); // get the TCXO Warm Up Time of the module (seconds)
    bool set_sleepMode(bool mode);
    /** @defgroup setGroup Set functions
     *  "Set functions" are used to configure the KIM1 module with AT Commands.
     *  All these functions have the same construction.
     *  An AT command is sent through the soft serial port to set a value to the
     *  chosen parameter. RetStatusKIMTypeDef is returned, see RetStatusKIMTypeDef
     *  details.
     *
     *
     *      set_BAND("B1", 2);      To set the frequency band on B1
     *      set_PWR("1000", 4);     To transmit at 1000 mW
     *      set_PWR("750", 3);      To transmit at 750 mW
     *  @{
     */
 //   RetStatusKIMTypeDef set_ID(char ID[], uint8_t len);
 //   RetStatusKIMTypeDef set_SN(char SN[], uint8_t len);
    RetStatusKIMTypeDef set_PWR(char PWR[], uint8_t len);
    RetStatusKIMTypeDef set_BAND(char BAND[], uint8_t len = 2);
    RetStatusKIMTypeDef set_FRQ(char FRQ[], uint8_t len);
 //   RetStatusKIMTypeDef set_TCXOWU(char TCXOWU[], uint8_t len);

    RetStatusKIMTypeDef send_data(char data[], uint8_t len); // envoyer un message
private:
    Serial kimSerial;
    DigitalOut power;
    char response[20];
    char command[70];
    RetStatusKIMTypeDef send_ATCommand();
};
#endif
