#include "emetteur.h"

Emetteur::Emetteur():kimSerial(PTC17,PTC16,4800),power(D4)
{
}

char* Emetteur::get_ID()
{
    for(uint8_t i=0; i<6; i++)command[i] = AT_ID[i];
    for(uint8_t i=0; i<3; i++)command[6+i] = AT_REQUEST[i];
    send_ATCommand();
    return response;
}


char* Emetteur::get_SN()
{
    for(uint8_t i=0; i<6; i++)command[i] = AT_SN[i];
    for(uint8_t i=0; i<3; i++)command[6+i] = AT_REQUEST[i];
    send_ATCommand();
    return response;
}

char* Emetteur::get_FW()
{
    for(uint8_t i=0; i<6; i++)command[i] = AT_FW[i];
    for(uint8_t i=0; i<3; i++)command[6+i] = AT_REQUEST[i];
    send_ATCommand();
    return response;
}

char* Emetteur::get_PWR()
{
    for(uint8_t i=0; i<7; i++)command[i] = AT_PWR[i];
    for(uint8_t i=0; i<3; i++)command[7+i] = AT_REQUEST[i];
    send_ATCommand();
    return response;
}

char* Emetteur::get_BAND()
{
    for(uint8_t i=0; i<8; i++)command[i] = AT_BAND[i];
    for(uint8_t i=0; i<3; i++)command[8+i] = AT_REQUEST[i];
    send_ATCommand();
    return response;
}

char* Emetteur::get_FRQ()
{
    for(uint8_t i=0; i<7; i++)command[i] = AT_FRQ[i];
    for(uint8_t i=0; i<3; i++)command[7+i] = AT_REQUEST[i];
    send_ATCommand();
    return response;
}

char* Emetteur::get_TCXOWU()
{
    for(uint8_t i=0; i<10; i++)command[i] = AT_TCXOWU[i];
    for(uint8_t i=0; i<3; i++)command[10+i] = AT_REQUEST[i];
    send_ATCommand();
    return response;
}

RetStatusKIMTypeDef Emetteur::set_PWR(char* PWR, uint8_t len)
{
    for(uint8_t i=0; i<7; i++)command[i] = AT_PWR[i];
    for(uint8_t i=0; i<len; i++)command[7+i] = PWR[i];
    command[7+len] = '\r';
    command[8+len] = '\0';
    return (send_ATCommand());
}

RetStatusKIMTypeDef Emetteur::set_BAND(char* BAND, uint8_t len)
{
    for(uint8_t i=0; i<8; i++)command[i] = AT_BAND[i];
    for(uint8_t i=0; i<len; i++)command[8+i] = BAND[i];
    command[8+len] = '\r';
    command[9+len] = '\0';
    return (send_ATCommand());
}

RetStatusKIMTypeDef Emetteur::set_FRQ(char* FRQ, uint8_t len)
{
    for(uint8_t i=0; i<7; i++)command[i] = AT_FRQ[i];
    for(uint8_t i=0; i<len; i++)command[7+i] = FRQ[i];
    command[7+len] = '\r';
    command[8+len] = '\0';
    return (send_ATCommand());
}

bool Emetteur::set_sleepMode(bool mode)
{
   if (mode==false) { // mise en mode sleep du module
       /* while (kimSerial.readable()>0) { //Clean RX buffer
            response[0] = kimSerial.getc();
            //pc.printf("caractere lu : %x \n",response[0]);
            wait(0.1);
        } // fin while */
        response[0] = '\0';
        power=1; // activation du module
        for(int i=0; i<2; i++) {
                //Clean RX buffer car envoie SN number a la mise sous tension
                response[i] = kimSerial.getc();
                //pc.printf("caractere lu : %x \n",response[0]);
                wait(0.1);
            } // fin for
            if (response[0] !=0) 
            {return (true);
            }
            else 
            {return (false);
            }
        }// fin if mode
        else {
            power=0; // mise en mode sleep du module
            return(true);
        } // fin else mode
    } // fin fonction


// -------------------------------------------------------------------------- //
//! Send data to satellites
// -------------------------------------------------------------------------- //

RetStatusKIMTypeDef Emetteur::send_data(char *data, uint8_t len)
{
    for(uint8_t i=0; i<6; i++)
        command[i] = AT_TX[i];

    for(uint8_t i=0; i<len; i++)
        command[6+i] = data[i];

    command[6+len] = '\r';
    command[7+len] = '\0';

    return send_ATCommand();
}



RetStatusKIMTypeDef Emetteur::send_ATCommand()
{
    Serial pc(USBTX,USBRX);
    while (kimSerial.readable()>0) { //Clean RX buffer
        response[0] = kimSerial.getc();
        //pc.printf("caractere lu : %x \n",response[0]);
        wait(0.1);
    } // fin while
    response[0] = '\0';
    //pc.printf("\non a vide buffer\n");
    kimSerial.printf(command);
    char carac=0;
    char i=0;
    while ((carac!=0x0a)) {
        carac=kimSerial.getc();
        response[i]=carac;
        i++;
    }
    response[i]=0;
    pc.printf("reponse KIM : %x \n",response);
    if((response[0] != '\0') && (
                response[1] == 'K'  /*OK*/  ||
                response[1] == 'I' /*+ID*/  ||
                response[1] == 'S' /*+SN*/  ||
                response[1] == 'F' /*+FW*/  ||
                response[1] == 'B' /*+BAND*/||
                response[1] == 'F' /*+FRQ*/ ||
                response[1] == 'P' /*+PWR*/)) {
        return OK_KIM;
    } else if (response[0] != '\0' && response[1] == 'R') {
        /*ERROR*/
        return ERROR_KIM;
    } else if (response[0] != '\0') {
        return UNKNOWN_ERROR_KIM;
    } // fin if else
    return (TIMEOUT_KIM);
}