/*
* WiiNunchuckReader. A program allowing the output of one or two
* Wii Nunchucks to be read via I2C and decoded for use, using the mbed 
* microcontroller and its associated libraries.
*
* Copyright (C) <2009> Petras Saduikis <petras@petras.co.uk>
*
* This file is part of WiiNunchuckReader.
*
* WiiNunchuckReader is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* WiiNunchuckReader is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with WiiNunchuckReader.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SNATCH59_I2CCONFIG_H
#define SNATCH59_I2CCONFIG_H

#include <mbed.h>

class I2CPort_A
{
public:
    static const PinName SDA;
    static const PinName SCL;
};

    
class I2CPort_B
{
public:
    static const PinName SDA;
    static const PinName SCL;
};

const PinName I2CPort_A::SDA = p9;
const PinName I2CPort_A::SCL = p10;

const PinName I2CPort_B::SDA = p28;
const PinName I2CPort_B::SCL = p27;

#endif