/*
* WiiNunchuckReader. A program allowing the output of one or two
* Wii Nunchucks to be read via I2C and decoded for use, using the mbed 
* microcontroller and its associated libraries.
*
* Copyright (C) <2009> Petras Saduikis <petras@petras.co.uk>
*
* This file is part of WiiNunchuckReader.
*
* WiiNunchuckReader is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* WiiNunchuckReader is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with WiiNunchuckReader.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "I2CConfig.h"
#include "WiiNunchuckReader.h"

#define LOOP_DELAY    1    // seconds

// global declarations
Serial serial(USBTX, USBRX);

void ReadAndReport(WiiNunchuckReader* const nchk, const char* const portname)
{
    int bufSize = 0;
    char* bufPtr = NULL;
    bool debug = true;

    nchk->RequestRead();
    serial.printf("%s: ", portname);
        
    if (debug)
    {
        bufSize = nchk->getBufferSize();
        bufPtr = nchk->getReadBuf();
        if (bufPtr != NULL)
        {
            for (int i = 0; i < bufSize; i++)
            {
                serial.printf("%x ", bufPtr[i]);
            }
            serial.printf("\r\n");
        }
    }
        
    serial.printf("%d\t", nchk->getButtonZ());
    serial.printf("%d\t", nchk->getButtonC());
    serial.printf("%d\t", nchk->getAccelX());
    serial.printf("%d\t", nchk->getAccelY());
    serial.printf("%d\t", nchk->getAccelZ());
    serial.printf("%d\t", nchk->getJoyX());
    serial.printf("%d\r\n", nchk->getJoyY());
    serial.printf("\r\n");
}

int main() 
{
    WiiNunchuckReader nchkA(I2CPort_A::SDA, I2CPort_A::SCL);
    WiiNunchuckReader nchkB(I2CPort_B::SDA, I2CPort_B::SCL);
    
    while (true)
    {
        ReadAndReport(&nchkA, "PORT A");
        ReadAndReport(&nchkB, "PORT B");
                
        wait(LOOP_DELAY);
    }
    
    return EXIT_SUCCESS;
}
