/*
* FiniteStateMachine. Table driven Finite State Machine library 
* based on theHarel state machine, supporting actions on transitions, state
* entry and state exit.
*
* Copyright (C) <2009> Petras Saduikis <petras@petras.co.uk>
*
* This file is part of FiniteStateMachine.
*
* FiniteStateMachine is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* FiniteStateMachine is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DebugTrace.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SNATCH59_MYINTERRUPTHANDLER_H
#define SNATCH59_MYINTERRUPTHANDLER_H

// event names
enum clientEvent {intr1, intr2, tickr1};

class MyInterruptHandler
{
public:
    MyInterruptHandler();

    void processEvent(clientEvent eventId);
    
    // interrupt & timer handlers
    void intrhandler1();
    void intrhandler2();
    void tickerhandler1();

    // state or transition actions
    void ledSequence1();
    void ledSequence2();
    
private:
    InterruptIn interrupt1;
    InterruptIn interrupt2;
    Ticker ticker1;
};

#endif
