/*
* FiniteStateMachine. Table driven Finite State Machine library 
* based on theHarel state machine, supporting actions on transitions, state
* entry and state exit.
*
* Copyright (C) <2009> Petras Saduikis <petras@petras.co.uk>
*
* This file is part of FiniteStateMachine.
*
* FiniteStateMachine is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* FiniteStateMachine is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DebugTrace.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SNATCH59_STATETRANSITION_H
#define SNATCH59_STATETRANSITION_H

#include <mbed.h> 
#include "FSMDefs.h"

STATE_TEMPLATE_ class State;

#include "State.h"
 
STATE_TEMPLATE_
class StateTransition
{
    
public:
    StateTransition(int event_id, ActionPtrType action, STATE_* state_ptr, StateBehaviour behaviour);
    
    STATE_* match(const int event_id) const;
    void doAction(StateObjectType* &its_state_object) const;
    StateBehaviour getStateBehaviour() const;
    
private:
    int eventId;
    ActionPtrType action;
    STATE_* newState;
    StateBehaviour mode;
};

STATE_TEMPLATE_
inline STATE_* STATE_TRANSITION_::match(const int event_id) const
{
    if (eventId == event_id)    return newState;
    
    return NULL;
}

STATE_TEMPLATE_
inline StateBehaviour STATE_TRANSITION_::getStateBehaviour() const
{
    return mode;
}

STATE_TEMPLATE_
STATE_TRANSITION_::StateTransition(int event_id, ActionPtrType action_ptr, STATE_* state_ptr, StateBehaviour behaviour) : 
    eventId(event_id), action(action_ptr), newState(state_ptr), mode(behaviour)
{
}

STATE_TEMPLATE_
void STATE_TRANSITION_::doAction(StateObjectType* &its_state_object) const
{
    if (action != NULL)
    {
        (its_state_object->*action)( );
    }
}

#endif
