/*
* FiniteStateMachine. Table driven Finite State Machine library 
* based on theHarel state machine, supporting actions on transitions, state
* entry and state exit.
*
* Copyright (C) <2009> Petras Saduikis <petras@petras.co.uk>
*
* This file is part of FiniteStateMachine.
*
* FiniteStateMachine is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* FiniteStateMachine is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with DebugTrace.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SNATCH59_FSMDEFS_H
#define SNATCH59_FSMDEFS_H

#define FSM_TEMPLATE_        template<class StateObjectType, class ActionPtrType, int maxStates>
#define STATE_TEMPLATE_        template<class StateObjectType, class ActionPtrType>
#define TRANS_DEF_TEMPLATE_    template<class ActionPtrType>

#define FINITE_STATE_MACHINE_    FiniteStateMachine<StateObjectType, ActionPtrType, maxStates>
#define STATE_                    State<StateObjectType, ActionPtrType>
#define STATE_TRANSITION_        StateTransition<StateObjectType, ActionPtrType>
#define TRANSITION_DEFINITION_    TransitionDefinition<ActionPtrType>
#define STATE_DEFINITION_        StateDefinition<ActionPtrType>

enum StateBehaviour {actions, noactions};

#endif
