//////////////////////////////////////////////
// DebugTrace demo.
// The log file is written to /local/log.txt
// by default, max size 1024 bytes.
// When the log file is full, it is deleted
// and started again.
//////////////////////////////////////////////

#include "DebugTrace.h"
#include <mbed.h>

DebugTrace pc(ON, TO_SERIAL);
DebugTrace file(ON, TO_FILE);    // i.e. file(ON, TO_FILE, "log.txt", 1024)

int main() 
{
    int val = 122;
    float fval = 1.414;
    
    file.clear();        // remove any log file from last time
    
    while(true) 
    {
        pc.traceOut("Test message\r\n");
        pc.traceOut("%x \r\n", val);
        pc.traceOut("%d \r\n", val);
        pc.traceOut("%f \r\n", fval);
        
        file.traceOut("Test message\r\n");
        file.traceOut("%x \r\n", val);
        file.traceOut("%d \r\n", val);
        file.traceOut("%f \r\n", fval);
   
        wait(2);
    }
}
