/** ST7735 Pong by Jonne Valola, derived work from William Johnston's mbed Pong for NokiaLCD / PS2 keyboard
* This pong uses a rotary encoder hooked to pins 21 and 22,
* ST7735_TFT library by me, RotaryEncoder library by Shinichiro Nakamura
* All copyrights of respective owners. Use on your own risk and discretion.  
*/ 

#include "mbed.h"
#include "ball.h"
#include "paddle.h"
#include "ST7735_TFT.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "RotaryEncoder.h"

RotaryEncoder re(p21, p22, 0, 600, 300);

// State enumerator
typedef enum {
  RESET, RUN, PAUSE
} STATES;

ST7735_TFT lcd(p5, p6, p7, p8, p11, p15,"TFT"); // mosi, miso, sclk, cs, rs, reset

/* 
 * Subroutine drawScreen:
 * Description: Draws both paddles
 *  and the ball.
 */
void drawScreen(Paddle paddle1, Paddle paddle2, Ball theBall, bool isBlack) {
  paddle1.draw(lcd, isBlack);
  paddle2.draw(lcd ,isBlack);
  theBall.draw(lcd ,isBlack);
}

/* 
 * Subroutine drawScores:
 * Description: Draws the scoreboard
 */
void drawScores(Paddle paddle1, Paddle paddle2) {
  lcd.locate(60,1);
  lcd.printf("%d", paddle1.getScore());
  lcd.locate(90,1);
  lcd.printf("%d", paddle2.getScore());
  lcd.fillrect(79,0,81,128,0xFFFFFF);
}

int main() {
  lcd.background(0x000000);
  lcd.cls();
  lcd.set_orientation(1);
  lcd.set_font((unsigned char*) Arial12x12);  // select the font
  Paddle paddle1, paddle2;
  Ball theBall;
  int temp, count=0, oldY;
  drawScreen(paddle1, paddle2, theBall, false);
  drawScores(paddle1, paddle2);
  STATES state = RESET; // Initial state is RESET
  while(1) {  
    switch(state) {
      case RESET: // Reset objects, draw the screen, state = PAUSE
        lcd.cls();
        paddle1 = Paddle(0,40,5,25,0xFFFFFF,paddle1.getLives(),paddle1.getScore());
        paddle2 = Paddle(154,40,5,25,0xFFFFFF,paddle2.getLives(),paddle2.getScore());
        theBall = Ball(80,64,5,5,0xFFFF00,1,1);
        drawScreen(paddle1, paddle2, theBall, false);
        drawScores(paddle1, paddle2);
        oldY = re.getVal();
        state = RUN;
        break;
      case RUN: 
        if (oldY > re.getVal()) { // Executes if encoder turned
                if(paddle1.getY()>2)
                paddle1.move(lcd, -2);
        }
         if (oldY < re.getVal()) { // Executes if encoder turned
              if(paddle1.getY()+paddle1.getHeight()<128)
                paddle1.move(lcd, 2);
        }
        oldY = re.getVal();
       
        if(count%2) // Only let CPU move once every 2 times through the loop
          paddle2.moveCPU(lcd, theBall.getY());
        if(++count==5) { // Only move the ball once every 5 times through the loop
          count = 0;
          if(theBall.hitP1((paddle1.getX()+paddle1.getWidth()), paddle1.getY(), paddle1.getHeight()))
            theBall.reverseX();
          if(theBall.hitP2(paddle2.getX(), paddle2.getY(), paddle2.getHeight()))
            theBall.reverseX();
          if(theBall.hitX()) { // If the ball hits one of the sides of the screen
            if(theBall.getX()<7) { // If the ball hit paddle1's side
                paddle2.addPoint();              
            }
            else if(theBall.getX()>153) { // If the ball hit paddle2's side
                paddle1.addPoint();            
            }
            theBall.reverseX();
            state = RESET; // Reset the objects
          }
          if(theBall.hitY()) 
            theBall.reverseY();
          theBall.move(lcd);
        }
        break;
    }
    drawScreen(paddle1, paddle2, theBall, false);
    drawScores(paddle1, paddle2);
  }
}
