 #include "stdio.h"
 #include "stdlib.h"
 #include "math.h"
 #include "mbed.h"
 #include "ST7735_TFT.h"
 #include "string"
 #include "Arial12x12.h"
 #include "Arial24x23.h"
 #include "Arial28x28.h"

 #define NUMBER_OF_STARS 300
 #define SCREEN_WIDTH 128
 #define SCREEN_HEIGHT 160
 
 /*star struct*/
typedef struct 
{
  float xpos, ypos;
  short zpos, speed;
  unsigned int color;
} STAR;

static STAR stars[NUMBER_OF_STARS];


void init_star(STAR* star, int i)
{
  /* randomly init stars, generate them around the center of the screen */
  
  star->xpos =  -10.0 + (20.0 * (rand()/(RAND_MAX+1.0)));
  star->ypos =  -10.0 + (20.0 * (rand()/(RAND_MAX+1.0)));
  
  star->xpos *= 3072.0; /*change viewpoint */
  star->ypos *= 3072.0;

  star->zpos =  i;
  star->speed =  2 + (int)(2.0 * (rand()/(RAND_MAX+1.0)));

  star->color = i*Cyan >> 2; /*the closer to the viewer the brighter*/
}


void init()
{
  int i;

  for (i = 0; i < NUMBER_OF_STARS; i++)
    {
      init_star(stars + i, i + 1);
    }
}
 
  
 // the TFT is connected to SPI pin 5-7, CS is p8, RS is p11, reset is p15 
 ST7735_TFT TFT(p5, p6, p7, p8, p11, p15,"TFT"); // mosi, miso, sclk, cs, rs, reset
 
 Serial pc(USBTX, USBRX); // tx, rx
 Timer t;

extern unsigned char p1[];  // the mbed logo
 
 int main() {
    
    unsigned int centerx, centery;
    int i, j, tempx, tempy;  
    init();
    TFT.set_orientation(1);
    centerx = TFT.width() >> 1;
    centery = TFT.height() >> 1; 
    
     
    TFT.claim(stdout);      // send stdout to the TFT display 
    //TFT.claim(stderr);      // send stderr to the TFT display

    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white
    
    TFT.cls();
    TFT.set_font((unsigned char*) Arial24x23);  // select the font
        
    t.start();

    ////// demo start
    
    for ( j = 0 ; j < 10000; j++ ) 
    {
     
      /* move and draw stars */
       
      for (i = 0; i < NUMBER_OF_STARS; i++)
    {
      tempx = (stars[i].xpos / stars[i].zpos) + centerx;
      tempy = (stars[i].ypos / stars[i].zpos) + centery;
      TFT.pixel(tempx,tempy,Black);
      
        
      stars[i].zpos -= stars[i].speed;
      
      if (stars[i].zpos <= 0)
        {
          init_star(stars + i, i + 1);
        }

      //compute 3D position
      tempx = (stars[i].xpos / stars[i].zpos) + centerx;
      tempy = (stars[i].ypos / stars[i].zpos) + centery;

      if (tempx < 0 || tempx > TFT.width() - 1 || tempy < 0 || tempy > TFT.height() - 1) //check if a star leaves the screen
        {
          init_star(stars + i, i + 1);
          continue;
        }
      
      TFT.pixel(tempx,tempy,stars[i].color);
        
    }
     TFT.Bitmap(centerx-60,centery-19,120,38,p1);
    }
    
    ///// demo stop

    t.stop();
    TFT.locate(0,10);
    TFT.set_font((unsigned char*) Arial12x12);  // select the font
    printf("Time %f s\n", t.read());
  }