#include "mbed.h"
#include "alarm.h"

using namespace mbed;

Alarm :: Alarm(PinName pin) : _pwm(pin)
{
    _pwm.period(1.0/1000);
    _pwm.write(0.0);
    active = false;
}

void Alarm :: startBeep(void)
{
    active = true;
    beepOn();
}

void Alarm :: stopBeep(void)
{
    active = false;
}

void Alarm :: beepOn(void)
{
    _pwm.write(0.5);
    beepTimer.attach(this, &Alarm::beepOff, 0.1);
}

void Alarm :: beepOff(void)
{
    _pwm.write(0.0);
    if(active)
        beepTimer.attach(this,&Alarm::beepOn, 0.05);
}