#include "mbed.h"
#include "m3pi_ng.h"
#include "btbee.h"

m3pi m3pi;
btbee btbee;

DigitalOut mbed_led[] = {(LED1), (LED2),(LED3), (LED4)};
DigitalOut m3pi_led[] = {(p13), (p14), (p15), (p16), (p17), (p18), (p19), (p20)};

int main ()
{
// initialization stuff ////////////////////////////////////////////////////////////////////////////////////////////////////
    for (int i = 0; i <4; i++) {
        mbed_led[i] = 0;
    }
    for (int i = 0; i <8; i++) {
        m3pi_led[i] = 0;
    }
    btbee.at_baud();
// end initialization stuff ////////////////////////////////////////////////////////////////////////////////////////////////
    m3pi.locate(0,0);
    m3pi.printf("ATSWITCH");
    m3pi.locate(0,1);
    m3pi.printf("RIGHT???");
    wait(0.1);
    m3pi_led[0]=1;
/*****************
The commands sent to the bee have to be lower case
The commands sent to the bee do not start with \r\n as the BlueTooth Bee wiki state
This works with the DFRobot BlueToothBee ver 2.0  Tested and verified 11/13/13 on my personal M3PI and BTBee module
Additional commands can be found at:  http://www.dfrobot.com/image/data/TEL0026/TEL0026_Datasheet.pdf

Steps to success:
    1.Power off
    2.switch on bee to AT Mode
    3.Power on
    4.Download program to MBED
    5.Run MBED program
    6.Power off     settings in the bee are sent to ROM and will be retained after the power cycle
    7.Switch to !AT Mode
    8.Power On
*****************/


    //btbee.printf("at\r\n"); // test command, returns "OK\r\n"
    //btbee.printf("at+uart=9600,0,0\r\n"); //default values, returns "OK\r\n"
    //btbee.printf("at+uart=115200,0,0\r\n"); //changing the baud rate, returns "OK\r\n"
    //wait(2.0);    //necessary delay after a baud rate change
    
    //btbee.printf("at+name=Pololu_Car\r\n");   /set the name of the Bluetooth Module to:  Pololu_Car
    
    wait(2.0);  //found that this delay elmiminates a lot of issues  Never Remove it
    
    //btbee.printf("at+uart?\r\n");     //asking for the serial set parameters, replies "+UART:baud,stop,parity\r\n"
    //btbee.printf("at+name?\r\n");     //returns the name assigned to the bee module
    //btbee.printf("at+role?\r\n");     //returns the role of the bee (master = 1, slave=0, slave is default)
    btbee.printf("at+pswd?\r\n");       //returns the current bee paring password (default is 1234)
    
    
    m3pi_led[1]=1;

    while (!btbee.readable()) { //wait for reply
        mbed_led[0]=!mbed_led[0];
        wait(0.1);
    }

    char reply_array[30];
    int reply_length=0;
    
    m3pi_led[2]=1;
    btbee.read_all(reply_array, 30, &reply_length);
    m3pi_led[3]=1;

    m3pi.locate(0,0);
    m3pi.cls();
    if (reply_length<9) {
        m3pi.print(reply_array, reply_length);
    } else {
        m3pi.print(reply_array, 8);
        m3pi.locate(0,1);
        m3pi.print(reply_array+8, reply_length-8);
    }
    m3pi_led[4]=1;

}//main

