#include "mbed.h"
#include "Adafruit_PN532.h"

#define SS   PTD0
// PTD1 is also LED_BLUE, it will blink during SPI communication.
#define SCK  PTD1
#define MOSI PTD2
#define MISO PTD3

Serial id(PTA2, PTA1);
int previous = 0;

Adafruit_PN532 nfc(SCK, MISO, MOSI, SS);

void loop(void);

int main() {
  id.baud(9600);
  nfc.begin();

  uint32_t versiondata = nfc.getFirmwareVersion();
  if (! versiondata) {
    while (1); // halt
  }

  nfc.SAMConfig();
  
  while(1) { loop(); }
}


void loop(void) {
  uint8_t success;
  uint8_t uid[] = { 0, 0, 0, 0, 0, 0, 0 };  
  uint8_t uidLength;                        
  
  success = nfc.readPassiveTargetID(PN532_MIFARE_ISO14443A, uid, &uidLength);
  
  if (success) {
    previous = 1;

    if (uidLength == 4)
    {
        uint8_t tag_1 = 250;
        uint8_t tag_2 = 186;
        uint8_t tag_3 = 106;
        uint8_t tag_4 = 10;
        id.printf("%d", uid[0]);
    }
  } else if (previous == 0){
     } else {
     previous = 0; 
    }
}