/*
 * 640x480 60Hz fullgraphic monochrome VGA Driver demo program
 *
 * Copyright (C) 2011 by Ivo van Poorten <ivop(at)euronet.nl>
 * and Gert van der Knokke <gertk(at)xs4all.nl>
 * This file is licensed under the terms of the GNU Lesser
 * General Public License, version 3.
 *
 * Inspired by Simon's (not Ford) Cookbook entry and Cliff Biffle's
 * assembly code.
 */
 
#include "mbed.h"
#include "fastlib/common.h"
#include "fastlib/pinsel.h"
#include "fastlib/gpio.h"
#include "fastlib/clock.h"
#include "fastlib/power.h"
#include "fastlib/pwm.h"
#include "fastlib/i2s.h"
#include "fastlib/uart.h"
#include "fastlib/dma.h"
#include "fastlib/nvic.h"

#include "vga640x480g.h"


// visual feedback
DigitalOut myled(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);   // Data sent LED

// Commands for SIRF III GPS
// to turn on or off data strings
#define GGA_ON   "$PSRF103,00,00,01,01*25\r\n"
#define GGA_OFF  "$PSRF103,00,00,00,01*24\r\n"
#define GLL_ON   "$PSRF103,01,00,01,01*24\r\n"
#define GLL_OFF  "$PSRF103,01,00,00,01*25\r\n"
#define GSA_ON   "$PSRF103,02,00,01,01*27\r\n"
#define GSA_OFF  "$PSRF103,02,00,00,01*26\r\n"
#define GSV_ON   "$PSRF103,03,00,05,01*22\r\n"
#define GSV_OFF  "$PSRF103,03,00,00,01*27\r\n"
#define RMC_ON   "$PSRF103,04,00,01,01*21\r\n"
#define RMC_OFF  "$PSRF103,04,00,00,01*20\r\n"
#define VTG_ON   "$PSRF103,05,00,01,01*20\r\n"
#define VTG_OFF  "$PSRF103,05,00,00,01*21\r\n"
//#define WAAS_ON  "$PSRF151,1*3F\r\n"
//#define WAAS_OFF "$PSRF151,0*3E\r\n"
#define UARTPORT 3

// Set up serial ports and LEDs
// SIRF GPS on Pin28 and Pin7
//Serial gps(p9, p10);     // tx, rx - 4800 baud required

//TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d0-d3

//char buffidx;
char vgatxtbuff[80];    // Data buffer for VGA output
char msg[256];           // GPS data buffer
char status;             // GPS status 'V' = Not locked; 'A' = Locked
char *parseptr;          // Pointer for parsing GPS message
char time_buff[7] = "000000";
char date_buff[7] = "000000";
char sens_buff[7] = "123456";
int i;

void putcharact(char chardata) {

  while ((fl_uart_get_line_status(UARTPORT)& 0x60)==0) {
  
  }
  *FL_UART(UARTPORT, THR)= chardata;
}
char getcharact(void) {
  while ((fl_uart_get_line_status(UARTPORT)& 0x01)==0) {
  }
  return fl_uart_receive_byte(UARTPORT);
}

// Switch off all but $GPRMC string
void setgps() {
    sprintf(msg,GGA_ON);
    i=0;
    while (msg[i]!= 0) {
      putcharact(msg[i]);
      i++;
    }
    sprintf(msg,GLL_ON);
    i=0;
    while (msg[i]!= 0) {
      putcharact(msg[i]);
      i++;
    }
    sprintf(msg,GSA_ON);
    i=0;
    while (msg[i]!= 0) {
      putcharact(msg[i]);
      i++;
    }
    sprintf(msg,GSV_ON);
    i=0;
    while (msg[i]!= 0) {
      putcharact(msg[i]);
      i++;
    }
    sprintf(msg,RMC_ON);
    i=0;
    while (msg[i]!= 0) {
      putcharact(msg[i]);
      i++;
    }
    sprintf(msg,VTG_ON);
    i=0;
    while (msg[i]!= 0) {
      putcharact(msg[i]);
      i++;
    }
//    gps.printf(WAAS_OFF);
    return;
}

// Get line of data from GPS
void getline() {
    while (getcharact() != '$'); // Wait for start of line
    for (int i=0; i<256; i++) {
        msg[i] = getcharact();
        if (msg[i] == '\r') {
            msg[i] = 0;
            return;
        }
    }
}


float trunc(float v) {
    if(v < 0.0) {
        v*= -1.0;
        v = floor(v);
        v*=-1.0;
    } else {
        v = floor(v);
    }
    return v;
}

/** The longitude (call sample() to set) */
float longitude;
/** The latitude (call sample() to set) */
float latitude;
float gps_time;
char ns, ew;
int lock,sat_used;
float HDOP;
float altitude;

int toggle_flag=0;
int gps_hour;
int gps_min;
int gps_sec;
int s;
unsigned power_state;

int main() {
    // init the VGA subsystem (always do this first!)
    init_vga();
    setbuf(stdout, NULL); // no buffering for this filehandle

//    gps.baud(4800);         // NB GPS baud rate 4800
    fl_power_uart3(FL_ON);
    fl_select_clock_uart3(FL_CLOCK_DIV1);
    *FL_UART(UARTPORT, LCR) = 0x00000083; //DLAB 1 for access to divisors
    fl_uart_set_fractional_divider(UARTPORT, 0, 0);
    fl_uart_set_divisor_latch(UARTPORT, 1302);
    *FL_UART(UARTPORT, FCR) = 0x00000007; // FIFO enable (must) and clear FIFOs
    *FL_UART(UARTPORT, LCR) = 0x00000003; // DLAB 0
    *FL_UART(UARTPORT, IER) = 0x00000000; // no interrupts
    fl_pinsel(0, 0, FL_FUNC_ALT2, FL_IGNORE, FL_IGNORE);    // TX3
    fl_pinsel(0, 1, FL_FUNC_ALT2, FL_IGNORE, FL_IGNORE);    // RX3
    fl_uart_transmitter_enable(UARTPORT, 1);
    
    setgps();


    // clear the screen
    vga_cls();
    // circumfence the screen
    vga_box(0,0,639,479,WHITE);
           vga_putstring(400,370,"GPS DEMO",WHITE);
/*    // put a string on screen
    for (s=0; s<150; s++) {
       vga_putstring(400,370-s,"GPS DEMO",WHITE);
       wait(0.01);
       vga_putstring(400,370-s,"GPS DEMO",BLACK);
    }
      for (s=0; s<150; s++) {
       vga_putstring(400-s,220,"GPS DEMO",WHITE);
       wait(0.01);
       vga_putstring(400-s,220,"GPS DEMO",BLACK);
    }
      for (s=0; s<150; s++) {
       vga_putstring(250,220+s,"GPS DEMO",WHITE);
       wait(0.01);
       vga_putstring(250,220+s,"GPS DEMO",BLACK);
    }
      for (s=0; s<150; s++) {
       vga_putstring(250+s,370,"GPS DEMO",WHITE);
       wait(0.01);
       vga_putstring(250+s,370,"GPS DEMO",BLACK);
    }
        wait(1);
    for (s=0;s<30;s++){
       vga_putstring(400,370,"GPS DEMO",WHITE);
         wait(.1);
       vga_putstring(400,370,"GPS DEMO",BLACK);
         wait(.1);
    }
*/
    
    vga_putstring(10,50,"CGA",WHITE);
    vga_putstring(10,70,"GLL",WHITE);
    vga_putstring(10,90,"GSA",WHITE);
    vga_putstring(10,110,"GSV",WHITE);
    vga_putstring(10,130,"RMC",WHITE);
    vga_putstring(10,150,"RMC",WHITE);
   
   

    while (1) {
led4=1;
        getline();
        if (sscanf(msg,"GPGGA,%s", &vgatxtbuff)>=1){
            vga_putstring(50,50,vgatxtbuff,WHITE);
        }
        if (sscanf(msg,"GPGLL,%s", &vgatxtbuff)>=1){
            vga_putstring(50,70,vgatxtbuff,WHITE);
        }
        if (sscanf(msg,"GPGSA,%s", &vgatxtbuff)>=1){
            vga_putstring(50,90,vgatxtbuff,WHITE);
        }
        if (sscanf(msg,"GPGSV,%s", &vgatxtbuff)>=1){
            vga_putstring(50,110,vgatxtbuff,WHITE);
        }
        if (sscanf(msg,"GPRMC,%s", &vgatxtbuff)>=1){
            vga_putstring(50,130,vgatxtbuff,WHITE);
        }
        if (sscanf(msg,"GPVTG,%s", &vgatxtbuff)>=1){
            vga_putstring(50,150,vgatxtbuff,WHITE);
        }
       // Check if it is a GPGGA msg (matches both locked and non-locked msg)
        if(sscanf(msg, "GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f", &gps_time, &latitude, &ns, &longitude, &ew, &lock, &sat_used, &HDOP, &altitude) >= 1) { 
            if(!lock) {
                led4 = 1;
                longitude = 0.0;
                latitude = 0.0;        
            } else {
                led4 = 0;
                if(ns == 'S') {    latitude  *= -1.0; }
                if(ew == 'W') {    longitude *= -1.0; }
                float degrees = trunc(latitude / 100.0f);
                float minutes = latitude - (degrees * 100.0f);
                latitude = degrees + minutes / 60.0f;    
                degrees = trunc(longitude / 100.0f);
                minutes = longitude - (degrees * 100.0f);
                longitude = degrees + minutes / 60.0f;
                gps_hour = trunc(gps_time/10000.0f);
                gps_min = trunc((gps_time - gps_hour*10000.0f)/100.0f);
                gps_sec = trunc(gps_time-gps_hour*10000.0f-gps_min*100.0f);
                gps_hour++;
                if (gps_hour>=24) {
                    gps_hour=0;
                }
            }
            sprintf(vgatxtbuff, "lat: %3.7f long: %3.7f time: %2.4f sat_used: %d alt: %5.3f",latitude, longitude,gps_time, sat_used, altitude);
            vga_putstring(10,30,vgatxtbuff,WHITE);
        }
    }
}

