/*
This code uses the button1 to toggle LED1 and button2 to toggle LED2 
Author: Dan M
Date Created: 12.12.2014
Last Update: 12.12.2014
*/
#include "mbed.h"
/* Define pin names and numbers */

#define SW4 p16
#define SW3 p15
#define SW2 p14
#define SW1 p13

/*Function Prototypes*/
void trigger1();//Button1 Interrupt function
void trigger2();//Button2 Interrup Function
void trigger3();//Button1 Interrupt function
void trigger4();//Button2 Interrup Function

//Instantiate IO objects
DigitalOut led_1(LED1);
DigitalOut led_2(LED2);
DigitalOut led_3(LED3);
DigitalOut led_4(LED4);

DigitalIn  sw_1(SW1);
DigitalIn  sw_2(SW2);
DigitalIn  sw_3(SW3);
DigitalIn  sw_4(SW4);

//Instantiate input interrupts
InterruptIn sw1Press(SW1);
InterruptIn sw2Press(SW2);
InterruptIn sw3Press(SW3);
InterruptIn sw4Press(SW4);

int main() {
    //Initialise LED output
    led_1=0;
    led_2=0;
    led_3=0;
    led_4=0;
    
    //Choose falling edge interrupt and connect to appropriate interrupt function
    sw1Press.fall(&trigger1);
    sw2Press.fall(&trigger2);
    sw3Press.fall(&trigger3);
    sw4Press.fall(&trigger4);
    while(1) {}
}
/*Button1 interrupt function*/
void trigger1()
{
 led_1=!led_1;
}
/*Button2 interrupt function*/
void trigger2()
{
 led_2=!led_2; 
}
/*Button3 interrupt function*/
void trigger3()
{
 led_3=!led_3;
}
/*Button4 interrupt function*/
void trigger4()
{
 led_4=!led_4; 
}