/* mbed USBJoystick Library Demo
 * Copyright (c) 2012, v01:  Initial version, WH,
 *                           Modified USBMouse code ARM Limited.
 *                           (c) 2010-2011 mbed.org, MIT License
 *               2016, v02:  Updated USBDevice Lib, Added waitForConnect, Updated 32 bits button
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, inclumosig without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUmosiG BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
 // Note: you must connect the usb cable to your computer before the program will proceed
 
// USB parts from: https://developer.mbed.org/forum/helloworld/topic/3496/

#include "mbed.h"
#include "USBJoystick.h"

//USBMouse mouse;
USBJoystick joystick;

// Variables for Heartbeat and Status monitoring
PwmOut myled1(LED1);
//PwmOut myled2(LED2);
//PwmOut myled3(LED3);
//DigitalOut heartbeatLED(LED4);

AnalogIn joyXin(A0);
AnalogIn joyYin(A1);
AnalogIn joyZin(A2);
AnalogIn joyRxin(A3);
AnalogIn joyRyin(A4);
AnalogIn joyRzin(A5);

Ticker heartbeat;
Serial pc(USBTX, USBRX); // tx, rx

int16_t map(int32_t x, int32_t in_min, int32_t in_max, int32_t out_min, int32_t out_max) // found here: C:\Program Files (x86)\Arduino\hardware\arduino\avr\cores\arduino\WMath.cpp
{
    return (int16_t)((x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min);
}

float mapf(float x, float in_min, float in_max, float out_min, float out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

// Heartbeat monitor
//void pulse()
//{
//    heartbeatLED = !heartbeatLED;
//}
//
//void heartbeat_start()
//{
//    heartbeatLED = 1;
//    heartbeat.attach(&pulse, 0.5);
//}
//
//void heartbeat_stop()
//{
//    heartbeat.detach();
//}


int main()
{
    uint16_t i = 0;
    int16_t x = 0;
    int16_t y = 0;
    int16_t z = 0;
    int16_t rx = 0;
    int16_t ry = 0;
    int16_t rz = 0;
    uint8_t tmp = 0;
    uint32_t buttons = 0;
    uint8_t hat = 0;

    pc.printf("6 DOF Joystick\n\r");

//    myled1 = 0;
//    myled2 = 0;
//    myled3 = 0;
//    heartbeatLED = 0;
//  heartbeat_start();

    while (1) {
        // 6DOF Joystick with buttons and a hat

#if (BUTTONS4 == 1)
        buttons = (i >> 8) & 0x0F;   // value    0 ..  15, one bit per button
#endif
#if (BUTTONS8 == 1)
        buttons = (i >> 8) & 0xFF;   // value    0 .. 255, one bit per button
#endif
#if (BUTTONS32 == 1)
        tmp     = (i >> 8) & 0xFF;   // value    0 .. 255, one bit per button
        buttons =           (( tmp <<  0) & 0x000000FF);
        buttons = buttons | ((~tmp <<  8) & 0x0000FF00);
        buttons = buttons | (( tmp << 16) & 0x00FF0000);
        buttons = buttons | ((~tmp << 24) & 0xFF000000);
#endif

#if (HAT4 == 1)
        hat    = (i >> 8) & 0x03;   // value 0, 1, 2, 3 or 4 for neutral
#endif
#if (HAT8 == 1)
        hat    = (i >> 8) & 0x07;   // value 0..7 or 8 for neutral
#endif
        i++;

//    joystick.move(joyXin.read_u16(), joyYin.read_u16(), joyZin.read_u16(), joyRxin.read_u16(), joyRyin.read_u16(), joyRzin.read_u16());

        x = map(joyXin.read_u16(), 0, 65535, -32768, 32768);  // value -32768 .. 32767
        y = map(joyYin.read_u16(), 0, 65535, -32768, 32768);
        z = map(joyZin.read_u16(), 0, 65535, -32768, 32768);
        rx = map(joyRxin.read_u16(), 0, 65535, -32768, 32768);
        ry = map(joyRyin.read_u16(), 0, 65535, -32768, 32768);
        rz = map(joyRzin.read_u16(), 0, 65535, -32768, 32768);

        myled1 = mapf(x, -32768, 32768, 0, 1.0);

        pc.printf(" %d %d %d %d %d %d\r\n", x, y, z, rx, ry, rz);

        joystick.update(x, y, z, rx, ry, rz, buttons, hat);
        wait(0.005);
    }
}
