// Using MF51E103F3950 NTC 10k Thermistor, with a B value of 3950
#include "mbed.h"

// which analog pin to connect
#define THERMISTORPIN A0
// resistance at 25 degrees C
#define THERMISTORNOMINAL 10000
// temp. for nominal resistance (almost always 25 C)
#define TEMPERATURENOMINAL 25
// how many samples to take and average, more takes longer
// but is more 'smooth'
#define NUMSAMPLES 5
// The beta coefficient of the thermistor (usually 3000-4000)
#define BCOEFFICIENT 3950
// the value of the 'other' resistor
#define SERIESRESISTOR 10000.0f

#define OFFSET_NUM_AVERAGES 20

Serial pc(USBTX, USBRX); // tx, rx
AnalogIn ain0(A0);
AnalogIn ain1(A1);
AnalogIn ain2(A2);
AnalogIn ain3(A3);
AnalogIn ain4(A4);
AnalogIn ain5(A5);
AnalogIn ain6(PA_5); // Note: on the Nucleo F401, this is connected to the LED.
AnalogIn ain7(PA_6);
AnalogIn ain8(PA_7);

Timer timer;

float offsets[9] = {0};
float resistors[9] = {9984.270169f, 9999.947582f, 9999.962164f, 9999.960999f, 9999.958757f, 9999.918074f, 9999.969933f, 9999.966487f, 9999.977766f};

int main()
{
    pc.baud(115200);

    pc.printf("\nThermistor test\n");
    float rawReading[9] = {0};
    float reading[9] = {0};
    
// Find offset values (take average 20 readings for offset):
    float sum = 0;
//    for(uint8_t i = 0; i < OFFSET_NUM_AVERAGES; i++) {
//        sum += ain0.read();
//    }
//    offsets[0] = (sum / OFFSET_NUM_AVERAGES);
//    
//    sum = 0;
//    for(uint8_t i = 0; i < OFFSET_NUM_AVERAGES; i++) {
//        sum += ain1.read();
//    }
//    offsets[1] = (sum / OFFSET_NUM_AVERAGES);
//    
//    sum = 0;
//    for(uint8_t i = 0; i < OFFSET_NUM_AVERAGES; i++) {
//        sum += ain2.read();
//    }
//    offsets[2] = (sum / OFFSET_NUM_AVERAGES);
//    
//    sum = 0;
//    for(uint8_t i = 0; i < OFFSET_NUM_AVERAGES; i++) {
//        sum += ain3.read();
//    }
//    offsets[3] = (sum / OFFSET_NUM_AVERAGES);    
//
//    sum = 0;
//    for(uint8_t i = 0; i < OFFSET_NUM_AVERAGES; i++) {
//        sum += ain4.read();
//    }
//    offsets[4] = (sum / OFFSET_NUM_AVERAGES);
//
//    sum = 0;
//    for(uint8_t i = 0; i < OFFSET_NUM_AVERAGES; i++) {
//        sum += ain5.read();
//    }
//    offsets[5] = (sum / OFFSET_NUM_AVERAGES);
//            
//    sum = 0;
//    for(uint8_t i = 0; i < OFFSET_NUM_AVERAGES; i++) {
//        sum += ain5.read();
//    }
//    offsets[5] = (sum / OFFSET_NUM_AVERAGES);
//
//    sum = 0;
//    for(uint8_t i = 0; i < OFFSET_NUM_AVERAGES; i++) {
//        sum += ain6.read();
//    }
//    offsets[6] = (sum / OFFSET_NUM_AVERAGES);
//
//    sum = 0;
//    for(uint8_t i = 0; i < OFFSET_NUM_AVERAGES; i++) {
//        sum += ain7.read();
//    }
//    offsets[7] = (sum / OFFSET_NUM_AVERAGES);
//    
//    sum = 0;
//    for(uint8_t i = 0; i < OFFSET_NUM_AVERAGES; i++) {
//        sum += ain8.read();
//    }
//    offsets[8] = (sum / OFFSET_NUM_AVERAGES);

// Single reading for offset:
//    offsets[0] = ain0.read();
//    offsets[1] = ain1.read();
//    offsets[2] = ain2.read();
//    offsets[3] = ain3.read();
//    offsets[4] = ain4.read();
//    offsets[5] = ain5.read();
//    offsets[6] = ain6.read();
//    offsets[7] = ain7.read();
//    offsets[8] = ain8.read();
    
// Find average of offsets and store in offsets array:
    sum = 0;
    float average = 0;
    
    for(uint8_t i = 0; i < 9; i++) {
        sum += offsets[i];
    }
    
    average = sum / 9;
    
    for(uint8_t i = 0; i < 9; i++) {
        offsets[i] = offsets[i] - average;
    }

    timer.start();

    while(1) {
// Take reading and apply offset, then use voltage divider equation:
//        rawReading[0] = 1 / (ain0.read() - offsets[0]) - 1;
//        rawReading[1] = 1 / (ain1.read() - offsets[1]) - 1;
//        rawReading[2] = 1 / (ain2.read() - offsets[2]) - 1;
//        rawReading[3] = 1 / (ain3.read() - offsets[3]) - 1;
//        rawReading[4] = 1 / (ain4.read() - offsets[4]) - 1;
//        rawReading[5] = 1 / (ain5.read() - offsets[5]) - 1;
//        rawReading[6] = 1 / (ain6.read() - offsets[6]) - 1;
//        rawReading[7] = 1 / (ain7.read() - offsets[7]) - 1;
//        rawReading[8] = 1 / (ain8.read() - offsets[8]) - 1;
        
        rawReading[0] = 1 / ain0.read() - 1;
        rawReading[1] = 1 / ain1.read() - 1;
        rawReading[2] = 1 / ain2.read() - 1;
        rawReading[3] = 1 / ain3.read() - 1;
        rawReading[4] = 1 / ain4.read() - 1;
        rawReading[5] = 1 / ain5.read() - 1;
        rawReading[6] = 1 / ain6.read() - 1;
        rawReading[7] = 1 / ain7.read() - 1;
        rawReading[8] = 1 / ain8.read() - 1;
        
        for(uint8_t i = 0; i < 9; i++) {
            reading[i] = resistors[i] / rawReading[i];
        }
                
//        pc.printf("Thermistor resistance ");
//        pc.printf("%f\t", reading0);

// Apply Steinhart equation:

        for(uint8_t i = 0; i < 9; i++) {
            float steinhart;
            steinhart = reading[i] / THERMISTORNOMINAL;     // (R/Ro)
            steinhart = log(steinhart);                  // ln(R/Ro)
            steinhart /= BCOEFFICIENT;                   // 1/B * ln(R/Ro)
            steinhart += 1.0 / (TEMPERATURENOMINAL + 273.15); // + (1/To)
            steinhart = 1.0f / steinhart;                 // Invert
            steinhart -= 273.15f;                         // convert to C
//            pc.printf("Temperature %d: %f *C\t", i, steinhart);

// Print commas for plotting (except at end):

            if(i == 6)
                continue;   // bad analog input (on LED)
            else {
                pc.printf("%.4f,", steinhart);
            }
        }
        pc.printf("%.2f\n", timer.read()/60.0f); // print time from boot in minutes

        wait(1);
    }
}
