#include "mbed.h"
 
InterruptIn event(USER_BUTTON);
DigitalOut myled(LED1);
 
int go_to_sleep = 0;
 
void pressed()
{
    printf("Button pressed\n");
    go_to_sleep = !go_to_sleep;
}
 
int main()
{
    int i = 0;
 
    event.fall(&pressed);
 
    while (1) {
        if (go_to_sleep) {
            myled = 1;
            printf("%d: Entering sleep (press user button to resume)\n", i);
            sleep();
            //deepsleep();
            //wait(0.1);
        } else {
            printf("%d: Running\n", i);
            myled = !myled;
            wait(1.0);
        }
        i++;
    }
}
