#include "mbed.h"
#include "cmsis_os.h"

class ThreadData
{
public:
    ThreadData( PinName pin, int delay )
        : Pin( pin )
        , Delay( delay )
    {
    } 
    
    DigitalOut Pin;
    int Delay;
};

ThreadData led1( LED1, 200 );
ThreadData led2( LED2, 250 );    

void Blinky( void const *argument )
{
    ThreadData& pinInfo = *reinterpret_cast<ThreadData*>( const_cast<void*>( argument ) );
    while( 1 )
    {
        pinInfo.Pin = 1;
        wait_ms( pinInfo.Delay );
        pinInfo.Pin = 0;
        wait_ms( pinInfo.Delay );
    }
}

osThreadDef( Blinky, osPriorityNormal, 200 );

int main()
{
    osThreadCreate( osThread( Blinky ), &led2 );
    Blinky( &led1 ); 
}
