#include "mbed.h"
#include "MSCFileSystem.h"

#define FSNAME "msc"
#define LOCAL "local"

#define START 1
#define STOP  0
#define DEBOUNCING_INTERVAL 40   //  Debouncing interval (in mili-seconds)

Serial pc(USBTX,USBRX);

MSCFileSystem msc(FSNAME);
LocalFileSystem local(LOCAL);

DigitalOut led1(LED1);

AnalogIn input(p16);
InterruptIn bouton(p18);
Timeout timeout;
Timer t;
Timer timerAcquisition;
Timer tempsBoucle;

struct TRAME
    {
        unsigned long int tempsA; /* 4 octets nb de tops de 250&#65533;s */
        unsigned char topAv, topAr;
        unsigned short guidon, refx, refy, refz, ax, ay, az, rx, ry, rz, gaz;
        unsigned long int tempsB; /* 4 octets tempsA + 1 */
    };
        
TRAME trame;
int etatBouton = STOP;
int compteurfclose = 0;
int compteurfopen  = 0;
int veriffclose = 1;
int compteurBoucle= 0;
DIR *d;
FILE *fichier;

void isr_interrupteurRisingStart(void) {
    if ( t.read_ms() > DEBOUNCING_INTERVAL ) {  
        etatBouton = START;
        printf("Isr Rising\n\r");
        compteurfopen  = 1; 
        wait_ms(100);             
    }
    
    t.reset();  //  timer reset
}
void isr_interrupteurFallingStop(void) {
    if ( t.read_ms() > DEBOUNCING_INTERVAL ) {
        etatBouton = STOP;
        printf("Isr Falling\n\r");
        compteurfclose = 1;  
        wait_ms(100);                    
    }
    
    t.reset();  //  timer reset
}
int main() {     
    t.start();    
    int acquisition = 0;
    float temps;
    char i;
    
    trame.refx = 0x7ff; /* 2047 */
    trame.refy = 0x7ff;
    trame.refz = 0x7ff;
    trame.ax = 0x5555;
    
    unsigned short int buf[16];
    for(i=0;i<16;i++){
        buf[i] = 0;
    }    
    buf[4] = 0x7FF;
    buf[5] = 0x7FF;
    buf[6] = 0x7FF;
    buf[7] = 0x5555; 
    //d = opendir("/" FSNAME);
    //fichier = fopen( "/" FSNAME "/Datatest.txt", "ab");  
   
    //d = opendir("/" LOCAL);
    //fichier = fopen( "/" LOCAL "/Datatest.txt", "ab"); 
       
    bouton.rise(&isr_interrupteurRisingStart);
    bouton.fall(&isr_interrupteurFallingStop);  

    while (1){
            
        if(compteurfopen){
            if(veriffclose){
                do{ 
                    printf("do\n\r");                 
                    fichier = fopen( "/" FSNAME "/Data.IEF", "ab");
                    timerAcquisition.start();
                }while (fichier == NULL);                               
                printf("Open file\n\rAcquisition : %d\n\r",acquisition);
                veriffclose = 0;
                compteurfopen  = 0;
                acquisition++;
            }else{
                printf("Defaultclose file\n\r");
                compteurfclose = 1;             
            } 
        } 
        tempsBoucle.start();
        while (etatBouton && !compteurfopen){     
            buf[1]  = ((timerAcquisition.read_us()) & 0xFFFF0000)>>16;
            buf[0]  = timerAcquisition.read_us();    
            buf[15] = ((timerAcquisition.read_us()/2)& 0xFFFF0000)>>16;
            buf[14] = timerAcquisition.read_us()/2;
            buf[7]  = input.read_u16();                       
            fwrite(buf,2,16,fichier);            
            led1 = 1;
            compteurBoucle++;
        }
        
        if(compteurfclose){
            temps = tempsBoucle.read();
            printf("%d %f\n\r", compteurBoucle, temps);       
            fclose(fichier);
            timerAcquisition.reset();
            led1 = 0;           
            printf("Close file Compteur\n\r"); 
            compteurfclose = 0;
            veriffclose = 1;
            compteurBoucle = 0;           
        }
    }
}
