#include "mbed.h"
#include "MSCFileSystem.h"

#define FSNAME "msc"
#define LOCAL "local"

Serial pc(USBTX,USBRX);
MSCFileSystem msc(FSNAME);
LocalFileSystem local(LOCAL);

void lire_repertoire(struct dirent *p, DIR *d);
void copie_prog(FILE *fichier_source,FILE *fichier_copie);

int main()
{
    pc.baud(9600);
    DIR *d,*b;
    struct dirent *p,*q;
    char temp[64];
    FILE *fichier1,*fichier2,*fichier3;
    FILE *fcopie;
    
    pc.printf("==============================================\n\r");
    pc.printf("USB Mass storage demo program for mbed LPC1768\n\r");
    pc.printf("==============================================\n\r");
    
    d = opendir("/" FSNAME);
    b = opendir("/" LOCAL);
    
    pc.printf("\nList of files on the Usb:\n\r");
    lire_repertoire(p,d);
    pc.printf("\nList of files on Mbed :\n\r");
    lire_repertoire(q,b);  
}


void copie_prog(FILE *fichier_source,FILE *fichier_copie){        
    char buffer[512];
    int NbLus;
        
    pc.printf("\n\nCopiage du fichier en cours...");            
    
    if (fichier_source == NULL){
    pc.printf("Could not open source file \r");                
    }
    
    if (fichier_copie == NULL){
    fclose(fichier_source);
    pc.printf("Could not open destination file \r");                
    } 
            
    while ((NbLus = fread(buffer, 1, 512, fichier_source)) != 0)
    fwrite(buffer, 1, NbLus, fichier_copie);
            
    fclose(fichier_copie);
    fclose(fichier_source);
    
    pc.printf("Fini\n\r");
}


void lire_repertoire(struct dirent *p, DIR *d){
    char compteur=0;
    if ( d != NULL ){
        while ( (p = readdir(d)) != NULL ){
        compteur++;
            pc.printf(" %d %s\n\r",compteur, p->d_name);           
        }
    }
    else{
        pc.printf("Could not open directory!\r");
    }
}