#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "HTTPClient.h"

#define LOCAL "local"
Serial pc(p9,p10);
HTTPServer svr;

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

EthernetNetIf eth(
  IpAddr(169,254,113,94),   //IP Address
  IpAddr(255,255,0,0),      //Network Mask
  IpAddr(129,168,1,1),      //Gateway  /129.168.1.1
  IpAddr(129,168,1,1)       //DNS      /129.168.1.1  
);

LocalFileSystem local(LOCAL);
HTTPClient http;

void lire_repertoire(struct dirent *p, DIR *d,FILE *file);


int main() {
     
      DIR *d;
      struct dirent *p; 
      d = opendir("/" LOCAL);      
      
      pc.baud(9600);
      pc.printf("Setting up...\n\r");
      EthernetErr ethErr = eth.setup();
      if(ethErr)
      {
        pc.printf("Error %d in setup.\n\r", ethErr);
        return -1;
      }
      pc.printf("Setup OK\n\r");
      
      FSHandler::mount("/local", "/"); //Mount /local path on web root path
 
      svr.addHandler<FSHandler>("/");
      svr.addHandler<RPCHandler>("/rpc");
      svr.bind(80);
      
      pc.printf("En Ecoute...\n\r");
        
      Timer tm;
      tm.start();      
      
      FILE *fp = fopen( "/" LOCAL "/testmbed.htm", "w");
      if ( fp == NULL )
      {
        pc.printf("Could not open file for write\n");
      }
      fprintf(fp,"<B><font size=\"5\"> Liste de programme dans le Mbed :</font></B><br><br>");
      lire_repertoire(p,d,fp);      
      
      fclose(fp); 
      pc.printf("\n - OK\n\r");
      
      IpAddr ip = eth.getIp();
      pc.printf("Addresse IP local: %d.%d.%d.%d\r\n", ip[0], ip[1], ip[2], ip[3]); 
      HTTPText txt;
      HTTPResult r = http.get("http://www.martobre.fr/films/get_ip.php", &txt);
      
      if(r==HTTP_OK)
      {
         pc.printf("Adresse IP public :\n\r\"%s\"\n\r", txt.gets()); 
      }
      else
      {
         pc.printf("Error %d\n", r);
      }

      //Listen indefinitely
      while(true)
      {
        Net::poll();
        if(tm.read()>.5)
        {
          led1=!led1; //Show that we are alive
          tm.start();
        }
      }
}
void lire_repertoire(struct dirent *p, DIR *d,FILE *file){
    char compteur=0;
    
    if ( d != NULL ){
        while ( (p = readdir(d)) != NULL ){
        compteur++;
            fprintf(file,"%d/%s <br>",compteur, p->d_name);           
        }
    }
    else{
        pc.printf("Could not open directory!\r");
    }
}