#include "mbed.h"
#include "EthernetNetIf.h"							

DigitalOut myled(LED1);
Serial pc(p9, p10); 
EthernetNetIf eth(
  IpAddr(192,168,175,31), 	//IP Address
  IpAddr(255,255,0,0),  	//Network Mask
  IpAddr(1,1,1,1),  		//Gateway		   //192.168.175.1
  IpAddr(1,1,1,1)  			//DNS			   //129.175.225.12
);

int main() {
	pc.baud(9600);
	myled=1;
	EthernetErr ethErr = eth.setup();
	if(ethErr)
	{
		pc.printf("Error %d in setup.\n\r", ethErr);
		return -1;
	}
	pc.printf("Setup OK\n\r");
	IpAddr ip = eth.getIp();
	pc.printf("Addresse IP local: %d.%d.%d.%d\r\n", ip[0], ip[1], ip[2], ip[3]); 

	while (1) {
		Net::poll();
	}
}