#include "mbed.h"
#include "QEI.h"
#include "TextLCD.h"
#include "Rtc_Ds1307.h"

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
QEI encoder (PTA13, PTD5, NC, 624);
Rtc_Ds1307 rtc(PTE0, PTE1);
AnalogIn y(PTB3);//entrada analoga
AnalogOut u(PTE30);//salida analoga OJO solo se le pueden drenar 1.5mA en circuitos use un Buffer
//si se ignora esto se arruina la FRDMKL25Z
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

DigitalIn button3(PTC16);//cambia ingreso de  los 4 parametros
DigitalIn button4(PTC17);//termina y consolida valores de 4 parametros y sale del loop


//codigos movimiento del curzor

//int C1=0x0E; // solo muestra el curzor
int C2=0x18; // desplaza izquierda
int C3=0x1A; // desplaza derecha
int C4=0x0C; // quito cursor bajo

int C1=0x0F;
int cambio=0, diferencia=0;
float pid,o,ai,ad,ap,med,err;
float err_v;
int spnum=0,kinum=0,kpnum=0,kdnum=0,pos=1;
int sub=0,sost=0,baj=0,pos1=1;
int t1,t2,t3;
float f;
int i=0;
int c,c1=0;
int n=60;
float ref;

int main()
{
    lcd.locate(0,1);
    lcd.printf("**Control PID**");
    wait(2);
    lcd.cls(); // Borrar Pantalla
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD

    lcd.locate(8,0);
    lcd.printf("Kp=%d",kpnum);
    lcd.locate(0,1);
    lcd.printf("Ki=%d",kinum);
    lcd.locate(8,1);
    lcd.printf("Kd=%d",kdnum);
    lcd.locate(0,0);
    lcd.printf("Sp=%d",spnum);

    while(1)
    {
        //lcd.locate(8,0);
        //lcd.printf("Kp=%d",encoder.getPulses());
        //wait(.5);

        diferencia=encoder.getPulses()-cambio;
        cambio=encoder.getPulses();

        if (diferencia==0)
        {
            //nada
        }
        else if(diferencia>0)
        {
            if(pos==1)
            {
                if(spnum+diferencia>=999)
                {
                    spnum=999;
                    lcd.locate(3,0);
                    lcd.printf("    ");
                    lcd.locate(3,0);
                    lcd.printf("%d", spnum);
                }
                else
                {
                    spnum+=diferencia;
                    lcd.locate(3,0);
                    lcd.printf("%d", spnum);
                }
            }
            else if(pos==2)
            {
                if(kpnum+diferencia>=999)
                {
                    kpnum=999;
                    lcd.locate(11,0);
                    lcd.printf("    ");
                    lcd.locate(11,0);
                    lcd.printf("%d", kpnum);
                }
                else
                {
                    kpnum+=diferencia;
                    lcd.locate(11,0);
                    lcd.printf("%d", kpnum);
                }
            }
            else if(pos==3)
            {
                if(kinum+diferencia>=999)
                {
                    kinum=999;
                    lcd.locate(3,1);
                    lcd.printf("    ");
                    lcd.locate(3,1);
                    lcd.printf("%d", kinum);
                }
                else
                {
                    kinum+=diferencia;
                    lcd.locate(3,1);
                    lcd.printf("%d", kinum);
                }
            }
            else if(pos==4)
            {
                if(kdnum+diferencia>=999)
                {
                    kdnum=999;
                    lcd.locate(11,1);
                    lcd.printf("    ");
                    lcd.locate(11,1);
                    lcd.printf("%d", kdnum);
                }
                else
                {
                    kdnum+=diferencia;
                    lcd.locate(11,1);
                    lcd.printf("%d", kdnum);
                }
            }
        }
        
        else if(diferencia<0)
        {
            if(pos==1)
            {
                if(spnum+diferencia<0)
                {
                    //No ocurre nada
                }
                else
                {
                    spnum+=diferencia;
                    lcd.locate(3,0);
                    lcd.printf("    ");
                    lcd.locate(3,0);
                    lcd.printf("%d", spnum);
                }
            }
            else if(pos==2)
            {
                if(kpnum+diferencia<0)
                {
                    //No ocurre nada
                }
                else
                {
                    kpnum+=diferencia;
                    lcd.locate(11,0);
                    lcd.printf("    ");
                    lcd.locate(11,0);
                    lcd.printf("%d", kpnum);
                }
            }
            else if(pos==3)
            {
                if(kinum+diferencia<0)
                {
                    //No ocurre nada
                }
                else
                {
                    kinum+=diferencia;
                    lcd.locate(3,1);
                    lcd.printf("    ");
                    lcd.locate(3,1);
                    lcd.printf("%d", kinum);
                }
            }
            else if(pos==4)
            {
                if(kdnum+diferencia<0)
                {
                    //No ocurre nada
                }
                else
                {
                    kdnum+=diferencia;
                    lcd.locate(11,1);
                    lcd.printf("    ");
                    lcd.locate(11,1);
                    lcd.printf("%d", kdnum);
                }
            }
        }

        if (!button3)  //cambia la posicion de ingreso de parametros
        {
            led3 =!led3;
            if(pos==4)
            {
                pos=1;
                lcd.locate(3,0);
                lcd.printf("%d", spnum);
            }
            else if (pos==1)
            {
                pos++;
                lcd.locate(11,0);
                lcd.printf("%d", kpnum);
            }
            else if(pos==2)
            {
                pos++;
                lcd.locate(3,1);
                lcd.printf("%d", kinum);
            }
            else if(pos==3)
            {
                pos++;
                lcd.locate(11,1);
                lcd.printf("%d", kdnum);
            }
            wait(0.25);

        }

        if (!button4)
        {
            break;     //sale del bucle si pisan suiche4
        }
        wait(0.1);        
    }
    lcd.cls();
    lcd.locate(8,0);
    lcd.printf("so=%d",sost);
    lcd.locate(0,1);
    lcd.printf("ba=%d",baj);
    lcd.locate(0,0);
    lcd.printf("su=%d",sub);
    wait(3);
    while (0.1)
    {
        diferencia=encoder.getPulses()-cambio;
        cambio=encoder.getPulses();

        if (diferencia==0)
        {
            //nada
        }
        else if(diferencia>0)
        {
            if(pos1==1)
            {
                if(sub+diferencia>=59)
                {
                    sub=59;
                    lcd.locate(3,0);
                    lcd.printf("    ");
                    lcd.locate(3,0);
                    lcd.printf("%d", sub);
                }
                else
                {
                    sub+=diferencia;
                    lcd.locate(3,0);
                    lcd.printf("%d", sub);
                }
            }
            else if(pos1==2)
            {
                if(sost+diferencia>=59)
                {
                    sost=59;
                    lcd.locate(11,0);
                    lcd.printf("    ");
                    lcd.locate(11,0);
                    lcd.printf("%d", sost);
                }
                else
                {
                    sost+=diferencia;
                    lcd.locate(11,0);
                    lcd.printf("%d", sost);
                }
            }
            else if(pos1==3)
            {
                if(baj+diferencia>=59)
                {
                    baj=59;
                    lcd.locate(3,1);
                    lcd.printf("    ");
                    lcd.locate(3,1);
                    lcd.printf("%d", baj);
                }
                else
                {
                    baj+=diferencia;
                    lcd.locate(3,1);
                    lcd.printf("%d", baj);
                }
            }
        }
        
        else if(diferencia<0)
        {
            if(pos1==1)
            {
                if(sub+diferencia<0)
                {
                    //No ocurre nada
                }
                else
                {
                    sub+=diferencia;
                    lcd.locate(3,0);
                    lcd.printf("    ");
                    lcd.locate(3,0);
                    lcd.printf("%d", sub);
                }
            }
            else if(pos1==2)
            {
                if(sost+diferencia<0)
                {
                    //No ocurre nada
                }
                else
                {
                    sost+=diferencia;
                    lcd.locate(11,0);
                    lcd.printf("    ");
                    lcd.locate(11,0);
                    lcd.printf("%d", sost);
                }
            }
            else if(pos1==3)
            {
                if(baj+diferencia<0)
                {
                    //No ocurre nada
                }
                else
                {
                    baj+=diferencia;
                    lcd.locate(3,1);
                    lcd.printf("    ");
                    lcd.locate(3,1);
                    lcd.printf("%d", baj);
                }
            }
            
        }

        if (!button3)  //cambia la posicion de ingreso de parametros
        {
            led3 =!led3;
            if(pos1==3)
            {
                pos1=1;
                lcd.locate(3,0);
                lcd.printf("%d", sub);
            }
            else if (pos1==1)
            {
                pos1++;
                lcd.locate(11,0);
                lcd.printf("%d", sost);
            }
            else if(pos1==2)
            {
                pos1++;
                lcd.locate(3,1);
                lcd.printf("%d", baj);
            }
            wait(0.25);

        }

        if (!button4)
        {
            break;     //sale del bucle si pisan suiche4
        }
        wait(0.1);        
    }  

//Transicion
    lcd.writeCommand(C4);//escribimos un comando segun el manual del modulo LCD para quitar cursor bajo
    lcd.cls(); //borra la pantalla
    lcd.printf("   GUARDADOS!");
    Rtc_Ds1307::Time_rtc tm = {};
    tm.min=0;
    tm.sec=0;
    t1=sub*60;
    t2=(sost+sub)*60;
    t3=(sub+sost+baj)*60;
    rtc.setTime(tm, false, false);
    wait(1);
    lcd.cls();
    lcd.printf(" INICIA EL PID");
    wait(1);
    rtc.startClock();
// se imprimen los parches del control  *****************************************
    lcd.cls();
    lcd.printf("Er=%3.0f",err);
    lcd.locate(8,0);
    lcd.printf("Me=%3.0f",med);
    lcd.locate(0,1);
    lcd.printf("Sp=%3.0f",spnum);
    lcd.locate(8,1);
    lcd.printf("tm=%02d",tm.min);
    lcd.printf(":%02d",tm.sec);
    wait(1);

// CICLO PRINCIPAL CONTROLADOR PID
 lop1: 
        rtc.getTime(tm);
        if(c1<t1)
        {
            f=spnum/float(sub*60);
            ref=f*float(c1);
        }
        if((c1>=t1)&&(c1<t2))
        {
            ref=spnum;
        }
        if((c1>=t2)&&(c1<t3))
        {
            f=-spnum/float(baj*60);
            ref=f*float(c1-t2)+spnum;
        }
        if (c1>=t3)
        {
            ref=0;
        }
        med = y.read()*999;
        err = (ref-med);  //se calcula el error
        ap = kpnum*err*0.01f;     //se calcula la accion proporcinal
        ai =(kinum*err*0.01f)+ai;    //calculo de la integral del error
        ad = kdnum*(err-err_v)*0.01f; //calculo de la accion derivativa
        pid = (ap+ai+ad);
        // se verifica que pid sea positivo **************************************
        if(pid<=0)
        {
            pid=0;
        }

        // se verifica que pid sea menor o igual la valor maximo *****************
        if (pid > 999)
        {
            pid=999;
        }
        //contador
        if ((tm.sec==0)&&(tm.min!=0))
        {
            n=n+60;
            wait(1);
        }
        c1=n+tm.sec-60;
        //se muestran las variables******************************************
            lcd.locate(3,0);
            lcd.printf("    ");
            lcd.locate(3,0);
            lcd.printf("%3.0f",err);
            lcd.locate(11,0);
            lcd.printf("   ");
            lcd.locate(11,0);
            lcd.printf("%3.0f",med);
            lcd.locate(3,1);
            lcd.printf("   ");
            lcd.locate(3,1);
            lcd.printf("%3.0f",ref);
            lcd.locate(11,1);
            lcd.printf("   ");
            lcd.locate(11,1);
            lcd.printf("%02d",tm.min);
            lcd.printf(":%02d",tm.sec);
           
            
        

        //Normalizacion de la salida
        // se actualizan las variables *******************************************
        err_v = err;
        o = pid/999;
        u.write(o);
        //  se envia el valor pid a puerto analogico de salida (D/A) **************
        wait(0.1);
        //  se repite el ciclo
        goto lop1;
}
