#ifndef INCLUDED_SBUS_H
#define INCLUDED_SBUS_H

#include "mbed.h"
#include "BufferedSerial.h"

class SBUS {
    public:
        // @parm    tx  communication tx pin
        //          rx  communocation rx pin
        SBUS(PinName tx, PinName rx);
        
        // function of getting stick value
        // @parm    tag stickName
        float getStickValue(int tag);
        
        // function of getting channel value
        // @parm    tag 0-25
        int getChannelValue(int tag);
        
        // checks failsafe timer, returns 1 if data was received in last 100ms, 
        // 0 if there was no data in last 100ms
        int checkFailsafeTimer();
        
        int failSafeTimerMs();
        
        Timer failsafetimer;
    
    private:
        Serial sbus;
        //BufferedSerial sbus;
        
        int sbusMaximumValue;
        int sbusNeutralValue;
        int sbusMinimumValue;
        int sbusDeadband;

        int channel[16];
        int receivedData[50];
        float stickValue[16];
        
        void receiveData();
        
        void decordReceivedData();
        
        void convertReceivedData();
        
        int failsafetime;
        int lastreadtime;
        int reportreadtime;
};

#endif
