#include "mbed.h"
#include "BufferedSerial.h"

#define HOVERSERIAL_BAUD    38400       // [-] Baud rate for HoverSerial (used to communicate with the hoverboard)
#define START_FRAME         0xABCD      // [-] Start frme definition for reliable serial communication
//#define DEBUG_RX                      // [-] Debug received data. Prints all bytes to serial (comment-out to disable)

class HoverSerial {
    public:
        // @parm    tx  communication tx pin
        //          rx  communocation rx pin
        HoverSerial(PinName tx, PinName rx);
        
        typedef struct {                        //Structure for sending data to hoverboard
            uint16_t  start;
            int16_t  steer;
            int16_t  speed;
            uint16_t checksum;
        } SerialCommand;
        SerialCommand Command;

        typedef struct {                       //Structure for feedback from hoverboard
            uint16_t start;
            int16_t   cmd1;
            int16_t   cmd2;
            int16_t   speedR_meas;
            int16_t   speedL_meas;
            int16_t   batVoltage;
            int16_t   boardTemp;
            uint16_t cmdLed;
            uint16_t checksum;
        } SerialFeedback;
        SerialFeedback Feedback;
        SerialFeedback NewFeedback;
        
        void sendData(int16_t uSteer, int16_t uSpeed);
        
        void receiveData();
        
    private:
        BufferedSerial hoverserial;
};