// CONFIGURATION on the hoverboard side in config.h:
// • Option 1: Serial on Left Sensor cable (long wired cable)
//   #define CONTROL_SERIAL_USART2
//   #define FEEDBACK_SERIAL_USART2
//   // #define DEBUG_SERIAL_USART2
// • Option 2: Serial on Right Sensor cable (short wired cable) - recommended, so the ADCs on the other cable are still available
//   #define CONTROL_SERIAL_USART3
//   #define FEEDBACK_SERIAL_USART3
//   // #define DEBUG_SERIAL_USART3
// *******************************************************************

// ########################## INCLUDES ##########################

#include "mbed.h"
#include "hoverserial.h"
#include "BufferedSerial.h"

HoverSerial::HoverSerial(PinName tx, PinName rx) :
hoverserial(tx, rx)

{
    hoverserial.baud(38400);
}

void HoverSerial::sendData(int16_t uSteer, int16_t uSpeed) {
    // Create command
    Command.start    = (uint16_t)START_FRAME;
    Command.steer    = (int16_t)uSteer;
    Command.speed    = (int16_t)uSpeed;
    Command.checksum = (uint16_t)(Command.start ^ Command.steer ^ Command.speed);
    // Write to Serial
    hoverserial.write((uint8_t *) &Command, sizeof(Command));
}

void HoverSerial::receiveData() {
}