#include "TLC5940.h"

int num_drivers = 1;

void setup (SPI &driver, DigitalOut &vprg, DigitalOut &xlat, DigitalOut &blank, DigitalOut &dcprg, PwmOut &gsclk, int num_ics)
{
    xlat = 0;               // hold GS/DC data constant
    blank = 0;
    blank = 1;
    blank = 0;              // Blank (squelch) all outputs
    dcprg = 1;              // dcprg points DC data to DC register.
    vprg = 0;               // sets drivers to GS mode. Set to 1 to change to DC mode
    gsclk.period_us (1);    // set grayscale clock to 1000 Hz
    gsclk = 0.5;            // turn on grayscale clock to 50% duty cycle at afore mentioned frequency
    
    if (num_ics <= 0)
    {
        num_drivers = 1;
    }
    else
    {
        num_drivers = num_ics;
    }
    
    
    driver.format (12,0);
    driver.frequency (30000000);
}


void update_led (SPI &driver, DigitalOut &xlat, DigitalOut &blank, unsigned short* LEDS)
{
    blank = 1;
    blank = 0;
    for (int k = (num_drivers - 1); k >= 0; k--)
    {
        for (int i = (16 - 1); i >= 0; i--)
        {
            driver.write (*(LEDS + k + i));
        }
    }
    xlat = 1;
    xlat = 0;
}