#include "mbed.h"
#include "MODSERIAL.h"

class GPSParser
{
    public:
        
        struct GPS
        {
            float latitude, lat_deg, lat_min, deg_latitude, longitude, long_deg, long_min, deg_longitude, altitude, HDOP, geoidal_sep, AODC, heading, mag_heading, speed_knots, speed_kph;
            char ns, ew, mode;
            int hours, minutes, seconds, m_seconds, fix, sats_used, DGPS_ID;
            unsigned short checksum_gga, checksum_vtg;
        };
    
        struct GPS readings;
        
        
        GPSParser (PinName tx, PinName rx, int baud, int num_sentence, MODSERIAL &pc, PwmOut &indicator);
        
        void process_readings ();
        
        void ready_buffer(MODSERIAL_IRQ_INFO *q);
        /*{
            MODSERIAL *serial = q->serial;
        
            if (serial->rxGetLastChar() == '\n')
                ctr++;
        
            if (ctr == num_sentences)
            {
                read_gps();
                ctr = 0;
            }
        };*/

    protected:
        
        int GLL, RMC, VTG, GGA, GSA, GSV, GRS, GST, MALM, MEPH, MDGP, MDBG, ZDA, MCHN;
        int num_sentences;// = 0;
        volatile int ctr;// = 0;
        int baudrate;
    
        MODSERIAL gps;
        MODSERIAL pc;
        PwmOut indicator;
        

};