/* Gatech ECE2035 2014 FALL missile command
 * Copyright (c) 2014 Gatech ECE2035
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
 
// Template of player header file
#ifndef PLAYER_H
#define PLAYER_H

// Example of some player settings
#define PLAYER_WIDTH   10 
#define PLAYER_HEIGHT  3
#define PLAYER_DELTA   3
#define PLAYER_COLOR   0x0000FF


typedef enum {
    PLAYER_ACTIVE = 1,
    PLAYER_DIED = 0
} PLAYER_STATUS;


typedef struct {
    int timer;
    int is_active;
} PROTECTOR;

typedef struct {
    int x;// the current x of the player, bottom left
    int y;//current y position of the player, bottom left point
    int max_am;
    int am_remain;//how many missile for the player remain
    int life;//his hp remain
    int current_level;
    PLAYER_STATUS status;//if he is dead
    int score;//# of interceptions 
    int protector_num;// number of protector left
    PROTECTOR protector;
    int is_diagnoal;
    int angle;
    int timer;  
} PLAYER;
/** et the information of city
    @brief x and y are the top left corner of the player drawing
    @param x x-coordinate
    @param y y-coordinate
*/



typedef enum {
    DEACTIVE = 0,
    ACTIVE = 1,
    //MISSLE_EXPLODE = 2
} ANTIMISSLE_STATUS;

typedef struct {
    int x;
    int y;
    int speed;
    int tick; //anti missile's internal clock
    ANTIMISSLE_STATUS status;
    int is_diagnoal;
    int angle;
}  ANTIMISSILE;

typedef enum{
    YES = 1,
    NO = 0    
} EXPLOSION_STATUS;

typedef struct{
    int x;
    int y;
    int tick;
    int radius;
    EXPLOSION_STATUS exploded;
    int color;
} EXPLOSION;
    

//initialize the player for the game
void player_init();
void player_draw();
void player_move_left();
void player_move_right();
void antimissile_init();
void shoot();
void update_antimissile_positions();
void draw_antimissiles();
void explosion_init();
void update_explosion();
void draw_explosion();
void update_protector();// update protector status and draw it on the screen
void big_shoot();//shoot all remaining antimissile at random position

//extern PLAYER current_player;
//extern ANTIMISSILE am[5];
//extern EXPLOSION ex[5];
/**
get the currrent player info
*/
PLAYER get_player_info();
#endif //PLAYER_H