/* Gatech ECE2035 2014 FALL missile command
 * Copyright (c) 2014 Gatech ECE2035
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifndef CITY_LANDSCAPE_PRIVATE_H
#define CITY_LANDSCAPE_PRIVATE_H

#include "mbed.h"
#include "uLCD_4DGL.h"
#include "globals.h"
#include "city_landscape_public.h"

//==== [private type] ====
// N/A



//==== [private function] ====
// N/A



//==== [private macros] ====
// The bottom of the screen => y=127
// Gut the landscape grow up from the bottom of the screen. It is awkward.
// Thus, we use a macro to reverse the coordinate for convenience.
#define REVERSE_Y(x) (SIZE_Y-(x))

//==== [private settings] ====
// You could modify these settings, but try to keep them be used only inside city_landscape.cpp
// Here are the settings to define the looking of your city landscape
#define CITY_TO_SCREEN_MARGIN 25 // pixel on the screen
#define CITY_WIDTH 10 // pixel on the screen
#define BUILDING_WIDTH 2 // pixel on the screen
#define NUM_BUILDING (CITY_WIDTH/BUILDING_WIDTH)
#define BUILDING_COLOR 0x00FF00
//#define LANDSCAPE_COLOR 0xCCAA00





#endif //CITY_LANDSCAPE_PRIVATE_H