/* Gatech ECE2035 2014 FALL missile command
 * Copyright (c) 2014 Gatech ECE2035
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
/** @file missile_public.h */
#ifndef MISSILE_PUBLIC_H
#define MISSILE_PUBLIC_H

///The missile status
typedef enum {
    MISSILE_EXPLODED=2,///<missile has been destroyed
    MISSILE_ACTIVE=1,///<missile is active
    MISSILE_DEACTIVE=0///<missile is no longer active
} MISSILE_STATUS;

/// The structure to store the information of a missile
typedef struct {
    int x;                   ///< The x-coordinate of missile current position
    int y;                   ///< The y-coordinate of missile current position
    double source_x;           ///< The x-coordinate of the missile's origin
    double target_x;           ///< The x-coordinate of the missile's target
    int tick;                  ///< The missile's internal tick
    MISSILE_STATUS status;   ///< The missile status, see MISSILE_STATUS
} MISSILE;


#define MAX_NUM_MISSILE  5

//MISSILE missile_record[MAX_NUM_MISSILE];

/** This function draw the missiles onto the screen
    Call missile_generator() repeatedly in your game-loop. ex: main()
*/
void missile_generator(void);

/** The function set the status of missile to be MISSILE_EXPLODED
    @param index The index in missile_record. It must be smaller than MAX_NUM_MISSILE.
*/
void missile_set_exploded(int index);

/** Get the information of a missile
    @param index The index in missile_record. It must be smaller than MAX_NUM_MISSILE.
    @return The structure of missile information
*/
MISSILE missile_get_info(int index);

/** Set the speed of missiles, Speed has range of 1-8 with 1 being fastest and 8 being slowest
*/
void set_missile_speed(int speed);

/** Set the interval that the missiles fire, interval has range of 1-100 with 1 being fired in
    very quick succession and 100 being fired very slowly after one another
*/
void set_missile_interval(int interval);

#endif //MISSILE_PUBLIC_H