/* Gatech ECE2035 2014 FALL missile command
 * Copyright (c) 2014 Gatech ECE2035
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

// Template of player implementation
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "globals.h"
#include "player.h"
#include <math.h>

// Example of drawing the player

void player_init() {
    current_player.x = 60;
    current_player.y = 100;
    current_player.am_remain = 5;
    current_player.max_am = 5;
    current_player.status = PLAYER_ACTIVE;
    current_player.score = 0;
    current_player.current_level = 0;
    current_player.life = 1;//inital 1 hp  
    current_player.protector_num = 3; 
    current_player.is_diagnoal = 0;
    current_player.timer = 0; 
}

void update_protector() {
    if (current_player.protector.is_active) {
        current_player.protector.timer++;
        uLCD.line(0, 80, 128, 80, WHITE);
        int i,k;
        for (i = 0; i < MAX_NUM_MISSILE; i++) {
            if (missile_record[i].status == MISSILE_ACTIVE && missile_record[i].y < 80) {
                for (k = 0; k < current_player.max_am; k++) {
                    if (ex[k].exploded == NO) {
                        //find a unused explosion activate it
                        ex[k].x = missile_record[i].x;
                        ex[k].y = missile_record[i].y;
                        ex[k].exploded = YES;
                        ex[k].color = WHITE;
                        break;   
                    }    
                }
                missile_record[i].status = MISSILE_EXPLODED;
            }
        }
        if (current_player.protector.timer == 10) {
            current_player.protector.is_active = 0;
            uLCD.line(0, 80, 128, 80, BACKGROUND_COLOR);
        }
    }    
}

void explosion_init() {
       int i;
        for (i = 0; i < current_player.max_am;i++) {
            ex[i].x = 0;
            ex[i].y  = 0;
            ex[i].tick = 0;
            ex[i].radius = 3;
            ex[i].exploded = NO;
            ex[i].color = PLAYER_COLOR;   
    }     
}

void update_explosion() {
    int i;
    for (i = 0;i < current_player.max_am;i++) {
        if (ex[i].exploded == YES) {
            ex[i].tick++;
            uLCD.circle(ex[i].x, ex[i].y, ex[i].radius - 2, BACKGROUND_COLOR);
            uLCD.circle(ex[i].x, ex[i].y, ex[i].radius, BACKGROUND_COLOR);
            draw_landscape();
            if (ex[i].tick <= 5) {
                ex[i].radius = ex[i].radius + 2;
            } else {
                ex[i].tick = 0;
                ex[i].radius = 0;
                ex[i].exploded = NO;
            }
        }
    }
}

void draw_explosion() {
    int i;
    for (i = 0;i < current_player.max_am;i++) {
        if (ex[i].exploded == YES) {
            uLCD.circle(ex[i].x, ex[i].y, ex[i].radius - 2, ex[i].color);
            uLCD.circle(ex[i].x, ex[i].y, ex[i].radius, ex[i].color);    
        }    
    } 
}

void antimissile_init() {
    int i;
    for (i = 0; i < current_player.max_am;i++) {
        am[i].x = current_player.x;
        am[i].y = current_player.y;
        am[i].speed = 5;
        am[i].tick = 0;
        am[i].status = DEACTIVE;
    }    
}
//(x,y) is the top left corner 
void player_draw() {
   int x = current_player.x;
   int y = current_player.y;
   uLCD.filled_rectangle(x - 5, y, x- 5 + PLAYER_WIDTH, y+PLAYER_HEIGHT, PLAYER_COLOR);
   uLCD.line(x - 5, y - 3, x  - 5, y + PLAYER_HEIGHT + 3, PLAYER_COLOR);
   uLCD.line(x- 5 + PLAYER_WIDTH, y - 3, x- 5 + PLAYER_WIDTH, y + PLAYER_HEIGHT + 3, PLAYER_COLOR);
   uLCD.line(x, y - 3, x, y + PLAYER_HEIGHT + 3, PLAYER_COLOR); 
    //uLCD.filled_rectangle(x+PLAYER_DELTA, y-PLAYER_DELTA, x+PLAYER_WIDTH-PLAYER_DELTA, y+PLAYER_HEIGHT, PLAYER_COLOR);  
}

void player_move_left() {
     int x = current_player.x;
     int y = current_player.y;
    uLCD.filled_rectangle(x - 5, y, x- 5 + PLAYER_WIDTH, y+PLAYER_HEIGHT, BACKGROUND_COLOR);
    uLCD.line(x - 5, y - 3, x  - 5, y + PLAYER_HEIGHT + 3, BACKGROUND_COLOR);
    uLCD.line(x- 5 + PLAYER_WIDTH, y - 3, x- 5 + PLAYER_WIDTH, y + PLAYER_HEIGHT + 3, BACKGROUND_COLOR);
    uLCD.line(x, y - 3, x, y + PLAYER_HEIGHT + 3, BACKGROUND_COLOR); 
    if (current_player.x - PLAYER_DELTA > 0 && !current_player.is_diagnoal) {
        current_player.x = current_player.x - PLAYER_DELTA;    
    } 
}

void player_move_right() {
    int x = current_player.x;
    int y = current_player.y;
    uLCD.filled_rectangle(x - 5, y, x- 5 + PLAYER_WIDTH, y+PLAYER_HEIGHT, BACKGROUND_COLOR);
    uLCD.line(x - 5, y - 3, x  - 5, y + PLAYER_HEIGHT + 3, BACKGROUND_COLOR);
    uLCD.line(x- 5 + PLAYER_WIDTH, y - 3, x- 5 + PLAYER_WIDTH, y + PLAYER_HEIGHT + 3, BACKGROUND_COLOR);
    uLCD.line(x, y - 3, x, y + PLAYER_HEIGHT + 3, BACKGROUND_COLOR); 
    if(current_player.x + PLAYER_DELTA < 126) {
        current_player.x = current_player.x + PLAYER_DELTA;
    }
}

PLAYER get_player_info() {
    return current_player;
}

//find a available antimissile and set it active 
void shoot() {
    int i;
    if (current_player.am_remain > 0) {
            for(i = 0; i < current_player.max_am; i++) {
                if (am[i].status == DEACTIVE) {
                     am[i].status = ACTIVE;
                     am[i].x = current_player.x;
                     am[i].y = current_player.y;
                     am[i].speed = 5; // need to be improved
                     am[i].tick = 0;
                     am[i].is_diagnoal = current_player.is_diagnoal;
                     current_player.am_remain--;
                     break;
                 }
            }
    }    
}

void big_shoot() {
    int i, count = 0;
    if (current_player.am_remain > 0) {
        for(i = 0; i < current_player.max_am; i++) {
            if (am[i].status == DEACTIVE) {
             count++;
             am[i].status = ACTIVE;
             am[i].x = (current_player.x * 2 + count * 32) % 128 ;
             am[i].y = 100;
             am[i].speed = 5; 
             am[i].tick = 0;
             am[i].is_diagnoal = current_player.is_diagnoal;
             current_player.am_remain--;
            }
        }    
    }    
}
//update all active missiles position 
void update_antimissile_positions() {
        int i, rate;
        for(i = 0; i < current_player.max_am;i++) {
            if(am[i].status == ACTIVE) {
                   am[i].tick++;
                   rate = 5 / am[i].speed;
                   if (am[i].y - 2 <= 0) {
                        //when the missile flies out of the screen
                        am[i].status = DEACTIVE;
                        uLCD.line(am[i].x, am[i].y, am[i].x, 100, BACKGROUND_COLOR);
                        am[i].y = current_player.y;
                        am[i].x = current_player.x;
                        current_player.am_remain++;
                           
                    } else if (am[i].tick % rate == 0) {
                        uLCD.line(am[i].x, am[i].y, am[i].x, 100, BACKGROUND_COLOR);
                        am[i].y = am[i].y - 2;
                    }
                    
            }
        }
}
//find all active antimissiles and draw their current position
void draw_antimissiles() {
    int i;
    for(i = 0; i < current_player.max_am;i++) {
        if (am[i].status == ACTIVE ) {
            uLCD.line(am[i].x, am[i].y, am[i].x, 100, PLAYER_COLOR);
        }
    }
}



// ... You need to implement your own functions for player ...


