/* Gatech ECE2035 2014 FALL missile command
 * Copyright (c) 2014 Gatech ECE2035
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
/** @file city_landscape_public.h */
#ifndef CITY_LANDSCAPE_PUBLIC_H
#define CITY_LANDSCAPE_PUBLIC_H
#define LANDSCAPE_COLOR 0xCCAA00

/// The enum define the status of a city
typedef enum {
    EXIST=1,      ///< The city will be shown on screen
    DESTROYED=0   ///< The city won't be shown on screen
} CITY_STATUS;

/// The structure to store the information of a city
typedef struct {
    int x;        ///< Bottom-left corner of the city. x coordinate on the screen.
    int y;        ///< Bottom-left corner of the city. y coordinate on the screen.
    int width;    ///< The width of the city. The shape of the city is an rectangle.
    int height;   ///< The height of the city
    CITY_STATUS status;  ///< See enum CITY_STATUS
} CITY;

#define MAX_NUM_CITY 6

/** Call city_landscape_init() once at the begining of your code
    @brief It initialize the city data structure and draw the cities.
    @param num_city number of city to be draw. It must be less/equal to MAX_NUM_CITY.
*/
void city_landscape_init(int num_city);

/** Get the information of city
    @param index The index in city_record. It must be smaller than MAX_NUM_CITY.
    @return The structure of city information
*/
CITY city_get_info(int index);

/** Remove the city from its record and the screen
    @param index The index in city_record. It must be smaller than MAX_NUM_CITY.
*/
void city_destroy(int index);

/** Draw all exist cities on the screen
    @brief You might not need to use this function, but you could still use it if you want.
*/
void draw_cities(void);

/** Draw the landscape
    @brief You might not need to use this function, but you could still use it if you want.
*/
void draw_landscape(void);

int is_any_left();


#endif //CITY_LANDSCAPE_H