#include "mbed.h"
#include "DHT11.h"

//Tested with success on DISCO-L475VG-IOT01A
//if you find target DISCO-L475VG-IOT01A not found, try to delete mbed library then import it again.

InterruptIn mybutton(USER_BUTTON);
Serial pc(SERIAL_TX, SERIAL_RX); 

DHT11 dht(A0);

int main() {
    pc.printf("\r\nDHT11 Reader example"); 
    pc.printf("\r\n===================="); 
    pc.printf("\r\nPress blue user button to read DHT1\r\n"); 
    while(1) {
        if(mybutton == 0){ 
            pc.printf("\r\nmybutton pressed!");
            if(dht.readData() < 0){
                pc.printf("\r\nError while reading");
            }
            else{
                pc.printf("\r\nReading DHT11 from A0");
                pc.printf("\r\nTemperature: %d ",dht.getTemperature());
                pc.printf("\r\nHumidity: %d \r\n",dht.getHumidity());
            }
            
        } 
    }
}
