#include "mbed.h"
#include "GPS.h"
#include "HMC5883L.h"

Serial pc(SERIAL_TX, SERIAL_RX);
GPS ark(PA_9, PA_10);
DigitalOut myled(LED1);
HMC5883L compass(D14, D15);
 
int main()
{
     pc.baud(9600);
     pc.printf("l");  
    int16_t data[3] = {0};
    double heading = 0.0f;  
    
    compass.init();
    while(1) 
    {
        compass.getXYZ(data);
        wait(0.1f);
        heading = compass.getHeadingXYDeg();
        pc.printf("x: %4d, y: %4d, z: %4d\r\n", data[0], data[1], data[2]);
        pc.printf("heading: %0.2f\r\n", heading);
        wait(1.0f);
           
        if( ark.sample() == 1) 
        {
            myled=0;
            float latitude = ark.latitude;
            float longitude = ark.longitude;
            float latitudeB = ark.latitudeB;
            float longitudeA = ark.longitudeA;
            float utc = ark.utc + 50000;
            pc.printf("latitude: %0.6f, longitude: %0.6f, latitudeRAW: %0.6f, longitudeRAW: %0.6f, utc: %f\r\n",latitude,longitude,latitudeB,longitudeA,utc);                     
            wait(1);
        } 
        else 
        {
            myled=1;
        }
    }
}


 