#include "mbed.h"
#include <vector>
#include <list>
#include <algorithm>

class NetworkNode{
private:
    std::vector<uint8_t> addr; //16 bit network address vector
    std::vector<uint8_t> addr64; //64 bit network address vector
    int nodeNum; //index
    int x; //x coordinate
    int y; //y coordinate
    int heading; //heading
public:
    NetworkNode(std::vector<uint8_t> & addrIn, int indexIn);
    //constructor
    
    NetworkNode(std::vector<uint8_t> & addrIn, std::vector<uint8_t> & addr64In,int indexIn);
    //constructor including 64 bit address
    
    std::vector<uint8_t> getAddr();
    //returns address
    
    std::vector<uint8_t> getAddr64();
    //returns 64 bit address
    
    int getIndex();
    //returns index
    
    int getX();
    //returns x coordinate
    
    int getY();
    //returns y coordinate
    
    int getHeading();
    //returns heading
    
    void setCoordinates(int x_in, int y_in, int heading_in);
    //sets coordinates
    
    void setAddr(std::vector<uint8_t> & addrIn);
    //sets address
    
    void setIndex(int indexIn);
    //sets index
};


class XBee_Robot {
private:

    std::vector< vector <int> > obstacles; // 2D vector to hold positions of obstacles 
    
    int currentIndex; //current index of NetworkNode for received packet, allows coordinates to be updated

    std::vector< NetworkNode > node_list; //list of network nodes
    
    Serial dataLink; //declare global serial
    
    int commandX; // x coordinate received as commanded by the coordinator
    
    int commandY; //y coordinate received as commanded by the coordinator
    
    int commandFlag; // flag that indicates if coordinates from the coordinator have been received
    
    int finishedFlag; // flag that indictates if the router robots have finished their journey (coordinator use only)
    
public:
    
    XBee_Robot(PinName _txIn, PinName _rxIn);
    //constructor for XBee
    
    void Rx_interrupt();
    //ISR for receive pin
    
    void transmitRequest(uint8_t *BitAddress64, uint8_t *BitAddress16, uint8_t broadcastRadius, uint8_t options, uint8_t *data,size_t dataLength);
    //assembles and sends transmission requests
    
    void ATQuery(uint8_t ATu, uint8_t ATl);
    //assembled and sends AT requests with no data byte in order to query the AT configuration of the XBee
    
    uint8_t calculateChecksum(std::vector<uint8_t> & packet);
    //calculates checksum for assembled packets
    
    void RxPacketControl(std::vector<uint8_t> & packet);
    //seperates packets depending on API command
    
    void checkSourceAddr(std::vector<uint8_t> & addr, std::vector<uint8_t> & addr64);
    //checks 16 bit source address of received packet against list of known addresses and adds new addresses (16 and 64 bit)
    
    void checkSourceAddr(std::vector<uint8_t> & addr);
    //checks 16 bit source address of received packet against list of known addresses and adds new addresses (16 bit only)
    
    void RxDataHandler(std::vector<uint8_t> & packet);
    //handles received data based on data command
    
    int getCommandX();
    //used by main program to extract received command coordinates
    
    int getCommandY();
    //used by main program to extract received command coordinates
    
    int getCommandFlag();
    //used by main program to poll command flag
    
    int getFinishedFlag();
    //used by main program to poll finished flag (coordinator use only)
    
    void resetFinishedFlag();
    //used by main program to reset finished flag (coordinator use only)
    
    void resetCommandFlag();
    //used by main program to reset command flag
    
    int checkObstacle(int x_in, int y_in);
    //used by main program to check if an obstacle exists at given coordinates (coordinator use only)

    int convSigned(int int_in);
    //used to convert unsigned 8 bit integers to signed integers
};
