#include "Prox.h"

Prox::Prox(PinName sda, PinName scl) { 
    _sda = sda;
    _scl = scl;

    WriteByte(0x72,0xE7); // Clear interrupt
    
    char PTIME;
    char WTIME;
    char PPULSE;

    WTIME = 0xff; // 2.7 ms - minimum Wait time
    PTIME = 0xff; // 2.7 ms - minimum Prox integration time
    PPULSE = 1; // Minimum prox pulse count
 
    WriteByte(0x72, 0, 0); //Disable and Powerdown
    WriteByte (0x72, 2, PTIME);
    WriteByte (0x72, 3, WTIME);
    WriteByte (0x72, 0xe, PPULSE);
    
    char PIHTL, PIHTH; //Upper interrupt threshold low and high bytes
    
    PIHTL = 0x01;
    PIHTH = 0x01; //trigger at 256
    
    WriteByte (0x72, 0x0A, PIHTL);
    WriteByte (0x72, 0x0B, PIHTH);
    
    char PDRIVE;
    char PDIODE;
    char PGAIN;
    
    PDRIVE = 0; //100mA of LED Power
    PDIODE = 0x20; // CH1 Diode
    PGAIN = 0x08; //4x Prox gain

    WriteByte (0x72, 0xf, PDRIVE | PDIODE | PGAIN );

    char WEN, PEN, PON, PIEN;
    WEN = 8; // Enable Wait
    PIEN = 32; //Enable interrupt
    PEN = 4; // Enable Prox
    PON = 1; // Enable Power On

    WriteByte (0x72, 0, WEN | PIEN | PEN | PON);
    
    wait(0.12); //Wait for 120 ms
}




uint16_t Prox::readProx(){
    WriteByte (0x72, 0xE7); //clear interrupt pin (untested)
    uint16_t prox;
    ReadWord(0x72, 0x18, &prox);
    return prox;
}
 




// Read a byte on the i2c interface

void Prox::ReadWord(char addr, char reg, uint16_t *data) {
  I2C i2c(_sda,_scl);
  char reg1 = 0xA0 | reg;
  char reading[2];
  i2c.write(addr,&reg1,1);
  i2c.read(addr,reading,2);
  *data = reading[0] | (reading[1]<<8);
  wait(0.07);
}

void Prox::ReadByte(char addr, char reg, char *bytedata) {
  I2C i2c(_sda,_scl);
  char tempdata;
  char reg1 = 0x80 | reg;
  i2c.write(addr,&reg1,1);
  i2c.read(addr,&tempdata,1);
  *bytedata = tempdata;
  wait(0.07);
}



// Write a byte on the i2c interface

void Prox::WriteByte(uint8_t addr, uint8_t reg, char data) {
    I2C i2c(_sda,_scl);
    char data1[2];
    data1[0] = 0x80 | reg;
    data1[1] = data;
    i2c.write(addr,data1,2);
    wait(0.07);

}

void Prox::WriteByte(uint8_t addr, uint8_t reg) {
    I2C i2c(_sda,_scl);
    char data1;
    data1 = 0x80 | reg;
    i2c.write(addr,&data1,1);
    wait(0.07);

}