#include "mbed.h"
#include "m3pi.h"

class Navigate_Pololu{
    
private:
const float PI = 3.14159f; //declare constants for pi and 2pi
const float TWO_PI = PI * 2.0f;
float distancePerCount;
float radiansPerCount;
float X;
float Y;
float heading;
int previousLeftCounts;
int previousRightCounts;
float deltaDistance;
float deltaX;
float deltaY;
int leftCounts;
int rightCounts;
int deltaLeft;
int deltaRight;
float deltaHeading;
InterruptIn leftOpto;
InterruptIn rightOpto;

public:

m3pi robot; //create robot object, make it public so it can be accessed by main program

Navigate_Pololu(PinName leftIn, PinName rightIn, int countsPerRevolution, float wheelDiameter, float trackWidth,PinName robotTx, PinName robotRx);
//constuctor

void leftWheelInterrupt();
//IRQ for left wheel sensor

void rightWheelInterrupt();
//IRQ for right wheel sensor

void UpdatePosition();
//Updates position based on wheel counts
int getX();
//returns x coordinate

int getY();
//returns y coordinate

int getHeading();
//returns heading

void calibratePos();
//aligns wheels

void resetCoordinates();
//resets X and Y coordinates
};