#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#define DELTA_Y 3
#define DELTA_X 3
#define DELTA_X_P 2
#define COVER_COLOR 0xf0c890
#define H_32 32
#define H_16 16
#define STATE_START 0
#define STATE_GAME 1
#define STATE_LOSE 2
#define STATE_SCORE 4
#define MOVE_LEFT 1
#define MOVE_RIGHT 2
#define MOVE_UP 4
#define MOVE_DOWN 8

class Entity {
    private:
    public:
    //y position of an entity (in pixels)
    int row;
    //x position of an entity (in pixels)
    int col;
    
    };
class Cursor : public Entity {
    public:
    //size of the s by s square cursor
    int s;
    //space that the cursor will move when the joystick is pressed left or right
    int delta_x;
    //space that the cursor will move when the joystick is pressed up or down
    int delta_y;
    //buffer that will contain the initials for a new high score
    char initBuf[3];
    int c;
    //flag to see if the user moved the cursor
    bool hasMoved;
    //flag to see if the user has pressed the fire button on the high score screen
    bool letterPressed;
    //numerical value assoicated with a particular movement
    int moveFlag;
    //the last letter that the cursor selected on letterPressed
    char curChar;
    //default no-arg constructor
    Cursor(void);
    //function to draw the cursor on screen
    void draw(uLCD_4DGL *u);
    //function to cover up the previous position of the cursor
    void coverUp(uLCD_4DGL *u);
};
class Player : public Entity {
    public:
    //Width of the p;ayer in pixels
    int w;
    //Height of the player in pixels
    int h;
    //(deprecated) color of the player in RGB
    int color;
    //default no-arg constructor
    Player(void);
    //flag to see if the user has moved using the joystick
    bool hasMoved;
    //flag to see if the user is jumping
    bool isJumping;
    //flag to see if the user is falling
    bool isFalling;
    //Used to keep track of how long until the player reaches the apex of the jump
    int upCounter; 
    //Used to check how long until the player lands
    int fallCounter; 
    //value representing some movement of direction
    int moveFlag;
};
class Obstacle : public Entity {
    public:
    //(deprecated) color of the obstacle in RGB
    int color;
    //width of the obstacle in pixels
    int w;
    //height of the obstacle in pixels
    int h;
    //default constructor; color input variable is deprecated
    Obstacle(int c);
};
class Counter : public Entity {
};
class Screen {
private:
public:
//(deprecated) sector address of the screen's background
int bgAddr;
//current position, on or off-screen, in pixels
int pos;
//
void drawScreen(void);
//increase the position values of each object and screen, so that they appear to be moving
void decScreen(void);
//default constructor
Screen(int bg, int initPos);
//main constructor, though the boolean flag serves no purpose and should be removed
Screen(int bg, bool randomSpots, int initPos);
//the 4 cactus obstacles associated with this screen
Obstacle *obs[4];
//Class destructor.  Needed to delete both the screen and its associated obstacle objects
~Screen(void);
};
//(Deprecated) draw the rectangles of the obstacles while also checking if they are on-screen
void DrawIfOnScreen(Obstacle *o, uLCD_4DGL *u);
//draw the cactus image for each obstacle, also checking if any part of the obstacle is off-screen, and drawing the appropriate image if so
void DrawSliceBySlice(Obstacle *o, uLCD_4DGL *u);
//Draw a filled rectangle with the background color to hide the pixels of the previous position of an object
void DrawCoverUp(int row, int col, int w, int h, uLCD_4DGL *u);
//Check if any screens are now past the player, and rearrange the screens if so
void evalScreens(Screen **s);
//draw all objects associated with a screen
void drawScreens(uLCD_4DGL *u, Screen **s);
//draw the player sprite
void drawPlayer(uLCD_4DGL *u, Player *p);
//(deprecated) draw the cover up rectangle for x-axis movement of the player
void drawPlayerCoverUp(uLCD_4DGL *u, Player *p);
//Draw the cover up rectangle for x-axis movement of the player
void drawPlayerCoverUp(uLCD_4DGL *u, Player *p, int dir);
//draw the cover up rectangle for y-axis movement of the player
void drawPlayerAirborneCoverUp(uLCD_4DGL *u, Player *p);
//Cover up the small square that occurs if the user moves diagonally
void drawPlayerDiagCoverUp(uLCD_4DGL *u, Player *p);
//Draw the sun and any other background objects
void drawScenery(uLCD_4DGL *u);
//Collision Detection
//check a collision on the top-right corner of the player
bool detectTR(Obstacle *o,Player *p);
//check a collision on the bottom-left corner of the player
bool detectBL(Obstacle *o,Player *p);
//check a collision on the bottom-right corner of the player
bool detectBR(Obstacle *o,Player *p);
//check a collision on the top-left corner of the player
bool detectTL(Obstacle *o, Player *p);
//main function for collision detection; runs previous four functions and sets appropriate flags
void CollisionDetect(Screen **s, Player *p,bool *flag);
//draw the score counter on the right side of the screen
void drawScore(uLCD_4DGL *u, int score);
//Reset flags and other objects for a new game
void initialize(Screen **s, Player *p, int *score, bool* initFlash, bool *scDrawn, bool *collide, int *c, int *r, Cursor *curs);