#include "entity.h"
void evalScreens(Screen **s) {
    if((*s[1]).pos > 127) {
        //delete screen, shift old screen 1 to screen 0, create new screen 1
        delete s[1];
        s[1] = s[0];
        //s[0] = new Screen(0x780D, -127);
        s[0] = new Screen(0x780D, true,-127);
    }
    (*s[0]).decScreen();
    (*s[1]).decScreen();
}
void drawScreens(uLCD_4DGL *u, Screen **s) {
    //Only draw left-most screen objects if it is not in its initial position 
    if((*s[0]).pos > -127) {
        //overwrite previous location of blocks with bg color
        for(int j = 0;j<=3;j++) {
            DrawCoverUp((*(*s[0]).obs[j]).row, (*(*s[0]).obs[j]).col - DELTA_X,(*(*s[0]).obs[j]).w - 1,(*(*s[0]).obs[j]).h - 1,u);
        }
        //draw obstacles in new positions
        DrawSliceBySlice((*s[0]).obs[0], u);
        DrawSliceBySlice((*s[0]).obs[1], u);
        DrawSliceBySlice((*s[0]).obs[2], u);
        DrawSliceBySlice((*s[0]).obs[3], u);
    }
    //Since s[1] is always on-screen, draw its objects and any necessary cover-up boxes
    for(int i = 0;i<=3;i++) {
        DrawCoverUp((*(*s[1]).obs[i]).row, (*(*s[1]).obs[i]).col - DELTA_X,(*(*s[1]).obs[i]).w - 1, (*(*s[1]).obs[i]).h - 1,u);
    }
    //draw blocks in new positions
    DrawSliceBySlice((*s[1]).obs[0], u);
    DrawSliceBySlice((*s[1]).obs[1], u);
    DrawSliceBySlice((*s[1]).obs[2], u);
    DrawSliceBySlice((*s[1]).obs[3], u);
}
void drawPlayer(uLCD_4DGL *u, Player *p) {
    //(*u).filled_rectangle((*p).col,(*p).row,(*p).col + 15,(*p).row + 31, (*p).color);
    if((*p).isJumping) {
        (*u).set_sector_address(0x001D, 0x78A5);
    //set jumping sector
    } else if((*p).isFalling) {
        (*u).set_sector_address(0x001D, 0x78A2);
    //set falling sector
    } else {
        (*u).set_sector_address(0x001D, 0x78A8);
    }
    //set neutral sector
    (*u).display_image((*p).col, (*p).row);
}
void drawPlayerCoverUp(uLCD_4DGL *u, Player *p) {
    //(*u).filled_rectangle((*p).col - (((*p).moveFlag & 2) >> 1) + ((*p).moveFlag & 1),(*p).row,(*p).col + 15,(*p).row + 31, 0x000000);
    (*u).filled_rectangle((*p).col - (DELTA_X_P * (((*p).moveFlag & 2) >> 1)) + (((*p).w * ((*p).moveFlag & 1)) + 0),(*p).row,(*p).col - (1 * (((*p).moveFlag & 2) >> 1)) + ((16 * ((*p).moveFlag & 1)) + (DELTA_X_P * ((*p).moveFlag & 1))),(*p).row + 31, COVER_COLOR);
}
void drawPlayerCoverUp(uLCD_4DGL *u, Player *p, int dir) {
    if((*p).moveFlag == MOVE_RIGHT) {
        (*u).filled_rectangle((*p).col - DELTA_X_P - 1,(*p).row,(*p).col - 1,(*p).row + (*p).h - 1,COVER_COLOR);
    }
    if((*p).moveFlag == MOVE_LEFT) {
        (*u).filled_rectangle((*p).col + (*p).w,(*p).row,(*p).col + (*p).w + DELTA_X_P + 1,(*p).row + (*p).h - 1,COVER_COLOR);
    }
}
/*void drawPlayerAirborneCoverUp(uLCD_4DGL *u, Player *p) {
    (*u).filled_rectangle((*p).col, (*p).row - (((*p).isFalling && ((*p).fallCounter >= 0)) ? DELTA_Y : 0) + 
    (((*p).isJumping && ((*p).upCounter >= 0)) ? 32 : 0),(*p).col + 15, (*p).row - (((*p).isFalling && ((*p).fallCounter >= 0)) ? 1 : 0) + 
    (((*p).isJumping && ((*p).upCounter >= 0)) ? 32 + DELTA_Y : 0), COVER_COLOR);
}*/
void drawPlayerAirborneCoverUp(uLCD_4DGL *u, Player *p) {
    if((*p).isJumping) {
        //draw a cover-up box below the player
        (*u).filled_rectangle((*p).col,(*p).row + (*p).h,(*p).col + (*p).w - 1,(*p).row + (*p).h + DELTA_Y,COVER_COLOR);
    }
    if((*p).isFalling) {
        //draw a cover-up box above the player
        (*u).filled_rectangle((*p).col,(*p).row - DELTA_Y - 1, (*p).col + (*p).w - 1, (*p).row - 1,COVER_COLOR);
    }
}
void drawPlayerDiagCoverUp(uLCD_4DGL *u, Player *p) {
    if((*p).isJumping) {
        if((*p).moveFlag == MOVE_RIGHT) {
            (*u).filled_rectangle((*p).col - DELTA_X_P,(*p).row + (*p).h, (*p).col - 1, (*p).row + (*p).h +DELTA_Y - 1, COVER_COLOR);
        }
        if((*p).moveFlag == MOVE_LEFT) {
            (*u).filled_rectangle((*p).col + (*p).w,(*p).row + (*p).h, (*p).col + (*p).w + DELTA_X_P - 1, (*p).row + (*p).h + DELTA_Y - 1, COVER_COLOR);
        }
    }
    if((*p).isFalling) {
        if((*p).moveFlag == MOVE_RIGHT) {
            (*u).filled_rectangle((*p).col - DELTA_X_P,(*p).row - DELTA_Y,(*p).col - 1, (*p).row - 1,COVER_COLOR);
        }
        if((*p).moveFlag == MOVE_LEFT) {
            (*u).filled_rectangle((*p).col + (*p).w, (*p).row - DELTA_Y, (*p).col + (*p).w + DELTA_X_P - 1, (*p).row - 1, COVER_COLOR);
        }
    }
}
void DrawIfOnScreen(Obstacle *o, uLCD_4DGL *u) {
    if(((*o).col >= 0) || (((*o).col + (*o).w - 1) > 0)) { //If entity is on-screen
        if((*o).col < 0) {
            (*u).filled_rectangle(0,(*o).row,(*o).w - 1 + (*o).col,(*o).row + (*o).h - 1,(*o).color);//If left side is not on screen
        } else if(((*o).col + 15) > 127) {
            (*u).filled_rectangle((*o).col,(*o).row,127,(*o).row + (*o).h - 1,(*o).color);//Else if right side not on screen
        } else {
            (*u).filled_rectangle((*o).col,(*o).row,(*o).col + (*o).w - 1,(*o).row + (*o).h - 1,(*o).color); //Else all of the entity is on the screen 
        }
    } 
}
void DrawSliceBySlice(Obstacle *o, uLCD_4DGL *u) {
    /*for(int i = 0; i<=15;i++) {
        if((*o).col + i > 0 && (*o).col + i <= 127) {
            (*u).set_sector_address(0x001D, 0x788F + i);
            (*u).display_image((*o).col + i, (*o).row);
        }
    }*/
             //(*u).set_sector_address(0x001D, 0x789F);
            //(*u).display_image((*o).col, (*o).row); 
            
        if(((*o).col >= 0) || (((*o).col + (*o).w - 1) > 0)) { //If entity is on-screen
        if((*o).col < 0) { //If the left side is off-screen
            //set sector for particular slice
            if((*o).w + (*o).col - 2 < 8) {
                //+1 addition to pick sector
                (*u).set_sector_address(0x001D, 0x78AB + (*o).w + (*o).col - 2);
            } else {
                //+2 addition to pick sector
                (*u).set_sector_address(0x001D, 0x78B4 + ((((*o).w + (*o).col - 2) % 8) * 2));
               
            }
            //draw the object
            (*u).display_image(0, (*o).row); 
        } else if(((*o).col + 15) > 127) { //If the right side is off-screen
            if(127 - (*o).col < 8) {
                //-1 to pick sector
                (*u).set_sector_address(0x001D,0x78D8 - ((127 - (*o).col) % 8));
            } else {
                //-2 to pick sector
                (*u).set_sector_address(0x001D,0x78D2 - (((127 - (*o).col) % 8) * 2));
            }
            //draw the object
            (*u).display_image((*o).col, (*o).row); 
        } else { //Otherwise the entire object is on-screen
            (*u).set_sector_address(0x001D, 0x789F);
            (*u).display_image((*o).col, (*o).row); 
        }
    }   
}
void DrawCoverUp(int row, int col, int w, int h, uLCD_4DGL *u) {
    if((col >= 0) || ((col + w) > 0)) { //If entity is on-screen
        if(col < 0) {
            //(*u).filled_rectangle(0,row,15+col,row + 15,0x000000);//If left side is not on screen
        } else if((col + w) > 127) {
            (*u).filled_rectangle(col,row,col + DELTA_X - 1,row + h,COVER_COLOR);//Else if right side not on screen
        } else {
            (*u).filled_rectangle(col,row,col + DELTA_X - 1,row + h,COVER_COLOR); //Else all of the entity is on the screen 
        }
    } 
}
void drawScenery(uLCD_4DGL *u) {
    (*u).filled_rectangle(0,0,127,7,0xf09860);
    (*u).filled_rectangle(0,8,127,15,0xf0a870);
    (*u).filled_rectangle(0,16,127,23,0xf0b880);
    (*u).filled_rectangle(0,24,127,31,0xf0c890);
    (*u).set_sector_address(0x001D,0x791A);
    (*u).display_image(0,0);
}
void drawScore(uLCD_4DGL *u, int score) {
char scoreChar[15];
sprintf(scoreChar,"%d",score);
(*u).textbackground_color(0xf09860);
(*u).locate(11-strlen(scoreChar),0);
(*u).printf("Score: %s",scoreChar);
}
//Collision detection functions
void CollisionDetect(Screen **s, Player *p,bool *flag) {
    if((*s[0]).pos > -127) {
            //Check if the player has collided with any of s[0]'s objects
            for(int j = 0;j<=3;j++) {
                if(detectTR((*s[0]).obs[j],p) || detectBL((*s[0]).obs[j],p) || detectBR((*s[0]).obs[j],p) || detectTL((*s[0]).obs[j],p)) {
                    //mark player as collided
                    //(*p).color = 0xFF00FF;
                    //mark block as collided
                    //(*(*s[0]).obs[j]).color = 0x00FFFF;
                    //set the collided flag to true
                    *flag = true;
                }
            }
    }
    
    //Check if the player has collided with any of s[1]'s objects
    for(int i = 0;i<=3;i++) {
                if(detectTR((*s[1]).obs[i],p) || detectBL((*s[1]).obs[i],p) || detectBR((*s[1]).obs[i],p) || detectTL((*s[1]).obs[i],p)) {
                    //mark player as collided
                    //(*p).color = 0xFF00FF;
                    //mark block as collided
                    //(*(*s[1]).obs[i]).color = 0x00FFFF;
                    //set the collided flag to true
                    *flag = true;
                }
            }
}
bool detectTR(Obstacle *o,Player *p) {
    //return true if the top right corner of the player overlaps with an object
    return ((((*o).col + (*o).w - 1) >= (*p).col) && (((*o).col + (*o).w - 1) <= (*p).col + (*p).w - 1) 
    && (((*o).row >= (*p).row) && ((*o).row <= ((*p).row + (*p).h - 1))));
}
bool detectBL(Obstacle *o,Player *p) {
    //return true if the bottom left corner of the player overlaps with an object
    return ((((*o).col) >= (*p).col) && (((*o).col) <= (*p).col + (*p).w - 1) 
    && (((*o).row + (*o).h - 1 >= (*p).row) && ((*o).row + (*o).h - 1 <= ((*p).row + (*p).h - 1))));
}
bool detectBR(Obstacle *o,Player *p) {
    //return true if the bottom right corner of the player overlaps with an object
    return ((((*o).col + (*o).w - 1) >= (*p).col) && (((*o).col + (*o).w - 1) <= (*p).col + (*p).w - 1) 
    && (((*o).row + (*o).h - 1 >= (*p).row) && ((*o).row + (*o).h - 1 <= ((*p).row + (*p).h - 1))));
}
bool detectTL(Obstacle *o, Player *p) {
    //return true if the top left corner of the player overlaps with an object
    return ((((*o).col) >= (*p).col) && (((*o).col) <= (*p).col + (*p).w - 1)
    && (((*o).row >= (*p).row) && ((*o).row <= ((*p).row + (*p).h - 1))));
}
/*
//functions that belong to the Screen class
*/
void Screen::decScreen(void) {
    //increment screen position and object positions so that they can move off-screen
    pos+=DELTA_X;
    (*obs[0]).col+=DELTA_X;
    (*obs[1]).col+=DELTA_X;
    (*obs[2]).col+=DELTA_X;
    (*obs[3]).col+=DELTA_X;
    //decrement position of objects associated with screen
}
Screen::Screen(int bg, int initPos) {
    bgAddr = bg;
    pos = initPos;
    int j;
    for(j = 0;j<=3;j++) {
        obs[j] = new Obstacle(0x00FF00);
        (*obs[j]).col = initPos + (16*j) + j;
        (*obs[j]).row = 111;
    }
}
//new default constructor
Screen::Screen(int bg, bool randomSpots, int initPos) {
    pos = initPos;
    for(int j = 0;j<=3;j++) {
        obs[j] = new Obstacle(0x0000FF);
    }
    //Pick random locations within the screen for the objects
    (*obs[0]).col = initPos + (rand() % 2) * 16;
    (*obs[1]).col = ((rand() % 2) * 16) + (*obs[0]).col;
    (*obs[2]).col = ((rand() % 2) * 16) + (*obs[1]).col;
    (*obs[3]).col = ((rand() % 2) * 16) + (*obs[2]).col;
    //set height to either 16 or 32 pixels for object
    for(int j = 0;j<=3;j++) {
        (*obs[j]).h = ((rand() % 2) == 1 ? H_32 : H_16);
        (*obs[j]).w = H_16;
        (*obs[j]).row = 127-(*obs[j]).h;
    }    
}
Screen::~Screen(void) {
    //free the space for the deleted screen's obstacles in memory
    delete obs[0];
    delete obs[1];
    delete obs[2];
    delete obs[3];
}
/*
//Functions that belong to the Obstacle class
*/
Obstacle::Obstacle(int c) {
    color = c;
    w = 16;
    h = 16;
    row = 0;
    col = 0;
}
/*
//Function that belong to the Player class
*/
Player::Player(void) {
    //set default variables so that the player is in the bottom-right corner when the game begins
    w = H_16;
    h = H_32;
    color = 0xFF0000; //color is deprecated, since we're using images now
    col = 111;
    row = 95;
    hasMoved = false;
    moveFlag = 0;
    isFalling = false;
    isJumping = false;
    upCounter = -1;
    fallCounter = -1;
}
/*
// Functions that belong to the cursor class
*/
Cursor::Cursor(void) {
    //set default cursor position so that the cursor is over 'A' on the high score screen
    row = 30;
    col = 5;
    s = 10;
    curChar = 'A';
    delta_x = 14;
    delta_y = 16;
    hasMoved = false;
    letterPressed = false;
    c = 0;
    moveFlag = 0;
}
void Cursor::draw(uLCD_4DGL *u) {
    //draw the cursor rectangle at the current position
    (*u).rectangle(col,row,col + s,row + s,0xFF3300);
}
void Cursor::coverUp(uLCD_4DGL *u) {
    //draw a rectangle with the BG color at the previous cursor position to cover up the rectangle left behind by previous draw function
    (*u).rectangle(col + ((moveFlag & MOVE_LEFT) * ((delta_x - s) + s)) - (((moveFlag & MOVE_RIGHT) >> 1) * ((delta_x - s) + s)), row + (((moveFlag & MOVE_UP)>>2) * ((delta_y - s) + s)) - (((moveFlag & MOVE_DOWN)>>3) * ((delta_y - s) + s)),
    (col + s) + ((moveFlag & MOVE_LEFT)*  ((delta_x - s) + s)) - (((moveFlag & MOVE_RIGHT) >> 1) * ((delta_x - s) + s)), row + s + (((moveFlag & MOVE_UP)>>2) * ((delta_y - s) + s)) - (((moveFlag & MOVE_DOWN)>>3) * ((delta_y - s) + s)),
    COVER_COLOR);
}