/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#include "font.h"

__attribute__ (( __section__(".text.glyphs") ))
const glyph_t glyphs_DejaVu_Serif_8[] = {
    { /* ' ' */
        .bearingX = 0,
        .bearingY = 0,
        .width    = 0,
        .height   = 0,
        .advance  = 6,
        .bitmapIndex = 0,
    },
    { /* '!' */
        .bearingX = 3,
        .bearingY = 14,
        .width    = 2,
        .height   = 14,
        .advance  = 8,
        .bitmapIndex = 0,
    },
    { /* '"' */
        .bearingX = 2,
        .bearingY = 14,
        .width    = 4,
        .height   = 5,
        .advance  = 9,
        .bitmapIndex = 14,
    },
    { /* '#' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 13,
        .height   = 14,
        .advance  = 16,
        .bitmapIndex = 19,
    },
    { /* '$' */
        .bearingX = 2,
        .bearingY = 14,
        .width    = 9,
        .height   = 17,
        .advance  = 12,
        .bitmapIndex = 47,
    },
    { /* '%' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 16,
        .height   = 14,
        .advance  = 18,
        .bitmapIndex = 81,
    },
    { /* '&' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 15,
        .height   = 15,
        .advance  = 17,
        .bitmapIndex = 109,
    },
    { /* ''' */
        .bearingX = 2,
        .bearingY = 14,
        .width    = 1,
        .height   = 5,
        .advance  = 5,
        .bitmapIndex = 139,
    },
    { /* '(' */
        .bearingX = 2,
        .bearingY = 14,
        .width    = 5,
        .height   = 17,
        .advance  = 7,
        .bitmapIndex = 144,
    },
    { /* ')' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 5,
        .height   = 17,
        .advance  = 7,
        .bitmapIndex = 161,
    },
    { /* '*' */
        .bearingX = 0,
        .bearingY = 14,
        .width    = 9,
        .height   = 9,
        .advance  = 10,
        .bitmapIndex = 178,
    },
    { /* '+' */
        .bearingX = 1,
        .bearingY = 13,
        .width    = 13,
        .height   = 13,
        .advance  = 16,
        .bitmapIndex = 196,
    },
    { /* ',' */
        .bearingX = 0,
        .bearingY = 2,
        .width    = 4,
        .height   = 5,
        .advance  = 6,
        .bitmapIndex = 222,
    },
    { /* '-' */
        .bearingX = 1,
        .bearingY = 6,
        .width    = 5,
        .height   = 1,
        .advance  = 6,
        .bitmapIndex = 227,
    },
    { /* '.' */
        .bearingX = 2,
        .bearingY = 2,
        .width    = 2,
        .height   = 2,
        .advance  = 6,
        .bitmapIndex = 228,
    },
    { /* '/' */
        .bearingX = 0,
        .bearingY = 14,
        .width    = 6,
        .height   = 16,
        .advance  = 6,
        .bitmapIndex = 230,
    },
    { /* '0' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 10,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 246,
    },
    { /* '1' */
        .bearingX = 2,
        .bearingY = 14,
        .width    = 7,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 274,
    },
    { /* '2' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 9,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 288,
    },
    { /* '3' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 9,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 316,
    },
    { /* '4' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 11,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 344,
    },
    { /* '5' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 9,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 372,
    },
    { /* '6' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 10,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 400,
    },
    { /* '7' */
        .bearingX = 2,
        .bearingY = 14,
        .width    = 9,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 428,
    },
    { /* '8' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 10,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 456,
    },
    { /* '9' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 10,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 484,
    },
    { /* ':' */
        .bearingX = 2,
        .bearingY = 8,
        .width    = 2,
        .height   = 8,
        .advance  = 6,
        .bitmapIndex = 512,
    },
    { /* ';' */
        .bearingX = 0,
        .bearingY = 8,
        .width    = 4,
        .height   = 11,
        .advance  = 6,
        .bitmapIndex = 520,
    },
    { /* '<' */
        .bearingX = 2,
        .bearingY = 11,
        .width    = 12,
        .height   = 10,
        .advance  = 16,
        .bitmapIndex = 531,
    },
    { /* '=' */
        .bearingX = 2,
        .bearingY = 9,
        .width    = 12,
        .height   = 5,
        .advance  = 16,
        .bitmapIndex = 551,
    },
    { /* '>' */
        .bearingX = 2,
        .bearingY = 11,
        .width    = 12,
        .height   = 10,
        .advance  = 16,
        .bitmapIndex = 561,
    },
    { /* '?' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 8,
        .height   = 14,
        .advance  = 10,
        .bitmapIndex = 581,
    },
    { /* '@' */
        .bearingX = 1,
        .bearingY = 13,
        .width    = 16,
        .height   = 17,
        .advance  = 19,
        .bitmapIndex = 595,
    },
    { /* 'A' */
        .bearingX = 0,
        .bearingY = 14,
        .width    = 14,
        .height   = 14,
        .advance  = 14,
        .bitmapIndex = 629,
    },
    { /* 'B' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 12,
        .height   = 14,
        .advance  = 14,
        .bitmapIndex = 657,
    },
    { /* 'C' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 12,
        .height   = 14,
        .advance  = 15,
        .bitmapIndex = 685,
    },
    { /* 'D' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 13,
        .height   = 14,
        .advance  = 15,
        .bitmapIndex = 713,
    },
    { /* 'E' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 12,
        .height   = 14,
        .advance  = 14,
        .bitmapIndex = 741,
    },
    { /* 'F' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 12,
        .height   = 14,
        .advance  = 13,
        .bitmapIndex = 769,
    },
    { /* 'G' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 13,
        .height   = 14,
        .advance  = 15,
        .bitmapIndex = 797,
    },
    { /* 'H' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 15,
        .height   = 14,
        .advance  = 17,
        .bitmapIndex = 825,
    },
    { /* 'I' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 6,
        .height   = 14,
        .advance  = 8,
        .bitmapIndex = 853,
    },
    { /* 'J' */
        .bearingX = -2,
        .bearingY = 14,
        .width    = 9,
        .height   = 18,
        .advance  = 8,
        .bitmapIndex = 867,
    },
    { /* 'K' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 14,
        .height   = 14,
        .advance  = 14,
        .bitmapIndex = 903,
    },
    { /* 'L' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 11,
        .height   = 14,
        .advance  = 13,
        .bitmapIndex = 931,
    },
    { /* 'M' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 18,
        .height   = 14,
        .advance  = 20,
        .bitmapIndex = 959,
    },
    { /* 'N' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 15,
        .height   = 14,
        .advance  = 17,
        .bitmapIndex = 1001,
    },
    { /* 'O' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 13,
        .height   = 14,
        .advance  = 15,
        .bitmapIndex = 1029,
    },
    { /* 'P' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 11,
        .height   = 14,
        .advance  = 13,
        .bitmapIndex = 1057,
    },
    { /* 'Q' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 13,
        .height   = 17,
        .advance  = 15,
        .bitmapIndex = 1085,
    },
    { /* 'R' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 14,
        .height   = 14,
        .advance  = 14,
        .bitmapIndex = 1119,
    },
    { /* 'S' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 11,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 1147,
    },
    { /* 'T' */
        .bearingX = 0,
        .bearingY = 14,
        .width    = 12,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 1175,
    },
    { /* 'U' */
        .bearingX = 0,
        .bearingY = 14,
        .width    = 15,
        .height   = 14,
        .advance  = 15,
        .bitmapIndex = 1203,
    },
    { /* 'V' */
        .bearingX = 0,
        .bearingY = 14,
        .width    = 14,
        .height   = 14,
        .advance  = 14,
        .bitmapIndex = 1231,
    },
    { /* 'W' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 19,
        .height   = 14,
        .advance  = 20,
        .bitmapIndex = 1259,
    },
    { /* 'X' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 13,
        .height   = 14,
        .advance  = 14,
        .bitmapIndex = 1301,
    },
    { /* 'Y' */
        .bearingX = 0,
        .bearingY = 14,
        .width    = 13,
        .height   = 14,
        .advance  = 13,
        .bitmapIndex = 1329,
    },
    { /* 'Z' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 12,
        .height   = 14,
        .advance  = 13,
        .bitmapIndex = 1357,
    },
    { /* '[' */
        .bearingX = 2,
        .bearingY = 14,
        .width    = 5,
        .height   = 17,
        .advance  = 7,
        .bitmapIndex = 1385,
    },
    { /* '\' */
        .bearingX = 0,
        .bearingY = 14,
        .width    = 6,
        .height   = 16,
        .advance  = 6,
        .bitmapIndex = 1402,
    },
    { /* ']' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 5,
        .height   = 17,
        .advance  = 7,
        .bitmapIndex = 1418,
    },
    { /* '^' */
        .bearingX = 2,
        .bearingY = 14,
        .width    = 12,
        .height   = 5,
        .advance  = 16,
        .bitmapIndex = 1435,
    },
    { /* '_' */
        .bearingX = 0,
        .bearingY = -3,
        .width    = 10,
        .height   = 1,
        .advance  = 10,
        .bitmapIndex = 1445,
    },
    { /* '`' */
        .bearingX = 1,
        .bearingY = 15,
        .width    = 4,
        .height   = 3,
        .advance  = 10,
        .bitmapIndex = 1447,
    },
    { /* 'a' */
        .bearingX = 1,
        .bearingY = 9,
        .width    = 9,
        .height   = 9,
        .advance  = 11,
        .bitmapIndex = 1450,
    },
    { /* 'b' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 10,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 1468,
    },
    { /* 'c' */
        .bearingX = 1,
        .bearingY = 9,
        .width    = 9,
        .height   = 9,
        .advance  = 11,
        .bitmapIndex = 1496,
    },
    { /* 'd' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 10,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 1514,
    },
    { /* 'e' */
        .bearingX = 1,
        .bearingY = 9,
        .width    = 9,
        .height   = 9,
        .advance  = 11,
        .bitmapIndex = 1542,
    },
    { /* 'f' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 7,
        .height   = 14,
        .advance  = 7,
        .bitmapIndex = 1560,
    },
    { /* 'g' */
        .bearingX = 1,
        .bearingY = 9,
        .width    = 10,
        .height   = 13,
        .advance  = 12,
        .bitmapIndex = 1574,
    },
    { /* 'h' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 10,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 1600,
    },
    { /* 'i' */
        .bearingX = 1,
        .bearingY = 13,
        .width    = 4,
        .height   = 13,
        .advance  = 6,
        .bitmapIndex = 1628,
    },
    { /* 'j' */
        .bearingX = -2,
        .bearingY = 13,
        .width    = 6,
        .height   = 17,
        .advance  = 6,
        .bitmapIndex = 1641,
    },
    { /* 'k' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 11,
        .height   = 14,
        .advance  = 12,
        .bitmapIndex = 1658,
    },
    { /* 'l' */
        .bearingX = 1,
        .bearingY = 14,
        .width    = 4,
        .height   = 14,
        .advance  = 6,
        .bitmapIndex = 1686,
    },
    { /* 'm' */
        .bearingX = 1,
        .bearingY = 9,
        .width    = 16,
        .height   = 9,
        .advance  = 18,
        .bitmapIndex = 1700,
    },
    { /* 'n' */
        .bearingX = 1,
        .bearingY = 9,
        .width    = 10,
        .height   = 9,
        .advance  = 12,
        .bitmapIndex = 1718,
    },
    { /* 'o' */
        .bearingX = 1,
        .bearingY = 9,
        .width    = 9,
        .height   = 9,
        .advance  = 11,
        .bitmapIndex = 1736,
    },
    { /* 'p' */
        .bearingX = 1,
        .bearingY = 9,
        .width    = 10,
        .height   = 13,
        .advance  = 12,
        .bitmapIndex = 1754,
    },
    { /* 'q' */
        .bearingX = 1,
        .bearingY = 9,
        .width    = 10,
        .height   = 13,
        .advance  = 12,
        .bitmapIndex = 1780,
    },
    { /* 'r' */
        .bearingX = 1,
        .bearingY = 9,
        .width    = 8,
        .height   = 9,
        .advance  = 9,
        .bitmapIndex = 1806,
    },
    { /* 's' */
        .bearingX = 1,
        .bearingY = 9,
        .width    = 9,
        .height   = 9,
        .advance  = 10,
        .bitmapIndex = 1815,
    },
    { /* 't' */
        .bearingX = 1,
        .bearingY = 12,
        .width    = 6,
        .height   = 12,
        .advance  = 8,
        .bitmapIndex = 1833,
    },
    { /* 'u' */
        .bearingX = 1,
        .bearingY = 9,
        .width    = 10,
        .height   = 9,
        .advance  = 12,
        .bitmapIndex = 1845,
    },
    { /* 'v' */
        .bearingX = 0,
        .bearingY = 9,
        .width    = 11,
        .height   = 9,
        .advance  = 11,
        .bitmapIndex = 1863,
    },
    { /* 'w' */
        .bearingX = 0,
        .bearingY = 9,
        .width    = 16,
        .height   = 9,
        .advance  = 16,
        .bitmapIndex = 1881,
    },
    { /* 'x' */
        .bearingX = 0,
        .bearingY = 9,
        .width    = 10,
        .height   = 9,
        .advance  = 11,
        .bitmapIndex = 1899,
    },
    { /* 'y' */
        .bearingX = 0,
        .bearingY = 9,
        .width    = 11,
        .height   = 13,
        .advance  = 11,
        .bitmapIndex = 1917,
    },
    { /* 'z' */
        .bearingX = 1,
        .bearingY = 9,
        .width    = 9,
        .height   = 9,
        .advance  = 10,
        .bitmapIndex = 1943,
    },
    { /* '{' */
        .bearingX = 2,
        .bearingY = 14,
        .width    = 8,
        .height   = 18,
        .advance  = 12,
        .bitmapIndex = 1961,
    },
    { /* '|' */
        .bearingX = 2,
        .bearingY = 15,
        .width    = 2,
        .height   = 19,
        .advance  = 6,
        .bitmapIndex = 1979,
    },
    { /* '}' */
        .bearingX = 2,
        .bearingY = 14,
        .width    = 8,
        .height   = 18,
        .advance  = 12,
        .bitmapIndex = 1998,
    },
    { /* '~' */
        .bearingX = 2,
        .bearingY = 8,
        .width    = 12,
        .height   = 4,
        .advance  = 16,
        .bitmapIndex = 2016,
    },
};

__attribute__ (( __section__(".text.bitmaps") ))
const uint8_t bitmaps_DejaVu_Serif_8[] = {
    0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFF, 0xFF,
    0x3F, 0x3F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0xF9, 0x9F, 0xFB, 0x9F, 0xFB,
    0xBF, 0xF3, 0xBF, 0x80, 0x07, 0xF7, 0x3F, 0xF7, 0x7F, 0xE7, 0x7F, 0xE6,
    0x7F, 0x00, 0x0F, 0xEE, 0xFF, 0xCE, 0xFF, 0xCC, 0xFF, 0xCC, 0xFF, 0xF7,
    0xFF, 0xF7, 0xFF, 0xC1, 0xFF, 0x14, 0xFF, 0x36, 0xFF, 0x37, 0xFF, 0x07,
    0xFF, 0xC1, 0xFF, 0xF0, 0xFF, 0xF6, 0x7F, 0x76, 0x7F, 0x76, 0x7F, 0x34,
    0xFF, 0x81, 0xFF, 0xF7, 0xFF, 0xF7, 0xFF, 0xF7, 0xFF, 0x87, 0xF7, 0xB7,
    0xEF, 0x7B, 0xCF, 0x7B, 0xDF, 0x7B, 0xBF, 0x7B, 0x3F, 0xB7, 0x61, 0x86,
    0xED, 0xFC, 0xDE, 0xFD, 0xDE, 0xFB, 0xDE, 0xF3, 0xDE, 0xF7, 0xED, 0xEF,
    0xE1, 0xF0, 0xFF, 0xC6, 0x7F, 0xCF, 0x7F, 0xCF, 0xFF, 0xC7, 0xFF, 0xE3,
    0xFF, 0x93, 0xC1, 0xB9, 0xF7, 0x3C, 0xF7, 0x3E, 0x6F, 0x3E, 0x0F, 0x1F,
    0x1F, 0x8F, 0x0F, 0xC0, 0xC1, 0xFF, 0xFF, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
    0xF7, 0xEF, 0xDF, 0x9F, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
    0xBF, 0x9F, 0xDF, 0xEF, 0xF7, 0x7F, 0xBF, 0xDF, 0xCF, 0xEF, 0xE7, 0xE7,
    0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xEF, 0xCF, 0xDF, 0xBF, 0x7F, 0xF7, 0xFF,
    0xF7, 0xFF, 0x36, 0x7F, 0x94, 0xFF, 0xE3, 0xFF, 0x80, 0xFF, 0x36, 0x7F,
    0xF7, 0xFF, 0xF7, 0xFF, 0xFD, 0xFF, 0xFD, 0xFF, 0xFD, 0xFF, 0xFD, 0xFF,
    0xFD, 0xFF, 0xFD, 0xFF, 0x00, 0x07, 0xFD, 0xFF, 0xFD, 0xFF, 0xFD, 0xFF,
    0xFD, 0xFF, 0xFD, 0xFF, 0xFD, 0xFF, 0xCF, 0xCF, 0xDF, 0x9F, 0x3F, 0x07,
    0x3F, 0x3F, 0xF3, 0xF3, 0xF7, 0xF7, 0xE7, 0xEF, 0xEF, 0xCF, 0xCF, 0xDF,
    0xDF, 0x9F, 0xBF, 0xBF, 0x3F, 0x3F, 0xE1, 0xFF, 0xCC, 0xFF, 0x9E, 0x7F,
    0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
    0x3F, 0x3F, 0x3F, 0x3F, 0x9E, 0x7F, 0xCC, 0xFF, 0xE1, 0xFF, 0xE7, 0x87,
    0x67, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x81,
    0x81, 0xFF, 0x3C, 0xFF, 0x7E, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0xFF,
    0xFC, 0xFF, 0xF9, 0xFF, 0xF7, 0xFF, 0xEF, 0xFF, 0xDF, 0x7F, 0xBF, 0x7F,
    0x00, 0x7F, 0x00, 0x7F, 0x83, 0xFF, 0x38, 0xFF, 0x7C, 0xFF, 0xFC, 0xFF,
    0xFC, 0xFF, 0xF9, 0xFF, 0xE7, 0xFF, 0xF8, 0xFF, 0xFE, 0x7F, 0xFE, 0x7F,
    0xFE, 0x7F, 0x7E, 0x7F, 0x3C, 0xFF, 0x81, 0xFF, 0xFC, 0xFF, 0xF8, 0xFF,
    0xF0, 0xFF, 0xF4, 0xFF, 0xEC, 0xFF, 0xCC, 0xFF, 0xDC, 0xFF, 0xBC, 0xFF,
    0x3C, 0xFF, 0x00, 0x1F, 0xFC, 0xFF, 0xFC, 0xFF, 0xFC, 0xFF, 0xF0, 0x3F,
    0x80, 0xFF, 0x80, 0xFF, 0xBF, 0xFF, 0xBF, 0xFF, 0xBF, 0xFF, 0x81, 0xFF,
    0xBC, 0xFF, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0x7E, 0x7F,
    0x3C, 0xFF, 0x81, 0xFF, 0xE0, 0xFF, 0xCE, 0x7F, 0x9F, 0x7F, 0xBF, 0xFF,
    0x3F, 0xFF, 0x20, 0xFF, 0x1E, 0x7F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
    0x3F, 0x3F, 0xBF, 0x3F, 0x9E, 0x7F, 0xE0, 0xFF, 0x00, 0x7F, 0x00, 0x7F,
    0x7E, 0xFF, 0x7E, 0xFF, 0xFC, 0xFF, 0xFD, 0xFF, 0xFD, 0xFF, 0xFB, 0xFF,
    0xFB, 0xFF, 0xF7, 0xFF, 0xF7, 0xFF, 0xF7, 0xFF, 0xEF, 0xFF, 0xEF, 0xFF,
    0xC0, 0xFF, 0x9E, 0x7F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x9E, 0x7F,
    0xE1, 0xFF, 0x9E, 0x7F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
    0x9E, 0x7F, 0xC0, 0xFF, 0xC1, 0xFF, 0x9E, 0x7F, 0x3F, 0x7F, 0x3F, 0x3F,
    0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x9E, 0x3F, 0xC1, 0x3F, 0xFF, 0x3F,
    0xFF, 0x7F, 0xBE, 0x7F, 0x9C, 0xFF, 0xC1, 0xFF, 0x3F, 0x3F, 0xFF, 0xFF,
    0xFF, 0xFF, 0x3F, 0x3F, 0xCF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xCF,
    0xDF, 0x9F, 0xBF, 0xFF, 0xEF, 0xFF, 0x0F, 0xF8, 0x7F, 0xC1, 0xFF, 0x0F,
    0xFF, 0x0F, 0xFF, 0xC3, 0xFF, 0xF8, 0x7F, 0xFF, 0x0F, 0xFF, 0xEF, 0x00,
    0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x0F, 0x7F, 0xFF, 0x0F,
    0xFF, 0xE1, 0xFF, 0xF8, 0x3F, 0xFF, 0x0F, 0xFF, 0x0F, 0xFC, 0x3F, 0xE1,
    0xFF, 0x0F, 0xFF, 0x7F, 0xFF, 0x83, 0x39, 0x7C, 0xFC, 0xFC, 0xF8, 0xF1,
    0xE3, 0xEF, 0xEF, 0xEF, 0xFF, 0xCF, 0xCF, 0xF8, 0x1F, 0xF3, 0xE7, 0xC7,
    0xFB, 0xCF, 0xFD, 0x9C, 0x4D, 0xBC, 0x8E, 0x39, 0xCE, 0x39, 0xCE, 0x39,
    0xCE, 0x39, 0xCE, 0x39, 0xCD, 0x3C, 0x8B, 0x9C, 0x47, 0x8F, 0xFF, 0xC7,
    0xF7, 0xE3, 0xE7, 0xF8, 0x1F, 0xFC, 0xFF, 0xFC, 0xFF, 0xF8, 0x7F, 0xFA,
    0x7F, 0xF6, 0x7F, 0xF7, 0x3F, 0xF7, 0x3F, 0xEF, 0x1F, 0xEF, 0x9F, 0xC0,
    0x1F, 0xDF, 0xCF, 0xDF, 0xCF, 0xBF, 0xCF, 0x0F, 0x83, 0x00, 0x7F, 0xCF,
    0x1F, 0xCF, 0x9F, 0xCF, 0x9F, 0xCF, 0x9F, 0xCF, 0x3F, 0xC0, 0x7F, 0xCF,
    0x9F, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0x9F, 0x00,
    0x3F, 0xF0, 0x3F, 0xCF, 0x8F, 0x9F, 0xCF, 0x9F, 0xEF, 0x3F, 0xFF, 0x3F,
    0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x9F, 0xCF, 0x9F,
    0x9F, 0xCF, 0x1F, 0xF0, 0x7F, 0x00, 0x7F, 0xCF, 0x1F, 0xCF, 0xCF, 0xCF,
    0xCF, 0xCF, 0xE7, 0xCF, 0xE7, 0xCF, 0xE7, 0xCF, 0xE7, 0xCF, 0xE7, 0xCF,
    0xE7, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0x1F, 0x00, 0x7F, 0x00, 0x0F, 0xCF,
    0xEF, 0xCF, 0xEF, 0xCF, 0xFF, 0xCF, 0xBF, 0xCF, 0xBF, 0xC0, 0x3F, 0xCF,
    0xBF, 0xCF, 0xBF, 0xCF, 0xFF, 0xCF, 0xFF, 0xCF, 0xEF, 0xCF, 0xEF, 0x00,
    0x0F, 0x00, 0x0F, 0xCF, 0xEF, 0xCF, 0xEF, 0xCF, 0xFF, 0xCF, 0xBF, 0xCF,
    0xBF, 0xC0, 0x3F, 0xCF, 0xBF, 0xCF, 0xBF, 0xCF, 0xFF, 0xCF, 0xFF, 0xCF,
    0xFF, 0xCF, 0xFF, 0x03, 0xFF, 0xF0, 0x1F, 0xE7, 0xC7, 0x9F, 0xE7, 0x9F,
    0xF7, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0x07, 0x3F, 0xE7, 0x3F,
    0xE7, 0x9F, 0xE7, 0x9F, 0xE7, 0xC7, 0xC7, 0xF0, 0x1F, 0x03, 0x81, 0xCF,
    0xE7, 0xCF, 0xE7, 0xCF, 0xE7, 0xCF, 0xE7, 0xCF, 0xE7, 0xC0, 0x07, 0xCF,
    0xE7, 0xCF, 0xE7, 0xCF, 0xE7, 0xCF, 0xE7, 0xCF, 0xE7, 0xCF, 0xE7, 0x03,
    0x81, 0x03, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF, 0xCF,
    0xCF, 0xCF, 0x03, 0xE0, 0x7F, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9,
    0xFF, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9,
    0xFF, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9, 0xFF, 0x79, 0xFF, 0x73,
    0xFF, 0x87, 0xFF, 0x03, 0x87, 0xCF, 0xDF, 0xCF, 0x3F, 0xCE, 0x7F, 0xCC,
    0xFF, 0xCB, 0xFF, 0xC3, 0xFF, 0xC1, 0xFF, 0xC8, 0xFF, 0xCC, 0x7F, 0xCE,
    0x3F, 0xCF, 0x1F, 0xCF, 0x8F, 0x03, 0xC3, 0x03, 0xFF, 0xCF, 0xFF, 0xCF,
    0xFF, 0xCF, 0xFF, 0xCF, 0xFF, 0xCF, 0xFF, 0xCF, 0xFF, 0xCF, 0xFF, 0xCF,
    0xFF, 0xCF, 0xFF, 0xCF, 0xFF, 0xCF, 0xDF, 0xCF, 0xDF, 0x00, 0x1F, 0x0F,
    0xFC, 0x3F, 0xC7, 0xF8, 0xFF, 0xC7, 0xF8, 0xFF, 0xD3, 0xF4, 0xFF, 0xD3,
    0xF4, 0xFF, 0xD9, 0xEC, 0xFF, 0xD9, 0xEC, 0xFF, 0xDC, 0xDC, 0xFF, 0xDC,
    0xDC, 0xFF, 0xDE, 0x3C, 0xFF, 0xDE, 0x3C, 0xFF, 0xDE, 0x7C, 0xFF, 0xDF,
    0xFC, 0xFF, 0x07, 0xF0, 0x3F, 0x0F, 0xC1, 0xC7, 0xF7, 0xC3, 0xF7, 0xD3,
    0xF7, 0xD9, 0xF7, 0xD8, 0xF7, 0xDC, 0x77, 0xDE, 0x77, 0xDF, 0x37, 0xDF,
    0x17, 0xDF, 0x87, 0xDF, 0xC7, 0xDF, 0xE7, 0x07, 0xE7, 0xF0, 0x7F, 0xCF,
    0x9F, 0x9F, 0xCF, 0x9F, 0xCF, 0x3F, 0xE7, 0x3F, 0xE7, 0x3F, 0xE7, 0x3F,
    0xE7, 0x3F, 0xE7, 0x3F, 0xE7, 0x9F, 0xCF, 0x9F, 0xCF, 0xCF, 0x9F, 0xF0,
    0x7F, 0x00, 0x7F, 0xCF, 0x3F, 0xCF, 0x9F, 0xCF, 0x9F, 0xCF, 0x9F, 0xCF,
    0x9F, 0xCF, 0x3F, 0xC0, 0x7F, 0xCF, 0xFF, 0xCF, 0xFF, 0xCF, 0xFF, 0xCF,
    0xFF, 0xCF, 0xFF, 0x03, 0xFF, 0xF0, 0x7F, 0xCF, 0x9F, 0x9F, 0xCF, 0x9F,
    0xCF, 0x3F, 0xE7, 0x3F, 0xE7, 0x3F, 0xE7, 0x3F, 0xE7, 0x3F, 0xE7, 0x3F,
    0xE7, 0x9F, 0xCF, 0x9F, 0xCF, 0xCF, 0x9F, 0xF0, 0x7F, 0xFE, 0x7F, 0xFF,
    0x1F, 0xFF, 0x9F, 0x00, 0x7F, 0xCF, 0x3F, 0xCF, 0x9F, 0xCF, 0x9F, 0xCF,
    0x9F, 0xCF, 0x9F, 0xCF, 0x3F, 0xC0, 0xFF, 0xCE, 0x7F, 0xCF, 0x3F, 0xCF,
    0x3F, 0xCF, 0x9F, 0xCF, 0x8F, 0x03, 0xC7, 0xC0, 0xFF, 0x9E, 0x7F, 0x3F,
    0x7F, 0x3F, 0x7F, 0x3F, 0xFF, 0x0F, 0xFF, 0x81, 0xFF, 0xE0, 0x7F, 0xFE,
    0x3F, 0xFF, 0x3F, 0x7F, 0x3F, 0x7F, 0x3F, 0x3E, 0x7F, 0x80, 0xFF, 0x00,
    0x0F, 0x79, 0xEF, 0x79, 0xEF, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9,
    0xFF, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9, 0xFF, 0xF9,
    0xFF, 0xE0, 0x7F, 0x03, 0xC1, 0xCF, 0xF7, 0xCF, 0xF7, 0xCF, 0xF7, 0xCF,
    0xF7, 0xCF, 0xF7, 0xCF, 0xF7, 0xCF, 0xF7, 0xCF, 0xF7, 0xCF, 0xF7, 0xCF,
    0xF7, 0xC7, 0xE7, 0xE3, 0xCF, 0xF0, 0x1F, 0x07, 0xC3, 0x8F, 0xEF, 0xCF,
    0xEF, 0xCF, 0xEF, 0xE7, 0xDF, 0xE7, 0xDF, 0xE7, 0x9F, 0xF3, 0xBF, 0xF3,
    0xBF, 0xF1, 0x7F, 0xF9, 0x7F, 0xF9, 0x7F, 0xFC, 0xFF, 0xFC, 0xFF, 0x07,
    0x9E, 0x1F, 0x8F, 0x9F, 0x3F, 0xCF, 0x9F, 0x7F, 0xCF, 0x4F, 0x7F, 0xCF,
    0x4F, 0x7F, 0xE7, 0x4E, 0xFF, 0xE6, 0xCE, 0xFF, 0xE6, 0xE6, 0xFF, 0xE6,
    0xE6, 0xFF, 0xF2, 0xE5, 0xFF, 0xF1, 0xE1, 0xFF, 0xF1, 0xF1, 0xFF, 0xF1,
    0xF1, 0xFF, 0xF9, 0xF3, 0xFF, 0x06, 0x0F, 0xCF, 0xBF, 0xC7, 0x3F, 0xE7,
    0x7F, 0xF2, 0xFF, 0xF0, 0xFF, 0xF9, 0xFF, 0xF8, 0xFF, 0xF0, 0xFF, 0xF6,
    0x7F, 0xEE, 0x3F, 0xCF, 0x3F, 0xDF, 0x9F, 0x0E, 0x07, 0x07, 0x87, 0xCF,
    0xCF, 0xC7, 0xDF, 0xE7, 0xBF, 0xF3, 0xBF, 0xF1, 0x7F, 0xF9, 0x7F, 0xFC,
    0xFF, 0xFC, 0xFF, 0xFC, 0xFF, 0xFC, 0xFF, 0xFC, 0xFF, 0xFC, 0xFF, 0xF0,
    0x3F, 0x00, 0x0F, 0x7F, 0x9F, 0x7F, 0x1F, 0xFE, 0x3F, 0xFE, 0x7F, 0xFC,
    0xFF, 0xF8, 0xFF, 0xF1, 0xFF, 0xF3, 0xFF, 0xE7, 0xFF, 0xC7, 0xFF, 0x8F,
    0xEF, 0x9F, 0xEF, 0x00, 0x0F, 0x07, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
    0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x07, 0x3F, 0x3F,
    0xBF, 0xBF, 0x9F, 0xDF, 0xDF, 0xCF, 0xCF, 0xEF, 0xEF, 0xE7, 0xF7, 0xF7,
    0xF3, 0xF3, 0x07, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7,
    0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x07, 0xF9, 0xFF, 0xF0, 0xFF, 0xE6,
    0x7F, 0xDF, 0xBF, 0xBF, 0xDF, 0x00, 0x3F, 0x3F, 0x9F, 0xCF, 0xC3, 0xFF,
    0x99, 0xFF, 0xBC, 0xFF, 0xFC, 0xFF, 0x80, 0xFF, 0x3C, 0xFF, 0x3C, 0xFF,
    0x3C, 0xFF, 0x80, 0x7F, 0x1F, 0xFF, 0x9F, 0xFF, 0x9F, 0xFF, 0x9F, 0xFF,
    0x9F, 0xFF, 0x90, 0xFF, 0x8E, 0x7F, 0x9F, 0x3F, 0x9F, 0x3F, 0x9F, 0x3F,
    0x9F, 0x3F, 0x9F, 0x3F, 0x8E, 0x7F, 0x10, 0xFF, 0xE0, 0xFF, 0x9E, 0x7F,
    0x3F, 0x7F, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0x7F, 0x9E, 0xFF,
    0xC1, 0xFF, 0xFC, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F,
    0xC2, 0x7F, 0x9C, 0x7F, 0x3E, 0x7F, 0x3E, 0x7F, 0x3E, 0x7F, 0x3E, 0x7F,
    0x3E, 0x7F, 0x9C, 0x7F, 0xC2, 0x3F, 0xC1, 0xFF, 0x9C, 0xFF, 0x3E, 0x7F,
    0x3E, 0x7F, 0x00, 0x7F, 0x3F, 0xFF, 0x3F, 0x7F, 0x9E, 0xFF, 0xC1, 0xFF,
    0xC1, 0x9D, 0x9F, 0x9F, 0x9F, 0x03, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F,
    0x9F, 0x07, 0xC2, 0x3F, 0x9C, 0x7F, 0x3E, 0x7F, 0x3E, 0x7F, 0x3E, 0x7F,
    0x3E, 0x7F, 0x3E, 0x7F, 0x9C, 0x7F, 0xC2, 0x7F, 0xFE, 0x7F, 0xBE, 0x7F,
    0x9C, 0xFF, 0xC1, 0xFF, 0x1F, 0xFF, 0x9F, 0xFF, 0x9F, 0xFF, 0x9F, 0xFF,
    0x9F, 0xFF, 0x90, 0xFF, 0x8E, 0x7F, 0x9E, 0x7F, 0x9E, 0x7F, 0x9E, 0x7F,
    0x9E, 0x7F, 0x9E, 0x7F, 0x9E, 0x7F, 0x0C, 0x3F, 0x9F, 0x9F, 0xFF, 0xFF,
    0x1F, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x0F, 0xF3, 0xF3, 0xFF,
    0xFF, 0xE3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0x73,
    0x73, 0x87, 0x1F, 0xFF, 0x9F, 0xFF, 0x9F, 0xFF, 0x9F, 0xFF, 0x9F, 0xFF,
    0x98, 0x3F, 0x9C, 0xFF, 0x9B, 0xFF, 0x93, 0xFF, 0x83, 0xFF, 0x99, 0xFF,
    0x98, 0xFF, 0x9C, 0xFF, 0x08, 0x3F, 0x1F, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F,
    0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x0F, 0x10, 0xC3, 0x8E, 0x39,
    0x9E, 0x79, 0x9E, 0x79, 0x9E, 0x79, 0x9E, 0x79, 0x9E, 0x79, 0x9E, 0x79,
    0x0C, 0x30, 0x10, 0xFF, 0x8E, 0x7F, 0x9E, 0x7F, 0x9E, 0x7F, 0x9E, 0x7F,
    0x9E, 0x7F, 0x9E, 0x7F, 0x9E, 0x7F, 0x0C, 0x3F, 0xC1, 0xFF, 0x9C, 0xFF,
    0x3E, 0x7F, 0x3E, 0x7F, 0x3E, 0x7F, 0x3E, 0x7F, 0x3E, 0x7F, 0x9C, 0xFF,
    0xC1, 0xFF, 0x10, 0xFF, 0x8E, 0x7F, 0x9F, 0x3F, 0x9F, 0x3F, 0x9F, 0x3F,
    0x9F, 0x3F, 0x9F, 0x3F, 0x8E, 0x7F, 0x90, 0xFF, 0x9F, 0xFF, 0x9F, 0xFF,
    0x9F, 0xFF, 0x0F, 0xFF, 0xC2, 0x3F, 0x9C, 0x7F, 0x3E, 0x7F, 0x3E, 0x7F,
    0x3E, 0x7F, 0x3E, 0x7F, 0x3E, 0x7F, 0x9C, 0x7F, 0xC2, 0x7F, 0xFE, 0x7F,
    0xFE, 0x7F, 0xFE, 0x7F, 0xFC, 0x3F, 0x10, 0x8E, 0x9F, 0x9F, 0x9F, 0x9F,
    0x9F, 0x9F, 0x07, 0x81, 0xFF, 0x3C, 0xFF, 0x3E, 0xFF, 0x07, 0xFF, 0xC1,
    0xFF, 0xF8, 0xFF, 0x7C, 0xFF, 0x3C, 0xFF, 0x81, 0xFF, 0x9F, 0x9F, 0x9F,
    0x03, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x9B, 0x9B, 0xC7, 0x1C, 0x7F, 0x9E,
    0x7F, 0x9E, 0x7F, 0x9E, 0x7F, 0x9E, 0x7F, 0x9E, 0x7F, 0x9E, 0x7F, 0x9C,
    0x7F, 0xC2, 0x3F, 0x07, 0x1F, 0x8F, 0xBF, 0xCF, 0x7F, 0xCF, 0x7F, 0xE6,
    0xFF, 0xE6, 0xFF, 0xF1, 0xFF, 0xF1, 0xFF, 0xFB, 0xFF, 0x0F, 0x78, 0x9E,
    0x3D, 0xCE, 0x3B, 0xCC, 0x3B, 0xC5, 0x1B, 0xE5, 0x97, 0xE3, 0x97, 0xF3,
    0xCF, 0xF3, 0xCF, 0x0E, 0x3F, 0xCE, 0xFF, 0xC5, 0xFF, 0xE1, 0xFF, 0xF3,
    0xFF, 0xE1, 0xFF, 0xE8, 0xFF, 0xDC, 0xFF, 0x08, 0x3F, 0x07, 0x1F, 0xCF,
    0xBF, 0xCF, 0x7F, 0xE7, 0x7F, 0xE6, 0xFF, 0xF2, 0xFF, 0xF0, 0xFF, 0xF1,
    0xFF, 0xF9, 0xFF, 0xFB, 0xFF, 0xFB, 0xFF, 0xB7, 0xFF, 0x87, 0xFF, 0x00,
    0x7F, 0x7C, 0xFF, 0x79, 0xFF, 0xF1, 0xFF, 0xE3, 0xFF, 0xC7, 0xFF, 0x8F,
    0x7F, 0x9F, 0x7F, 0x00, 0x7F, 0xF0, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7,
    0xE7, 0xC7, 0x1F, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xF0, 0x3F,
    0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
    0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x0F, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7,
    0xE7, 0xE7, 0xF3, 0xF8, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x0F,
    0xFF, 0xFF, 0x83, 0xEF, 0x7C, 0x1F, 0xFF, 0xFF,
};
